/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.ExtensionLite;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.ExtensionSchema;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.SchemaUtil;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class ExtensionSchemaLite
extends ExtensionSchema<GeneratedMessageLite.ExtensionDescriptor> {
    ExtensionSchemaLite() {
    }

    @Override
    final boolean hasExtensions(MessageLite prototype) {
        return prototype instanceof GeneratedMessageLite.ExtendableMessage;
    }

    @Override
    final FieldSet<GeneratedMessageLite.ExtensionDescriptor> getExtensions(Object message) {
        return ((GeneratedMessageLite.ExtendableMessage)message).extensions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void setExtensions(Object message, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) {
        void var2_2;
        ((GeneratedMessageLite.ExtendableMessage)message).extensions = var2_2;
    }

    @Override
    final FieldSet<GeneratedMessageLite.ExtensionDescriptor> getMutableExtensions(Object message) {
        return ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void makeImmutable(Object message) {
        void var1_1;
        this.getExtensions(var1_1).makeImmutable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final <UT, UB> UB parseExtension(Object containerMessage, Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        int fieldNumber = ((ExtensionLite)extension).getNumber();
        if (extension.descriptor.isRepeated() && extension.descriptor.isPacked()) {
            ArrayList<Constable> value;
            switch (((ExtensionLite)extension).getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list = new ArrayList<Double>();
                    reader.readDoubleList(list);
                    value = list;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list = new ArrayList<Float>();
                    reader.readFloatList(list);
                    value = list;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readInt64List(list);
                    value = list;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readUInt64List(list);
                    value = list;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readInt32List(list);
                    value = list;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readFixed64List(list);
                    value = list;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readFixed32List(list);
                    value = list;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    reader.readBoolList(list);
                    value = list;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readUInt32List(list);
                    value = list;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSFixed32List(list);
                    value = list;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSFixed64List(list);
                    value = list;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSInt32List(list);
                    value = list;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSInt64List(list);
                    value = list;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readEnumList(list);
                    unknownFields = SchemaUtil.filterUnknownEnumList(containerMessage, fieldNumber, list, extension.descriptor.getEnumType(), unknownFields, unknownFieldSchema);
                    value = list;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                }
            }
            extensions.setField(extension.descriptor, value);
        } else {
            Object object;
            Object value = null;
            if (((ExtensionLite)extension).getLiteType() == WireFormat.FieldType.ENUM) {
                int number = reader.readInt32();
                value = extension.descriptor.getEnumType().findValueByNumber(number);
                if (value == null) {
                    return SchemaUtil.storeUnknownEnum(containerMessage, fieldNumber, number, unknownFields, unknownFieldSchema);
                }
                value = number;
            } else {
                switch (((ExtensionLite)extension).getLiteType()) {
                    case DOUBLE: {
                        value = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        value = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        value = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        value = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        value = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        value = reader.readString();
                        break;
                    }
                    case GROUP: {
                        Object newValue;
                        Object extSchema;
                        Object oldValue;
                        if (!((ExtensionLite)extension).isRepeated() && (oldValue = extensions.getField(extension.descriptor)) instanceof GeneratedMessageLite) {
                            extSchema = Protobuf.getInstance().schemaFor(oldValue);
                            if (!((GeneratedMessageLite)oldValue).isMutable()) {
                                newValue = extSchema.newInstance();
                                extSchema.mergeFrom(newValue, oldValue);
                                extensions.setField(extension.descriptor, newValue);
                                oldValue = newValue;
                            }
                            reader.mergeGroupField(oldValue, extSchema, extensionRegistry);
                            return unknownFields;
                        }
                        extSchema = reader.readGroup(((ExtensionLite)extension).getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        void var2_2;
                        Object oldValue;
                        Object newValue;
                        Object extSchema;
                        if (!((ExtensionLite)extension).isRepeated() && (oldValue = extensions.getField(extension.descriptor)) instanceof GeneratedMessageLite) {
                            extSchema = Protobuf.getInstance().schemaFor(oldValue);
                            if (!((GeneratedMessageLite)oldValue).isMutable()) {
                                void var1_1;
                                newValue = extSchema.newInstance();
                                extSchema.mergeFrom(newValue, oldValue);
                                extensions.setField(extension.descriptor, newValue);
                                oldValue = var1_1;
                            }
                            reader.mergeMessageField(oldValue, extSchema, extensionRegistry);
                            return unknownFields;
                        }
                        object = var2_2.readMessage(((ExtensionLite)extension).getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (((ExtensionLite)extension).isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, object);
            } else {
                void var3_3;
                switch (((ExtensionLite)extension).getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension.descriptor);
                        if (oldValue == null) break;
                        object = Internal.mergeMessage(oldValue, object);
                    }
                }
                extensions.setField(var3_3.descriptor, object);
            }
        }
        return unknownFields;
    }

    @Override
    final int extensionNumber(Map.Entry<?, ?> extension) {
        GeneratedMessageLite.ExtensionDescriptor extensionDescriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
        return extensionDescriptor.getNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void serializeExtension(Writer writer, Map.Entry<?, ?> extension) throws IOException {
        block43: {
            GeneratedMessageLite.ExtensionDescriptor descriptor;
            block42: {
                descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
                if (!descriptor.isRepeated()) break block42;
                switch (descriptor.getLiteType()) {
                    case DOUBLE: {
                        SchemaUtil.writeDoubleList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case FLOAT: {
                        SchemaUtil.writeFloatList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case INT64: {
                        SchemaUtil.writeInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case UINT64: {
                        SchemaUtil.writeUInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case INT32: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case FIXED64: {
                        SchemaUtil.writeFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case FIXED32: {
                        SchemaUtil.writeFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case BOOL: {
                        SchemaUtil.writeBoolList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case BYTES: {
                        SchemaUtil.writeBytesList(descriptor.getNumber(), (List)extension.getValue(), writer);
                        break block43;
                    }
                    case UINT32: {
                        SchemaUtil.writeUInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case SFIXED32: {
                        SchemaUtil.writeSFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case SFIXED64: {
                        SchemaUtil.writeSFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case SINT32: {
                        SchemaUtil.writeSInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case SINT64: {
                        SchemaUtil.writeSInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case ENUM: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                        break block43;
                    }
                    case STRING: {
                        SchemaUtil.writeStringList(descriptor.getNumber(), (List)extension.getValue(), writer);
                        break block43;
                    }
                    case GROUP: {
                        List data = (List)extension.getValue();
                        if (data != null && !data.isEmpty()) {
                            SchemaUtil.writeGroupList(descriptor.getNumber(), (List)extension.getValue(), writer, Protobuf.getInstance().schemaFor(data.get(0).getClass()));
                        }
                        break block43;
                    }
                    case MESSAGE: {
                        List data = (List)extension.getValue();
                        if (data != null && !data.isEmpty()) {
                            SchemaUtil.writeMessageList(descriptor.getNumber(), (List)extension.getValue(), writer, Protobuf.getInstance().schemaFor(data.get(0).getClass()));
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    writer.writeDouble(descriptor.getNumber(), (Double)extension.getValue());
                    return;
                }
                case FLOAT: {
                    writer.writeFloat(descriptor.getNumber(), ((Float)extension.getValue()).floatValue());
                    return;
                }
                case INT64: {
                    writer.writeInt64(descriptor.getNumber(), (Long)extension.getValue());
                    return;
                }
                case UINT64: {
                    writer.writeUInt64(descriptor.getNumber(), (Long)extension.getValue());
                    return;
                }
                case INT32: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case FIXED64: {
                    writer.writeFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    return;
                }
                case FIXED32: {
                    writer.writeFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case BOOL: {
                    writer.writeBool(descriptor.getNumber(), (Boolean)extension.getValue());
                    return;
                }
                case BYTES: {
                    writer.writeBytes(descriptor.getNumber(), (ByteString)extension.getValue());
                    return;
                }
                case UINT32: {
                    writer.writeUInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case SFIXED32: {
                    writer.writeSFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case SFIXED64: {
                    writer.writeSFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    return;
                }
                case SINT32: {
                    writer.writeSInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case SINT64: {
                    writer.writeSInt64(descriptor.getNumber(), (Long)extension.getValue());
                    return;
                }
                case ENUM: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    return;
                }
                case STRING: {
                    writer.writeString(descriptor.getNumber(), (String)extension.getValue());
                    return;
                }
                case GROUP: {
                    writer.writeGroup(descriptor.getNumber(), extension.getValue(), Protobuf.getInstance().schemaFor(extension.getValue().getClass()));
                    return;
                }
                case MESSAGE: {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    var1_1.writeMessage(var3_3.getNumber(), extension.getValue(), Protobuf.getInstance().schemaFor(var2_2.getValue().getClass()));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number) {
        void var3_3;
        void var2_2;
        return extensionRegistry.findLiteExtensionByNumber(var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void parseLengthPrefixedMessageSetItem(Reader reader, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        Object value = reader.readMessage(((ExtensionLite)extension).getMessageDefaultInstance().getClass(), (ExtensionRegistryLite)var3_3);
        extensions.setField(var2_2.descriptor, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void parseMessageSetItem(ByteString data, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        MessageLite.Builder builder = ((ExtensionLite)extension).getMessageDefaultInstance().newBuilderForType();
        CodedInputStream input = data.newCodedInput();
        builder.mergeFrom(input, (ExtensionRegistryLite)var3_3);
        extensions.setField(var2_2.descriptor, builder.buildPartial());
        var1_1.checkLastTagWas(0);
    }
}

