/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList<Double>
implements Internal.DoubleList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final DoubleArrayList EMPTY_LIST = new DoubleArrayList(new double[0], 0, false);
    private double[] array;
    private int size;

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    DoubleArrayList() {
        this(new double[10], 0, true);
    }

    /*
     * WARNING - void declaration
     */
    private DoubleArrayList(double[] other, int size, boolean isMutable) {
        super((boolean)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.array = var1_1;
        this.size = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= var2_2 - var1_1;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleArrayList)) {
            return super.equals(o);
        }
        DoubleArrayList other = (DoubleArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        double[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.array[i]) == Double.doubleToLongBits(arr[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            long bits = Double.doubleToLongBits(this.array[i]);
            result = result * 31 + Internal.hashLong((long)var3_3);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Internal.DoubleList mutableCopyWithCapacity(int capacity) {
        void var1_1;
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new DoubleArrayList(Arrays.copyOf(this.array, (int)var1_1), this.size, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double get(int index) {
        void var1_1;
        return this.getDouble((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double getDouble(int index) {
        void var1_1;
        this.ensureIndexInRange(index);
        return this.array[var1_1];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Double)) {
            return -1;
        }
        double unboxedElement = (Double)element;
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double set(int index, Double element) {
        void var2_2;
        void var1_1;
        return this.setDouble((int)var1_1, var2_2.doubleValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double setDouble(int index, double element) {
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        double previousValue = this.array[index];
        this.array[var1_1] = var2_2;
        return previousValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(Double element) {
        void var1_1;
        this.addDouble(var1_1.doubleValue());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, Double element) {
        void var2_2;
        void var1_1;
        this.addDouble((int)var1_1, var2_2.doubleValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addDouble(double element) {
        void var1_1;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            void var3_3;
            int n = this.size * 3 / 2 + 1;
            double[] newArray = new double[n];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = var3_3;
        }
        this.array[this.size++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void addDouble(int index, double element) {
        void var2_2;
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n = this.size * 3 / 2 + 1;
            double[] newArray = new double[n];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
            this.array = newArray;
        }
        this.array[var1_1] = var2_2;
        ++this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        void var1_1;
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof DoubleArrayList)) {
            return super.addAll(collection);
        }
        DoubleArrayList list = (DoubleArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, var1_1.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Double remove(int index) {
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        double value = this.array[index];
        if (index < this.size - 1) {
            void var1_1;
            System.arraycopy(this.array, index + 1, this.array, index, this.size - var1_1 - 1);
        }
        --this.size;
        ++this.modCount;
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            void var1_1;
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage((int)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String makeOutOfBoundsExceptionMessage(int index) {
        void var1_1;
        return "Index:" + (int)var1_1 + ", Size:" + this.size;
    }
}

