/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.BooleanArrayList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.DoubleArrayList;
import androidx.datastore.preferences.protobuf.FloatArrayList;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream output) {
        CodedOutputStream codedOutputStream;
        if (output.wrapper != null) {
            return output.wrapper;
        }
        return new CodedOutputStreamWriter(codedOutputStream);
    }

    /*
     * WARNING - void declaration
     */
    private CodedOutputStreamWriter(CodedOutputStream output) {
        void var1_1;
        this.output = (CodedOutputStream)Internal.checkNotNull(var1_1, "output");
        this.output.wrapper = this;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public final int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSFixed32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSFixed64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFloat((int)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeDouble((int)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeEnum((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeUInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFixed64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFixed32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBool(int fieldNumber, boolean value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeBool((int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeString(int fieldNumber, String value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeString((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeBytes((int)var1_1, (ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeUInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessage(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeMessage((int)var1_1, (MessageLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.output.writeMessage((int)var1_1, (MessageLite)var2_2, (Schema)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeGroup(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeGroup((int)var1_1, (MessageLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.output.writeGroup((int)var1_1, (MessageLite)var2_2, (Schema)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeStartGroup(int fieldNumber) throws IOException {
        void var1_1;
        this.output.writeTag((int)var1_1, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeEndGroup(int fieldNumber) throws IOException {
        void var1_1;
        this.output.writeTag((int)var1_1, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        if (value instanceof ByteString) {
            this.output.writeRawMessageSetExtension(fieldNumber, (ByteString)value);
            return;
        }
        this.output.writeMessageSetExtension((int)var1_1, (MessageLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeInt32ListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeInt32NoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeInt32((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeFixed32ListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeFixed32ListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeFixed32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFixed32SizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed32NoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed32((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFixed32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFixed32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof LongArrayList) {
            this.writeInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
            return;
        }
        this.writeInt64ListInternal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value.getLong(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeInt64NoTag(value.getLong(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeInt64((int)var1_1, value.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeInt64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeInt64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof LongArrayList) {
            this.writeUInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
            return;
        }
        this.writeUInt64ListInternal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeUInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value.getLong(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt64NoTag(value.getLong(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt64((int)var1_1, value.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeUInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof LongArrayList) {
            this.writeFixed64ListInternal(fieldNumber, (LongArrayList)value, packed);
            return;
        }
        this.writeFixed64ListInternal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeFixed64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFixed64SizeNoTag(value.getLong(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed64NoTag(value.getLong(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed64((int)var1_1, value.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFixed64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFixed64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloatList(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof FloatArrayList) {
            this.writeFloatListInternal(fieldNumber, (FloatArrayList)value, packed);
            return;
        }
        this.writeFloatListInternal((int)var1_1, (List<Float>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeFloatListInternal(int fieldNumber, FloatArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFloatSizeNoTag(value.getFloat(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFloatNoTag(value.getFloat(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFloat((int)var1_1, value.getFloat(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeFloatListInternal(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeFloatSizeNoTag(value.get(i).floatValue());
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFloatNoTag(value.get(i).floatValue());
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFloat((int)var1_1, value.get(i).floatValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDoubleList(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof DoubleArrayList) {
            this.writeDoubleListInternal(fieldNumber, (DoubleArrayList)value, packed);
            return;
        }
        this.writeDoubleListInternal((int)var1_1, (List<Double>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeDoubleListInternal(int fieldNumber, DoubleArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeDoubleSizeNoTag(value.getDouble(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeDoubleNoTag(value.getDouble(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeDouble((int)var1_1, value.getDouble(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeDoubleListInternal(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeDoubleSizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeDoubleNoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeDouble((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnumList(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeEnumListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeEnumListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeEnumListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeEnumNoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeEnum((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeEnumListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeEnumNoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeEnum((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBoolList(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof BooleanArrayList) {
            this.writeBoolListInternal(fieldNumber, (BooleanArrayList)value, packed);
            return;
        }
        this.writeBoolListInternal((int)var1_1, (List<Boolean>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeBoolListInternal(int fieldNumber, BooleanArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeBoolSizeNoTag(value.getBoolean(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeBoolNoTag(value.getBoolean(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeBool((int)var1_1, value.getBoolean(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeBoolListInternal(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeBoolSizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeBoolNoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeBool((int)var1_1, value.get(i));
        }
    }

    @Override
    public final void writeStringList(int fieldNumber, List<String> value) throws IOException {
        if (value instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)value;
            for (int i = 0; i < value.size(); ++i) {
                this.writeLazyString(fieldNumber, lazyList.getRaw(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            this.output.writeString(fieldNumber, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLazyString(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        if (value instanceof String) {
            this.output.writeString(fieldNumber, (String)value);
            return;
        }
        this.output.writeBytes((int)var1_1, (ByteString)var2_2);
    }

    @Override
    public final void writeBytesList(int fieldNumber, List<ByteString> value) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.output.writeBytes(fieldNumber, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeUInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeUInt32ListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeUInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt32NoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt32((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeUInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeSFixed32ListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeSFixed32ListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeSFixed32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSFixed32NoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSFixed32((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSFixed32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSFixed32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSFixed32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof LongArrayList) {
            this.writeSFixed64ListInternal(fieldNumber, (LongArrayList)value, packed);
            return;
        }
        this.writeSFixed64ListInternal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeSFixed64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag(value.getLong(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSFixed64NoTag(value.getLong(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSFixed64((int)var1_1, value.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSFixed64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSFixed64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSFixed64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof IntArrayList) {
            this.writeSInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
            return;
        }
        this.writeSInt32ListInternal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeSInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value.getInt(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt32NoTag(value.getInt(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt32((int)var1_1, value.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value instanceof LongArrayList) {
            this.writeSInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
            return;
        }
        this.writeSInt64ListInternal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeSInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value.getLong(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt64NoTag(value.getLong(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt64((int)var1_1, value.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt64((int)var1_1, value.get(i));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> value) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeMessage(fieldNumber, value.get(i));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeMessage(fieldNumber, value.get(i), schema);
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int fieldNumber, List<?> value) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeGroup(fieldNumber, value.get(i));
        }
    }

    @Override
    public final void writeGroupList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeGroup(fieldNumber, value.get(i), schema);
        }
    }

    @Override
    public final <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        Iterator iterator;
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(fieldNumber, metadata, map);
            return;
        }
        for (Map.Entry entry : iterator.entrySet()) {
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> void writeDeterministicMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V value = map.get(Boolean.FALSE);
                if (value != null) {
                    this.writeDeterministicBooleanMapEntry(fieldNumber, false, value, metadata);
                }
                if ((value = map.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(fieldNumber, true, value, metadata);
                return;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(fieldNumber, metadata, map);
                return;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(fieldNumber, metadata, map);
                return;
            }
            case STRING: {
                void var3_3;
                void var1_1;
                this.writeDeterministicStringMap((int)var1_1, (MapEntryLite.Metadata<String, V>)metadata, (Map<String, V>)var3_3);
                return;
            }
            default: {
                void var2_2;
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)var2_2.keyType));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private <V> void writeDeterministicBooleanMapEntry(int fieldNumber, boolean key, V value, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.output.writeTag((int)var1_1, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key, value));
        MapEntryLite.writeTo(this.output, metadata, (boolean)var2_2, var3_3);
    }

    private <V> void writeDeterministicIntegerMap(int fieldNumber, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map) throws IOException {
        int[] keys = new int[map.size()];
        int index = 0;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            int k = object.next();
            keys[index++] = k;
        }
        Arrays.sort(keys);
        object = keys;
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            Object key = object[i];
            V value = map.get((int)key);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)key, value));
            MapEntryLite.writeTo(this.output, metadata, (int)key, value);
        }
    }

    private <V> void writeDeterministicLongMap(int fieldNumber, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map) throws IOException {
        long[] keys = new long[map.size()];
        int index = 0;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            long k = object.next();
            keys[index++] = k;
        }
        Arrays.sort(keys);
        object = keys;
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            Object key = object[i];
            V value = map.get((long)key);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)key, value));
            MapEntryLite.writeTo(this.output, metadata, (long)key, value);
        }
    }

    private <V> void writeDeterministicStringMap(int fieldNumber, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map) throws IOException {
        Object[] keys = new String[map.size()];
        int index = 0;
        for (String k : map.keySet()) {
            keys[index++] = k;
        }
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            Object key = objectArray[i];
            V value = map.get(key);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key, value));
            MapEntryLite.writeTo(this.output, metadata, key, value);
        }
    }
}

