/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractMessageLite;
import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStreamWriter;
import androidx.datastore.preferences.protobuf.InlineMe;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.LazyFieldLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;
    @Deprecated
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean serializationDeterministic;

    static int computePreferredBufferSize(int dataLength) {
        int n;
        if (dataLength > 4096) {
            return 4096;
        }
        return n;
    }

    public static CodedOutputStream newInstance(OutputStream output) {
        return CodedOutputStream.newInstance(output, 4096);
    }

    /*
     * WARNING - void declaration
     */
    public static CodedOutputStream newInstance(OutputStream output, int bufferSize) {
        void var1_1;
        OutputStream outputStream;
        return new OutputStreamEncoder(outputStream, (int)var1_1);
    }

    public static CodedOutputStream newInstance(byte[] flatArray) {
        byte[] byArray;
        return CodedOutputStream.newInstance(flatArray, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static CodedOutputStream newInstance(byte[] flatArray, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return new ArrayEncoder(byArray, (int)var1_1, (int)var2_2);
    }

    public static CodedOutputStream newInstance(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return new HeapNioEncoder(buffer);
        }
        if (buffer.isDirect() && !buffer.isReadOnly()) {
            ByteBuffer byteBuffer;
            if (UnsafeDirectNioEncoder.isSupported()) {
                return CodedOutputStream.newUnsafeInstance(buffer);
            }
            return CodedOutputStream.newSafeInstance(byteBuffer);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    static CodedOutputStream newUnsafeInstance(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return new UnsafeDirectNioEncoder(byteBuffer);
    }

    static CodedOutputStream newSafeInstance(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return new SafeDirectNioEncoder(byteBuffer);
    }

    public void useDeterministicSerialization() {
        this.serializationDeterministic = true;
    }

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    @Deprecated
    public static CodedOutputStream newInstance(ByteBuffer byteBuffer, int unused) {
        return CodedOutputStream.newInstance(byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    static CodedOutputStream newInstance(ByteOutput byteOutput, int bufferSize) {
        void var1_1;
        ByteOutput byteOutput2;
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        return new ByteOutputEncoder(byteOutput2, (int)var1_1);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt32((int)var1_1, CodedOutputStream.encodeZigZag32((int)var2_2));
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt64((int)var1_1, (long)var2_2);
    }

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt64((int)var1_1, CodedOutputStream.encodeZigZag64((long)var2_2));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed32((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed64((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeInt32((int)var1_1, (int)var2_2);
    }

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2) throws IOException;

    public abstract void writeByteArray(int var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract void writeByteBuffer(int var1, ByteBuffer var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeRawByte(byte value) throws IOException {
        void var1_1;
        ((ByteOutput)this).write((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawByte(int value) throws IOException {
        void var1_1;
        ((ByteOutput)this).write((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(byte[] value) throws IOException {
        void var1_1;
        ((ByteOutput)this).write(value, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    public final void writeRawBytes(ByteString value) throws IOException {
        value.writeTo(this);
    }

    public abstract void writeRawBytes(ByteBuffer var1) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32NoTag(int value) throws IOException {
        void var1_1;
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32((int)var1_1));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed32NoTag(int value) throws IOException {
        void var1_1;
        this.writeFixed32NoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeUInt64NoTag((long)var1_1);
    }

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64((long)var1_1));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed64NoTag(long value) throws IOException {
        void var1_1;
        this.writeFixed64NoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFloatNoTag(float value) throws IOException {
        void var1_1;
        this.writeFixed32NoTag(Float.floatToRawIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDoubleNoTag(double value) throws IOException {
        void var1_1;
        this.writeFixed64NoTag(Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBoolNoTag(boolean value) throws IOException {
        void var1_1;
        ((ByteOutput)this).write((byte)(var1_1 != false ? 1 : 0));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeEnumNoTag(int value) throws IOException {
        void var1_1;
        this.writeInt32NoTag((int)var1_1);
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeByteArrayNoTag(byte[] value) throws IOException {
        void var1_1;
        this.writeByteArrayNoTag(value, 0, ((void)var1_1).length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    abstract void writeMessageNoTag(MessageLite var1, Schema var2) throws IOException;

    @Override
    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(ByteBuffer var1) throws IOException;

    @Override
    public abstract void writeLazy(ByteBuffer var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public static int computeInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFixed32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSFixed32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFixed64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFixed64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSFixed64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSFixed64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFloatSize(int fieldNumber, float value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeDoubleSize(int fieldNumber, double value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBoolSize(int fieldNumber, boolean value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeEnumSize(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSize(int fieldNumber, String value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBytesSize(int fieldNumber, ByteString value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag((ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeByteArraySize(int fieldNumber, byte[] value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeByteArraySizeNoTag((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeByteBufferSize(int fieldNumber, ByteBuffer value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeByteBufferSizeNoTag((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldSize(int fieldNumber, LazyFieldLite value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSize(int fieldNumber, MessageLite value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int computeMessageSize(int fieldNumber, MessageLite value, Schema schema) {
        void var2_2;
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1, (Schema)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, (MessageLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldMessageSetExtensionSize(int fieldNumber, LazyFieldLite value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeLazyFieldSize(3, (LazyFieldLite)var1_1);
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    public static int computeInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    public static int computeUInt32SizeNoTag(int value) {
        int n;
        int clz = Integer.numberOfLeadingZeros(value);
        return 352 - n * 9 >>> 6;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value));
    }

    public static int computeFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int unused) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64SizeNoTag(long value) {
        void var0_1;
        int clz = Long.numberOfLeadingZeros(value);
        return 640 - var0_1 * 9 >>> 6;
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value));
    }

    public static int computeFixed64SizeNoTag(long unused) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long unused) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float unused) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double unused) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean unused) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSizeNoTag(String value) {
        void var1_1;
        int length;
        try {
            length = Utf8.encodedLength(value);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            Object object;
            byte[] byArray = ((String)object).getBytes(Internal.UTF_8);
            object = byArray;
            length = byArray.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize((int)var1_1);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.size());
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.length);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.capacity());
    }

    public static int computeMessageSizeNoTag(MessageLite value) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(value.getSerializedSize());
    }

    /*
     * WARNING - void declaration
     */
    static int computeMessageSizeNoTag(MessageLite value, Schema schema) {
        void var1_1;
        return CodedOutputStream.computeLengthDelimitedFieldSize(((AbstractMessageLite)value).getSerializedSize((Schema)var1_1));
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        int n;
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + n;
    }

    public static int encodeZigZag32(int n) {
        int n2;
        return n << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long n) {
        long l;
        return n << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void inefficientWriteStringNoTag(String value, Utf8.UnpairedSurrogateException cause) throws IOException {
        void var2_3;
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", (Throwable)var2_3);
        byte[] bytes = value.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(bytes.length);
            ((ByteOutput)this).writeLazy(bytes, 0, bytes.length);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            void var1_2;
            throw new OutOfSpaceException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void writeGroup(int fieldNumber, MessageLite value) throws IOException {
        void var1_1;
        void var2_2;
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag((MessageLite)var2_2);
        this.writeTag((int)var1_1, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    final void writeGroup(int fieldNumber, MessageLite value, Schema schema) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag((MessageLite)var2_2, (Schema)var3_3);
        this.writeTag((int)var1_1, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite value) throws IOException {
        value.writeTo(this);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    final void writeGroupNoTag(MessageLite value, Schema schema) throws IOException {
        void var1_1;
        schema.writeTo(var1_1, this.wrapper);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int computeGroupSize(int fieldNumber, MessageLite value) {
        void var1_1;
        return (CodedOutputStream.computeTagSize(fieldNumber) << 1) + var1_1.getSerializedSize();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    static int computeGroupSize(int fieldNumber, MessageLite value, Schema schema) {
        void var2_2;
        void var1_1;
        return (CodedOutputStream.computeTagSize(fieldNumber) << 1) + CodedOutputStream.computeGroupSizeNoTag((MessageLite)var1_1, (Schema)var2_2);
    }

    @Deprecated
    @InlineMe(replacement="value.getSerializedSize()")
    public static int computeGroupSizeNoTag(MessageLite value) {
        return value.getSerializedSize();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    static int computeGroupSizeNoTag(MessageLite value, Schema schema) {
        void var1_1;
        return ((AbstractMessageLite)value).getSerializedSize((Schema)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this.writeUInt32NoTag(value)")
    public final void writeRawVarint32(int value) throws IOException {
        void var1_1;
        this.writeUInt32NoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this.writeUInt64NoTag(value)")
    public final void writeRawVarint64(long value) throws IOException {
        void var1_1;
        this.writeUInt64NoTag((long)var1_1);
    }

    @Deprecated
    @InlineMe(replacement="CodedOutputStream.computeUInt32SizeNoTag(value)", imports={"androidx.datastore.preferences.protobuf.CodedOutputStream"})
    public static int computeRawVarint32Size(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(value);
    }

    @Deprecated
    @InlineMe(replacement="CodedOutputStream.computeUInt64SizeNoTag(value)", imports={"androidx.datastore.preferences.protobuf.CodedOutputStream"})
    public static int computeRawVarint64Size(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this.writeFixed32NoTag(value)")
    public final void writeRawLittleEndian32(int value) throws IOException {
        void var1_1;
        this.writeFixed32NoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="this.writeFixed64NoTag(value)")
    public final void writeRawLittleEndian64(long value) throws IOException {
        void var1_1;
        this.writeFixed64NoTag((long)var1_1);
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        /*
         * WARNING - void declaration
         */
        OutputStreamEncoder(OutputStream out, int bufferSize) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.out = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(14);
            this.bufferTag((int)var1_1, 5);
            this.bufferFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(18);
            this.bufferTag((int)var1_1, 1);
            this.bufferFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(11);
            this.bufferTag((int)var1_1, 0);
            this.buffer((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeByteArray((int)var1_1, value, 0, ((void)var2_2).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeByteArrayNoTag((byte[])var2_2, (int)var3_3, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(value.capacity());
            ((CodedOutputStream)this).writeRawBytes((ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawBytes(ByteBuffer value) throws IOException {
            void var1_1;
            if (value.hasArray()) {
                ((ByteOutput)this).write(value.array(), value.arrayOffset(), value.capacity());
                return;
            }
            ByteBuffer duplicated = value.duplicate();
            Java8Compatibility.clear(duplicated);
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeMessageNoTag((MessageLite)var2_2, (Schema)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessageNoTag(MessageLite value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var2_2.writeTo(var1_1, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            void var1_1;
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            try {
                int actualLength;
                int maxLength = value.length() * 3;
                int maxLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(maxLength);
                if (maxLengthVarIntSize + maxLength > this.limit) {
                    byte[] encodedBytes = new byte[maxLength];
                    actualLength = Utf8.encode(value, encodedBytes, 0, maxLength);
                    ((CodedOutputStream)this).writeUInt32NoTag(actualLength);
                    ((ByteOutput)this).writeLazy(encodedBytes, 0, actualLength);
                    return;
                }
                if (maxLengthVarIntSize + actualLength > this.limit - this.position) {
                    this.doFlush();
                }
                int minLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(value.length());
                int oldPosition = this.position;
                try {
                    void var3_4;
                    int length;
                    if (minLengthVarIntSize == maxLengthVarIntSize) {
                        this.position = oldPosition + minLengthVarIntSize;
                        int newPosition = Utf8.encode(value, this.buffer, this.position, this.limit - this.position);
                        this.position = oldPosition;
                        length = newPosition - oldPosition - minLengthVarIntSize;
                        this.bufferUInt32NoTag(length);
                        this.position = newPosition;
                    } else {
                        length = Utf8.encodedLength(value);
                        this.bufferUInt32NoTag(length);
                        this.position = Utf8.encode(value, this.buffer, this.position, length);
                    }
                    this.totalBytesWritten += var3_4;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    this.totalBytesWritten -= this.position - oldPosition;
                    this.position = oldPosition;
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(e);
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var2_3;
                void var1_1;
                this.inefficientWriteStringNoTag((String)var1_1, (Utf8.UnpairedSurrogateException)var2_3);
            }
        }

        @Override
        public final void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            if (this.limit - this.position >= length) {
                System.arraycopy(value, offset, this.buffer, this.position, length);
                this.position += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    void var2_2;
                    void var1_1;
                    this.out.write((byte[])var1_1, (int)var2_2, length);
                }
            }
            this.totalBytesWritten += var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            void var3_3;
            int length = value.remaining();
            if (this.limit - this.position >= length) {
                value.get(this.buffer, this.position, length);
                this.position += length;
                this.totalBytesWritten += length;
                return;
            }
            int bytesWritten = this.limit - this.position;
            value.get(this.buffer, this.position, bytesWritten);
            length -= bytesWritten;
            this.position = this.limit;
            this.totalBytesWritten += var3_3;
            this.doFlush();
            while (length > this.limit) {
                value.get(this.buffer, 0, this.limit);
                this.out.write(this.buffer, 0, this.limit);
                length -= this.limit;
                this.totalBytesWritten += this.limit;
            }
            var1_1.get(this.buffer, 0, length);
            this.position = length;
            this.totalBytesWritten += var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) throws IOException {
            void var1_1;
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void flushIfNotAvailable(int requiredSize) throws IOException {
            void var1_1;
            if (this.limit - this.position < var1_1) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static final class ByteOutputEncoder
    extends AbstractBufferedEncoder {
        private final ByteOutput out;

        /*
         * WARNING - void declaration
         */
        ByteOutputEncoder(ByteOutput out, int bufferSize) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.out = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(14);
            this.bufferTag((int)var1_1, 5);
            this.bufferFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(18);
            this.bufferTag((int)var1_1, 1);
            this.bufferFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(11);
            this.bufferTag((int)var1_1, 0);
            this.buffer((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeByteArray((int)var1_1, value, 0, ((void)var2_2).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeByteArrayNoTag((byte[])var2_2, (int)var3_3, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(value.capacity());
            ((CodedOutputStream)this).writeRawBytes((ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawBytes(ByteBuffer value) throws IOException {
            void var1_1;
            if (value.hasArray()) {
                ((ByteOutput)this).write(value.array(), value.arrayOffset(), value.capacity());
                return;
            }
            ByteBuffer duplicated = value.duplicate();
            Java8Compatibility.clear(duplicated);
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeMessageNoTag((MessageLite)var2_2, (Schema)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessageNoTag(MessageLite value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var2_2.writeTo(var1_1, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            void var1_1;
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            block6: {
                int actualLength;
                int maxLength = value.length() * 3;
                int maxLengthVarIntSize = ByteOutputEncoder.computeUInt32SizeNoTag(maxLength);
                if (maxLengthVarIntSize + maxLength > this.limit) {
                    byte[] encodedBytes = new byte[maxLength];
                    actualLength = Utf8.encode(value, encodedBytes, 0, maxLength);
                    ((CodedOutputStream)this).writeUInt32NoTag(actualLength);
                    ((ByteOutput)this).writeLazy(encodedBytes, 0, actualLength);
                    return;
                }
                if (maxLengthVarIntSize + actualLength > this.limit - this.position) {
                    this.doFlush();
                }
                int oldPosition = this.position;
                try {
                    void var3_5;
                    int minLengthVarIntSize = ByteOutputEncoder.computeUInt32SizeNoTag(value.length());
                    if (minLengthVarIntSize == maxLengthVarIntSize) {
                        this.position = oldPosition + minLengthVarIntSize;
                        int newPosition = Utf8.encode(value, this.buffer, this.position, this.limit - this.position);
                        this.position = oldPosition;
                        int length = newPosition - oldPosition - minLengthVarIntSize;
                        this.bufferUInt32NoTag(length);
                        this.position = newPosition;
                        this.totalBytesWritten += length;
                        break block6;
                    }
                    int length = Utf8.encodedLength(value);
                    this.bufferUInt32NoTag(length);
                    this.position = Utf8.encode(value, this.buffer, this.position, length);
                    this.totalBytesWritten += var3_5;
                    return;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    void var1_1;
                    this.totalBytesWritten -= this.position - oldPosition;
                    this.position = oldPosition;
                    this.inefficientWriteStringNoTag((String)var1_1, e);
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    void var2_4;
                    throw new OutOfSpaceException((Throwable)var2_4);
                }
            }
        }

        @Override
        public final void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).flush();
            this.out.write((byte[])var1_1, (int)var2_2, length);
            this.totalBytesWritten += var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).flush();
            this.out.writeLazy((byte[])var1_1, (int)var2_2, length);
            this.totalBytesWritten += var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).flush();
            int length = value.remaining();
            this.out.write((ByteBuffer)var1_1);
            this.totalBytesWritten += var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).flush();
            int length = value.remaining();
            this.out.writeLazy((ByteBuffer)var1_1);
            this.totalBytesWritten += var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void flushIfNotAvailable(int requiredSize) throws IOException {
            void var1_1;
            if (this.limit - this.position < var1_1) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        /*
         * WARNING - void declaration
         */
        AbstractBufferedEncoder(int bufferSize) {
            void var1_1;
            if (bufferSize < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max((int)var1_1, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        /*
         * WARNING - void declaration
         */
        final void buffer(byte value) {
            void var1_1;
            this.buffer[this.position++] = var1_1;
            ++this.totalBytesWritten;
        }

        /*
         * WARNING - void declaration
         */
        final void bufferTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.bufferUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        final void bufferInt32NoTag(int value) {
            void var1_1;
            if (value >= 0) {
                this.bufferUInt32NoTag(value);
                return;
            }
            this.bufferUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void bufferUInt32NoTag(int value) {
            void var1_1;
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                void var2_2;
                long originalPos = this.position;
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)(value | 0x80));
                    value >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value);
                int delta = (int)((long)this.position - var2_2);
                this.totalBytesWritten += var1_1;
                return;
            }
            while (true) {
                if ((var1_1 & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)var1_1;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(var1_1 | 0x80);
                ++this.totalBytesWritten;
                var1_1 >>>= 7;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void bufferUInt64NoTag(long value) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                void var1_2;
                void var3_3;
                long originalPos = this.position;
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)value | 0x80));
                    value >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value);
                int delta = (int)((long)this.position - var3_3);
                this.totalBytesWritten += var1_2;
                return;
            }
            while (true) {
                void var1_1;
                if ((var1_1 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)var1_1;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)var1_1 | 0x80);
                ++this.totalBytesWritten;
                var1_1 >>>= 7;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void bufferFixed32NoTag(int value) {
            void var1_1;
            this.buffer[this.position++] = (byte)value;
            this.buffer[this.position++] = (byte)(value >> 8);
            this.buffer[this.position++] = (byte)(value >> 16);
            this.buffer[this.position++] = (byte)(var1_1 >>> 24);
            this.totalBytesWritten += 4;
        }

        /*
         * WARNING - void declaration
         */
        final void bufferFixed64NoTag(long value) {
            void var1_1;
            this.buffer[this.position++] = (byte)(value & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 32);
            this.buffer[this.position++] = (byte)(value >> 40);
            this.buffer[this.position++] = (byte)(value >> 48);
            this.buffer[this.position++] = (byte)(var1_1 >> 56);
            this.totalBytesWritten += 8;
        }
    }

    private static final class UnsafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final long address;
        private final long initialPosition;
        private final long limit;
        private final long oneVarintLimit;
        private long position;

        /*
         * WARNING - void declaration
         */
        UnsafeDirectNioEncoder(ByteBuffer buffer) {
            void var1_1;
            this.originalBuffer = buffer;
            this.buffer = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.address = UnsafeUtil.addressOffset(buffer);
            this.initialPosition = this.address + (long)buffer.position();
            this.limit = this.address + (long)var1_1.limit();
            this.oneVarintLimit = this.limit - 10L;
            this.position = this.initialPosition;
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 5);
            ((CodedOutputStream)this).writeFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 1);
            ((CodedOutputStream)this).writeFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeByteArray((int)var1_1, value, 0, ((void)var2_2).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeByteArrayNoTag((byte[])var2_2, (int)var3_3, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(value.capacity());
            ((CodedOutputStream)this).writeRawBytes((ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeMessageNoTag((MessageLite)var2_2, (Schema)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessageNoTag(MessageLite value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var2_2.writeTo(var1_1, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            void var1_1;
            if (this.position >= this.limit) {
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
            }
            UnsafeUtil.putByte(this.position++, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawBytes(ByteBuffer value) throws IOException {
            void var1_1;
            if (value.hasArray()) {
                ((ByteOutput)this).write(value.array(), value.arrayOffset(), value.capacity());
                return;
            }
            ByteBuffer duplicated = value.duplicate();
            Java8Compatibility.clear(duplicated);
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        UnsafeUtil.putByte(this.position++, (byte)value);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)(value | 0x80));
                    value >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((value & 0xFFFFFF80) == 0) {
                    UnsafeUtil.putByte(this.position++, (byte)value);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)(value | 0x80));
                value >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            void var1_1;
            UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
            this.buffer.putInt(unsafeDirectNioEncoder.bufferPos(unsafeDirectNioEncoder.position), (int)var1_1);
            this.position += 4L;
        }

        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            if (this.position <= this.oneVarintLimit) {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.position++, (byte)value);
                        return;
                    }
                    UnsafeUtil.putByte(this.position++, (byte)((int)value | 0x80));
                    value >>>= 7;
                }
            }
            while (this.position < this.limit) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    UnsafeUtil.putByte(this.position++, (byte)value);
                    return;
                }
                UnsafeUtil.putByte(this.position++, (byte)((int)value | 0x80));
                value >>>= 7;
            }
            throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            void var1_1;
            UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
            this.buffer.putLong(unsafeDirectNioEncoder.bufferPos(unsafeDirectNioEncoder.position), (long)var1_1);
            this.position += 8L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            if (value == null || offset < 0 || length < 0 || value.length - length < offset || this.limit - (long)length < this.position) {
                if (value == null) {
                    throw new NullPointerException("value");
                }
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, length));
            }
            UnsafeUtil.copyMemory((byte[])var1_1, (long)var2_2, this.position, (long)length);
            this.position += (long)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) throws IOException {
            try {
                void var1_1;
                int length = value.remaining();
                UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
                unsafeDirectNioEncoder.repositionBuffer(unsafeDirectNioEncoder.position);
                this.buffer.put((ByteBuffer)var1_1);
                this.position += (long)length;
                return;
            }
            catch (BufferOverflowException e) {
                void var2_3;
                throw new OutOfSpaceException((Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) throws IOException {
            void var1_1;
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            block5: {
                long prevPos = this.position;
                try {
                    int length;
                    int n = value.length() * 3;
                    int maxLengthVarIntSize = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(n);
                    int minLengthVarIntSize = UnsafeDirectNioEncoder.computeUInt32SizeNoTag(value.length());
                    if (minLengthVarIntSize == maxLengthVarIntSize) {
                        UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
                        int stringStart = unsafeDirectNioEncoder.bufferPos(unsafeDirectNioEncoder.position) + minLengthVarIntSize;
                        Java8Compatibility.position(this.buffer, stringStart);
                        Utf8.encodeUtf8(value, this.buffer);
                        length = this.buffer.position() - stringStart;
                        ((CodedOutputStream)this).writeUInt32NoTag(length);
                        this.position += (long)length;
                        break block5;
                    }
                    length = Utf8.encodedLength(value);
                    ((CodedOutputStream)this).writeUInt32NoTag(length);
                    UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
                    unsafeDirectNioEncoder.repositionBuffer(unsafeDirectNioEncoder.position);
                    Utf8.encodeUtf8(value, this.buffer);
                    this.position += (long)length;
                    return;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    void var1_1;
                    void var2_2;
                    this.position = var2_2;
                    UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
                    unsafeDirectNioEncoder.repositionBuffer(unsafeDirectNioEncoder.position);
                    this.inefficientWriteStringNoTag((String)var1_1, e);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new OutOfSpaceException(e);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(e);
                }
            }
        }

        @Override
        public final void flush() {
            UnsafeDirectNioEncoder unsafeDirectNioEncoder = this;
            Java8Compatibility.position(this.originalBuffer, unsafeDirectNioEncoder.bufferPos(unsafeDirectNioEncoder.position));
        }

        @Override
        public final int spaceLeft() {
            return (int)(this.limit - this.position);
        }

        @Override
        public final int getTotalBytesWritten() {
            return (int)(this.position - this.initialPosition);
        }

        /*
         * WARNING - void declaration
         */
        private void repositionBuffer(long pos) {
            void var1_1;
            Java8Compatibility.position(this.buffer, this.bufferPos((long)var1_1));
        }

        private int bufferPos(long pos) {
            return (int)(pos - this.address);
        }
    }

    private static final class SafeDirectNioEncoder
    extends CodedOutputStream {
        private final ByteBuffer originalBuffer;
        private final ByteBuffer buffer;
        private final int initialPosition;

        /*
         * WARNING - void declaration
         */
        SafeDirectNioEncoder(ByteBuffer buffer) {
            void var1_1;
            this.originalBuffer = buffer;
            this.buffer = buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.initialPosition = var1_1.position();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 5);
            ((CodedOutputStream)this).writeFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 1);
            ((CodedOutputStream)this).writeFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeByteArray((int)var1_1, value, 0, ((void)var2_2).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeByteArrayNoTag((byte[])var2_2, (int)var3_3, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(value.capacity());
            ((CodedOutputStream)this).writeRawBytes((ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeMessageNoTag((MessageLite)var2_2, (Schema)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessageNoTag(MessageLite value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var2_2.writeTo(var1_1, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            try {
                this.buffer.put(value);
                return;
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawBytes(ByteBuffer value) throws IOException {
            void var1_1;
            if (value.hasArray()) {
                ((ByteOutput)this).write(value.array(), value.arrayOffset(), value.capacity());
                return;
            }
            ByteBuffer duplicated = value.duplicate();
            Java8Compatibility.clear(duplicated);
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.buffer.put((byte)value);
                        return;
                    }
                    this.buffer.put((byte)(value | 0x80));
                    value >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            try {
                this.buffer.putInt(value);
                return;
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer.put((byte)value);
                        return;
                    }
                    this.buffer.put((byte)((int)value | 0x80));
                    value >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            try {
                this.buffer.putLong(value);
                return;
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) throws IOException {
            try {
                void var3_5;
                void var2_4;
                this.buffer.put(value, (int)var2_4, (int)var3_5);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
            catch (BufferOverflowException e) {
                void var1_3;
                throw new OutOfSpaceException((Throwable)var1_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) throws IOException {
            try {
                this.buffer.put(value);
                return;
            }
            catch (BufferOverflowException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) throws IOException {
            void var1_1;
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            int startPos = this.buffer.position();
            try {
                int n = value.length() * 3;
                int maxLengthVarIntSize = SafeDirectNioEncoder.computeUInt32SizeNoTag(n);
                int minLengthVarIntSize = SafeDirectNioEncoder.computeUInt32SizeNoTag(value.length());
                if (minLengthVarIntSize != maxLengthVarIntSize) {
                    int length = Utf8.encodedLength(value);
                    ((CodedOutputStream)this).writeUInt32NoTag(length);
                    this.encode(value);
                    return;
                }
                int startOfBytes = this.buffer.position() + minLengthVarIntSize;
                Java8Compatibility.position(this.buffer, startOfBytes);
                this.encode(value);
                int endOfBytes = this.buffer.position();
                Java8Compatibility.position(this.buffer, startPos);
                ((CodedOutputStream)this).writeUInt32NoTag(endOfBytes - startOfBytes);
                Java8Compatibility.position(this.buffer, endOfBytes);
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var1_1;
                void var2_2;
                Java8Compatibility.position(this.buffer, (int)var2_2);
                this.inefficientWriteStringNoTag((String)var1_1, e);
                return;
            }
            catch (IllegalArgumentException e) {
                void var3_5;
                throw new OutOfSpaceException((Throwable)var3_5);
            }
        }

        @Override
        public final void flush() {
            Java8Compatibility.position(this.originalBuffer, this.buffer.position());
        }

        @Override
        public final int spaceLeft() {
            return this.buffer.remaining();
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.buffer.position() - this.initialPosition;
        }

        /*
         * WARNING - void declaration
         */
        private void encode(String value) throws IOException {
            try {
                Utf8.encodeUtf8(value, this.buffer);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException((Throwable)var1_2);
            }
        }
    }

    private static final class HeapNioEncoder
    extends ArrayEncoder {
        private final ByteBuffer byteBuffer;
        private int initialPosition;

        /*
         * WARNING - void declaration
         */
        HeapNioEncoder(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            void var1_1;
            this.byteBuffer = byteBuffer;
            this.initialPosition = var1_1.position();
        }

        @Override
        public final void flush() {
            Java8Compatibility.position(this.byteBuffer, this.initialPosition + ((CodedOutputStream)this).getTotalBytesWritten());
        }
    }

    private static class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        /*
         * WARNING - void declaration
         */
        ArrayEncoder(byte[] buffer, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if ((offset | length | buffer.length - (offset + length)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", buffer.length, offset, length));
            }
            this.buffer = var1_1;
            this.offset = offset;
            this.position = offset;
            this.limit = var2_2 + var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 5);
            ((CodedOutputStream)this).writeFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 1);
            ((CodedOutputStream)this).writeFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeByteArray((int)var1_1, value, 0, ((void)var2_2).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArray(int fieldNumber, byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            this.writeByteArrayNoTag((byte[])var2_2, (int)var3_3, length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteBuffer(int fieldNumber, ByteBuffer value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(value.capacity());
            ((CodedOutputStream)this).writeRawBytes((ByteBuffer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawBytes(ByteBuffer value) throws IOException {
            void var1_1;
            if (value.hasArray()) {
                ((ByteOutput)this).write(value.array(), value.arrayOffset(), value.capacity());
                return;
            }
            ByteBuffer duplicated = value.duplicate();
            Java8Compatibility.clear(duplicated);
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var2_2;
            void var3_3;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var3_3.writeTo(var2_2, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            ((CodedOutputStream)this).writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessageNoTag(MessageLite value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            ((CodedOutputStream)this).writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var2_2.writeTo(var1_1, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            try {
                this.buffer[this.position++] = value;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(value | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && ((CodedOutputStream)this).spaceLeft() >= 10) {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)value);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, (long)this.position++, (byte)((int)value | 0x80));
                    value >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >> 24);
                this.buffer[this.position++] = (byte)(value >> 32);
                this.buffer[this.position++] = (byte)(value >> 40);
                this.buffer[this.position++] = (byte)(value >> 48);
                this.buffer[this.position++] = (byte)(value >> 56);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) throws IOException {
            try {
                void var2_3;
                System.arraycopy(value, (int)var2_3, this.buffer, this.position, length);
                this.position += length;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                void var3_4;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, (int)var3_4), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            ((ByteOutput)this).write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) throws IOException {
            int length = value.remaining();
            try {
                value.get(this.buffer, this.position, length);
                this.position += length;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                void var2_3;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, (int)var2_3), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) throws IOException {
            void var1_1;
            ((ByteOutput)this).write((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            int oldPosition = this.position;
            try {
                int n = value.length() * 3;
                int maxLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(n);
                int minLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(value.length());
                if (minLengthVarIntSize != maxLengthVarIntSize) {
                    int length = Utf8.encodedLength(value);
                    ((CodedOutputStream)this).writeUInt32NoTag(length);
                    this.position = Utf8.encode(value, this.buffer, this.position, ((CodedOutputStream)this).spaceLeft());
                    return;
                }
                this.position = oldPosition + minLengthVarIntSize;
                int newPosition = Utf8.encode(value, this.buffer, this.position, ((CodedOutputStream)this).spaceLeft());
                this.position = oldPosition;
                int length = newPosition - oldPosition - minLengthVarIntSize;
                ((CodedOutputStream)this).writeUInt32NoTag(length);
                this.position = newPosition;
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var1_1;
                void var2_2;
                this.position = var2_2;
                this.inefficientWriteStringNoTag((String)var1_1, e);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var3_5;
                throw new OutOfSpaceException((Throwable)var3_5);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.position - this.offset;
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;
        private static final String MESSAGE = "CodedOutputStream was writing to a flat byte array and ran out of space.";

        OutOfSpaceException() {
            super(MESSAGE);
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(String explanationMessage) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + (String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(Throwable cause) {
            super(MESSAGE, (Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + (String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

