/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import androidx.datastore.preferences.protobuf.ByteBufferWriter;
import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.CompileTimeConstant;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.RopeByteString;
import androidx.datastore.preferences.protobuf.TextFormatEscaper;
import androidx.datastore.preferences.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

@CheckReturnValue
public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    private static final long serialVersionUID = 1L;
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier() : new ArraysByteArrayCopier();
    private int hash = 0;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new Comparator<ByteString>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(ByteString former, ByteString latter) {
            void var2_2;
            void var1_1;
            ByteIterator formerBytes = former.iterator();
            ByteIterator latterBytes = latter.iterator();
            while (formerBytes.hasNext() && latterBytes.hasNext()) {
                int result = Integer.valueOf(ByteString.toInt(formerBytes.nextByte())).compareTo(ByteString.toInt(latterBytes.nextByte()));
                if (result == 0) continue;
                return result;
            }
            return Integer.valueOf(var1_1.size()).compareTo(var2_2.size());
        }
    };

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public ByteIterator iterator() {
        return new AbstractByteIterator(this){
            private int position = 0;
            private final int limit = this.this$0.size();
            final /* synthetic */ ByteString this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public boolean hasNext() {
                return this.position < this.limit;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public byte nextByte() {
                void var1_1;
                int currentPos = this.position;
                if (currentPos >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = currentPos + 1;
                return this.this$0.internalByteAt((int)var1_1);
            }
        };
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public static final ByteString empty() {
        return EMPTY;
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    private static int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            char c2;
            return c2 - 97 + 10;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static int extractHexDigit(String hexString, int index) {
        void var2_2;
        int digit = ByteString.hexDigit(hexString.charAt(index));
        if (digit == -1) {
            void var1_1;
            String string;
            throw new NumberFormatException("Invalid hexString " + hexString + " must only contain [0-9a-fA-F] but contained " + string.charAt(index) + " at index " + (int)var1_1);
        }
        return (int)var2_2;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString substring(int beginIndex) {
        void var1_1;
        return this.substring((int)var1_1, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    public final boolean startsWith(ByteString prefix) {
        void var1_1;
        return this.size() >= prefix.size() && this.substring(0, prefix.size()).equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean endsWith(ByteString suffix) {
        if (this.size() >= suffix.size()) {
            void var1_1;
            ByteString byteString = this;
            if (byteString.substring(byteString.size() - suffix.size()).equals(var1_1)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString fromHex(@CompileTimeConstant String hexString) {
        void var1_1;
        if (hexString.length() % 2 != 0) {
            throw new NumberFormatException("Invalid hexString " + hexString + " of length " + hexString.length() + " must be even.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            void var3_3;
            int d1 = ByteString.extractHexDigit(hexString, 2 * i);
            int d2 = ByteString.extractHexDigit(hexString, 2 * i + 1);
            bytes[i] = (byte)(var3_3 << 4 | d2);
        }
        return new LiteralByteString((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int n = offset;
        ByteString.checkRange(n, n + size, bytes.length);
        return new LiteralByteString(byteArrayCopier.copyFrom(byArray, (int)var1_1, (int)var2_2));
    }

    public static ByteString copyFrom(byte[] bytes) {
        byte[] byArray;
        return ByteString.copyFrom(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    static ByteString wrap(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (buffer.hasArray()) {
            void var1_1;
            int offset = buffer.arrayOffset();
            return ByteString.wrap(buffer.array(), (int)(var1_1 + buffer.position()), buffer.remaining());
        }
        return new NioByteString(byteBuffer);
    }

    static ByteString nioByteString(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        return new NioByteString(byteBuffer);
    }

    static ByteString wrap(byte[] bytes) {
        byte[] byArray;
        return new LiteralByteString(byArray);
    }

    /*
     * WARNING - void declaration
     */
    static ByteString wrap(byte[] bytes, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return new BoundedByteString(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(ByteBuffer bytes, int size) {
        void var1_2;
        ByteBuffer byteBuffer;
        ByteString.checkRange(0, size, bytes.remaining());
        byte[] copy = new byte[size];
        byteBuffer.get(copy);
        return new LiteralByteString((byte[])var1_2);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        ByteBuffer byteBuffer = bytes;
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        void var1_1;
        String string;
        return new LiteralByteString(string.getBytes((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(String text, Charset charset) {
        void var1_1;
        String string;
        return new LiteralByteString(string.getBytes((Charset)var1_1));
    }

    public static ByteString copyFromUtf8(String text) {
        String string;
        return new LiteralByteString(string.getBytes(Internal.UTF_8));
    }

    public static ByteString readFrom(InputStream streamToDrain) throws IOException {
        return ByteString.readFrom(streamToDrain, 256, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString readFrom(InputStream streamToDrain, int chunkSize) throws IOException {
        void var1_1;
        void v0 = var1_1;
        return ByteString.readFrom(streamToDrain, (int)v0, (int)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString readFrom(InputStream streamToDrain, int minChunkSize, int maxChunkSize) throws IOException {
        void var3_3;
        int chunkSize;
        ByteString chunk;
        ArrayList<ByteString> results = new ArrayList<ByteString>();
        while ((chunk = ByteString.readChunk(streamToDrain, chunkSize)) != null) {
            results.add(chunk);
            chunkSize = Math.min((int)(chunkSize << 1), maxChunkSize);
        }
        return ByteString.copyFrom((Iterable<ByteString>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteString readChunk(InputStream in, int chunkSize) throws IOException {
        void var3_3;
        void var2_2;
        int bytesRead;
        int count;
        byte[] buf = new byte[chunkSize];
        for (bytesRead = 0; bytesRead < chunkSize && (count = in.read(buf, bytesRead, chunkSize - bytesRead)) != -1; bytesRead += count) {
        }
        if (bytesRead == 0) {
            return null;
        }
        return ByteString.copyFrom((byte[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString concat(ByteString other) {
        void var1_1;
        if (Integer.MAX_VALUE - this.size() < other.size()) {
            throw new IllegalArgumentException("ByteString would be too long: " + this.size() + "+" + other.size());
        }
        return RopeByteString.concatenate(this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(Iterable<ByteString> byteStrings) {
        void var1_1;
        Iterable<ByteString> iterable;
        int size;
        if (!(byteStrings instanceof Collection)) {
            int tempSize = 0;
            Iterator<ByteString> iter = byteStrings.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++tempSize;
            }
        } else {
            size = ((Collection)byteStrings).size();
        }
        if (size == 0) {
            return EMPTY;
        }
        return ByteString.balancedConcat(iterable.iterator(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteString balancedConcat(Iterator<ByteString> iterator, int length) {
        ByteString byteString;
        ByteString result;
        if (length <= 0) {
            throw new IllegalArgumentException(String.format("length (%s) must be >= 1", length));
        }
        if (length == 1) {
            result = iterator.next();
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            int halfLength = length >>> 1;
            ByteString left = ByteString.balancedConcat((Iterator<ByteString>)((Object)result), halfLength);
            ByteString right = ByteString.balancedConcat((Iterator<ByteString>)((Object)result), (int)(var1_1 - var2_2));
            result = var3_3.concat(right);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(byte[] target, int offset) {
        void var2_2;
        void var1_1;
        this.copyTo((byte[])var1_1, 0, (int)var2_2, this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        int n = sourceOffset;
        ByteString.checkRange(n, n + numberToCopy, this.size());
        int n2 = targetOffset;
        ByteString.checkRange(n2, n2 + numberToCopy, target.length);
        if (numberToCopy > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.copyToInternal((byte[])var1_1, (int)var2_2, (int)var3_3, numberToCopy);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var2_2;
        void var1_1;
        int size = this.size();
        if (size == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, (int)var1_1);
        return var2_2;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void writeTo(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        int n = sourceOffset;
        ByteString.checkRange(n, n + numberToWrite, this.size());
        if (numberToWrite > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.writeToInternal((OutputStream)var1_1, (int)var2_2, (int)var3_3);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3) throws IOException;

    abstract void writeTo(ByteOutput var1) throws IOException;

    abstract void writeToReverse(ByteOutput var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    /*
     * WARNING - void declaration
     */
    public final String toString(String charsetName) throws UnsupportedEncodingException {
        try {
            return this.toString(Charset.forName(charsetName));
        }
        catch (UnsupportedCharsetException e) {
            void var1_1;
            void var2_2;
            UnsupportedEncodingException exception = new UnsupportedEncodingException(charsetName);
            exception.initCause((Throwable)var2_2);
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(Charset charset) {
        void var1_1;
        if (this.size() == 0) {
            return "";
        }
        return this.toStringInternal((Charset)var1_1);
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n;
        int h = this.hash;
        if (h == 0) {
            int size = this.size();
            n = this.partialHash(size, 0, n);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int initialCapacity) {
        int n;
        return new Output(n);
    }

    public static Output newOutput() {
        return new Output(128);
    }

    static CodedBuilder newCodedBuilder(int size) {
        int n;
        return new CodedBuilder(n);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    static void checkIndex(int index, int size) {
        if ((index | size - (index + 1)) < 0) {
            void var1_1;
            int n;
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + n + ", " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    static int checkRange(int startIndex, int endIndex, int size) {
        void var3_3;
        int length = endIndex - startIndex;
        if ((startIndex | endIndex | length | size - endIndex) < 0) {
            void var2_2;
            void var1_1;
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + startIndex + " < 0");
            }
            if (endIndex < startIndex) {
                int n;
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + n + ", " + endIndex);
            }
            throw new IndexOutOfBoundsException("End index: " + (int)var1_1 + " >= " + (int)var2_2);
        }
        return (int)var3_3;
    }

    public final String toString() {
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), this.truncateAndEscapeForDisplay());
    }

    private String truncateAndEscapeForDisplay() {
        if (this.size() <= 50) {
            return TextFormatEscaper.escapeBytes(this);
        }
        return TextFormatEscaper.escapeBytes(this.substring(0, 47)) + "...";
    }

    private static final class NioByteString
    extends LeafByteString {
        private final ByteBuffer buffer;

        /*
         * WARNING - void declaration
         */
        NioByteString(ByteBuffer buffer) {
            void var1_1;
            Internal.checkNotNull(buffer, "buffer");
            this.buffer = var1_1.slice().order(ByteOrder.nativeOrder());
        }

        private Object writeReplace() {
            return ByteString.copyFrom(this.buffer.slice());
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new InvalidObjectException("NioByteString instances are not to be serialized directly");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte byteAt(int index2) {
            try {
                return this.buffer.get(index2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ArrayIndexOutOfBoundsException index2 = arrayIndexOutOfBoundsException;
                throw arrayIndexOutOfBoundsException;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_3;
                throw new ArrayIndexOutOfBoundsException(var1_3.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte internalByteAt(int index) {
            void var1_1;
            return ((ByteString)this).byteAt((int)var1_1);
        }

        @Override
        public final int size() {
            return this.buffer.remaining();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString substring(int beginIndex, int endIndex) {
            try {
                void var2_5;
                ByteBuffer slice = this.slice(beginIndex, (int)var2_5);
                return new NioByteString(slice);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ArrayIndexOutOfBoundsException slice = arrayIndexOutOfBoundsException;
                throw arrayIndexOutOfBoundsException;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_4;
                throw new ArrayIndexOutOfBoundsException(var1_4.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var3_3;
            void var1_1;
            void var2_2;
            ByteBuffer slice = this.buffer.slice();
            Java8Compatibility.position(slice, (int)var2_2);
            slice.get((byte[])var1_1, (int)var3_3, numberToCopy);
        }

        @Override
        public final void copyTo(ByteBuffer target) {
            target.put(this.buffer.slice());
        }

        @Override
        public final void writeTo(OutputStream out) throws IOException {
            out.write(this.toByteArray());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsRange(ByteString other, int offset, int length) {
            void var3_3;
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            return ((ByteString)this).substring(0, length).equals(var1_1.substring((int)v0, (int)(v0 + var3_3)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this.buffer.hasArray()) {
                int bufferOffset = this.buffer.arrayOffset() + this.buffer.position() + sourceOffset;
                out.write(this.buffer.array(), (int)var2_2, numberToWrite);
                return;
            }
            void v0 = var2_2;
            ByteBufferWriter.write(this.slice((int)v0, (int)(v0 + var3_3)), (OutputStream)var1_1);
        }

        @Override
        final void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.buffer.slice());
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return this.buffer.asReadOnlyBuffer();
        }

        @Override
        public final List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(((ByteString)this).asReadOnlyByteBuffer());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String toStringInternal(Charset charset) {
            void var1_1;
            void var3_3;
            void var2_2;
            int length;
            int offset;
            byte[] bytes;
            if (this.buffer.hasArray()) {
                bytes = this.buffer.array();
                offset = this.buffer.arrayOffset() + this.buffer.position();
                length = this.buffer.remaining();
            } else {
                bytes = this.toByteArray();
                offset = 0;
                length = bytes.length;
            }
            return new String((byte[])var2_2, (int)var3_3, length, (Charset)var1_1);
        }

        @Override
        public final boolean isValidUtf8() {
            return Utf8.isValidUtf8(this.buffer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialIsValidUtf8(int state, int offset, int length) {
            void var3_3;
            void var2_2;
            void v0 = var2_2;
            return Utf8.partialIsValidUtf8(state, this.buffer, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var2_2;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteString)) {
                return false;
            }
            ByteString otherString = (ByteString)other;
            if (((ByteString)this).size() != otherString.size()) {
                return false;
            }
            if (((ByteString)this).size() == 0) {
                return true;
            }
            if (other instanceof NioByteString) {
                return this.buffer.equals(((NioByteString)other).buffer);
            }
            if (other instanceof RopeByteString) {
                void var1_1;
                return var1_1.equals(this);
            }
            return this.buffer.equals(var2_2.asReadOnlyByteBuffer());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialHash(int h, int offset, int length) {
            void var1_1;
            for (int i = offset; i < offset + length; ++i) {
                h = h * 31 + this.buffer.get(i);
            }
            return (int)var1_1;
        }

        @Override
        public final InputStream newInput() {
            return new InputStream(this){
                private final ByteBuffer buf;
                final /* synthetic */ NioByteString this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.buf = this.this$0.buffer.slice();
                }

                @Override
                public void mark(int readlimit) {
                    Java8Compatibility.mark(this.buf);
                }

                @Override
                public boolean markSupported() {
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void reset() throws IOException {
                    try {
                        Java8Compatibility.reset(this.buf);
                        return;
                    }
                    catch (InvalidMarkException e) {
                        void var1_1;
                        throw new IOException((Throwable)var1_1);
                    }
                }

                @Override
                public int available() throws IOException {
                    return this.buf.remaining();
                }

                @Override
                public int read() throws IOException {
                    if (!this.buf.hasRemaining()) {
                        return -1;
                    }
                    return this.buf.get() & 0xFF;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int read(byte[] bytes, int off, int len) throws IOException {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    if (!this.buf.hasRemaining()) {
                        return -1;
                    }
                    len = Math.min(len, this.buf.remaining());
                    this.buf.get((byte[])var1_1, (int)var2_2, len);
                    return (int)var3_3;
                }
            };
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.buffer, true);
        }

        /*
         * WARNING - void declaration
         */
        private ByteBuffer slice(int beginIndex, int endIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (beginIndex < this.buffer.position() || endIndex > this.buffer.limit() || beginIndex > endIndex) {
                throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", beginIndex, endIndex));
            }
            ByteBuffer slice = this.buffer.slice();
            Java8Compatibility.position(slice, (int)(var1_1 - this.buffer.position()));
            Java8Compatibility.limit(slice, (int)(var2_2 - this.buffer.position()));
            return var3_3;
        }
    }

    private static final class BoundedByteString
    extends LiteralByteString {
        private final int bytesOffset;
        private final int bytesLength;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        BoundedByteString(byte[] bytes, int offset, int length) {
            super(bytes);
            void var3_3;
            void var2_2;
            void var1_1;
            int n = offset;
            BoundedByteString.checkRange(n, n + length, ((void)var1_1).length);
            this.bytesOffset = var2_2;
            this.bytesLength = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte byteAt(int index) {
            void var1_1;
            BoundedByteString.checkIndex(index, ((ByteString)this).size());
            return this.bytes[this.bytesOffset + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[this.bytesOffset + var1_1];
        }

        @Override
        public final int size() {
            return this.bytesLength;
        }

        @Override
        protected final int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var3_3;
            void var1_1;
            void var2_2;
            System.arraycopy(this.bytes, this.getOffsetIntoBytes() + var2_2, var1_1, (int)var3_3, numberToCopy);
        }

        final Object writeReplace() {
            return ByteString.wrap(this.toByteArray());
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
        }
    }

    private static class LiteralByteString
    extends LeafByteString {
        private static final long serialVersionUID = 1L;
        protected final byte[] bytes;

        /*
         * WARNING - void declaration
         */
        LiteralByteString(byte[] bytes) {
            void var1_1;
            if (bytes == null) {
                throw new NullPointerException();
            }
            this.bytes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte byteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString substring(int beginIndex, int endIndex) {
            void var2_2;
            void var1_1;
            int length = LiteralByteString.checkRange(beginIndex, endIndex, ((ByteString)this).size());
            if (length == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var3_3;
            void var1_1;
            void var2_2;
            System.arraycopy(this.bytes, (int)var2_2, var1_1, (int)var3_3, numberToCopy);
        }

        @Override
        public final void copyTo(ByteBuffer target) {
            target.put(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size());
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size()).asReadOnlyBuffer();
        }

        @Override
        public final List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(((ByteString)this).asReadOnlyByteBuffer());
        }

        @Override
        public final void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.toByteArray());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
            void var3_3;
            void var2_2;
            outputStream.write(this.bytes, this.getOffsetIntoBytes() + var2_2, (int)var3_3);
        }

        @Override
        final void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String toStringInternal(Charset charset) {
            void var1_1;
            return new String(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), (Charset)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isValidUtf8() {
            void var1_1;
            int offset = this.getOffsetIntoBytes();
            void v0 = var1_1;
            return Utf8.isValidUtf8(this.bytes, (int)v0, (int)(v0 + ((ByteString)this).size()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialIsValidUtf8(int state, int offset, int length) {
            void var3_3;
            void var1_1;
            void var2_2;
            int index = this.getOffsetIntoBytes() + offset;
            void v0 = var2_2;
            return Utf8.partialIsValidUtf8((int)var1_1, this.bytes, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other) {
            void var1_1;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteString)) {
                return false;
            }
            if (((ByteString)this).size() != ((ByteString)other).size()) {
                return false;
            }
            if (((ByteString)this).size() == 0) {
                return true;
            }
            if (other instanceof LiteralByteString) {
                void var2_3;
                void var3_4;
                LiteralByteString otherAsLiteral = (LiteralByteString)other;
                int thisHash = this.peekCachedHashCode();
                int thatHash = otherAsLiteral.peekCachedHashCode();
                if (thisHash != 0 && thatHash != 0 && var3_4 != var2_3) {
                    return false;
                }
                return this.equalsRange((LiteralByteString)other, 0, ((ByteString)this).size());
            }
            return var1_1.equals(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean equalsRange(ByteString other, int offset, int length) {
            void var3_4;
            void var1_1;
            void var2_3;
            if (length > other.size()) {
                throw new IllegalArgumentException("Length too large: " + length + ((ByteString)this).size());
            }
            if (offset + length > other.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString lbsOther = (LiteralByteString)other;
                byte[] thisBytes = this.bytes;
                byte[] otherBytes = lbsOther.bytes;
                int thisLimit = this.getOffsetIntoBytes() + length;
                int thisIndex = this.getOffsetIntoBytes();
                int otherIndex = lbsOther.getOffsetIntoBytes() + offset;
                while (thisIndex < thisLimit) {
                    if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                        return false;
                    }
                    ++thisIndex;
                    ++otherIndex;
                }
                return true;
            }
            void v0 = var2_3;
            return var1_1.substring((int)v0, (int)(v0 + var3_4)).equals(((ByteString)this).substring(0, (int)var3_4));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialHash(int h, int offset, int length) {
            void var3_3;
            void var2_2;
            return Internal.partialHash(h, this.bytes, this.getOffsetIntoBytes() + var2_2, (int)var3_3);
        }

        @Override
        public final InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size());
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), true);
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        /*
         * WARNING - void declaration
         */
        private CodedBuilder(int size) {
            void var1_1;
            this.buffer = new byte[var1_1];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public final ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public final CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        /*
         * WARNING - void declaration
         */
        Output(int initialCapacity) {
            void var1_1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = initialCapacity;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void write(int b) {
            void var1_1;
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void write(byte[] b, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (length <= this.buffer.length - this.bufferPos) {
                System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
                return;
            }
            int copySize = this.buffer.length - this.bufferPos;
            System.arraycopy(b, offset, this.buffer, this.bufferPos, copySize);
            offset += copySize;
            this.flushFullBuffer(length -= copySize);
            System.arraycopy(var1_1, (int)var2_2, this.buffer, 0, length);
            this.bufferPos = var3_3;
        }

        public final synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        /*
         * WARNING - void declaration
         */
        public final void writeTo(OutputStream out) throws IOException {
            void var3_6;
            void var1_1;
            void var2_3;
            int cachedBufferPos;
            Output output = this;
            synchronized (output) {
                ByteString[] cachedFlushBuffers = this.flushedBuffers.toArray(new ByteString[0]);
                byte[] cachedBuffer = this.buffer;
                cachedBufferPos = this.bufferPos;
            }
            for (Output output2 : var2_3) {
                ((ByteString)((Object)output2)).writeTo(out);
            }
            var1_1.write(Arrays.copyOf((byte[])var3_6, cachedBufferPos));
        }

        public final synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public final synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public final String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        /*
         * WARNING - void declaration
         */
        private void flushFullBuffer(int minSize) {
            void var1_1;
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int newSize = Math.max(this.initialCapacity, Math.max(minSize, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[var1_1];
            this.bufferPos = 0;
        }

        /*
         * WARNING - void declaration
         */
        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    void var1_1;
                    byte[] bufferCopy = Arrays.copyOf(this.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString((byte[])var1_1));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        private static final long serialVersionUID = 1L;

        @Override
        protected final int getTreeDepth() {
            return 0;
        }

        @Override
        protected final boolean isBalanced() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void writeToReverse(ByteOutput byteOutput) throws IOException {
            void var1_1;
            this.writeTo((ByteOutput)var1_1);
        }

        abstract boolean equalsRange(ByteString var1, int var2, int var3);

        private LeafByteString() {
        }
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final Byte next() {
            return this.nextByte();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void v0 = var2_2;
            return Arrays.copyOfRange(bytes, (int)v0, (int)(v0 + var3_3));
        }
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void var1_1;
            byte[] copy = new byte[size];
            System.arraycopy(var1_1, (int)var2_2, copy, 0, (int)var3_3);
            return copy;
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }
}

