/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

final class ByteBufferWriter {
    private static final int MIN_CACHED_BUFFER_SIZE = 1024;
    private static final int MAX_CACHED_BUFFER_SIZE = 16384;
    private static final float BUFFER_REALLOCATION_THRESHOLD = 0.5f;
    private static final ThreadLocal<SoftReference<byte[]>> BUFFER = new ThreadLocal();
    private static final Class<?> FILE_OUTPUT_STREAM_CLASS = ByteBufferWriter.safeGetClass("java.io.FileOutputStream");
    private static final long CHANNEL_FIELD_OFFSET = ByteBufferWriter.getChannelFieldOffset(FILE_OUTPUT_STREAM_CLASS);

    private ByteBufferWriter() {
    }

    static void clearCachedBuffer() {
        BUFFER.set(null);
    }

    /*
     * WARNING - void declaration
     */
    static void write(ByteBuffer buffer, OutputStream output) throws IOException {
        int initialPos;
        block4: {
            initialPos = buffer.position();
            try {
                if (buffer.hasArray()) {
                    output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    break block4;
                }
                if (ByteBufferWriter.writeToChannel(buffer, output)) break block4;
                byte[] array = ByteBufferWriter.getOrCreateBuffer(buffer.remaining());
                while (buffer.hasRemaining()) {
                    int length = Math.min(buffer.remaining(), array.length);
                    buffer.get(array, 0, length);
                    output.write(array, 0, length);
                }
            }
            catch (Throwable throwable) {
                void var2_3;
                ByteBuffer byteBuffer;
                Java8Compatibility.position(byteBuffer, (int)var2_3);
                throw throwable;
            }
        }
        Java8Compatibility.position(buffer, initialPos);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getOrCreateBuffer(int requestedSize) {
        void var1_1;
        requestedSize = Math.max(requestedSize, 1024);
        byte[] buffer = ByteBufferWriter.getBuffer();
        if (buffer == null || ByteBufferWriter.needToReallocate(requestedSize, buffer.length)) {
            int n;
            buffer = new byte[requestedSize];
            if (n <= 16384) {
                ByteBufferWriter.setBuffer(buffer);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean needToReallocate(int requestedSize, int bufferLength) {
        int n;
        void var1_1;
        return bufferLength < requestedSize && (float)var1_1 < (float)n * 0.5f;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getBuffer() {
        void var0;
        SoftReference<byte[]> sr = BUFFER.get();
        if (sr == null) {
            return null;
        }
        return (byte[])var0.get();
    }

    private static void setBuffer(byte[] value) {
        byte[] byArray;
        BUFFER.set(new SoftReference<byte[]>(byArray));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean writeToChannel(ByteBuffer buffer, OutputStream output) throws IOException {
        if (CHANNEL_FIELD_OFFSET >= 0L && FILE_OUTPUT_STREAM_CLASS.isInstance(output)) {
            WritableByteChannel channel = null;
            try {
                void var1_1;
                channel = (WritableByteChannel)UnsafeUtil.getObject(var1_1, CHANNEL_FIELD_OFFSET);
            }
            catch (ClassCastException classCastException) {}
            if (channel != null) {
                ByteBuffer byteBuffer;
                void var2_2;
                var2_2.write(byteBuffer);
                return true;
            }
        }
        return false;
    }

    private static Class<?> safeGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static long getChannelFieldOffset(Class<?> clazz) {
        try {
            if (clazz != null && UnsafeUtil.hasUnsafeArrayOperations()) {
                AnnotatedElement annotatedElement;
                annotatedElement = annotatedElement.getDeclaredField("channel");
                return UnsafeUtil.objectFieldOffset((Field)annotatedElement);
            }
        }
        catch (Throwable throwable) {}
        return -1L;
    }
}

