/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AllocatedBuffer;
import androidx.datastore.preferences.protobuf.BooleanArrayList;
import androidx.datastore.preferences.protobuf.BufferAllocator;
import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.DoubleArrayList;
import androidx.datastore.preferences.protobuf.FloatArrayList;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;

@CheckReturnValue
abstract class BinaryWriter
extends ByteOutput
implements Writer {
    public static final int DEFAULT_CHUNK_SIZE = 4096;
    private final BufferAllocator alloc;
    private final int chunkSize;
    final ArrayDeque<AllocatedBuffer> buffers = new ArrayDeque(4);
    int totalDoneBytes;
    private static final int MAP_KEY_NUMBER = 1;
    private static final int MAP_VALUE_NUMBER = 2;

    public static BinaryWriter newHeapInstance(BufferAllocator alloc) {
        return BinaryWriter.newHeapInstance(alloc, 4096);
    }

    /*
     * WARNING - void declaration
     */
    public static BinaryWriter newHeapInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        if (BinaryWriter.isUnsafeHeapSupported()) {
            return BinaryWriter.newUnsafeHeapInstance(alloc, chunkSize);
        }
        return BinaryWriter.newSafeHeapInstance(bufferAllocator, (int)var1_1);
    }

    public static BinaryWriter newDirectInstance(BufferAllocator alloc) {
        return BinaryWriter.newDirectInstance(alloc, 4096);
    }

    /*
     * WARNING - void declaration
     */
    public static BinaryWriter newDirectInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        if (BinaryWriter.isUnsafeDirectSupported()) {
            return BinaryWriter.newUnsafeDirectInstance(alloc, chunkSize);
        }
        return BinaryWriter.newSafeDirectInstance(bufferAllocator, (int)var1_1);
    }

    static boolean isUnsafeHeapSupported() {
        return UnsafeHeapWriter.isSupported();
    }

    static boolean isUnsafeDirectSupported() {
        return UnsafeDirectWriter.isSupported();
    }

    /*
     * WARNING - void declaration
     */
    static BinaryWriter newSafeHeapInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        return new SafeHeapWriter(bufferAllocator, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static BinaryWriter newUnsafeHeapInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        if (!BinaryWriter.isUnsafeHeapSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeHeapWriter(bufferAllocator, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static BinaryWriter newSafeDirectInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        return new SafeDirectWriter(bufferAllocator, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static BinaryWriter newUnsafeDirectInstance(BufferAllocator alloc, int chunkSize) {
        void var1_1;
        BufferAllocator bufferAllocator;
        if (!BinaryWriter.isUnsafeDirectSupported()) {
            throw new UnsupportedOperationException("Unsafe operations not supported");
        }
        return new UnsafeDirectWriter(bufferAllocator, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private BinaryWriter(BufferAllocator alloc, int chunkSize) {
        void var2_2;
        void var1_1;
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.alloc = (BufferAllocator)Internal.checkNotNull(var1_1, "alloc");
        this.chunkSize = var2_2;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.DESCENDING;
    }

    @CanIgnoreReturnValue
    public final Queue<AllocatedBuffer> complete() {
        this.finishCurrentBuffer();
        return this.buffers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed32((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed64((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt32List(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof IntArrayList) {
            this.writeInt32List_Internal(fieldNumber, (IntArrayList)list, packed);
            return;
        }
        this.writeInt32List_Internal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    private void writeInt32List_Internal(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeInt32(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeInt32(fieldNumber, list.get(i));
        }
    }

    private void writeInt32List_Internal(int fieldNumber, IntArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeInt32(list.getInt(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeInt32(fieldNumber, list.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed32List(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof IntArrayList) {
            this.writeFixed32List_Internal(fieldNumber, (IntArrayList)list, packed);
            return;
        }
        this.writeFixed32List_Internal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    private void writeFixed32List_Internal(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 2));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed32(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFixed32(fieldNumber, list.get(i));
        }
    }

    private void writeFixed32List_Internal(int fieldNumber, IntArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 2));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed32(list.getInt(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFixed32(fieldNumber, list.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64List(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeUInt64List((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt64List(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof LongArrayList) {
            this.writeUInt64List_Internal(fieldNumber, (LongArrayList)list, packed);
            return;
        }
        this.writeUInt64List_Internal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    private void writeUInt64List_Internal(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeVarint64(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeUInt64(fieldNumber, list.get(i));
        }
    }

    private void writeUInt64List_Internal(int fieldNumber, LongArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeVarint64(list.getLong(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeUInt64(fieldNumber, list.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed64List(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof LongArrayList) {
            this.writeFixed64List_Internal(fieldNumber, (LongArrayList)list, packed);
            return;
        }
        this.writeFixed64List_Internal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    private void writeFixed64List_Internal(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 3));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed64(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFixed64(fieldNumber, list.get(i));
        }
    }

    private void writeFixed64List_Internal(int fieldNumber, LongArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 3));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed64(list.getLong(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFixed64(fieldNumber, list.getLong(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloatList(int fieldNumber, List<Float> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof FloatArrayList) {
            this.writeFloatList_Internal(fieldNumber, (FloatArrayList)list, packed);
            return;
        }
        this.writeFloatList_Internal((int)var1_1, (List<Float>)var2_2, (boolean)var3_3);
    }

    private void writeFloatList_Internal(int fieldNumber, List<Float> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 2));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed32(Float.floatToRawIntBits(list.get(i).floatValue()));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFloat(fieldNumber, list.get(i).floatValue());
        }
    }

    private void writeFloatList_Internal(int fieldNumber, FloatArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 2));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed32(Float.floatToRawIntBits(list.getFloat(i)));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeFloat(fieldNumber, list.getFloat(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDoubleList(int fieldNumber, List<Double> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof DoubleArrayList) {
            this.writeDoubleList_Internal(fieldNumber, (DoubleArrayList)list, packed);
            return;
        }
        this.writeDoubleList_Internal((int)var1_1, (List<Double>)var2_2, (boolean)var3_3);
    }

    private void writeDoubleList_Internal(int fieldNumber, List<Double> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 3));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed64(Double.doubleToRawLongBits(list.get(i)));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeDouble(fieldNumber, list.get(i));
        }
    }

    private void writeDoubleList_Internal(int fieldNumber, DoubleArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + (list.size() << 3));
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeFixed64(Double.doubleToRawLongBits(list.getDouble(i)));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeDouble(fieldNumber, list.getDouble(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnumList(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeInt32List((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBoolList(int fieldNumber, List<Boolean> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof BooleanArrayList) {
            this.writeBoolList_Internal(fieldNumber, (BooleanArrayList)list, packed);
            return;
        }
        this.writeBoolList_Internal((int)var1_1, (List<Boolean>)var2_2, (boolean)var3_3);
    }

    private void writeBoolList_Internal(int fieldNumber, List<Boolean> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size());
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeBool(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeBool(fieldNumber, list.get(i));
        }
    }

    private void writeBoolList_Internal(int fieldNumber, BooleanArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size());
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeBool(list.getBoolean(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeBool(fieldNumber, list.getBoolean(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeStringList(int fieldNumber, List<String> list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)list;
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeLazyString(fieldNumber, lazyList.getRaw(i));
            }
            return;
        }
        for (int i = var2_2.size() - 1; i >= 0; --i) {
            void var2_2;
            this.writeString(fieldNumber, (String)var2_2.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLazyString(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        if (value instanceof String) {
            this.writeString(fieldNumber, (String)value);
            return;
        }
        this.writeBytes((int)var1_1, (ByteString)var2_2);
    }

    @Override
    public final void writeBytesList(int fieldNumber, List<ByteString> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeBytes(fieldNumber, list.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt32List(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof IntArrayList) {
            this.writeUInt32List_Internal(fieldNumber, (IntArrayList)list, packed);
            return;
        }
        this.writeUInt32List_Internal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    private void writeUInt32List_Internal(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 5);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeVarint32(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeUInt32(fieldNumber, list.get(i));
        }
    }

    private void writeUInt32List_Internal(int fieldNumber, IntArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 5);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeVarint32(list.getInt(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeUInt32(fieldNumber, list.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32List(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeFixed32List((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64List(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeFixed64List((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt32List(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof IntArrayList) {
            this.writeSInt32List_Internal(fieldNumber, (IntArrayList)list, packed);
            return;
        }
        this.writeSInt32List_Internal((int)var1_1, (List<Integer>)var2_2, (boolean)var3_3);
    }

    private void writeSInt32List_Internal(int fieldNumber, List<Integer> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 5);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt32(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeSInt32(fieldNumber, list.get(i));
        }
    }

    private void writeSInt32List_Internal(int fieldNumber, IntArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 5);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt32(list.getInt(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeSInt32(fieldNumber, list.getInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt64List(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof LongArrayList) {
            this.writeSInt64List_Internal(fieldNumber, (LongArrayList)list, packed);
            return;
        }
        this.writeSInt64List_Internal((int)var1_1, (List<Long>)var2_2, (boolean)var3_3);
    }

    @Override
    public <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int prevBytes = this.getTotalBytesWritten();
            BinaryWriter.writeMapEntryField(this, 2, metadata.valueType, entry.getValue());
            BinaryWriter.writeMapEntryField(this, 1, metadata.keyType, entry.getKey());
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static final void writeMapEntryField(Writer writer, int fieldNumber, WireFormat.FieldType fieldType, Object object) throws IOException {
        void var2_2;
        switch (fieldType) {
            case BOOL: {
                writer.writeBool(fieldNumber, (Boolean)object);
                return;
            }
            case FIXED32: {
                writer.writeFixed32(fieldNumber, (Integer)object);
                return;
            }
            case FIXED64: {
                writer.writeFixed64(fieldNumber, (Long)object);
                return;
            }
            case INT32: {
                writer.writeInt32(fieldNumber, (Integer)object);
                return;
            }
            case INT64: {
                writer.writeInt64(fieldNumber, (Long)object);
                return;
            }
            case SFIXED32: {
                writer.writeSFixed32(fieldNumber, (Integer)object);
                return;
            }
            case SFIXED64: {
                writer.writeSFixed64(fieldNumber, (Long)object);
                return;
            }
            case SINT32: {
                writer.writeSInt32(fieldNumber, (Integer)object);
                return;
            }
            case SINT64: {
                writer.writeSInt64(fieldNumber, (Long)object);
                return;
            }
            case STRING: {
                writer.writeString(fieldNumber, (String)object);
                return;
            }
            case UINT32: {
                writer.writeUInt32(fieldNumber, (Integer)object);
                return;
            }
            case UINT64: {
                writer.writeUInt64(fieldNumber, (Long)object);
                return;
            }
            case FLOAT: {
                writer.writeFloat(fieldNumber, ((Float)object).floatValue());
                return;
            }
            case DOUBLE: {
                writer.writeDouble(fieldNumber, (Double)object);
                return;
            }
            case MESSAGE: {
                writer.writeMessage(fieldNumber, object);
                return;
            }
            case BYTES: {
                writer.writeBytes(fieldNumber, (ByteString)object);
                return;
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    writer.writeEnum(fieldNumber, ((Internal.EnumLite)object).getNumber());
                    return;
                }
                if (object instanceof Integer) {
                    void var3_3;
                    void var1_1;
                    Writer writer2;
                    writer2.writeEnum((int)var1_1, (Integer)var3_3);
                    return;
                }
                throw new IllegalArgumentException("Unexpected type for enum in map.");
            }
        }
        throw new IllegalArgumentException("Unsupported map value type for: " + var2_2);
    }

    private void writeSInt64List_Internal(int fieldNumber, List<Long> list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt64(list.get(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeSInt64(fieldNumber, list.get(i));
        }
    }

    private void writeSInt64List_Internal(int fieldNumber, LongArrayList list, boolean packed) throws IOException {
        if (packed) {
            this.requireSpace(10 + list.size() * 10);
            int prevBytes = this.getTotalBytesWritten();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.writeSInt64(list.getLong(i));
            }
            int length = this.getTotalBytesWritten() - prevBytes;
            this.writeVarint32(length);
            this.writeTag(fieldNumber, 2);
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeSInt64(fieldNumber, list.getLong(i));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeMessage(fieldNumber, list.get(i));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> list, Schema schema) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeMessage(fieldNumber, list.get(i), schema);
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int fieldNumber, List<?> list) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeGroup(fieldNumber, list.get(i));
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int fieldNumber, List<?> list, Schema schema) throws IOException {
        for (int i = list.size() - 1; i >= 0; --i) {
            this.writeGroup(fieldNumber, list.get(i), schema);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value) throws IOException {
        void var1_1;
        this.writeTag(1, 4);
        if (value instanceof ByteString) {
            this.writeBytes(3, (ByteString)value);
        } else {
            void var2_2;
            this.writeMessage(3, var2_2);
        }
        this.writeUInt32(2, (int)var1_1);
        this.writeTag(1, 3);
    }

    final AllocatedBuffer newHeapBuffer() {
        return this.alloc.allocateHeapBuffer(this.chunkSize);
    }

    /*
     * WARNING - void declaration
     */
    final AllocatedBuffer newHeapBuffer(int capacity) {
        void var1_1;
        return this.alloc.allocateHeapBuffer(Math.max((int)var1_1, this.chunkSize));
    }

    final AllocatedBuffer newDirectBuffer() {
        return this.alloc.allocateDirectBuffer(this.chunkSize);
    }

    /*
     * WARNING - void declaration
     */
    final AllocatedBuffer newDirectBuffer(int capacity) {
        void var1_1;
        return this.alloc.allocateDirectBuffer(Math.max((int)var1_1, this.chunkSize));
    }

    public abstract int getTotalBytesWritten();

    abstract void requireSpace(int var1);

    abstract void finishCurrentBuffer();

    abstract void writeTag(int var1, int var2);

    abstract void writeVarint32(int var1);

    abstract void writeInt32(int var1);

    abstract void writeSInt32(int var1);

    abstract void writeFixed32(int var1);

    abstract void writeVarint64(long var1);

    abstract void writeSInt64(long var1);

    abstract void writeFixed64(long var1);

    abstract void writeBool(boolean var1);

    abstract void writeString(String var1);

    /*
     * WARNING - void declaration
     */
    private static byte computeUInt64SizeNoTag(long value) {
        void var2_1;
        long l;
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n = 6;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n = (byte)(n + 2);
            value >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            n = (byte)(n + 1);
        }
        return (byte)var2_1;
    }

    private static final class UnsafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private long bufferOffset;
        private long limitMinusOne;
        private long pos;

        /*
         * WARNING - void declaration
         */
        UnsafeDirectWriter(BufferAllocator alloc, int chunkSize) {
            super((BufferAllocator)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.nextBuffer();
        }

        private static boolean isSupported() {
            return UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        private void nextBuffer() {
            UnsafeDirectWriter unsafeDirectWriter = this;
            unsafeDirectWriter.nextBuffer(unsafeDirectWriter.newDirectBuffer());
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(int capacity) {
            void var1_1;
            UnsafeDirectWriter unsafeDirectWriter = this;
            unsafeDirectWriter.nextBuffer(unsafeDirectWriter.newDirectBuffer((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            void var2_2;
            void var1_1;
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer nioBuffer = allocatedBuffer.nioBuffer();
            if (!nioBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst((AllocatedBuffer)var1_1);
            this.buffer = var2_2;
            Java8Compatibility.limit(this.buffer, this.buffer.capacity());
            Java8Compatibility.position(this.buffer, 0);
            this.bufferOffset = UnsafeUtil.addressOffset(this.buffer);
            this.pos = this.limitMinusOne = this.bufferOffset + (long)(this.buffer.limit() - 1);
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        private int spaceLeft() {
            return this.bufferPos() + 1;
        }

        @Override
        final void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
                this.buffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int bufferPos() {
            return (int)(this.pos - this.bufferOffset);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeVarint32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeSInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(9);
            this.writeFixed32((int)var2_2);
            this.writeTag((int)var1_1, 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeVarint64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeSInt64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(13);
            this.writeFixed64((long)var2_2);
            this.writeTag((int)var1_1, 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) {
            void var1_1;
            void var2_2;
            this.requireSpace(6);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            this.writeString(value);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) {
            void var1_1;
            void var2_3;
            try {
                value.writeToReverse(this);
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.requireSpace(10);
            this.writeVarint32(var2_3.size());
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(value, this);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            var3_4.writeTo(value, this);
            int length = this.getTotalBytesWritten() - prevBytes;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_2;
            this.writeTag(fieldNumber, 4);
            Protobuf.getInstance().writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            void var3_3;
            this.writeTag(fieldNumber, 4);
            var3_3.writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeStartGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeEndGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeInt32(int value) {
            void var1_1;
            if (value >= 0) {
                this.writeVarint32(value);
                return;
            }
            this.writeVarint64((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt32(int value) {
            void var1_1;
            this.writeVarint32(CodedOutputStream.encodeZigZag32((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt64(long value) {
            void var1_1;
            this.writeVarint64(CodedOutputStream.encodeZigZag64((long)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeBool(boolean value) {
            void var1_1;
            ((ByteOutput)this).write((byte)(var1_1 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.writeVarint32(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint32(int value) {
            void var1_1;
            if ((value & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(value);
                return;
            }
            if ((value & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(value);
                return;
            }
            if ((value & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(value);
                return;
            }
            if ((value & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(value);
                return;
            }
            this.writeVarint32FiveBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32OneByte(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32TwoBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32ThreeBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FourBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FiveBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint64(long value) {
            switch (BinaryWriter.computeUInt64SizeNoTag(value)) {
                case 1: {
                    this.writeVarint64OneByte(value);
                    return;
                }
                case 2: {
                    this.writeVarint64TwoBytes(value);
                    return;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(value);
                    return;
                }
                case 4: {
                    this.writeVarint64FourBytes(value);
                    return;
                }
                case 5: {
                    this.writeVarint64FiveBytes(value);
                    return;
                }
                case 6: {
                    this.writeVarint64SixBytes(value);
                    return;
                }
                case 7: {
                    this.writeVarint64SevenBytes(value);
                    return;
                }
                case 8: {
                    this.writeVarint64EightBytes(value);
                    return;
                }
                case 9: {
                    this.writeVarint64NineBytes(value);
                    return;
                }
                case 10: {
                    void var1_1;
                    this.writeVarint64TenBytes((long)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64OneByte(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TwoBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7));
            UnsafeUtil.putByte(this.pos--, (byte)((int)var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64ThreeBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)((int)value >>> 14));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FourBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FiveBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SixBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 35));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SevenBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 42));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64EightBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 49));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64NineBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 56));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TenBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 63));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed32(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >>> 24));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 16));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 8));
            UnsafeUtil.putByte(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed64(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 56));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 48));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 40));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 32));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 24));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 16));
            UnsafeUtil.putByte(this.pos--, (byte)(value >> 8));
            UnsafeUtil.putByte(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeString(String in) {
            char c;
            int i;
            this.requireSpace(in.length());
            for (i = in.length() - 1; i >= 0 && (c = in.charAt(i)) < '\u0080'; --i) {
                UnsafeUtil.putByte(this.pos--, (byte)c);
            }
            if (i == -1) {
                return;
            }
            while (i >= 0) {
                c = in.charAt(i);
                if (c < '\u0080' && this.pos >= this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > this.bufferOffset) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.bufferOffset + 1L) {
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > this.bufferOffset + 2L) {
                    void var3_3;
                    char high;
                    if (i == 0 || !Character.isSurrogatePair(high = in.charAt(i - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(i - 1, i);
                    }
                    --i;
                    int codePoint = Character.toCodePoint(high, c);
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & codePoint));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(this.pos--, (byte)(0xF0 | var3_3 >>> 18));
                } else {
                    this.requireSpace(i);
                    ++i;
                }
                --i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) {
            void var1_1;
            UnsafeUtil.putByte(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= (long)length;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value, offset, length));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)length;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) {
            void var1_1;
            void var2_2;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= (long)var2_2;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) {
            void var1_1;
            void var2_2;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)var2_2;
            Java8Compatibility.position(this.buffer, this.bufferPos() + 1);
            this.buffer.put((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void requireSpace(int size) {
            if (this.spaceLeft() < size) {
                void var1_1;
                this.nextBuffer((int)var1_1);
            }
        }
    }

    private static final class SafeDirectWriter
    extends BinaryWriter {
        private ByteBuffer buffer;
        private int limitMinusOne;
        private int pos;

        /*
         * WARNING - void declaration
         */
        SafeDirectWriter(BufferAllocator alloc, int chunkSize) {
            super((BufferAllocator)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.nextBuffer();
        }

        private void nextBuffer() {
            SafeDirectWriter safeDirectWriter = this;
            safeDirectWriter.nextBuffer(safeDirectWriter.newDirectBuffer());
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(int capacity) {
            void var1_1;
            SafeDirectWriter safeDirectWriter = this;
            safeDirectWriter.nextBuffer(safeDirectWriter.newDirectBuffer((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            void var2_2;
            void var1_1;
            if (!allocatedBuffer.hasNioBuffer()) {
                throw new RuntimeException("Allocated buffer does not have NIO buffer");
            }
            ByteBuffer nioBuffer = allocatedBuffer.nioBuffer();
            if (!nioBuffer.isDirect()) {
                throw new RuntimeException("Allocator returned non-direct buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst((AllocatedBuffer)var1_1);
            this.buffer = var2_2;
            Java8Compatibility.limit(this.buffer, this.buffer.capacity());
            Java8Compatibility.position(this.buffer, 0);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.pos = this.limitMinusOne = this.buffer.limit() - 1;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        private int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        private int spaceLeft() {
            return this.pos + 1;
        }

        @Override
        final void finishCurrentBuffer() {
            if (this.buffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                Java8Compatibility.position(this.buffer, this.pos + 1);
                this.buffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeVarint32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeSInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(9);
            this.writeFixed32((int)var2_2);
            this.writeTag((int)var1_1, 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeVarint64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeSInt64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(13);
            this.writeFixed64((long)var2_2);
            this.writeTag((int)var1_1, 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) {
            void var1_1;
            void var2_2;
            this.requireSpace(6);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            this.writeString(value);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) {
            void var1_1;
            void var2_3;
            try {
                value.writeToReverse(this);
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.requireSpace(10);
            this.writeVarint32(var2_3.size());
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(value, this);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            var3_4.writeTo(value, this);
            int length = this.getTotalBytesWritten() - prevBytes;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeGroup(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_2;
            this.writeTag(fieldNumber, 4);
            Protobuf.getInstance().writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            void var3_3;
            this.writeTag(fieldNumber, 4);
            var3_3.writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeStartGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeEndGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeInt32(int value) {
            void var1_1;
            if (value >= 0) {
                this.writeVarint32(value);
                return;
            }
            this.writeVarint64((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt32(int value) {
            void var1_1;
            this.writeVarint32(CodedOutputStream.encodeZigZag32((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt64(long value) {
            void var1_1;
            this.writeVarint64(CodedOutputStream.encodeZigZag64((long)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeBool(boolean value) {
            void var1_1;
            ((ByteOutput)this).write((byte)(var1_1 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.writeVarint32(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint32(int value) {
            void var1_1;
            if ((value & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(value);
                return;
            }
            if ((value & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(value);
                return;
            }
            if ((value & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(value);
                return;
            }
            if ((value & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(value);
                return;
            }
            this.writeVarint32FiveBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32OneByte(int value) {
            void var1_1;
            this.buffer.put(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32TwoBytes(int value) {
            void var1_1;
            this.pos -= 2;
            this.buffer.putShort(this.pos + 1, (short)((value & 0x3F80) << 1 | (var1_1 & 0x7F | 0x80)));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32ThreeBytes(int value) {
            void var1_1;
            this.pos -= 3;
            this.buffer.putInt(this.pos, (value & 0x1FC000) << 10 | (value & 0x3F80 | 0x4000) << 9 | (var1_1 & 0x7F | 0x80) << 8);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FourBytes(int value) {
            void var1_1;
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (value & 0xFE00000) << 3 | (value & 0x1FC000 | 0x200000) << 2 | (value & 0x3F80 | 0x4000) << 1 | (var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FiveBytes(int value) {
            void var1_1;
            this.buffer.put(this.pos--, (byte)(value >>> 28));
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (value >>> 21 & 0x7F | 0x80) << 24 | (value >>> 14 & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | (var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint64(long value) {
            switch (BinaryWriter.computeUInt64SizeNoTag(value)) {
                case 1: {
                    this.writeVarint64OneByte(value);
                    return;
                }
                case 2: {
                    this.writeVarint64TwoBytes(value);
                    return;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(value);
                    return;
                }
                case 4: {
                    this.writeVarint64FourBytes(value);
                    return;
                }
                case 5: {
                    this.writeVarint64FiveBytes(value);
                    return;
                }
                case 6: {
                    this.writeVarint64SixBytes(value);
                    return;
                }
                case 7: {
                    this.writeVarint64SevenBytes(value);
                    return;
                }
                case 8: {
                    this.writeVarint64EightBytes(value);
                    return;
                }
                case 9: {
                    this.writeVarint64NineBytes(value);
                    return;
                }
                case 10: {
                    void var1_1;
                    this.writeVarint64TenBytes((long)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64OneByte(long value) {
            void var1_1;
            this.writeVarint32OneByte((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TwoBytes(long value) {
            void var1_1;
            this.writeVarint32TwoBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64ThreeBytes(long value) {
            void var1_1;
            this.writeVarint32ThreeBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FourBytes(long value) {
            void var1_1;
            this.writeVarint32FourBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FiveBytes(long value) {
            void var1_1;
            this.pos -= 5;
            this.buffer.putLong(this.pos - 2, (value & 0x7F0000000L) << 28 | (value & 0xFE00000L | 0x10000000L) << 27 | (value & 0x1FC000L | 0x200000L) << 26 | (value & 0x3F80L | 0x4000L) << 25 | (var1_1 & 0x7FL | 0x80L) << 24);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SixBytes(long value) {
            void var1_1;
            this.pos -= 6;
            this.buffer.putLong(this.pos - 1, (value & 0x3F800000000L) << 21 | (value & 0x7F0000000L | 0x800000000L) << 20 | (value & 0xFE00000L | 0x10000000L) << 19 | (value & 0x1FC000L | 0x200000L) << 18 | (value & 0x3F80L | 0x4000L) << 17 | (var1_1 & 0x7FL | 0x80L) << 16);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SevenBytes(long value) {
            void var1_1;
            this.pos -= 7;
            this.buffer.putLong(this.pos, (value & 0x1FC0000000000L) << 14 | (value & 0x3F800000000L | 0x40000000000L) << 13 | (value & 0x7F0000000L | 0x800000000L) << 12 | (value & 0xFE00000L | 0x10000000L) << 11 | (value & 0x1FC000L | 0x200000L) << 10 | (value & 0x3F80L | 0x4000L) << 9 | (var1_1 & 0x7FL | 0x80L) << 8);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64EightBytes(long value) {
            void var1_1;
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (value & 0xFE000000000000L) << 7 | (value & 0x1FC0000000000L | 0x2000000000000L) << 6 | (value & 0x3F800000000L | 0x40000000000L) << 5 | (value & 0x7F0000000L | 0x800000000L) << 4 | (value & 0xFE00000L | 0x10000000L) << 3 | (value & 0x1FC000L | 0x200000L) << 2 | (value & 0x3F80L | 0x4000L) << 1 | (var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64EightBytesWithSign(long value) {
            void var1_1;
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (value & 0xFE000000000000L | 0x100000000000000L) << 7 | (value & 0x1FC0000000000L | 0x2000000000000L) << 6 | (value & 0x3F800000000L | 0x40000000000L) << 5 | (value & 0x7F0000000L | 0x800000000L) << 4 | (value & 0xFE00000L | 0x10000000L) << 3 | (value & 0x1FC000L | 0x200000L) << 2 | (value & 0x3F80L | 0x4000L) << 1 | (var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64NineBytes(long value) {
            void var1_1;
            this.buffer.put(this.pos--, (byte)(value >>> 56));
            this.writeVarint64EightBytesWithSign((long)(var1_1 & 0xFFFFFFFFFFFFFFL));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TenBytes(long value) {
            void var1_1;
            this.buffer.put(this.pos--, (byte)(value >>> 63));
            this.buffer.put(this.pos--, (byte)(value >>> 56 & 0x7FL | 0x80L));
            this.writeVarint64EightBytesWithSign((long)(var1_1 & 0xFFFFFFFFFFFFFFL));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed32(int value) {
            void var1_1;
            this.pos -= 4;
            this.buffer.putInt(this.pos + 1, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed64(long value) {
            void var1_1;
            this.pos -= 8;
            this.buffer.putLong(this.pos + 1, (long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeString(String in) {
            char c;
            int i;
            this.requireSpace(in.length());
            this.pos -= i;
            for (i = in.length() - 1; i >= 0 && (c = in.charAt(i)) < '\u0080'; --i) {
                this.buffer.put(this.pos + i, (byte)c);
            }
            if (i == -1) {
                --this.pos;
                return;
            }
            this.pos += i;
            while (i >= 0) {
                c = in.charAt(i);
                if (c < '\u0080' && this.pos >= 0) {
                    this.buffer.put(this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > 0) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c));
                    this.buffer.put(this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > 1) {
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > 2) {
                    void var3_3;
                    char high;
                    if (i == 0 || !Character.isSurrogatePair(high = in.charAt(i - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(i - 1, i);
                    }
                    --i;
                    int codePoint = Character.toCodePoint(high, c);
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & codePoint));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    this.buffer.put(this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    this.buffer.put(this.pos--, (byte)(0xF0 | var3_3 >>> 18));
                } else {
                    this.requireSpace(i);
                    ++i;
                }
                --i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) {
            void var1_1;
            this.buffer.put(this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= length;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value, offset, length));
                this.nextBuffer();
                return;
            }
            this.pos -= length;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) {
            void var1_1;
            void var2_2;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= var2_2;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) {
            void var1_1;
            void var2_2;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value));
                this.nextBuffer();
                return;
            }
            this.pos -= var2_2;
            Java8Compatibility.position(this.buffer, this.pos + 1);
            this.buffer.put((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void requireSpace(int size) {
            if (this.spaceLeft() < size) {
                void var1_1;
                this.nextBuffer((int)var1_1);
            }
        }
    }

    private static final class UnsafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private long offset;
        private long limit;
        private long offsetMinusOne;
        private long limitMinusOne;
        private long pos;

        /*
         * WARNING - void declaration
         */
        UnsafeHeapWriter(BufferAllocator alloc, int chunkSize) {
            super((BufferAllocator)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.nextBuffer();
        }

        static boolean isSupported() {
            return UnsafeUtil.hasUnsafeArrayOperations();
        }

        @Override
        final void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.arrayPos() - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0L;
                this.limitMinusOne = 0L;
            }
        }

        private int arrayPos() {
            return (int)this.pos;
        }

        private void nextBuffer() {
            UnsafeHeapWriter unsafeHeapWriter = this;
            unsafeHeapWriter.nextBuffer(unsafeHeapWriter.newHeapBuffer());
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(int capacity) {
            void var1_1;
            UnsafeHeapWriter unsafeHeapWriter = this;
            unsafeHeapWriter.nextBuffer(unsafeHeapWriter.newHeapBuffer((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            void var1_1;
            void var2_2;
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int arrayOffset = allocatedBuffer.arrayOffset();
            this.limit = (long)arrayOffset + (long)allocatedBuffer.limit();
            this.offset = (long)var2_2 + (long)var1_1.position();
            this.offsetMinusOne = this.offset - 1L;
            this.pos = this.limitMinusOne = this.limit - 1L;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        final int bytesWrittenToCurrentBuffer() {
            return (int)(this.limitMinusOne - this.pos);
        }

        final int spaceLeft() {
            return (int)(this.pos - this.offsetMinusOne);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeVarint32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeSInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) {
            void var1_1;
            void var2_2;
            this.requireSpace(9);
            this.writeFixed32((int)var2_2);
            this.writeTag((int)var1_1, 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeVarint64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeSInt64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) {
            void var1_1;
            void var2_2;
            this.requireSpace(13);
            this.writeFixed64((long)var2_2);
            this.writeTag((int)var1_1, 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) {
            void var1_1;
            void var2_2;
            this.requireSpace(6);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            this.writeString(value);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) {
            void var1_1;
            void var2_3;
            try {
                value.writeToReverse(this);
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.requireSpace(10);
            this.writeVarint32(var2_3.size());
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(value, this);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            var3_4.writeTo(value, this);
            int length = this.getTotalBytesWritten() - prevBytes;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_2;
            this.writeTag(fieldNumber, 4);
            Protobuf.getInstance().writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            void var3_3;
            this.writeTag(fieldNumber, 4);
            var3_3.writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStartGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeEndGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeInt32(int value) {
            void var1_1;
            if (value >= 0) {
                this.writeVarint32(value);
                return;
            }
            this.writeVarint64((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt32(int value) {
            void var1_1;
            this.writeVarint32(CodedOutputStream.encodeZigZag32((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt64(long value) {
            void var1_1;
            this.writeVarint64(CodedOutputStream.encodeZigZag64((long)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeBool(boolean value) {
            void var1_1;
            ((ByteOutput)this).write((byte)(var1_1 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.writeVarint32(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint32(int value) {
            void var1_1;
            if ((value & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(value);
                return;
            }
            if ((value & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(value);
                return;
            }
            if ((value & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(value);
                return;
            }
            if ((value & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(value);
                return;
            }
            this.writeVarint32FiveBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32OneByte(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32TwoBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32ThreeBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FourBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FiveBytes(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7F | 0x80));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint64(long value) {
            switch (BinaryWriter.computeUInt64SizeNoTag(value)) {
                case 1: {
                    this.writeVarint64OneByte(value);
                    return;
                }
                case 2: {
                    this.writeVarint64TwoBytes(value);
                    return;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(value);
                    return;
                }
                case 4: {
                    this.writeVarint64FourBytes(value);
                    return;
                }
                case 5: {
                    this.writeVarint64FiveBytes(value);
                    return;
                }
                case 6: {
                    this.writeVarint64SixBytes(value);
                    return;
                }
                case 7: {
                    this.writeVarint64SevenBytes(value);
                    return;
                }
                case 8: {
                    this.writeVarint64EightBytes(value);
                    return;
                }
                case 9: {
                    this.writeVarint64NineBytes(value);
                    return;
                }
                case 10: {
                    void var1_1;
                    this.writeVarint64TenBytes((long)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64OneByte(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TwoBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)var1_1 & 0x7F | 0x80));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64ThreeBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)((int)value >>> 14));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FourBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FiveBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SixBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 35));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SevenBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 42));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64EightBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 49));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64NineBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 56));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TenBytes(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 63));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 56 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 49 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 42 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 35 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 28 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 21 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 14 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 7 & 0x7FL | 0x80L));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(var1_1 & 0x7FL | 0x80L));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed32(int value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >>> 24));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 16));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 8));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed64(long value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 56));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 48));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 40));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 32));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 24));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 16));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(value >> 8));
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeString(String in) {
            char c;
            int i;
            this.requireSpace(in.length());
            for (i = in.length() - 1; i >= 0 && (c = in.charAt(i)) < '\u0080'; --i) {
                UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c);
            }
            if (i == -1) {
                return;
            }
            while (i >= 0) {
                c = in.charAt(i);
                if (c < '\u0080' && this.pos > this.offsetMinusOne) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)c);
                } else if (c < '\u0800' && this.pos > this.offset) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x3C0 | c >>> 6));
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.offset + 1L) {
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x1E0 | c >>> 12));
                } else if (this.pos > this.offset + 2L) {
                    void var3_3;
                    char high;
                    if (i == 0 || !Character.isSurrogatePair(high = in.charAt(i - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(i - 1, i);
                    }
                    --i;
                    int codePoint = Character.toCodePoint(high, c);
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & codePoint));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(this.buffer, this.pos--, (byte)(0xF0 | var3_3 >>> 18));
                } else {
                    this.requireSpace(i);
                    ++i;
                }
                --i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) {
            void var1_1;
            UnsafeUtil.putByte(this.buffer, this.pos--, (byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (offset < 0 || offset + length > value.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", value.length, offset, length));
            }
            this.requireSpace(length);
            this.pos -= (long)length;
            System.arraycopy(var1_1, (int)var2_2, this.buffer, this.arrayPos() + 1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (offset < 0 || offset + length > value.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("value.length=%d, offset=%d, length=%d", value.length, offset, length));
            }
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value, offset, length));
                this.nextBuffer();
                return;
            }
            this.pos -= (long)length;
            System.arraycopy(var1_1, (int)var2_2, this.buffer, this.arrayPos() + 1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) {
            void var2_2;
            void var1_1;
            int length = value.remaining();
            this.requireSpace(length);
            this.pos -= (long)length;
            var1_1.get(this.buffer, this.arrayPos() + 1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) {
            void var2_2;
            void var1_1;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value));
                this.nextBuffer();
            }
            this.pos -= (long)length;
            var1_1.get(this.buffer, this.arrayPos() + 1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void requireSpace(int size) {
            if (this.spaceLeft() < size) {
                void var1_1;
                this.nextBuffer((int)var1_1);
            }
        }
    }

    private static final class SafeHeapWriter
    extends BinaryWriter {
        private AllocatedBuffer allocatedBuffer;
        private byte[] buffer;
        private int offset;
        private int limit;
        private int offsetMinusOne;
        private int limitMinusOne;
        private int pos;

        /*
         * WARNING - void declaration
         */
        SafeHeapWriter(BufferAllocator alloc, int chunkSize) {
            super((BufferAllocator)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
            this.nextBuffer();
        }

        @Override
        final void finishCurrentBuffer() {
            if (this.allocatedBuffer != null) {
                this.totalDoneBytes += this.bytesWrittenToCurrentBuffer();
                this.allocatedBuffer.position(this.pos - this.allocatedBuffer.arrayOffset() + 1);
                this.allocatedBuffer = null;
                this.pos = 0;
                this.limitMinusOne = 0;
            }
        }

        private void nextBuffer() {
            SafeHeapWriter safeHeapWriter = this;
            safeHeapWriter.nextBuffer(safeHeapWriter.newHeapBuffer());
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(int capacity) {
            void var1_1;
            SafeHeapWriter safeHeapWriter = this;
            safeHeapWriter.nextBuffer(safeHeapWriter.newHeapBuffer((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private void nextBuffer(AllocatedBuffer allocatedBuffer) {
            void var1_1;
            void var2_2;
            if (!allocatedBuffer.hasArray()) {
                throw new RuntimeException("Allocator returned non-heap buffer");
            }
            this.finishCurrentBuffer();
            this.buffers.addFirst(allocatedBuffer);
            this.allocatedBuffer = allocatedBuffer;
            this.buffer = allocatedBuffer.array();
            int arrayOffset = allocatedBuffer.arrayOffset();
            this.limit = arrayOffset + allocatedBuffer.limit();
            this.offset = var2_2 + var1_1.position();
            this.offsetMinusOne = this.offset - 1;
            this.pos = this.limitMinusOne = this.limit - 1;
        }

        @Override
        public final int getTotalBytesWritten() {
            return this.totalDoneBytes + this.bytesWrittenToCurrentBuffer();
        }

        final int bytesWrittenToCurrentBuffer() {
            return this.limitMinusOne - this.pos;
        }

        final int spaceLeft() {
            return this.pos - this.offsetMinusOne;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeVarint32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt32(int fieldNumber, int value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(10);
            this.writeSInt32((int)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(9);
            this.writeFixed32((int)var2_2);
            this.writeTag((int)var1_1, 5);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeVarint64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeSInt64(int fieldNumber, long value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(15);
            this.writeSInt64((long)var2_2);
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(13);
            this.writeFixed64((long)var2_2);
            this.writeTag((int)var1_1, 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var1_1;
            void var2_2;
            this.requireSpace(6);
            ((ByteOutput)this).write((byte)(var2_2 != false ? 1 : 0));
            this.writeTag((int)var1_1, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            this.writeString(value);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var1_1;
            void var2_3;
            try {
                value.writeToReverse(this);
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
            this.requireSpace(10);
            this.writeVarint32(var2_3.size());
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            Protobuf.getInstance().writeTo(value, this);
            int length = this.getTotalBytesWritten() - var3_4;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_3;
            void var3_4;
            int prevBytes = this.getTotalBytesWritten();
            var3_4.writeTo(value, this);
            int length = this.getTotalBytesWritten() - prevBytes;
            this.requireSpace(10);
            this.writeVarint32((int)var2_3);
            this.writeTag((int)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final void writeGroup(int fieldNumber, Object value) throws IOException {
            void var1_1;
            void var2_2;
            this.writeTag(fieldNumber, 4);
            Protobuf.getInstance().writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
            void var1_1;
            void var2_2;
            void var3_3;
            this.writeTag(fieldNumber, 4);
            var3_3.writeTo(var2_2, this);
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStartGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeEndGroup(int fieldNumber) {
            void var1_1;
            this.writeTag((int)var1_1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeInt32(int value) {
            void var1_1;
            if (value >= 0) {
                this.writeVarint32(value);
                return;
            }
            this.writeVarint64((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt32(int value) {
            void var1_1;
            this.writeVarint32(CodedOutputStream.encodeZigZag32((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeSInt64(long value) {
            void var1_1;
            this.writeVarint64(CodedOutputStream.encodeZigZag64((long)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeBool(boolean value) {
            void var1_1;
            ((ByteOutput)this).write((byte)(var1_1 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.writeVarint32(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint32(int value) {
            void var1_1;
            if ((value & 0xFFFFFF80) == 0) {
                this.writeVarint32OneByte(value);
                return;
            }
            if ((value & 0xFFFFC000) == 0) {
                this.writeVarint32TwoBytes(value);
                return;
            }
            if ((value & 0xFFE00000) == 0) {
                this.writeVarint32ThreeBytes(value);
                return;
            }
            if ((value & 0xF0000000) == 0) {
                this.writeVarint32FourBytes(value);
                return;
            }
            this.writeVarint32FiveBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32OneByte(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32TwoBytes(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 7);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7F | 0x80);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32ThreeBytes(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 14);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7F | 0x80);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FourBytes(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 21);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7F | 0x80);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint32FiveBytes(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 28);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7F | 0x80);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7F | 0x80);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeVarint64(long value) {
            switch (BinaryWriter.computeUInt64SizeNoTag(value)) {
                case 1: {
                    this.writeVarint64OneByte(value);
                    return;
                }
                case 2: {
                    this.writeVarint64TwoBytes(value);
                    return;
                }
                case 3: {
                    this.writeVarint64ThreeBytes(value);
                    return;
                }
                case 4: {
                    this.writeVarint64FourBytes(value);
                    return;
                }
                case 5: {
                    this.writeVarint64FiveBytes(value);
                    return;
                }
                case 6: {
                    this.writeVarint64SixBytes(value);
                    return;
                }
                case 7: {
                    this.writeVarint64SevenBytes(value);
                    return;
                }
                case 8: {
                    this.writeVarint64EightBytes(value);
                    return;
                }
                case 9: {
                    this.writeVarint64NineBytes(value);
                    return;
                }
                case 10: {
                    void var1_1;
                    this.writeVarint64TenBytes((long)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64OneByte(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TwoBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 7);
            this.buffer[this.pos--] = (byte)((int)var1_1 & 0x7F | 0x80);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64ThreeBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)((int)value >>> 14);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FourBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 21);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64FiveBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 28);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SixBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 35);
            this.buffer[this.pos--] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64SevenBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 42);
            this.buffer[this.pos--] = (byte)(value >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64EightBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 49);
            this.buffer[this.pos--] = (byte)(value >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64NineBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 56);
            this.buffer[this.pos--] = (byte)(value >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        private void writeVarint64TenBytes(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 63);
            this.buffer[this.pos--] = (byte)(value >>> 56 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 49 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 42 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 35 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 28 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 21 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 14 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(value >>> 7 & 0x7FL | 0x80L);
            this.buffer[this.pos--] = (byte)(var1_1 & 0x7FL | 0x80L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed32(int value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >>> 24);
            this.buffer[this.pos--] = (byte)(value >> 16);
            this.buffer[this.pos--] = (byte)(value >> 8);
            this.buffer[this.pos--] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeFixed64(long value) {
            void var1_1;
            this.buffer[this.pos--] = (byte)(value >> 56);
            this.buffer[this.pos--] = (byte)(value >> 48);
            this.buffer[this.pos--] = (byte)(value >> 40);
            this.buffer[this.pos--] = (byte)(value >> 32);
            this.buffer[this.pos--] = (byte)(value >> 24);
            this.buffer[this.pos--] = (byte)(value >> 16);
            this.buffer[this.pos--] = (byte)(value >> 8);
            this.buffer[this.pos--] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeString(String in) {
            char c;
            int i;
            this.requireSpace(in.length());
            this.pos -= i;
            for (i = in.length() - 1; i >= 0 && (c = in.charAt(i)) < '\u0080'; --i) {
                this.buffer[this.pos + i] = (byte)c;
            }
            if (i == -1) {
                --this.pos;
                return;
            }
            this.pos += i;
            while (i >= 0) {
                c = in.charAt(i);
                if (c < '\u0080' && this.pos > this.offsetMinusOne) {
                    this.buffer[this.pos--] = (byte)c;
                } else if (c < '\u0800' && this.pos > this.offset) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c);
                    this.buffer[this.pos--] = (byte)(0x3C0 | c >>> 6);
                } else if ((c < '\ud800' || '\udfff' < c) && this.pos > this.offset + 1) {
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & c >>> 6);
                    this.buffer[this.pos--] = (byte)(0x1E0 | c >>> 12);
                } else if (this.pos > this.offset + 2) {
                    void var3_3;
                    char high;
                    if (i == 0 || !Character.isSurrogatePair(high = in.charAt(i - 1), c)) {
                        throw new Utf8.UnpairedSurrogateException(i - 1, i);
                    }
                    --i;
                    int codePoint = Character.toCodePoint(high, c);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & codePoint);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    this.buffer[this.pos--] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    this.buffer[this.pos--] = (byte)(0xF0 | var3_3 >>> 18);
                } else {
                    this.requireSpace(i);
                    ++i;
                }
                --i;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) {
            void var1_1;
            this.buffer[this.pos--] = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= length;
            System.arraycopy(var1_1, (int)var2_2, this.buffer, this.pos + 1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value, offset, length));
                this.nextBuffer();
                return;
            }
            this.pos -= length;
            System.arraycopy(var1_1, (int)var2_2, this.buffer, this.pos + 1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ByteBuffer value) {
            void var2_2;
            void var1_1;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.nextBuffer(length);
            }
            this.pos -= length;
            var1_1.get(this.buffer, this.pos + 1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(ByteBuffer value) {
            void var2_2;
            void var1_1;
            int length = value.remaining();
            if (this.spaceLeft() < length) {
                this.totalDoneBytes += length;
                this.buffers.addFirst(AllocatedBuffer.wrap(value));
                this.nextBuffer();
            }
            this.pos -= length;
            var1_1.get(this.buffer, this.pos + 1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void requireSpace(int size) {
            if (this.spaceLeft() < size) {
                void var1_1;
                this.nextBuffer((int)var1_1);
            }
        }
    }
}

