/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.BooleanArrayList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.DoubleArrayList;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.FloatArrayList;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@CheckReturnValue
abstract class BinaryReader
implements Reader {
    private static final int FIXED32_MULTIPLE_MASK = 3;
    private static final int FIXED64_MULTIPLE_MASK = 7;

    /*
     * WARNING - void declaration
     */
    public static BinaryReader newInstance(ByteBuffer buffer, boolean bufferIsImmutable) {
        if (buffer.hasArray()) {
            void var1_1;
            ByteBuffer byteBuffer;
            return new SafeHeapReader(byteBuffer, (boolean)var1_1);
        }
        throw new IllegalArgumentException("Direct buffers not yet supported");
    }

    private BinaryReader() {
    }

    public abstract int getTotalBytesRead();

    @Override
    public boolean shouldDiscardUnknownFields() {
        return false;
    }

    private static final class SafeHeapReader
    extends BinaryReader {
        private final boolean bufferIsImmutable;
        private final byte[] buffer;
        private int pos;
        private final int initialPos;
        private int limit;
        private int tag;
        private int endGroupTag;

        /*
         * WARNING - void declaration
         */
        public SafeHeapReader(ByteBuffer bytebuf, boolean bufferIsImmutable) {
            void var1_1;
            void var2_2;
            this.bufferIsImmutable = var2_2;
            this.buffer = bytebuf.array();
            SafeHeapReader safeHeapReader = this;
            safeHeapReader.initialPos = safeHeapReader.pos = bytebuf.arrayOffset() + bytebuf.position();
            this.limit = bytebuf.arrayOffset() + var1_1.limit();
        }

        private boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public final int getTotalBytesRead() {
            return this.pos - this.initialPos;
        }

        @Override
        public final int getFieldNumber() throws IOException {
            if (this.isAtEnd()) {
                return Integer.MAX_VALUE;
            }
            this.tag = this.readVarint32();
            if (this.tag == this.endGroupTag) {
                return Integer.MAX_VALUE;
            }
            return WireFormat.getTagFieldNumber(this.tag);
        }

        @Override
        public final int getTag() {
            return this.tag;
        }

        @Override
        public final boolean skipField() throws IOException {
            if (this.isAtEnd() || this.tag == this.endGroupTag) {
                return false;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 1: {
                    this.skipBytes(8);
                    return true;
                }
                case 2: {
                    SafeHeapReader safeHeapReader = this;
                    safeHeapReader.skipBytes(safeHeapReader.readVarint32());
                    return true;
                }
                case 5: {
                    this.skipBytes(4);
                    return true;
                }
                case 3: {
                    this.skipGroup();
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            this.requireWireType(1);
            return Double.longBitsToDouble(this.readLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            this.requireWireType(5);
            return Float.intBitsToFloat(this.readLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            this.requireWireType(0);
            return this.readVarint32() != 0;
        }

        @Override
        public final String readString() throws IOException {
            return this.readStringInternal(false);
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            return this.readStringInternal(true);
        }

        /*
         * WARNING - void declaration
         */
        public final String readStringInternal(boolean requireUtf8) throws IOException {
            void var1_2;
            void var2_3;
            this.requireWireType(2);
            int size = this.readVarint32();
            if (size == 0) {
                return "";
            }
            this.requireBytes(size);
            if (requireUtf8 && !Utf8.isValidUtf8(this.buffer, this.pos, this.pos + size)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
            this.pos += var2_3;
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            this.requireWireType(2);
            return this.readMessage(Protobuf.getInstance().schemaFor(var1_1), (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T readMessageBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            this.requireWireType(2);
            return this.readMessage((Schema<T>)var1_1, (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            T newInstance = schema.newInstance();
            this.mergeMessageField(newInstance, schema, (ExtensionRegistryLite)var2_2);
            var1_1.makeImmutable(newInstance);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> void mergeMessageField(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int newLimit;
            int size = this.readVarint32();
            this.requireBytes(size);
            int prevLimit = this.limit;
            this.limit = newLimit = this.pos + size;
            try {
                void var3_4;
                void var1_1;
                void var2_3;
                var2_3.mergeFrom(var1_1, this, (ExtensionRegistryLite)var3_4);
                if (this.pos != newLimit) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return;
            }
            finally {
                this.limit = prevLimit;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final <T> T readGroup(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            this.requireWireType(3);
            return this.readGroup(Protobuf.getInstance().schemaFor(var1_1), (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final <T> T readGroupBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            this.requireWireType(3);
            return this.readGroup((Schema<T>)var1_1, (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var1_1;
            void var2_2;
            T newInstance = schema.newInstance();
            this.mergeGroupField(newInstance, schema, (ExtensionRegistryLite)var2_2);
            var1_1.makeImmutable(newInstance);
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> void mergeGroupField(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int prevEndGroupTag = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            try {
                void var3_4;
                void var1_1;
                void var2_3;
                var2_3.mergeFrom(var1_1, this, (ExtensionRegistryLite)var3_4);
                if (this.tag != this.endGroupTag) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return;
            }
            finally {
                this.endGroupTag = prevEndGroupTag;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString readBytes() throws IOException {
            void var2_2;
            void var1_1;
            this.requireWireType(2);
            int size = this.readVarint32();
            if (size == 0) {
                return ByteString.EMPTY;
            }
            this.requireBytes(size);
            ByteString bytes = this.bufferIsImmutable ? ByteString.wrap(this.buffer, this.pos, size) : ByteString.copyFrom(this.buffer, this.pos, size);
            this.pos += var1_1;
            return var2_2;
        }

        @Override
        public final int readUInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag32(this.readVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag64(this.readVarint64());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readDoubleList(List<Double> target) throws IOException {
            if (target instanceof DoubleArrayList) {
                DoubleArrayList plist = (DoubleArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed64Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addDouble(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                        }
                        break;
                    }
                    case 1: {
                        int prevPos;
                        do {
                            plist.addDouble(this.readDouble());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed64Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                    }
                    break;
                }
                case 1: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readDouble());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readFloatList(List<Float> target) throws IOException {
            if (target instanceof FloatArrayList) {
                FloatArrayList plist = (FloatArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed32Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addFloat(Float.intBitsToFloat(this.readLittleEndian32_NoCheck()));
                        }
                        break;
                    }
                    case 5: {
                        int prevPos;
                        do {
                            plist.addFloat(this.readFloat());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed32Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(Float.valueOf(Float.intBitsToFloat(this.readLittleEndian32_NoCheck())));
                    }
                    break;
                }
                case 5: {
                    void var3_7;
                    int n;
                    do {
                        target.add(Float.valueOf(this.readFloat()));
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readUInt64List(List<Long> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof LongArrayList)) break block14;
                    LongArrayList plist = (LongArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int bytes = this.readVarint32();
                            int fieldEndPos = this.pos + bytes;
                            while (this.pos < fieldEndPos) {
                                plist.addLong(this.readVarint64());
                            }
                            this.requirePosition(fieldEndPos);
                            break block15;
                        }
                        case 0: {
                            int prevPos;
                            do {
                                plist.addLong(this.readUInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                prevPos = this.pos;
                            } while ((target = this.readVarint32()) == this.tag);
                            this.pos = prevPos;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        void var2_4;
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + var2_4;
                        while (this.pos < fieldEndPos) {
                            target.add(this.readVarint64());
                        }
                        this.requirePosition(fieldEndPos);
                        return;
                    }
                    case 0: {
                        void var3_7;
                        int n;
                        do {
                            target.add(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            int prevPos = this.pos;
                        } while ((n = this.readVarint32()) == this.tag);
                        this.pos = var3_7;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readInt64List(List<Long> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof LongArrayList)) break block14;
                    LongArrayList plist = (LongArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int bytes = this.readVarint32();
                            int fieldEndPos = this.pos + bytes;
                            while (this.pos < fieldEndPos) {
                                plist.addLong(this.readVarint64());
                            }
                            this.requirePosition(fieldEndPos);
                            break block15;
                        }
                        case 0: {
                            int prevPos;
                            do {
                                plist.addLong(this.readInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                prevPos = this.pos;
                            } while ((target = this.readVarint32()) == this.tag);
                            this.pos = prevPos;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        void var2_4;
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + var2_4;
                        while (this.pos < fieldEndPos) {
                            target.add(this.readVarint64());
                        }
                        this.requirePosition(fieldEndPos);
                        return;
                    }
                    case 0: {
                        void var3_7;
                        int n;
                        do {
                            target.add(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            int prevPos = this.pos;
                        } while ((n = this.readVarint32()) == this.tag);
                        this.pos = var3_7;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readInt32List(List<Integer> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof IntArrayList)) break block14;
                    IntArrayList plist = (IntArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int bytes = this.readVarint32();
                            int fieldEndPos = this.pos + bytes;
                            while (this.pos < fieldEndPos) {
                                plist.addInt(this.readVarint32());
                            }
                            this.requirePosition(fieldEndPos);
                            break block15;
                        }
                        case 0: {
                            int prevPos;
                            do {
                                plist.addInt(this.readInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                prevPos = this.pos;
                            } while ((target = this.readVarint32()) == this.tag);
                            this.pos = prevPos;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        void var2_4;
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + var2_4;
                        while (this.pos < fieldEndPos) {
                            target.add(this.readVarint32());
                        }
                        this.requirePosition(fieldEndPos);
                        return;
                    }
                    case 0: {
                        void var3_7;
                        int n;
                        do {
                            target.add(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            int prevPos = this.pos;
                        } while ((n = this.readVarint32()) == this.tag);
                        this.pos = var3_7;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readFixed64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed64Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addLong(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int prevPos;
                        do {
                            plist.addLong(this.readFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed64Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readLittleEndian64_NoCheck());
                    }
                    break;
                }
                case 1: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readFixed32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed32Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addInt(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int prevPos;
                        do {
                            plist.addInt(this.readFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed32Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readLittleEndian32_NoCheck());
                    }
                    break;
                }
                case 5: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readBoolList(List<Boolean> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof BooleanArrayList)) break block14;
                    BooleanArrayList plist = (BooleanArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int bytes = this.readVarint32();
                            int fieldEndPos = this.pos + bytes;
                            while (this.pos < fieldEndPos) {
                                plist.addBoolean(this.readVarint32() != 0);
                            }
                            this.requirePosition(fieldEndPos);
                            break block15;
                        }
                        case 0: {
                            int prevPos;
                            do {
                                plist.addBoolean(this.readBool());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                prevPos = this.pos;
                            } while ((target = this.readVarint32()) == this.tag);
                            this.pos = prevPos;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        void var2_4;
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + var2_4;
                        while (this.pos < fieldEndPos) {
                            target.add(this.readVarint32() != 0);
                        }
                        this.requirePosition(fieldEndPos);
                        return;
                    }
                    case 0: {
                        void var3_7;
                        int n;
                        do {
                            target.add(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            int prevPos = this.pos;
                        } while ((n = this.readVarint32()) == this.tag);
                        this.pos = var3_7;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readStringList(List<String> target) throws IOException {
            void var1_1;
            this.readStringListInternal((List<String>)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readStringListRequireUtf8(List<String> target) throws IOException {
            void var1_1;
            this.readStringListInternal((List<String>)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        public final void readStringListInternal(List<String> target, boolean requireUtf8) throws IOException {
            void var3_5;
            int n;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            if (target instanceof LazyStringList && !requireUtf8) {
                int prevPos;
                LazyStringList lazyList = (LazyStringList)target;
                do {
                    lazyList.add(this.readBytes());
                    if (this.isAtEnd()) {
                        return;
                    }
                    prevPos = this.pos;
                } while ((target = this.readVarint32()) == this.tag);
                this.pos = prevPos;
                return;
            }
            do {
                target.add(this.readStringInternal(requireUtf8));
                if (this.isAtEnd()) {
                    return;
                }
                int prevPos = this.pos;
            } while ((n = this.readVarint32()) == this.tag);
            this.pos = var3_5;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> void readMessageList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
            this.readMessageList((List<T>)var1_1, (Schema<T>)var2_2, (ExtensionRegistryLite)var3_3);
        }

        @Override
        public final <T> void readMessageList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int prevPos;
            int n;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int listTag = this.tag;
            do {
                target.add(this.readMessage(schema, extensionRegistry));
                if (this.isAtEnd()) {
                    return;
                }
                prevPos = this.pos;
            } while ((n = this.readVarint32()) == listTag);
            this.pos = prevPos;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Deprecated
        public final <T> void readGroupList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
            this.readGroupList((List<T>)var1_1, (Schema<T>)var2_2, (ExtensionRegistryLite)var3_3);
        }

        @Override
        @Deprecated
        public final <T> void readGroupList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int prevPos;
            int n;
            if (WireFormat.getTagWireType(this.tag) != 3) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int listTag = this.tag;
            do {
                target.add(this.readGroup(schema, extensionRegistry));
                if (this.isAtEnd()) {
                    return;
                }
                prevPos = this.pos;
            } while ((n = this.readVarint32()) == listTag);
            this.pos = prevPos;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readBytesList(List<ByteString> target) throws IOException {
            void var2_2;
            int n;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            do {
                target.add(this.readBytes());
                if (this.isAtEnd()) {
                    return;
                }
                int prevPos = this.pos;
            } while ((n = this.readVarint32()) == this.tag);
            this.pos = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readUInt32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addInt(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int prevPos;
                        do {
                            plist.addInt(this.readUInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readVarint32());
                    }
                    break;
                }
                case 0: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readUInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readEnumList(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addInt(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int prevPos;
                        do {
                            plist.addInt(this.readEnum());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readVarint32());
                    }
                    break;
                }
                case 0: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readEnum());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readSFixed32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed32Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addInt(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int prevPos;
                        do {
                            plist.addInt(this.readSFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed32Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readLittleEndian32_NoCheck());
                    }
                    break;
                }
                case 5: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readSFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readSFixed64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        this.verifyPackedFixed64Length(bytes);
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addLong(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int prevPos;
                        do {
                            plist.addLong(this.readSFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    this.verifyPackedFixed64Length(bytes);
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(this.readLittleEndian64_NoCheck());
                    }
                    break;
                }
                case 1: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readSFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readSInt32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addInt(CodedInputStream.decodeZigZag32(this.readVarint32()));
                        }
                        break;
                    }
                    case 0: {
                        int prevPos;
                        do {
                            plist.addInt(this.readSInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(CodedInputStream.decodeZigZag32(this.readVarint32()));
                    }
                    break;
                }
                case 0: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readSInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readSInt64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.readVarint32();
                        int fieldEndPos = this.pos + bytes;
                        while (this.pos < fieldEndPos) {
                            plist.addLong(CodedInputStream.decodeZigZag64(this.readVarint64()));
                        }
                        break;
                    }
                    case 0: {
                        int prevPos;
                        do {
                            plist.addLong(this.readSInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            prevPos = this.pos;
                        } while ((target = this.readVarint32()) == this.tag);
                        this.pos = prevPos;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var2_4;
                    int bytes = this.readVarint32();
                    int fieldEndPos = this.pos + var2_4;
                    while (this.pos < fieldEndPos) {
                        target.add(CodedInputStream.decodeZigZag64(this.readVarint64()));
                    }
                    break;
                }
                case 0: {
                    void var3_7;
                    int n;
                    do {
                        target.add(this.readSInt64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        int prevPos = this.pos;
                    } while ((n = this.readVarint32()) == this.tag);
                    this.pos = var3_7;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <K, V> void readMap(Map<K, V> target, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
            int newLimit;
            this.requireWireType(2);
            int size = this.readVarint32();
            this.requireBytes(size);
            int prevLimit = this.limit;
            this.limit = newLimit = this.pos + size;
            try {
                void var1_1;
                int number;
                Object key = metadata.defaultKey;
                Object value = metadata.defaultValue;
                block9: while ((number = this.getFieldNumber()) != Integer.MAX_VALUE) {
                    try {
                        switch (number) {
                            case 1: {
                                key = this.readField(metadata.keyType, null, null);
                                continue block9;
                            }
                            case 2: {
                                value = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistry);
                                continue block9;
                            }
                        }
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                    catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                }
                var1_1.put(key, value);
                return;
            }
            finally {
                this.limit = prevLimit;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object readField(WireFormat.FieldType fieldType, Class<?> messageType, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
                case 1: {
                    return this.readBool();
                }
                case 2: {
                    return this.readBytes();
                }
                case 3: {
                    return this.readDouble();
                }
                case 4: {
                    return this.readEnum();
                }
                case 5: {
                    return this.readFixed32();
                }
                case 6: {
                    return this.readFixed64();
                }
                case 7: {
                    return Float.valueOf(this.readFloat());
                }
                case 8: {
                    return this.readInt32();
                }
                case 9: {
                    return this.readInt64();
                }
                case 10: {
                    void var3_3;
                    void var2_2;
                    return this.readMessage((Class)var2_2, (ExtensionRegistryLite)var3_3);
                }
                case 11: {
                    return this.readSFixed32();
                }
                case 12: {
                    return this.readSFixed64();
                }
                case 13: {
                    return this.readSInt32();
                }
                case 14: {
                    return this.readSInt64();
                }
                case 15: {
                    return this.readStringRequireUtf8();
                }
                case 16: {
                    return this.readUInt32();
                }
                case 17: {
                    return this.readUInt64();
                }
            }
            throw new RuntimeException("unsupported field type.");
        }

        /*
         * WARNING - void declaration
         */
        private int readVarint32() throws IOException {
            void var2_2;
            void var1_1;
            int x;
            int i = this.pos;
            if (this.limit == this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((x = this.buffer[i++]) >= 0) {
                this.pos = i;
                return x;
            }
            if (this.limit - i < 9) {
                return (int)this.readVarint64SlowPath();
            }
            if ((x ^= this.buffer[i++] << 7) < 0) {
                x ^= 0xFFFFFF80;
            } else if ((x ^= this.buffer[i++] << 14) >= 0) {
                x ^= 0x3F80;
            } else if ((x ^= this.buffer[i++] << 21) < 0) {
                x ^= 0xFFE03F80;
            } else {
                void var3_3;
                byte y = this.buffer[i++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (var3_3 < 0 && this.buffer[i++] < 0 && this.buffer[i++] < 0 && this.buffer[i++] < 0 && this.buffer[i++] < 0 && this.buffer[i++] < 0) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = var1_1;
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final long readVarint64() throws IOException {
            void var3_4;
            void var1_1;
            int x32;
            long x32;
            int y;
            int i = this.pos;
            if (this.limit == i) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] buffer = this.buffer;
            if ((y = this.buffer[i++]) >= 0) {
                this.pos = i;
                return y;
            }
            if (this.limit - i < 9) {
                return this.readVarint64SlowPath();
            }
            if ((y ^= buffer[i++] << 7) < 0) {
                x32 = y ^ 0xFFFFFF80;
            } else if ((x32 ^= buffer[i++] << 14) >= 0) {
                x32 = x32 ^ 0x3F80;
            } else if ((x32 ^= buffer[i++] << 21) < 0) {
                x32 = x32 ^ 0xFFE03F80;
            } else if ((x32 = (long)x32 ^ (long)buffer[i++] << 28) >= 0L) {
                x32 ^= 0xFE03F80L;
            } else if ((x32 ^= (long)buffer[i++] << 35) < 0L) {
                x32 ^= 0xFFFFFFF80FE03F80L;
            } else if ((x32 ^= (long)buffer[i++] << 42) >= 0L) {
                x32 ^= 0x3F80FE03F80L;
            } else if ((x32 ^= (long)buffer[i++] << 49) < 0L) {
                x32 ^= 0xFFFE03F80FE03F80L;
            } else {
                void var2_2;
                x32 ^= (long)buffer[i++] << 56;
                if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[i++] < 0L) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = var1_1;
            return (long)var3_4;
        }

        private long readVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private byte readByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        private int readLittleEndian32() throws IOException {
            this.requireBytes(4);
            return this.readLittleEndian32_NoCheck();
        }

        private long readLittleEndian64() throws IOException {
            this.requireBytes(8);
            return this.readLittleEndian64_NoCheck();
        }

        /*
         * WARNING - void declaration
         */
        private int readLittleEndian32_NoCheck() {
            void var1_1;
            void var2_2;
            int p = this.pos;
            byte[] buffer = this.buffer;
            this.pos = p + 4;
            return buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readLittleEndian64_NoCheck() {
            void var1_1;
            void var2_2;
            int p = this.pos;
            byte[] buffer = this.buffer;
            this.pos = p + 8;
            return (long)buffer[p] & 0xFFL | ((long)buffer[p + 1] & 0xFFL) << 8 | ((long)buffer[p + 2] & 0xFFL) << 16 | ((long)buffer[p + 3] & 0xFFL) << 24 | ((long)buffer[p + 4] & 0xFFL) << 32 | ((long)buffer[p + 5] & 0xFFL) << 40 | ((long)buffer[p + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
        }

        private void skipVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                byte[] buffer = this.buffer;
                int p = this.pos;
                for (int i = 0; i < 10; ++i) {
                    if (buffer[p++] < 0) continue;
                    this.pos = p;
                    return;
                }
            }
            this.skipVarintSlowPath();
        }

        private void skipVarintSlowPath() throws IOException {
            for (int i = 0; i < 10; ++i) {
                if (this.readByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private void skipBytes(int size) throws IOException {
            void var1_1;
            this.requireBytes(size);
            this.pos += var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void skipGroup() throws IOException {
            void var1_1;
            int prevEndGroupTag = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            while (this.getFieldNumber() != Integer.MAX_VALUE && this.skipField()) {
            }
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void requireBytes(int size) throws IOException {
            void var1_1;
            if (size < 0 || var1_1 > this.limit - this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void requireWireType(int requiredWireType) throws IOException {
            void var1_1;
            if (WireFormat.getTagWireType(this.tag) != var1_1) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void verifyPackedFixed64Length(int bytes) throws IOException {
            void var1_1;
            this.requireBytes(bytes);
            if ((var1_1 & 7) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void verifyPackedFixed32Length(int bytes) throws IOException {
            void var1_1;
            this.requireBytes(bytes);
            if ((var1_1 & 3) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void requirePosition(int expectedPosition) throws IOException {
            void var1_1;
            if (this.pos != var1_1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }
    }
}

