/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.BooleanArrayList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.DoubleArrayList;
import androidx.datastore.preferences.protobuf.ExtensionLite;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.FloatArrayList;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.MessageSchema;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaUtil;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.UnknownFieldSetLite;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;

@CheckReturnValue
final class ArrayDecoders {
    static final int DEFAULT_RECURSION_LIMIT = 100;
    private static volatile int recursionLimit = 100;

    private ArrayDecoders() {
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint32(byte[] data, int position, Registers registers) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        void var3_3;
        int value;
        if ((value = data[position++]) >= 0) {
            registers.int1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint32((int)var3_3, byArray, (int)var1_1, (Registers)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint32(int firstByte, byte[] data, int position, Registers registers) {
        void var2_2;
        int n;
        byte b5;
        byte b4;
        byte b3;
        byte b2;
        int value = firstByte & 0x7F;
        if ((b2 = data[position++]) >= 0) {
            registers.int1 = value | b2 << 7;
            return position;
        }
        value |= (b2 & 0x7F) << 7;
        if ((b3 = data[position++]) >= 0) {
            registers.int1 = value | b3 << 14;
            return position;
        }
        value |= (b3 & 0x7F) << 14;
        if ((b4 = data[position++]) >= 0) {
            registers.int1 = value | b4 << 21;
            return position;
        }
        value |= (b4 & 0x7F) << 21;
        if ((b5 = data[position++]) >= 0) {
            registers.int1 = value | b5 << 28;
            return position;
        }
        value |= (b5 & 0x7F) << 28;
        while (data[position++] < 0) {
        }
        var3_3.int1 = n;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint64(byte[] data, int position, Registers registers) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        void var3_3;
        long value;
        if ((value = (long)data[position++]) >= 0L) {
            registers.long1 = value;
            return position;
        }
        return ArrayDecoders.decodeVarint64((long)var3_3, byArray, (int)var1_1, (Registers)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint64(long firstByte, byte[] data, int position, Registers registers) {
        void var3_3;
        long value = firstByte & 0x7FL;
        byte next = data[position++];
        int shift = 7;
        value |= (long)(next & 0x7F) << 7;
        while (next < 0) {
            next = data[position++];
            value |= (long)(next & 0x7F) << (shift += 7);
        }
        registers.long1 = value;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeFixed32(byte[] data, int position) {
        void var1_1;
        byte[] byArray;
        return data[position] & 0xFF | (data[position + 1] & 0xFF) << 8 | (data[position + 2] & 0xFF) << 16 | (byArray[var1_1 + 3] & 0xFF) << 24;
    }

    /*
     * WARNING - void declaration
     */
    static long decodeFixed64(byte[] data, int position) {
        void var1_1;
        byte[] byArray;
        return (long)data[position] & 0xFFL | ((long)data[position + 1] & 0xFFL) << 8 | ((long)data[position + 2] & 0xFFL) << 16 | ((long)data[position + 3] & 0xFFL) << 24 | ((long)data[position + 4] & 0xFFL) << 32 | ((long)data[position + 5] & 0xFFL) << 40 | ((long)data[position + 6] & 0xFFL) << 48 | ((long)byArray[var1_1 + 7] & 0xFFL) << 56;
    }

    /*
     * WARNING - void declaration
     */
    static double decodeDouble(byte[] data, int position) {
        void var1_1;
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(data, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static float decodeFloat(byte[] data, int position) {
        void var1_1;
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(data, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static int decodeString(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        void var3_3;
        void var1_1;
        byte[] byArray;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        var2_2.object1 = new String(byArray, position, length, Internal.UTF_8);
        return (int)(var1_1 + var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int decodeStringRequireUtf8(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        void var3_3;
        void var1_1;
        byte[] byArray;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            registers.object1 = "";
            return position;
        }
        var2_2.object1 = Utf8.decodeUtf8(byArray, position, length);
        return (int)(var1_1 + var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int decodeBytes(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        void var3_3;
        void var1_1;
        byte[] byArray;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            registers.object1 = ByteString.EMPTY;
            return position;
        }
        var2_2.object1 = ByteString.copyFrom(byArray, position, length);
        return (int)(var1_1 + var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int decodeMessageField(Schema schema, byte[] data, int position, int limit, Registers registers) throws IOException {
        void var1_2;
        Schema schema2;
        void var3_4;
        void var2_3;
        Object msg = schema.newInstance();
        int offset = ArrayDecoders.mergeMessageField(msg, schema, data, (int)var2_3, (int)var3_4, registers);
        schema2.makeImmutable(msg);
        registers.object1 = msg;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeGroupField(Schema schema, byte[] data, int position, int limit, int endGroup, Registers registers) throws IOException {
        void var1_2;
        Schema schema2;
        void var3_4;
        void var2_3;
        Object msg = schema.newInstance();
        int offset = ArrayDecoders.mergeGroupField(msg, schema, data, (int)var2_3, (int)var3_4, endGroup, registers);
        schema2.makeImmutable(msg);
        registers.object1 = msg;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static int mergeMessageField(Object msg, Schema schema, byte[] data, int position, int limit, Registers registers) throws IOException {
        void var3_3;
        Object object;
        void var2_2;
        void var1_1;
        int length;
        if ((length = data[position++]) < 0) {
            position = ArrayDecoders.decodeVarint32(length, data, position, registers);
            length = registers.int1;
        }
        if (length < 0 || length > limit - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        ++registers.recursionDepth;
        ArrayDecoders.checkRecursionLimit(registers.recursionDepth);
        int n = position;
        var1_1.mergeFrom(msg, (byte[])var2_2, n, n + length, registers);
        --registers.recursionDepth;
        registers.object1 = object;
        return (int)(var3_3 + length);
    }

    /*
     * WARNING - void declaration
     */
    static int mergeGroupField(Object msg, Schema schema, byte[] data, int position, int limit, int endGroup, Registers registers) throws IOException {
        void var1_2;
        Object object;
        void var3_4;
        void var2_3;
        MessageSchema messageSchema = (MessageSchema)schema;
        ++registers.recursionDepth;
        ArrayDecoders.checkRecursionLimit(registers.recursionDepth);
        int endPosition = messageSchema.parseMessage(msg, (byte[])var2_3, (int)var3_4, limit, endGroup, registers);
        --registers.recursionDepth;
        registers.object1 = object;
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        output.addInt(registers.int1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            output.addInt(registers.int1);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeVarint64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addLong(registers.long1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addLong(registers.long1);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeFixed32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        IntArrayList output = (IntArrayList)list;
        output.addInt(ArrayDecoders.decodeFixed32(data, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addInt(ArrayDecoders.decodeFixed32(data, nextPosition));
            position = nextPosition + 4;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeFixed64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        LongArrayList output = (LongArrayList)list;
        output.addLong(ArrayDecoders.decodeFixed64(data, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addLong(ArrayDecoders.decodeFixed64(data, nextPosition));
            position = nextPosition + 8;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeFloatList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        FloatArrayList output = (FloatArrayList)list;
        output.addFloat(ArrayDecoders.decodeFloat(data, position));
        position += 4;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addFloat(ArrayDecoders.decodeFloat(data, nextPosition));
            position = nextPosition + 4;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeDoubleList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        DoubleArrayList output = (DoubleArrayList)list;
        output.addDouble(ArrayDecoders.decodeDouble(data, position));
        position += 8;
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            output.addDouble(ArrayDecoders.decodeDouble(data, nextPosition));
            position = nextPosition + 8;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeBoolList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        BooleanArrayList output = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addBoolean(registers.long1 != 0L);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeSInt32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeSInt64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        void var2_2;
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, nextPosition, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedVarint32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            output.addInt(registers.int1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedVarint64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addLong(registers.long1);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedFixed32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        void var3_4;
        IntArrayList output = (IntArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 4) {
            output.addInt(ArrayDecoders.decodeFixed32(data, position));
        }
        if (position != var3_4) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedFixed64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        void var3_4;
        LongArrayList output = (LongArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 8) {
            output.addLong(ArrayDecoders.decodeFixed64(data, position));
        }
        if (position != var3_4) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedFloatList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        void var3_4;
        FloatArrayList output = (FloatArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 4) {
            output.addFloat(ArrayDecoders.decodeFloat(data, position));
        }
        if (position != var3_4) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedDoubleList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        void var3_4;
        DoubleArrayList output = (DoubleArrayList)list;
        int fieldLimit = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < fieldLimit; position += 8) {
            output.addDouble(ArrayDecoders.decodeDouble(data, position));
        }
        if (position != var3_4) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedBoolList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        BooleanArrayList output = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addBoolean(registers.long1 != 0L);
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedSInt32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        IntArrayList output = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            output.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodePackedSInt64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var1_1;
        LongArrayList output = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int fieldLimit = position + registers.int1;
        while (position < fieldLimit) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            output.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (position != fieldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeStringList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        void var2_2;
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            String value = new String(data, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            String value = new String(data, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeStringListRequireUtf8(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        void var2_2;
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length == 0) {
            output.add("");
        } else {
            int n = position;
            if (!Utf8.isValidUtf8(data, n, n + length)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data, position, length, Internal.UTF_8);
            output.add(value);
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength == 0) {
                output.add("");
                continue;
            }
            int n = position;
            if (!Utf8.isValidUtf8(data, n, n + nextLength)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String value = new String(data, position, nextLength, Internal.UTF_8);
            output.add(value);
            position += nextLength;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeBytesList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        void var2_2;
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int length = registers.int1;
        if (length < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (length > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (length == 0) {
            output.add(ByteString.EMPTY);
        } else {
            output.add(ByteString.copyFrom(data, position, length));
            position += length;
        }
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, nextPosition, registers);
            int nextLength = registers.int1;
            if (nextLength < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (nextLength > data.length - position) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (nextLength == 0) {
                output.add(ByteString.EMPTY);
                continue;
            }
            output.add(ByteString.copyFrom(data, position, nextLength));
            position += nextLength;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeMessageList(Schema<?> schema, int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var3_3;
        Internal.ProtobufList<?> output = list;
        position = ArrayDecoders.decodeMessageField(schema, data, position, limit, registers);
        output.add(registers.object1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeMessageField(schema, data, nextPosition, limit, registers);
            output.add(registers.object1);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeGroupList(Schema schema, int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        void var3_3;
        Internal.ProtobufList<?> output = list;
        int endgroup = tag & 0xFFFFFFF8 | 4;
        position = ArrayDecoders.decodeGroupField(schema, data, position, limit, endgroup, registers);
        output.add(registers.object1);
        while (position < limit) {
            int nextPosition = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeGroupField(schema, data, nextPosition, limit, endgroup, registers);
            output.add(registers.object1);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeExtensionOrUnknownField(int tag, byte[] data, int position, int limit, Object message, MessageLite defaultInstance, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        int number = tag >>> 3;
        GeneratedMessageLite.GeneratedExtension<MessageLite, ?> extension = registers.extensionRegistry.findLiteExtensionByNumber(defaultInstance, number);
        if (extension == null) {
            return ArrayDecoders.decodeUnknownField(tag, data, position, limit, MessageSchema.getMutableUnknownFields(message), registers);
        }
        ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
        return ArrayDecoders.decodeExtension(n, (byte[])var1_1, (int)var2_2, (int)var3_3, (GeneratedMessageLite.ExtendableMessage)message, extension, unknownFieldSchema, registers);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static int decodeExtension(int tag, byte[] data, int position, int limit, GeneratedMessageLite.ExtendableMessage<?, ?> message, GeneratedMessageLite.GeneratedExtension<?, ?> extension, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        void var9_38;
        void var2_4;
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions;
        block35: {
            int fieldNumber;
            block34: {
                extensions = message.extensions;
                fieldNumber = tag >>> 3;
                if (!extension.descriptor.isRepeated() || !extension.descriptor.isPacked()) break block34;
                switch (((ExtensionLite)extension).getLiteType()) {
                    case DOUBLE: {
                        DoubleArrayList doubleArrayList = new DoubleArrayList();
                        position = ArrayDecoders.decodePackedDoubleList(data, position, doubleArrayList, registers);
                        break block35;
                    }
                    case FLOAT: {
                        FloatArrayList floatArrayList = new FloatArrayList();
                        position = ArrayDecoders.decodePackedFloatList(data, position, floatArrayList, registers);
                        break block35;
                    }
                    case INT64: 
                    case UINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        position = ArrayDecoders.decodePackedVarint64List(data, position, longArrayList, registers);
                        break block35;
                    }
                    case INT32: 
                    case UINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data, position, intArrayList, registers);
                        break block35;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        LongArrayList longArrayList = new LongArrayList();
                        position = ArrayDecoders.decodePackedFixed64List(data, position, longArrayList, registers);
                        break block35;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        IntArrayList intArrayList = new IntArrayList();
                        position = ArrayDecoders.decodePackedFixed32List(data, position, intArrayList, registers);
                        break block35;
                    }
                    case BOOL: {
                        BooleanArrayList booleanArrayList = new BooleanArrayList();
                        position = ArrayDecoders.decodePackedBoolList(data, position, booleanArrayList, registers);
                        break block35;
                    }
                    case SINT32: {
                        IntArrayList intArrayList = new IntArrayList();
                        position = ArrayDecoders.decodePackedSInt32List(data, position, intArrayList, registers);
                        break block35;
                    }
                    case SINT64: {
                        LongArrayList longArrayList = new LongArrayList();
                        position = ArrayDecoders.decodePackedSInt64List(data, position, longArrayList, registers);
                        break block35;
                    }
                    case ENUM: {
                        IntArrayList intArrayList = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data, position, intArrayList, registers);
                        SchemaUtil.filterUnknownEnumList(message, fieldNumber, (List<Integer>)intArrayList, extension.descriptor.getEnumType(), null, unknownFieldSchema);
                        break block35;
                    }
                    default: {
                        throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                    }
                }
            }
            Object var9_21 = null;
            if (((ExtensionLite)extension).getLiteType() == WireFormat.FieldType.ENUM) {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                Object obj = extension.descriptor.getEnumType().findValueByNumber(registers.int1);
                if (obj == null) {
                    SchemaUtil.storeUnknownEnum(message, fieldNumber, registers.int1, null, unknownFieldSchema);
                    return position;
                }
                Integer n = registers.int1;
            } else {
                switch (((ExtensionLite)extension).getLiteType()) {
                    case DOUBLE: {
                        Double d = ArrayDecoders.decodeDouble(data, position);
                        position += 8;
                        break;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf(ArrayDecoders.decodeFloat(data, position));
                        position += 4;
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        Long l = registers.long1;
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        Integer n = registers.int1;
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        Long l = ArrayDecoders.decodeFixed64(data, position);
                        position += 8;
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        Integer n = ArrayDecoders.decodeFixed32(data, position);
                        position += 4;
                        break;
                    }
                    case BOOL: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        Boolean bl = registers.long1 != 0L;
                        break;
                    }
                    case BYTES: {
                        position = ArrayDecoders.decodeBytes(data, position, registers);
                        Object object = registers.object1;
                        break;
                    }
                    case SINT32: {
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        Integer n = CodedInputStream.decodeZigZag32(registers.int1);
                        break;
                    }
                    case SINT64: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        Long l = CodedInputStream.decodeZigZag64(registers.long1);
                        break;
                    }
                    case STRING: {
                        position = ArrayDecoders.decodeString(data, position, registers);
                        Object object = registers.object1;
                        break;
                    }
                    case GROUP: {
                        int n = fieldNumber << 3 | 4;
                        Schema<Class<?>> fieldSchema = Protobuf.getInstance().schemaFor(((ExtensionLite)extension).getMessageDefaultInstance().getClass());
                        if (((ExtensionLite)extension).isRepeated()) {
                            position = ArrayDecoders.decodeGroupField(fieldSchema, data, position, limit, n, registers);
                            extensions.addRepeatedField(extension.descriptor, registers.object1);
                            return position;
                        }
                        Class<?> oldValue = extensions.getField(extension.descriptor);
                        if (oldValue != null) return ArrayDecoders.mergeGroupField(oldValue, fieldSchema, data, position, limit, n, registers);
                        oldValue = fieldSchema.newInstance();
                        extensions.setField(extension.descriptor, oldValue);
                        return ArrayDecoders.mergeGroupField(oldValue, fieldSchema, data, position, limit, n, registers);
                    }
                    case MESSAGE: {
                        void var3_5;
                        void var1_3;
                        void var0_2;
                        Schema<Class<?>> schema = Protobuf.getInstance().schemaFor(((ExtensionLite)extension).getMessageDefaultInstance().getClass());
                        if (((ExtensionLite)extension).isRepeated()) {
                            position = ArrayDecoders.decodeMessageField(schema, data, position, limit, registers);
                            extensions.addRepeatedField(extension.descriptor, registers.object1);
                            return position;
                        }
                        Class<?> oldValue = extensions.getField(extension.descriptor);
                        if (oldValue != null) return ArrayDecoders.mergeMessageField(var0_2, schema, (byte[])var1_3, position, (int)var3_5, registers);
                        oldValue = schema.newInstance();
                        extensions.setField(extension.descriptor, oldValue);
                        return ArrayDecoders.mergeMessageField(var0_2, schema, (byte[])var1_3, position, (int)var3_5, registers);
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (((ExtensionLite)extension).isRepeated()) {
                void var9_37;
                extensions.addRepeatedField(extension.descriptor, var9_37);
                return (int)var2_4;
            }
        }
        extensions.setField(extension.descriptor, var9_38);
        return (int)var2_4;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeUnknownField(int tag, byte[] data, int position, int limit, UnknownFieldSetLite unknownFields, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unknownFields.storeField(tag, registers.long1);
                return position;
            }
            case 5: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed32(data, position));
                return position + 4;
            }
            case 1: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed64(data, position));
                return position + 8;
            }
            case 2: {
                void var3_3;
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int length = registers.int1;
                if (length < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (length > data.length - position) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (length == 0) {
                    unknownFields.storeField(tag, ByteString.EMPTY);
                } else {
                    unknownFields.storeField(tag, ByteString.copyFrom(data, position, length));
                }
                return position + var3_3;
            }
            case 3: {
                void var2_2;
                int n;
                void var3_3;
                UnknownFieldSetLite child = UnknownFieldSetLite.newInstance();
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                ++registers.recursionDepth;
                ArrayDecoders.checkRecursionLimit(registers.recursionDepth);
                while (position < var3_3) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.decodeUnknownField(lastTag, data, position, (int)var3_3, child, registers);
                }
                --registers.recursionDepth;
                if (position > var3_3 || lastTag != endGroup) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFields.storeField(n, child);
                return (int)var2_2;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    /*
     * WARNING - void declaration
     */
    static int skipField(int tag, byte[] data, int position, int limit, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                return position;
            }
            case 5: {
                return position + 4;
            }
            case 1: {
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                return position + registers.int1;
            }
            case 3: {
                void var2_2;
                int n;
                void var3_3;
                int endGroup = tag & 0xFFFFFFF8 | 4;
                int lastTag = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    lastTag = registers.int1;
                    if (lastTag == endGroup) break;
                    position = ArrayDecoders.skipField(lastTag, data, position, limit, registers);
                }
                if (position > var3_3 || lastTag != n) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return (int)var2_2;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    public static void setRecursionLimit(int limit) {
        recursionLimit = limit;
    }

    private static void checkRecursionLimit(int depth) throws InvalidProtocolBufferException {
        if (depth >= recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;
        public final ExtensionRegistryLite extensionRegistry;
        public int recursionDepth;

        Registers() {
            this.extensionRegistry = ExtensionRegistryLite.getEmptyRegistry();
        }

        /*
         * WARNING - void declaration
         */
        Registers(ExtensionRegistryLite extensionRegistry) {
            void var1_1;
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            this.extensionRegistry = var1_1;
        }
    }
}

