/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.CanIgnoreReturnValue;
import androidx.datastore.preferences.protobuf.CheckReturnValue;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.Java8Compatibility;
import java.nio.ByteBuffer;

@CheckReturnValue
abstract class AllocatedBuffer {
    AllocatedBuffer() {
    }

    public abstract boolean hasNioBuffer();

    public abstract boolean hasArray();

    public abstract ByteBuffer nioBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract int position();

    @CanIgnoreReturnValue
    public abstract AllocatedBuffer position(int var1);

    public abstract int limit();

    public abstract int remaining();

    public static AllocatedBuffer wrap(byte[] bytes) {
        byte[] byArray;
        return AllocatedBuffer.wrapNoCheck(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static AllocatedBuffer wrap(byte[] bytes, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException(String.format("bytes.length=%d, offset=%d, length=%d", bytes.length, offset, length));
        }
        return AllocatedBuffer.wrapNoCheck(byArray, (int)var1_1, (int)var2_2);
    }

    public static AllocatedBuffer wrap(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        Internal.checkNotNull(buffer, "buffer");
        return new AllocatedBuffer(){

            @Override
            public boolean hasNioBuffer() {
                return true;
            }

            @Override
            public ByteBuffer nioBuffer() {
                return byteBuffer;
            }

            @Override
            public boolean hasArray() {
                return byteBuffer.hasArray();
            }

            @Override
            public byte[] array() {
                return byteBuffer.array();
            }

            @Override
            public int arrayOffset() {
                return byteBuffer.arrayOffset();
            }

            @Override
            public int position() {
                return byteBuffer.position();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AllocatedBuffer position(int position) {
                void var1_1;
                Java8Compatibility.position(byteBuffer, (int)var1_1);
                return this;
            }

            @Override
            public int limit() {
                return byteBuffer.limit();
            }

            @Override
            public int remaining() {
                return byteBuffer.remaining();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static AllocatedBuffer wrapNoCheck(byte[] bytes, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return new AllocatedBuffer((int)var1_1, (int)var2_2){
            private int position;
            final /* synthetic */ int val$offset;
            final /* synthetic */ int val$length;
            {
                this.val$offset = n;
                this.val$length = n2;
            }

            @Override
            public boolean hasNioBuffer() {
                return false;
            }

            @Override
            public ByteBuffer nioBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasArray() {
                return true;
            }

            @Override
            public byte[] array() {
                return byArray;
            }

            @Override
            public int arrayOffset() {
                return this.val$offset;
            }

            @Override
            public int position() {
                return this.position;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AllocatedBuffer position(int position) {
                void var1_1;
                if (position < 0 || position > this.val$length) {
                    throw new IllegalArgumentException("Invalid position: " + position);
                }
                this.position = var1_1;
                return this;
            }

            @Override
            public int limit() {
                return this.val$length;
            }

            @Override
            public int remaining() {
                return this.val$length - this.position;
            }
        };
    }
}

