/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Internal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable;

    AbstractProtobufList() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    AbstractProtobufList(boolean isMutable) {
        void var1_1;
        this.isMutable = var1_1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (!(o instanceof RandomAccess)) {
            return super.equals(o);
        }
        List other = (List)o;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var2_2;
        int size = this.size();
        int hashCode = 1;
        for (int i = 0; i < size; ++i) {
            hashCode = hashCode * 31 + this.get(i).hashCode();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(E e) {
        void var1_1;
        this.ensureIsMutable();
        return super.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, E element) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        super.add((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        void var1_1;
        this.ensureIsMutable();
        return super.addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        return super.addAll((int)var1_1, var2_2);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E remove(int index) {
        void var1_1;
        this.ensureIsMutable();
        return super.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_2;
        this.ensureIsMutable();
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove((int)var1_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        void var1_1;
        this.ensureIsMutable();
        return super.removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        void var1_1;
        this.ensureIsMutable();
        return super.retainAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E set(int index, E element) {
        void var2_2;
        void var1_1;
        this.ensureIsMutable();
        return super.set((int)var1_1, var2_2);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

