/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UninitializedMessageException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageLite<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
implements MessageLite {
    protected int memoizedHashCode = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException(this.getSerializingExceptionMessage("ByteString"), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toByteArray() {
        try {
            void var2_3;
            byte[] result = new byte[this.getSerializedSize()];
            CodedOutputStream output = CodedOutputStream.newInstance(result);
            this.writeTo(output);
            var2_3.checkNoSpaceLeft();
            return result;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException(this.getSerializingExceptionMessage("byte array"), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTo(OutputStream output) throws IOException {
        void var1_1;
        void var2_2;
        int bufferSize = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, (int)var2_2);
        this.writeTo(codedOutput);
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeDelimitedTo(OutputStream output) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        int serialized = this.getSerializedSize();
        int bufferSize = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeUInt32SizeNoTag(serialized) + serialized);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, (int)var3_3);
        codedOutput.writeUInt32NoTag((int)var2_2);
        this.writeTo(codedOutput);
        var1_1.flush();
    }

    int getMemoizedSerializedSize() {
        throw new UnsupportedOperationException();
    }

    void setMemoizedSerializedSize(int size) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    int getSerializedSize(Schema schema) {
        void var2_2;
        int memoizedSerializedSize = this.getMemoizedSerializedSize();
        if (memoizedSerializedSize == -1) {
            void var1_1;
            memoizedSerializedSize = var1_1.getSerializedSize(this);
            this.setMemoizedSerializedSize(memoizedSerializedSize);
        }
        return (int)var2_2;
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    /*
     * WARNING - void declaration
     */
    private String getSerializingExceptionMessage(String target) {
        void var1_1;
        return "Serializing " + this.getClass().getName() + " to a " + (String)var1_1 + " threw an IOException (should never happen).";
    }

    protected static void checkByteStringIsUtf8(ByteString byteString) throws IllegalArgumentException {
        if (!byteString.isValidUtf8()) {
            throw new IllegalArgumentException("Byte string is not UTF-8.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
        void var1_1;
        Builder.addAll(values, var1_1);
    }

    public static abstract class Builder<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(CodedInputStream input) throws IOException {
            void var1_1;
            return (BuilderType)this.mergeFrom((CodedInputStream)var1_1, ExtensionRegistryLite.getEmptyRegistry());
        }

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            Object input;
            try {
                input = data.newCodedInput();
                this.mergeFrom((CodedInputStream)input);
                ((CodedInputStream)input).checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Object input;
            try {
                void var2_3;
                input = data.newCodedInput();
                this.mergeFrom((CodedInputStream)input, (ExtensionRegistryLite)var2_3);
                ((CodedInputStream)input).checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException(this.getReadingExceptionMessage("ByteString"), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            void var1_1;
            return (BuilderType)this.mergeFrom(data, 0, ((void)var1_1).length);
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
            Object input;
            try {
                void var3_4;
                void var2_3;
                input = CodedInputStream.newInstance(data, (int)var2_3, (int)var3_4);
                this.mergeFrom((CodedInputStream)input);
                ((CodedInputStream)input).checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException(this.getReadingExceptionMessage("byte array"), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            return (BuilderType)this.mergeFrom(data, 0, ((void)var1_1).length, (ExtensionRegistryLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Object input;
            try {
                void var3_4;
                void var2_3;
                input = CodedInputStream.newInstance(data, (int)var2_3, (int)var3_4);
                this.mergeFrom((CodedInputStream)input, extensionRegistry);
                ((CodedInputStream)input).checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException(this.getReadingExceptionMessage("byte array"), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(InputStream input) throws IOException {
            void var1_1;
            CodedInputStream codedInput = CodedInputStream.newInstance(input);
            this.mergeFrom(codedInput);
            var1_1.checkLastTagWas(0);
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var1_1;
            void var2_2;
            CodedInputStream codedInput = CodedInputStream.newInstance(input);
            this.mergeFrom(codedInput, (ExtensionRegistryLite)var2_2);
            var1_1.checkLastTagWas(0);
            return (BuilderType)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            void var2_2;
            void var1_1;
            void var3_3;
            int firstByte = input.read();
            if (firstByte == -1) {
                return false;
            }
            int size = CodedInputStream.readRawVarint32(firstByte, input);
            LimitedInputStream limitedInput = new LimitedInputStream(input, (int)var3_3);
            this.mergeFrom((InputStream)var1_1, (ExtensionRegistryLite)var2_2);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean mergeDelimitedFrom(InputStream input) throws IOException {
            void var1_1;
            return this.mergeDelimitedFrom((InputStream)var1_1, ExtensionRegistryLite.getEmptyRegistry());
        }

        /*
         * WARNING - void declaration
         */
        public BuilderType mergeFrom(MessageLite other) {
            void var1_1;
            if (!this.getDefaultInstanceForType().getClass().isInstance(other)) {
                throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
            }
            return this.internalMergeFrom((AbstractMessageLite)var1_1);
        }

        protected abstract BuilderType internalMergeFrom(MessageType var1);

        /*
         * WARNING - void declaration
         */
        private String getReadingExceptionMessage(String target) {
            void var1_1;
            return "Reading " + this.getClass().getName() + " from a " + (String)var1_1 + " threw an IOException (should never happen).";
        }

        /*
         * WARNING - void declaration
         */
        private static <T> void addAllCheckingNulls(Iterable<T> values, List<? super T> list) {
            if (list instanceof ArrayList && values instanceof Collection) {
                ((ArrayList)list).ensureCapacity(list.size() + ((Collection)values).size());
            }
            int begin = list.size();
            values = values.iterator();
            while (values.hasNext()) {
                void var3_3;
                Object value = values.next();
                if (value == null) {
                    String string;
                    String message = "Element at index " + (list.size() - begin) + " is null.";
                    for (int i = list.size() - 1; i >= begin; --i) {
                        list.remove(i);
                    }
                    throw new NullPointerException(string);
                }
                list.add(var3_3);
            }
        }

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite message) {
            MessageLite messageLite;
            return new UninitializedMessageException(messageLite);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
            void var1_1;
            Builder.addAll(values, (List)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
            void var1_1;
            String string;
            Internal.checkNotNull(values);
            if (values instanceof LazyStringList) {
                String lazyValues = ((LazyStringList)values).getUnderlyingElements();
                LazyStringList lazyList = (LazyStringList)list;
                int begin = list.size();
                lazyValues = lazyValues.iterator();
                while (lazyValues.hasNext()) {
                    void var3_4;
                    Object value = lazyValues.next();
                    if (value == null) {
                        String message = "Element at index " + (lazyList.size() - begin) + " is null.";
                        for (int i = lazyList.size() - 1; i >= begin; --i) {
                            lazyList.remove(i);
                        }
                        throw new NullPointerException(string);
                    }
                    if (var3_4 instanceof ByteString) {
                        lazyList.add((ByteString)var3_4);
                        continue;
                    }
                    if (var3_4 instanceof byte[]) {
                        lazyList.add(ByteString.copyFrom((byte[])var3_4));
                        continue;
                    }
                    lazyList.add((String)var3_4);
                }
                return;
            }
            if (string instanceof PrimitiveNonBoxingCollection) {
                var1_1.addAll((Collection)((Object)string));
                return;
            }
            Builder.addAllCheckingNulls(string, var1_1);
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            /*
             * WARNING - void declaration
             */
            LimitedInputStream(InputStream in, int limit) {
                super((InputStream)var1_1);
                void var2_2;
                void var1_1;
                this.limit = var2_2;
            }

            @Override
            public final int available() throws IOException {
                return Math.min(super.available(), this.limit);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int read() throws IOException {
                void var1_1;
                if (this.limit <= 0) {
                    return -1;
                }
                int result = super.read();
                if (result >= 0) {
                    --this.limit;
                }
                return (int)var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int read(byte[] b, int off, int len) throws IOException {
                void var1_2;
                void var3_4;
                void var2_3;
                if (this.limit <= 0) {
                    return -1;
                }
                len = Math.min(len, this.limit);
                int result = super.read(b, (int)var2_3, (int)var3_4);
                if (result >= 0) {
                    this.limit -= result;
                }
                return (int)var1_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final long skip(long n) throws IOException {
                void var1_2;
                int result = (int)super.skip(Math.min(n, (long)this.limit));
                if (result >= 0) {
                    this.limit -= result;
                }
                return (long)var1_2;
            }
        }
    }

    protected static interface InternalOneOfEnum {
        public int getNumber();
    }
}

