/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.internal.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J3\u0010\u001e\u001a\u00020\u001d2\n\u0010\u001c\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001f"}, d2={"Landroidx/navigation/internal/UriCodec;", "", "<init>", "()V", "", "c", "", "hexCharToValue", "(C)I", "", "uri", "name", "unexpected", "index", "Landroidx/navigation/internal/URISyntaxException;", "unexpectedCharacterException", "(Ljava/lang/String;Ljava/lang/String;CI)Landroidx/navigation/internal/URISyntaxException;", "end", "getNextCharacter", "(Ljava/lang/String;IILjava/lang/String;)C", "s", "", "convertPlus", "throwOnFailure", "decode", "(Ljava/lang/String;ZZ)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "", "appendDecoded", "(Ljava/lang/StringBuilder;Ljava/lang/String;ZZ)V"})
public final class UriCodec {
    public static final UriCodec INSTANCE = new UriCodec();

    private UriCodec() {
    }

    /*
     * WARNING - void declaration
     */
    private final int hexCharToValue(char c) {
        boolean bl = '0' <= c ? c < ':' : false;
        if (bl) {
            return c - 48;
        }
        boolean bl2 = 'a' <= c ? c < 'g' : false;
        if (bl2) {
            return c + 10 - 97;
        }
        boolean bl3 = 'A' <= c ? c < 'G' : false;
        if (bl3) {
            void var1_1;
            return (int)(var1_1 + 10 - 65);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final URISyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string = name;
        Object nameString = string == null ? "" : " in [" + string + "]";
        return new URISyntaxException((String)var1_1, "Unexpected character" + (String)var2_2 + ": " + (char)var3_3, index);
    }

    /*
     * WARNING - void declaration
     */
    private final char getNextCharacter(String uri, int index, int end, String name) throws URISyntaxException {
        void var2_2;
        void var1_1;
        if (index >= end) {
            void var3_4;
            String string = name;
            Object nameString = string == null ? "" : " in [" + string + "]";
            throw new URISyntaxException(uri, "Unexpected end of string" + (String)var3_4, index);
        }
        return var1_1.charAt((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String decode(String s, boolean convertPlus, boolean throwOnFailure) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder builder = new StringBuilder(s.length());
        this.appendDecoded(builder, (String)var1_1, (boolean)var2_2, (boolean)var3_3);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendDecoded(StringBuilder builder, String s, boolean convertPlus, boolean throwOnFailure) {
        void var1_1;
        int n = 0;
        int n2 = s.length();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = 0;
        }
        byte[] byteBuffer = byArray;
        Ref.IntRef byteBufferPosition = new Ref.IntRef();
        int i = 0;
        block7: while (i < s.length()) {
            char c = s.charAt(i);
            ++i;
            switch (c) {
                case '+': {
                    UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                    builder.append(convertPlus ? (char)' ' : '+');
                    continue block7;
                }
                case '%': {
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            c = this.getNextCharacter(s, i, s.length(), null);
                        }
                        catch (URISyntaxException e) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(e);
                            }
                            UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            return;
                        }
                        ++i;
                        int newDigit = this.hexCharToValue(c);
                        if (newDigit < 0) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(this.unexpectedCharacterException(s, null, c, i - 1));
                            }
                            UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)((hexValue << 4) + newDigit);
                    }
                    UriCodec.appendDecoded$put(byteBuffer, byteBufferPosition, hexValue);
                    continue block7;
                }
            }
            UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
            builder.append(c);
        }
        UriCodec.appendDecoded$flush(byteBufferPosition, (StringBuilder)var1_1, byteBuffer, throwOnFailure);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendDecoded$put(byte[] byteBuffer, Ref.IntRef byteBufferPosition, byte by) {
        void var2_3;
        int n = byteBufferPosition.element;
        var1_2.element = n + 1;
        byteBuffer[n] = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendDecoded$flush(Ref.IntRef byteBufferPosition, StringBuilder $builder, byte[] byteBuffer, boolean $throwOnFailure) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (byteBufferPosition.element == 0) {
            return;
        }
        var1_1.append(StringsKt.decodeToString$default((byte[])var2_2, (int)0, (int)byteBufferPosition.element, (boolean)var3_3, (int)1, null));
        var0.element = 0;
    }
}

