/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.collection.SparseArrayCompat;
import androidx.collection.SparseArrayKt;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavType;
import androidx.navigation.serialization.RouteSerializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u001a\u001a\u00020\u00122\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0016H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ7\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\u001d\u0010$J!\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u001d\u0010&J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0'H\u0000\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010.\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b,\u0010-J\u0017\u00102\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b0\u00101J!\u00102\u001a\u00020\u0012\"\b\b\u0000\u00103*\u00020\u00012\u0006\u0010/\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b0\u00104J7\u00102\u001a\u00020\u0012\"\u0004\b\u0000\u001032\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u0000052\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000607H\u0000\u00a2\u0006\u0004\b0\u00109R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010:R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0;8@X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010<\u001a\u0004\b=\u0010>R\u001c\u0010?\u001a\u00020\u001b8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u001e\u0010C\u001a\u0004\u0018\u00010\u00068\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u0016\u0010H\u001a\u00020\u001b8@@@X\u0080\f\u00a2\u0006\u0006\u001a\u0004\bG\u0010BR.\u0010I\u001a\u0004\u0018\u00010\u00062\b\u0010/\u001a\u0004\u0018\u00010\u00068\u0000@@X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010D\u001a\u0004\bJ\u0010F\"\u0004\bK\u00101R\u0014\u0010M\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010F"}, d2={"Landroidx/navigation/internal/NavGraphImpl;", "", "Landroidx/navigation/NavGraph;", "graph", "<init>", "(Landroidx/navigation/NavGraph;)V", "", "route", "", "searchChildren", "searchParent", "Landroidx/navigation/NavDestination;", "lastVisited", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "matchRouteComprehensive$navigation_common", "(Ljava/lang/String;ZZLandroidx/navigation/NavDestination;)Landroidx/navigation/NavDestination$DeepLinkMatch;", "matchRouteComprehensive", "node", "", "addDestination$navigation_common", "(Landroidx/navigation/NavDestination;)V", "addDestination", "", "nodes", "addDestinations$navigation_common", "(Ljava/util/Collection;)V", "addDestinations", "", "resId", "findNode$navigation_common", "(I)Landroidx/navigation/NavDestination;", "findNode", "matchingDest", "findNodeComprehensive$navigation_common", "(ILandroidx/navigation/NavDestination;ZLandroidx/navigation/NavDestination;)Landroidx/navigation/NavDestination;", "findNodeComprehensive", "(Ljava/lang/String;)Landroidx/navigation/NavDestination;", "searchParents", "(Ljava/lang/String;Z)Landroidx/navigation/NavDestination;", "", "iterator$navigation_common", "()Ljava/util/Iterator;", "iterator", "superName", "getDisplayName$navigation_common", "(Ljava/lang/String;)Ljava/lang/String;", "getDisplayName", "startDestRoute", "setStartDestination$navigation_common", "(Ljava/lang/String;)V", "setStartDestination", "T", "(Ljava/lang/Object;)V", "Lkotlinx/serialization/KSerializer;", "serializer", "Lkotlin/Function1;", "parseRoute", "(Lkotlinx/serialization/KSerializer;Lkotlin/jvm/functions/Function1;)V", "Landroidx/navigation/NavGraph;", "Landroidx/collection/SparseArrayCompat;", "Landroidx/collection/SparseArrayCompat;", "getNodes$navigation_common", "()Landroidx/collection/SparseArrayCompat;", "startDestId", "I", "getStartDestId$navigation_common", "()I", "startDestIdName", "Ljava/lang/String;", "getStartDestIdName$navigation_common", "()Ljava/lang/String;", "getStartDestinationId$navigation_common", "startDestinationId", "startDestinationRoute", "getStartDestinationRoute$navigation_common", "setStartDestinationRoute$navigation_common", "getStartDestDisplayName$navigation_common", "startDestDisplayName"})
@SourceDebugExtension(value={"SMAP\nNavGraphImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphImpl.kt\nandroidx/navigation/internal/NavGraphImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,372:1\n1617#2,9:373\n1869#2:382\n1870#2:384\n1626#2:385\n1617#2,9:386\n1869#2:395\n1870#2:397\n1626#2:398\n1252#2,4:404\n1#3:383\n1#3:396\n1#3:399\n183#4,2:400\n465#5:402\n415#5:403\n*S KotlinDebug\n*F\n+ 1 NavGraphImpl.kt\nandroidx/navigation/internal/NavGraphImpl\n*L\n55#1:373,9\n55#1:382\n55#1:384\n55#1:385\n94#1:386,9\n94#1:395\n94#1:397\n94#1:398\n322#1:404,4\n55#1:383\n94#1:396\n221#1:400,2\n322#1:402\n322#1:403\n*E\n"})
public final class NavGraphImpl {
    public final NavGraph graph;
    private final SparseArrayCompat<NavDestination> nodes;
    private int startDestId;
    private String startDestIdName;
    private String startDestinationRoute;

    /*
     * WARNING - void declaration
     */
    public NavGraphImpl(NavGraph graph) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = var1_1;
        this.nodes = new SparseArrayCompat(0, 1, null);
    }

    public final SparseArrayCompat<NavDestination> getNodes$navigation_common() {
        return this.nodes;
    }

    public final int getStartDestId$navigation_common() {
        return this.startDestId;
    }

    public final String getStartDestIdName$navigation_common() {
        return this.startDestIdName;
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination.DeepLinkMatch matchRouteComprehensive$navigation_common(String route, boolean searchChildren, boolean searchParent, NavDestination lastVisited) {
        NavDestination.DeepLinkMatch deepLinkMatch;
        Object[] objectArray;
        NavDestination.DeepLinkMatch deepLinkMatch2;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)lastVisited, (String)"lastVisited");
        NavDestination.DeepLinkMatch bestMatch = this.graph.matchRoute(route);
        if (searchChildren) {
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.graph;
            Collection destination$iv$iv = new ArrayList();
            $this$mapNotNullTo$iv$iv = $this$mapNotNullTo$iv$iv.iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                NavDestination.DeepLinkMatch it$iv$iv;
                NavDestination child;
                Object t = $this$mapNotNullTo$iv$iv.next();
                Object t2 = t;
                t2 = t;
                NavDestination navDestination = child = (NavDestination)t;
                if ((Intrinsics.areEqual((Object)child, (Object)lastVisited) ? null : (navDestination instanceof NavGraph ? ((NavGraph)child).matchRouteComprehensive(route, true, false, this.graph) : child.matchRoute(route))) == null) continue;
                it$iv$iv = it$iv$iv;
                destination$iv$iv.add(it$iv$iv);
            }
            deepLinkMatch2 = (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        } else {
            deepLinkMatch2 = null;
        }
        NavDestination.DeepLinkMatch bestChildMatch = deepLinkMatch2;
        NavGraph navGraph = this.graph.getParent();
        if (navGraph != null) {
            void var2_2;
            void var3_3;
            NavGraph it = navGraph;
            deepLinkMatch = var3_3 != false && !Intrinsics.areEqual((Object)it, (Object)lastVisited) ? it.matchRouteComprehensive((String)objectArray, (boolean)var2_2, true, this.graph) : null;
        } else {
            deepLinkMatch = null;
        }
        NavDestination.DeepLinkMatch bestParentMatch = deepLinkMatch;
        Object[] objectArray2 = new NavDestination.DeepLinkMatch[3];
        objectArray = objectArray2;
        objectArray2[0] = bestMatch;
        objectArray[1] = bestChildMatch;
        objectArray[2] = bestParentMatch;
        return (NavDestination.DeepLinkMatch)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public final void addDestination$navigation_common(NavDestination node) {
        void var1_1;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int id = ((NavDestination)node).getId();
        String innerRoute = ((NavDestination)node).getRoute();
        if (!(id != 0 || innerRoute != null)) {
            node = "Destinations must have an id or route. Call setId(), setRoute(), or include an android:id or app:route in your navigation XML.";
            throw new IllegalArgumentException(node.toString());
        }
        if (this.graph.getRoute() != null && !(!Intrinsics.areEqual((Object)var3_4, (Object)this.graph.getRoute()))) {
            node = "Destination " + (NavDestination)node + " cannot have the same route as graph " + this.graph;
            throw new IllegalArgumentException(node.toString());
        }
        if (!(id != this.graph.getId())) {
            node = "Destination " + (NavDestination)node + " cannot have the same id as graph " + this.graph;
            throw new IllegalArgumentException(node.toString());
        }
        NavDestination existingDestination = (NavDestination)this.nodes.get(id);
        if (existingDestination == node) {
            return;
        }
        if (!(((NavDestination)node).getParent() == null)) {
            node = "Destination already has a parent set. Call NavGraph.remove() to remove the previous parent.";
            throw new IllegalStateException(node.toString());
        }
        if (existingDestination != null) {
            void var2_3;
            var2_3.setParent(null);
        }
        ((NavDestination)node).setParent(this.graph);
        this.nodes.put(((NavDestination)node).getId(), (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addDestinations$navigation_common(Collection<? extends NavDestination> nodes) {
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            NavDestination node = (NavDestination)iterator2.next();
            if (node == null) continue;
            this.addDestination$navigation_common((NavDestination)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination findNode$navigation_common(int resId) {
        void var1_1;
        return NavGraphImpl.findNodeComprehensive$navigation_common$default(this, (int)var1_1, this.graph, false, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination findNodeComprehensive$navigation_common(int resId, NavDestination lastVisited, boolean searchChildren, NavDestination matchingDest) {
        NavDestination navDestination;
        Object destination;
        block8: {
            destination = (NavDestination)this.nodes.get(resId);
            if (matchingDest != null) {
                if (Intrinsics.areEqual((Object)destination, (Object)matchingDest) && Intrinsics.areEqual((Object)((NavDestination)destination).getParent(), (Object)matchingDest.getParent())) {
                    return destination;
                }
                destination = null;
            } else if (destination != null) {
                return destination;
            }
            if (searchChildren) {
                Object object;
                destination = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.nodes)).iterator();
                while (destination.hasNext()) {
                    NavDestination child = (NavDestination)destination.next();
                    NavDestination navDestination2 = child instanceof NavGraph && !Intrinsics.areEqual((Object)child, (Object)lastVisited) ? ((NavGraph)child).findNodeComprehensive(resId, this.graph, true, matchingDest) : null;
                    if (navDestination2 == null) continue;
                    object = navDestination2;
                    break block8;
                }
                object = destination = null;
            }
        }
        if ((navDestination = destination) == null) {
            void var2_2;
            if (this.graph.getParent() != null && !Intrinsics.areEqual((Object)this.graph.getParent(), (Object)var2_2)) {
                void var3_3;
                void var1_1;
                NavGraph navGraph = this.graph.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                return navGraph.findNodeComprehensive((int)var1_1, this.graph, (boolean)var3_3, matchingDest);
            }
            navDestination = null;
        }
        return navDestination;
    }

    public static /* synthetic */ NavDestination findNodeComprehensive$navigation_common$default(NavGraphImpl navGraphImpl, int n, NavDestination navDestination, boolean bl, NavDestination navDestination2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            navDestination2 = null;
        }
        return navGraphImpl.findNodeComprehensive$navigation_common(n, navDestination, bl, navDestination2);
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination findNode$navigation_common(String route) {
        CharSequence charSequence = route;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            void var1_1;
            return this.findNode$navigation_common((String)var1_1, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination findNode$navigation_common(String route, boolean searchParents) {
        Object v0;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            object = SequencesKt.asSequence((Iterator)SparseArrayKt.valueIterator(this.nodes));
            object = object.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                NavDestination it = (NavDestination)element$iv;
                if (!(StringsKt.equals$default((String)it.getRoute(), (String)route, (boolean)false, (int)2, null) || it.matchRoute(route) != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        object = v0;
        NavDestination navDestination = object;
        if (object == null) {
            void var2_2;
            if (var2_2 != false && this.graph.getParent() != null) {
                void var1_1;
                NavGraph navGraph = this.graph.getParent();
                Intrinsics.checkNotNull((Object)navGraph);
                return navGraph.findNode((String)var1_1);
            }
            navDestination = null;
        }
        return navDestination;
    }

    public final Iterator<NavDestination> iterator$navigation_common() {
        return new Iterator<NavDestination>(this){
            private int index;
            private boolean wentToNext;
            final /* synthetic */ NavGraphImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.index = -1;
            }

            public final boolean hasNext() {
                return this.index + 1 < this.this$0.getNodes$navigation_common().size();
            }

            public final NavDestination next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.wentToNext = true;
                ++this.index;
                return (NavDestination)this.this$0.getNodes$navigation_common().valueAt(this.index);
            }

            /*
             * WARNING - void declaration
             */
            public final void remove() {
                void var1_2;
                if (!this.wentToNext) {
                    String string = "You must call next() before you can remove an element";
                    throw new IllegalStateException(string.toString());
                }
                SparseArrayCompat<NavDestination> $this$remove_u24lambda_u241 = this.this$0.getNodes$navigation_common();
                ((NavDestination)$this$remove_u24lambda_u241.valueAt(this.index)).setParent(null);
                var1_2.removeAt(this.index);
                int n = this.index;
                this.index = n + -1;
                this.wentToNext = false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final String getDisplayName$navigation_common(String superName) {
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        if (this.graph.getId() != 0) {
            void var1_1;
            return var1_1;
        }
        return "the root navigation";
    }

    public final int getStartDestinationId$navigation_common() {
        return this.startDestId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStartDestination$navigation_common(String startDestRoute) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)startDestRoute, (String)"startDestRoute");
        this.setStartDestinationRoute$navigation_common((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void setStartDestination$navigation_common(T startDestRoute) {
        void var1_1;
        Intrinsics.checkNotNullParameter(startDestRoute, (String)"startDestRoute");
        this.setStartDestination$navigation_common(SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(startDestRoute.getClass())), (Function1<? super NavDestination, String>)((Function1)arg_0 -> NavGraphImpl.setStartDestination$lambda$14(var1_1, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void setStartDestination$navigation_common(KSerializer<T> serializer, Function1<? super NavDestination, String> parseRoute) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(parseRoute, (String)"parseRoute");
        int id = RouteSerializerKt.generateHashCode(serializer);
        NavDestination startDest = this.findNode$navigation_common(id);
        if (startDest == null) {
            String string;
            string = "Cannot find startDestination " + string.getDescriptor().getSerialName() + " from NavGraph. Ensure the starting NavDestination was added with route from KClass.";
            throw new IllegalStateException(string.toString());
        }
        this.setStartDestinationRoute$navigation_common((String)var2_2.invoke((Object)startDest));
        this.startDestId = var3_3;
    }

    public final String getStartDestinationRoute$navigation_common() {
        return this.startDestinationRoute;
    }

    /*
     * WARNING - void declaration
     */
    public final void setStartDestinationRoute$navigation_common(String startDestRoute) {
        void var1_1;
        int n;
        NavGraphImpl navGraphImpl = this;
        if (startDestRoute == null) {
            n = 0;
        } else {
            if (!(!Intrinsics.areEqual((Object)startDestRoute, (Object)this.graph.getRoute()))) {
                startDestRoute = "Start destination " + (String)startDestRoute + " cannot use the same route as the graph " + this.graph;
                throw new IllegalArgumentException(startDestRoute.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)startDestRoute)))) {
                startDestRoute = "Cannot have an empty start destination route";
                throw new IllegalArgumentException(startDestRoute.toString());
            }
            String string = NavDestination.Companion.createRoute((String)startDestRoute);
            n = string.hashCode();
        }
        navGraphImpl.startDestId = n;
        this.startDestinationRoute = var1_1;
    }

    public final String getStartDestDisplayName$navigation_common() {
        if (this.startDestIdName == null) {
            String string = this.startDestinationRoute;
            if (string == null) {
                string = String.valueOf(this.startDestId);
            }
            this.startDestIdName = string;
        }
        String string = this.startDestIdName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String setStartDestination$lambda$14(Object $startDestRoute, NavDestination startDestination) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter((Object)startDestination, (String)"startDestination");
        Map<String, NavArgument> $this$mapValues$iv = startDestination.getArguments();
        Iterator iterator2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        iterator2 = iterator2.entrySet();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            NavType<Object> navType;
            void it$iv$iv;
            Object element$iv$iv$iv = iterator2.next();
            Object object2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            element$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            map = it$iv$iv.getKey();
            object2 = map;
            navType = ((NavArgument)navType.getValue()).getType();
            object2.put(map, navType);
        }
        return RouteSerializerKt.generateRouteWithArgs(object, (Map<String, ? extends NavType<Object>>)var1_1);
    }
}

