/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.NavArgument;
import androidx.navigation.NavArgumentKt;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDestination;
import androidx.navigation.NavUri;
import androidx.navigation.NavUriKt;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010!\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0004\b\u001f\u0010 R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u001e\u0010#\u001a\u0004\u0018\u00010\f8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R \u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060'8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R(\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00190,8\u0000@\u0000X\u0080\f\u00a2\u0006\f\n\u0004\b\u0013\u0010-\u001a\u0004\b.\u0010/R*\u00101\u001a\u0002002\u0006\u00101\u001a\u0002008\u0000@@X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R.\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f8\u0000@@X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010$\u001a\u0004\b7\u0010&\"\u0004\b8\u00109R\u001e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<"}, d2={"Landroidx/navigation/internal/NavDestinationImpl;", "", "Landroidx/navigation/NavDestination;", "destination", "<init>", "(Landroidx/navigation/NavDestination;)V", "Landroidx/navigation/NavDeepLink;", "navDeepLink", "", "addDeepLink$navigation_common", "(Landroidx/navigation/NavDeepLink;)V", "addDeepLink", "", "route", "Landroidx/navigation/NavDestination$DeepLinkMatch;", "matchRoute$navigation_common", "(Ljava/lang/String;)Landroidx/navigation/NavDestination$DeepLinkMatch;", "matchRoute", "Landroidx/savedstate/SavedState;", "arguments", "", "hasRoute$navigation_common", "(Ljava/lang/String;Landroidx/savedstate/SavedState;)Z", "hasRoute", "argumentName", "Landroidx/navigation/NavArgument;", "argument", "addArgument$navigation_common", "(Ljava/lang/String;Landroidx/navigation/NavArgument;)V", "addArgument", "args", "addInDefaultArgs$navigation_common", "(Landroidx/savedstate/SavedState;)Landroidx/savedstate/SavedState;", "addInDefaultArgs", "Landroidx/navigation/NavDestination;", "idName", "Ljava/lang/String;", "getIdName$navigation_common", "()Ljava/lang/String;", "", "deepLinks", "Ljava/util/List;", "getDeepLinks$navigation_common", "()Ljava/util/List;", "", "Ljava/util/Map;", "getArguments$navigation_common", "()Ljava/util/Map;", "", "id", "I", "getId$navigation_common", "()I", "setId$navigation_common", "(I)V", "getRoute$navigation_common", "setRoute$navigation_common", "(Ljava/lang/String;)V", "Lkotlin/Lazy;", "routeDeepLink", "Lkotlin/Lazy;"})
@SourceDebugExtension(value={"SMAP\nNavDestinationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDestinationImpl.kt\nandroidx/navigation/internal/NavDestinationImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 4 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 5 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt$savedState$1\n*L\n1#1,213:1\n1#2:214\n1#2:219\n30#3:215\n45#3:216\n34#3,2:217\n106#4:220\n106#4:222\n90#4:223\n45#5:221\n*S KotlinDebug\n*F\n+ 1 NavDestinationImpl.kt\nandroidx/navigation/internal/NavDestinationImpl\n*L\n193#1:219\n193#1:215\n193#1:216\n193#1:217,2\n193#1:220\n198#1:222\n161#1:223\n193#1:221\n*E\n"})
public final class NavDestinationImpl {
    public final NavDestination destination;
    private String idName;
    private final List<NavDeepLink> deepLinks;
    private Map<String, NavArgument> arguments;
    private int id;
    private String route;
    private Lazy<NavDeepLink> routeDeepLink;

    /*
     * WARNING - void declaration
     */
    public NavDestinationImpl(NavDestination destination) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.destination = var1_1;
        this.deepLinks = new ArrayList();
        this.arguments = new LinkedHashMap();
    }

    public final String getIdName$navigation_common() {
        return this.idName;
    }

    public final List<NavDeepLink> getDeepLinks$navigation_common() {
        return this.deepLinks;
    }

    public final Map<String, NavArgument> getArguments$navigation_common() {
        return this.arguments;
    }

    public final int getId$navigation_common() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public final void setId$navigation_common(int id) {
        void var1_1;
        this.id = var1_1;
        this.idName = null;
    }

    public final String getRoute$navigation_common() {
        return this.route;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRoute$navigation_common(String route) {
        void var1_1;
        if (route == null) {
            this.setId$navigation_common(0);
        } else {
            void var2_4;
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)route)))) {
                String string = "Cannot have an empty route";
                throw new IllegalArgumentException(string.toString());
            }
            String tempRoute = NavDestination.Companion.createRoute((String)route);
            NavDeepLink tempDeepLink = new NavDeepLink.Builder().setUriPattern(tempRoute).build();
            List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(this.arguments, (Function1<? super String, Boolean>)((Function1)arg_0 -> NavDestinationImpl._set_route_$lambda$1(tempDeepLink, arg_0)));
            if (!missingRequiredArguments.isEmpty()) {
                void var3_3;
                route = "Cannot set route \"" + (String)route + "\" for destination " + this.destination + ". Following required arguments are missing: " + (List)var3_3;
                throw new IllegalArgumentException(route.toString());
            }
            this.routeDeepLink = LazyKt.lazy(() -> NavDestinationImpl._set_route_$lambda$3(tempRoute));
            this.setId$navigation_common(var2_4.hashCode());
        }
        this.route = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addDeepLink$navigation_common(NavDeepLink navDeepLink) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)navDeepLink, (String)"navDeepLink");
        List<String> missingRequiredArguments = NavArgumentKt.missingRequiredArguments(this.arguments, (Function1<? super String, Boolean>)((Function1)arg_0 -> NavDestinationImpl.addDeepLink$lambda$4((NavDeepLink)navDeepLink, arg_0)));
        if (!missingRequiredArguments.isEmpty()) {
            void var2_2;
            navDeepLink = "Deep link " + ((NavDeepLink)navDeepLink).getUriPattern() + " can't be used to open destination " + this.destination + ".\nFollowing required arguments are missing: " + (List)var2_2;
            throw new IllegalArgumentException(navDeepLink.toString());
        }
        this.deepLinks.add((NavDeepLink)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final NavDestination.DeepLinkMatch matchRoute$navigation_common(String route) {
        void var1_2;
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Object object = this.routeDeepLink;
        if (object == null || (object = (NavDeepLink)object.getValue()) == null) {
            return null;
        }
        Object routeDeepLink = object;
        NavUri uri = NavUriKt.NavUri(NavDestination.Companion.createRoute(route));
        SavedState savedState = ((NavDeepLink)routeDeepLink).getMatchingArguments(uri, this.arguments);
        if (savedState == null) {
            return null;
        }
        SavedState matchingArguments = savedState;
        int matchingPathSegments = ((NavDeepLink)routeDeepLink).calculateMatchingPathSegments$navigation_common(uri);
        return new NavDestination.DeepLinkMatch(this.destination, (SavedState)var3_4, var2_3.isExactDeepLink(), (int)var1_2, false, -1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasRoute$navigation_common(String route, SavedState arguments) {
        void var2_2;
        void var1_1;
        NavDestination.DeepLinkMatch matchingDeepLink;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        if (Intrinsics.areEqual((Object)this.route, (Object)route)) {
            return true;
        }
        NavDestination.DeepLinkMatch deepLinkMatch = matchingDeepLink = this.matchRoute$navigation_common(route);
        if (!Intrinsics.areEqual((Object)this.destination, (Object)(deepLinkMatch != null ? deepLinkMatch.getDestination() : null))) {
            return false;
        }
        return var1_1.hasMatchingArgs((SavedState)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addArgument$navigation_common(String argumentName, NavArgument argument) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        this.arguments.put((String)var1_1, (NavArgument)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final SavedState addInDefaultArgs$navigation_common(SavedState args) {
        void defaultArgs;
        String key;
        if (args == null && this.arguments.isEmpty()) {
            return null;
        }
        Object object = MapsKt.emptyMap();
        Map.Entry<String, NavArgument> copiedState$iv2 = MapsKt.toMutableMap((Map)object);
        SavedState savedState = new SavedState((Map)((Object)copiedState$iv2));
        object = savedState;
        object = savedState;
        SavedStateWriter.constructor-impl((SavedState)savedState);
        for (Map.Entry<String, NavArgument> copiedState$iv2 : this.arguments.entrySet()) {
            key = (String)copiedState$iv2.getKey();
            copiedState$iv2 = (NavArgument)copiedState$iv2.getValue();
            ((NavArgument)((Object)copiedState$iv2)).putDefaultValue(key, (SavedState)defaultArgs);
        }
        if (args != null) {
            void var1_1;
            object = defaultArgs;
            key = SavedStateWriter.constructor-impl((SavedState)object);
            SavedStateWriter.putAll-impl((SavedState)key, (SavedState)var1_1);
            object = this.arguments.entrySet().iterator();
            while (object.hasNext()) {
                copiedState$iv2 = object.next();
                key = copiedState$iv2.getKey();
                NavArgument value = copiedState$iv2.getValue();
                if (value.isDefaultValueUnknown$navigation_common() || value.verify(key, (SavedState)defaultArgs)) continue;
                object = "Wrong argument type for '" + key + "' in argument savedState. " + value.getType().getName() + " expected.";
                throw new IllegalArgumentException(object.toString());
            }
        }
        return savedState;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean _set_route_$lambda$1(NavDeepLink $tempDeepLink, String key) {
        void var1_1;
        NavDeepLink navDeepLink;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return !navDeepLink.getArgumentsNames$navigation_common().contains(var1_1);
    }

    private static final NavDeepLink _set_route_$lambda$3(String $tempRoute) {
        String string;
        return new NavDeepLink.Builder().setUriPattern(string).build();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean addDeepLink$lambda$4(NavDeepLink $navDeepLink, String key) {
        void var1_1;
        NavDeepLink navDeepLink;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return !navDeepLink.getArgumentsNames$navigation_common().contains(var1_1);
    }
}

