/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.internal.UriCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Landroidx/navigation/internal/InternalUri;", "", "<init>", "()V", "", "s", "allow", "encode", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "decode", "(Ljava/lang/String;)Ljava/lang/String;", "", "c", "", "isAllowed", "(CLjava/lang/String;)Z", "uriString", "", "ssi", "parsePath", "(Ljava/lang/String;I)Ljava/lang/String;", "", "HEX_DIGITS", "[C"})
public final class InternalUri {
    public static final InternalUri INSTANCE = new InternalUri();
    private static final char[] HEX_DIGITS;

    private InternalUri() {
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(String s, String allow) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder encoded = null;
        int oldLength = s.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                if (current == 0) {
                    return s;
                }
                StringBuilder stringBuilder = encoded;
                Intrinsics.checkNotNull(stringBuilder);
                stringBuilder.append(s, current, oldLength);
                String string = encoded.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            byte[] bytes = StringsKt.encodeToByteArray$default((String)s, (int)current, (int)nextAllowed, (boolean)false, (int)4, null);
            int bytesLength = bytes.length;
            for (int i = 0; i < bytesLength; ++i) {
                encoded.append('%');
                encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
            }
            int n = nextAllowed;
        }
        String string = var3_3;
        if (string == null || (string = ((StringBuilder)((Object)string)).toString()) == null) {
            void var1_1;
            string = var1_1;
        }
        return string;
    }

    public static /* synthetic */ String encode$default(InternalUri internalUri, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return internalUri.encode(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final String decode(String s) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return UriCodec.INSTANCE.decode((String)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAllowed(char c, String allow) {
        block4: {
            block3: {
                void var1_1;
                void var2_2;
                if ('A' <= c ? c < '[' : false) break block3;
                if ('a' <= c ? c < '{' : false) break block3;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl && StringsKt.indexOf$default((CharSequence)"_-!.~'()*", (char)c, (int)0, (boolean)false, (int)6, null) == -1 && (allow == null || StringsKt.indexOf$default((CharSequence)((CharSequence)var2_2), (char)var1_1, (int)0, (boolean)false, (int)6, null) == -1)) break block4;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String parsePath(String uriString, int ssi) {
        void var2_2;
        void var1_1;
        void pathEnd;
        int length;
        block11: {
            int pathStart;
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            length = uriString.length();
            if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                pathStart = ssi + 3;
                while (pathStart < length) {
                    switch (uriString.charAt(pathStart)) {
                        case '#': 
                        case '?': {
                            return "";
                        }
                        case '/': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            ++pathStart;
                            break;
                        }
                    }
                }
            } else {
                ++pathStart;
            }
        }
        block8: for (pathEnd = pathStart; pathEnd < length; ++pathEnd) {
            switch (uriString.charAt((int)pathEnd)) {
                case '#': 
                case '?': {
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        String string = var1_1.substring((int)var2_2, (int)pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_DIGITS = cArray;
    }
}

