/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.NavOptionsBuilder;
import androidx.navigation.NavOptionsBuilderKt;
import androidx.navigation.NavigatorState;
import androidx.savedstate.SavedState;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\b'\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u00015B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ1\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ7\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00028\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u001fJ\u001f\u0010#\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010#\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010%J\u0011\u0010&\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b(\u0010)R\u0016\u0010*\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010\u0007\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0018\u0010.\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u0010\n\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R$\u00103\u001a\u00020!2\u0006\u00102\u001a\u00020!8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b3\u0010%"}, d2={"Landroidx/navigation/Navigator;", "Landroidx/navigation/NavDestination;", "D", "", "<init>", "()V", "", "name", "(Ljava/lang/String;)V", "Landroidx/navigation/NavigatorState;", "state", "", "onAttach", "(Landroidx/navigation/NavigatorState;)V", "createDestination", "()Landroidx/navigation/NavDestination;", "", "Landroidx/navigation/NavBackStackEntry;", "entries", "Landroidx/navigation/NavOptions;", "navOptions", "Landroidx/navigation/Navigator$Extras;", "navigatorExtras", "navigate", "(Ljava/util/List;Landroidx/navigation/NavOptions;Landroidx/navigation/Navigator$Extras;)V", "backStackEntry", "onLaunchSingleTop", "(Landroidx/navigation/NavBackStackEntry;)V", "destination", "Landroidx/savedstate/SavedState;", "args", "(Landroidx/navigation/NavDestination;Landroidx/savedstate/SavedState;Landroidx/navigation/NavOptions;Landroidx/navigation/Navigator$Extras;)Landroidx/navigation/NavDestination;", "popUpTo", "", "savedState", "popBackStack", "(Landroidx/navigation/NavBackStackEntry;Z)V", "()Z", "onSaveState", "()Landroidx/savedstate/SavedState;", "onRestoreState", "(Landroidx/savedstate/SavedState;)V", "_name", "Ljava/lang/String;", "getName$navigation_common", "()Ljava/lang/String;", "_state", "Landroidx/navigation/NavigatorState;", "getState", "()Landroidx/navigation/NavigatorState;", "value", "isAttached", "Z", "Extras"})
@SourceDebugExtension(value={"SMAP\nNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Navigator.kt\nandroidx/navigation/Navigator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,260:1\n1321#2,2:261\n*S KotlinDebug\n*F\n+ 1 Navigator.kt\nandroidx/navigation/Navigator\n*L\n154#1:261,2\n*E\n"})
public abstract class Navigator<D extends NavDestination> {
    private final String _name;
    private NavigatorState _state;
    private boolean isAttached;

    public Navigator() {
        this._name = null;
    }

    /*
     * WARNING - void declaration
     */
    public Navigator(String name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this._name = var1_1;
    }

    public final String getName$navigation_common() {
        String string = this._name;
        if (string == null) {
            String string2 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string2);
            string = StringsKt.removeSuffix((String)string2, (CharSequence)"Navigator");
        }
        return string;
    }

    protected final NavigatorState getState() {
        NavigatorState navigatorState = this._state;
        if (navigatorState == null) {
            String string = "You cannot access the Navigator's state until the Navigator is attached";
            throw new IllegalStateException(string.toString());
        }
        return navigatorState;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    /*
     * WARNING - void declaration
     */
    public void onAttach(NavigatorState state) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state = var1_1;
        this.isAttached = true;
    }

    public abstract D createDestination();

    /*
     * WARNING - void declaration
     */
    public void navigate(List<NavBackStackEntry> entries, NavOptions navOptions, Extras navigatorExtras) {
        void var3_3;
        Object object;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        object = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), arg_0 -> Navigator.navigate$lambda$1(this, navOptions, (Extras)var3_3, arg_0)));
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            navOptions = object.next();
            NavBackStackEntry backStackEntry = (NavBackStackEntry)((Object)navOptions);
            this.getState().push((NavBackStackEntry)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onLaunchSingleTop(NavBackStackEntry backStackEntry) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavDestination navDestination = backStackEntry.getDestination();
        NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
        if (navDestination2 == null) {
            return;
        }
        NavDestination destination = navDestination2;
        this.navigate(navDestination, null, NavOptionsBuilderKt.navOptions((Function1<? super NavOptionsBuilder, Unit>)((Function1)Navigator::onLaunchSingleTop$lambda$3)), null);
        this.getState().onLaunchSingleTop((NavBackStackEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public NavDestination navigate(D destination, SavedState args, NavOptions navOptions, Extras navigatorExtras) {
        void var1_1;
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void popBackStack(NavBackStackEntry popUpTo, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        List backStack = (List)this.getState().getBackStack().getValue();
        if (!backStack.contains(popUpTo)) {
            String string = "popBackStack was called with " + popUpTo + " which does not exist in back stack " + backStack;
            throw new IllegalStateException(string.toString());
        }
        List list = backStack;
        ListIterator iterator2 = list.listIterator(list.size());
        NavBackStackEntry lastPoppedEntry = null;
        while (this.popBackStack() && !Intrinsics.areEqual((Object)(lastPoppedEntry = (NavBackStackEntry)iterator2.previous()), (Object)popUpTo)) {
        }
        if (lastPoppedEntry != null) {
            void var2_2;
            this.getState().pop(lastPoppedEntry, (boolean)var2_2);
        }
    }

    public boolean popBackStack() {
        return true;
    }

    public SavedState onSaveState() {
        return null;
    }

    public void onRestoreState(SavedState savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
    }

    /*
     * WARNING - void declaration
     */
    private static final NavBackStackEntry navigate$lambda$1(Navigator this$0, NavOptions $navOptions, Extras $navigatorExtras, NavBackStackEntry backStackEntry) {
        void var3_3;
        Navigator navigator;
        void var1_1;
        void var2_2;
        NavDestination navigatedToDestination;
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavDestination navDestination = backStackEntry.getDestination();
        NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
        if (navDestination2 == null) {
            return null;
        }
        NavDestination destination = navDestination2;
        navDestination = navigatedToDestination = this$0.navigate(destination, backStackEntry.getArguments(), $navOptions, (Extras)var2_2);
        if (navigatedToDestination == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)navDestination, (Object)destination)) {
            return backStackEntry;
        }
        void v1 = var1_1;
        return navigator.getState().createBackStackEntry((NavDestination)v1, v1.addInDefaultArgs(var3_3.getArguments()));
    }

    private static final Unit onLaunchSingleTop$lambda$3(NavOptionsBuilder $this$navOptions) {
        NavOptionsBuilder navOptionsBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$navOptions, (String)"$this$navOptions");
        navOptionsBuilder.setLaunchSingleTop(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Landroidx/navigation/Navigator$Extras;", ""})
    public static interface Extras {
    }
}

