/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavType;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\u0001%B;\b\u0000\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001f\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b\u0005\u0010 R\u0017\u0010!\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001f\u001a\u0004\b!\u0010 R\u001a\u0010\"\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010 R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00018\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010$"}, d2={"Landroidx/navigation/NavArgument;", "", "Landroidx/navigation/NavType;", "type", "", "isNullable", "defaultValue", "defaultValuePresent", "unknownDefaultValuePresent", "<init>", "(Landroidx/navigation/NavType;ZLjava/lang/Object;ZZ)V", "", "name", "Landroidx/savedstate/SavedState;", "bundle", "", "putDefaultValue", "(Ljava/lang/String;Landroidx/savedstate/SavedState;)V", "verify", "(Ljava/lang/String;Landroidx/savedstate/SavedState;)Z", "toString", "()Ljava/lang/String;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Landroidx/navigation/NavType;", "getType", "()Landroidx/navigation/NavType;", "Z", "()Z", "isDefaultValuePresent", "isDefaultValueUnknown", "isDefaultValueUnknown$navigation_common", "Ljava/lang/Object;", "Builder"})
@SourceDebugExtension(value={"SMAP\nNavArgument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavArgument.kt\nandroidx/navigation/NavArgument\n+ 2 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n*L\n1#1,239:1\n90#2:240\n*S KotlinDebug\n*F\n+ 1 NavArgument.kt\nandroidx/navigation/NavArgument\n*L\n86#1:240\n*E\n"})
public final class NavArgument {
    private final NavType<Object> type;
    private final boolean isNullable;
    private final boolean isDefaultValuePresent;
    private final boolean isDefaultValueUnknown;
    public final Object defaultValue;

    /*
     * WARNING - void declaration
     */
    public NavArgument(NavType<Object> type, boolean isNullable, Object defaultValue, boolean defaultValuePresent, boolean unknownDefaultValuePresent) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!(((NavType)type).isNullableAllowed() || !isNullable)) {
            type = ((NavType)type).getName() + " does not allow nullable values";
            throw new IllegalArgumentException(type.toString());
        }
        if (!(isNullable || !defaultValuePresent || defaultValue != null)) {
            type = "Argument with type " + ((NavType)type).getName() + " has null value but is not nullable.";
            throw new IllegalArgumentException(type.toString());
        }
        this.type = var1_1;
        this.isNullable = var2_2;
        this.defaultValue = var3_3;
        this.isDefaultValuePresent = defaultValuePresent || unknownDefaultValuePresent;
        this.isDefaultValueUnknown = unknownDefaultValuePresent;
    }

    public final NavType<Object> getType() {
        return this.type;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public final boolean isDefaultValuePresent() {
        return this.isDefaultValuePresent;
    }

    public final boolean isDefaultValueUnknown$navigation_common() {
        return this.isDefaultValueUnknown;
    }

    /*
     * WARNING - void declaration
     */
    public final void putDefaultValue(String name, SavedState bundle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (this.isDefaultValuePresent && this.defaultValue != null) {
            void var1_1;
            void var2_2;
            this.type.put((SavedState)var2_2, (String)var1_1, this.defaultValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean verify(String name, SavedState bundle) {
        SavedState savedState;
        SavedState $this$verify_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (!this.isNullable && SavedStateReader.contains-impl((SavedState)($this$verify_u24lambda_u240 = SavedStateReader.constructor-impl((SavedState)(savedState = bundle))), (String)name) && SavedStateReader.isNull-impl((SavedState)savedState, (String)name)) {
            return false;
        }
        try {
            void var1_1;
            void var2_2;
            this.type.get((SavedState)var2_2, (String)var1_1);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        sb.append(" Type: " + this.type);
        sb.append(" Nullable: " + this.isNullable);
        if (this.isDefaultValuePresent) {
            sb.append(" DefaultValue: " + this.defaultValue);
        }
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NavArgument that = (NavArgument)other;
        if (this.isNullable != that.isNullable) {
            return false;
        }
        if (this.isDefaultValuePresent != that.isDefaultValuePresent) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, that.type)) {
            return false;
        }
        if (this.defaultValue != null) {
            return Intrinsics.areEqual((Object)this.defaultValue, (Object)that.defaultValue);
        }
        return var1_1.defaultValue == null;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.type.hashCode();
        result = result * 31 + (this.isNullable ? 1 : 0);
        result = result * 31 + (this.isDefaultValuePresent ? 1 : 0);
        Object object = this.defaultValue;
        var1_1 = var1_1 * 31 + (object != null ? object.hashCode() : 0);
        return (int)var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0007\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u000e\u0010\fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0013R\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0014R\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0014R\u0016\u0010\r\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0014"}, d2={"Landroidx/navigation/NavArgument$Builder;", "", "<init>", "()V", "T", "Landroidx/navigation/NavType;", "type", "setType", "(Landroidx/navigation/NavType;)Landroidx/navigation/NavArgument$Builder;", "", "isNullable", "setIsNullable", "(Z)Landroidx/navigation/NavArgument$Builder;", "unknownDefaultValuePresent", "setUnknownDefaultValuePresent$navigation_common", "setUnknownDefaultValuePresent", "Landroidx/navigation/NavArgument;", "build", "()Landroidx/navigation/NavArgument;", "Landroidx/navigation/NavType;", "Z", "defaultValue", "Ljava/lang/Object;", "defaultValuePresent"})
    public static final class Builder {
        private NavType<Object> type;
        private boolean isNullable;
        private Object defaultValue;
        private boolean defaultValuePresent;
        private boolean unknownDefaultValuePresent;

        /*
         * WARNING - void declaration
         */
        public final <T> Builder setType(NavType<T> type) {
            void var1_1;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setIsNullable(boolean isNullable) {
            void var1_1;
            this.isNullable = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setUnknownDefaultValuePresent$navigation_common(boolean unknownDefaultValuePresent) {
            void var1_1;
            this.unknownDefaultValuePresent = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final NavArgument build() {
            void var1_1;
            NavType<Object> navType = this.type;
            if (navType == null) {
                NavType<Object> navType2 = NavType.Companion.inferFromValueType(this.defaultValue);
                navType = navType2;
                Intrinsics.checkNotNull(navType2, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any?>");
            }
            NavType<Object> finalType = navType;
            return new NavArgument((NavType<Object>)var1_1, this.isNullable, this.defaultValue, this.defaultValuePresent, this.unknownDefaultValuePresent);
        }
    }
}

