/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavUri;
import androidx.navigation.internal.InternalUri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u00028BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0007R\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u0007R\u001b\u0010\"\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010!R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0018\u001a\u0004\b$\u0010\u000b"}, d2={"Landroidx/navigation/ActualUri;", "Landroidx/navigation/NavUri;", "", "uriString", "<init>", "(Ljava/lang/String;)V", "getFragment", "()Ljava/lang/String;", "getQuery", "", "getPathSegments", "()Ljava/util/List;", "", "isHierarchical", "()Z", "key", "getQueryParameters", "(Ljava/lang/String;)Ljava/util/List;", "", "getQueryParameterNames", "()Ljava/util/Set;", "toString", "Ljava/lang/String;", "_query$delegate", "Lkotlin/Lazy;", "get_query", "_query", "_fragment$delegate", "get_fragment", "_fragment", "", "schemeSeparatorIndex$delegate", "getSchemeSeparatorIndex", "()I", "schemeSeparatorIndex", "_pathSegments$delegate", "get_pathSegments", "_pathSegments", "Companion"})
@SourceDebugExtension(value={"SMAP\nNavUri.nonAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavUri.nonAndroid.kt\nandroidx/navigation/ActualUri\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1617#2,9:110\n1869#2:119\n1870#2:121\n1626#2:122\n1563#2:123\n1634#2,3:124\n1563#2:127\n1634#2,3:128\n1#3:120\n*S KotlinDebug\n*F\n+ 1 NavUri.nonAndroid.kt\nandroidx/navigation/ActualUri\n*L\n86#1:110,9\n86#1:119\n86#1:121\n86#1:122\n100#1:123\n100#1:124,3\n64#1:127\n64#1:128,3\n86#1:120\n*E\n"})
final class ActualUri
extends NavUri {
    private static final Companion Companion = new Companion(null);
    private final String uriString;
    private final Lazy _query$delegate;
    private final Lazy _fragment$delegate;
    private final Lazy schemeSeparatorIndex$delegate;
    private final Lazy _pathSegments$delegate;
    private static final Regex QUERY_PATTERN = new Regex("^[^?#]+\\?([^#]*).*");
    private static final Regex FRAGMENT_PATTERN = new Regex("#(.+)");

    /*
     * WARNING - void declaration
     */
    public ActualUri(String uriString) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        this.uriString = var1_1;
        this._query$delegate = LazyKt.lazy(() -> ActualUri._query_delegate$lambda$0(this));
        this._fragment$delegate = LazyKt.lazy(() -> ActualUri._fragment_delegate$lambda$1(this));
        this.schemeSeparatorIndex$delegate = LazyKt.lazy(() -> ActualUri.schemeSeparatorIndex_delegate$lambda$2(this));
        this._pathSegments$delegate = LazyKt.lazy(() -> ActualUri._pathSegments_delegate$lambda$4(this));
    }

    private final String get_query() {
        Lazy lazy = this._query$delegate;
        return (String)lazy.getValue();
    }

    private final String get_fragment() {
        Lazy lazy = this._fragment$delegate;
        return (String)lazy.getValue();
    }

    private final int getSchemeSeparatorIndex() {
        Lazy lazy = this.schemeSeparatorIndex$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final List<String> get_pathSegments() {
        Lazy lazy = this._pathSegments$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public final String getFragment() {
        return this.get_fragment();
    }

    @Override
    public final String getQuery() {
        return this.get_query();
    }

    @Override
    public final List<String> getPathSegments() {
        return this.get_pathSegments();
    }

    private final boolean isHierarchical() {
        if (this.getSchemeSeparatorIndex() == -1) {
            return true;
        }
        if (this.uriString.length() == this.getSchemeSeparatorIndex() + 1) {
            return false;
        }
        return this.uriString.charAt(this.getSchemeSeparatorIndex() + 1) == '/';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<String> getQueryParameters(String key) {
        void var3_3;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.isHierarchical()) {
            key = "Failed requirement.";
            throw new IllegalArgumentException(key.toString());
        }
        String string = this.get_query();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Object query = string;
        String encodedKey = InternalUri.encode$default(InternalUri.INSTANCE, key, null, 2, null);
        CharSequence charSequence = (CharSequence)query;
        char[] cArray = new char[1];
        query = cArray;
        cArray[0] = 38;
        query = StringsKt.split$default((CharSequence)charSequence, (char[])query, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object t = iterator2.next();
            Object t2 = t;
            t2 = t;
            String it = (String)t;
            int i = StringsKt.indexOf$default((CharSequence)it, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string2 = Intrinsics.areEqual((Object)it, (Object)encodedKey) ? "" : null;
            } else {
                String string3 = it.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                if (Intrinsics.areEqual((Object)string3, (Object)encodedKey)) {
                    String string4 = it.substring(i + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    string2 = InternalUri.INSTANCE.decode(string4);
                } else {
                    string2 = null;
                }
            }
            if (string2 == null) continue;
            String it$iv$iv = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<String> getQueryParameterNames() {
        if (!this.isHierarchical()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.get_query();
        if (string == null) {
            return SetsKt.emptySet();
        }
        Object object = string;
        char[] cArray = new char[1];
        object = cArray;
        cArray[0] = 38;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            String string2;
            void it;
            Object item$iv$iv = object2.next();
            item$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)'=', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                string2 = it;
            } else {
                void var3_4;
                String string3 = var3_4.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string2 = InternalUri.INSTANCE.decode(string3);
            }
            collection.add(string2);
        }
        return CollectionsKt.toSet((Iterable)((List)object));
    }

    @Override
    public final String toString() {
        return this.uriString;
    }

    private static final String _query_delegate$lambda$0(ActualUri this$0) {
        ActualUri actualUri;
        MatchResult matchResult = Regex.find$default((Regex)QUERY_PATTERN, (CharSequence)actualUri.uriString, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null) {
            return matchResult.getValue();
        }
        return null;
    }

    private static final String _fragment_delegate$lambda$1(ActualUri this$0) {
        ActualUri actualUri;
        MatchResult matchResult = Regex.find$default((Regex)FRAGMENT_PATTERN, (CharSequence)actualUri.uriString, (int)0, (int)2, null);
        if (matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null) {
            return matchResult.getValue();
        }
        return null;
    }

    private static final int schemeSeparatorIndex_delegate$lambda$2(ActualUri this$0) {
        return StringsKt.indexOf$default((CharSequence)this$0.uriString, (char)':', (int)0, (boolean)false, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _pathSegments_delegate$lambda$4(ActualUri this$0) {
        Collection collection;
        Iterator iterator2;
        int ssi22 = ((ActualUri)this$0).getSchemeSeparatorIndex();
        if (ssi22 >= 0) {
            if (ssi22 + 1 == ((ActualUri)this$0).uriString.length()) {
                return CollectionsKt.emptyList();
            }
            Character c = StringsKt.getOrNull((CharSequence)((ActualUri)this$0).uriString, (int)(ssi22 + 1));
            if (c == null || c.charValue() != '/') {
                return CollectionsKt.emptyList();
            }
        }
        String string = InternalUri.INSTANCE.parsePath(((ActualUri)this$0).uriString, ssi22);
        this$0 = string;
        char[] cArray = new char[1];
        this$0 = cArray;
        cArray[0] = 47;
        Collection $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])this$0, (boolean)false, (int)0, (int)6, null);
        Iterable ssi22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_3;
            Object item$iv$iv = iterator2.next();
            String it = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            collection2.add(InternalUri.INSTANCE.decode((String)var2_3));
        }
        return (List)collection;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006"}, d2={"Landroidx/navigation/ActualUri$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "QUERY_PATTERN", "Lkotlin/text/Regex;", "FRAGMENT_PATTERN"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

