/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "<init>", "()V", "Ljava/awt/Window;", "window", "", "onWindowCreated", "(Ljava/awt/Window;)V", "onWindowDisposed", "Ljava/awt/Point;", "getCascadeLocationFor", "(Ljava/awt/Window;)Ljava/awt/Point;", "cascadeOffset", "Ljava/awt/Point;", "", "lastFocusedWindows", "Ljava/util/Set;", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "focusListener", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "lastActiveGraphicsConfiguration"})
public final class WindowLocationTracker {
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    private static final Point cascadeOffset = new Point(48, 48);
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        /*
         * WARNING - void declaration
         */
        public final void windowGainedFocus(WindowEvent e) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = var1_1.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            set.add(window);
        }

        public final void windowLostFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };
    public static final int $stable = 8;

    private WindowLocationTracker() {
    }

    /*
     * WARNING - void declaration
     */
    public final void onWindowCreated(Window window) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        var1_1.addWindowFocusListener(focusListener);
    }

    /*
     * WARNING - void declaration
     */
    public final void onWindowDisposed(Window window) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(var1_1);
    }

    public final GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        if (window != null) {
            return window.getGraphicsConfiguration();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Point getCascadeLocationFor(Window window) {
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Window lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (lastWindow == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsConfiguration = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if (object != null) {
            void var2_2;
            void var3_3;
            void var1_1;
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNull((Object)screenBounds);
            Point screenLeftTop = Geometry_desktopKt.plus(Geometry_desktopKt.getLeftTop(screenBounds), new Point(screenInsets.left, screenInsets.top));
            Point screenRightBottom = Geometry_desktopKt.minus(Geometry_desktopKt.getRightBottom(screenBounds), new Point(screenInsets.right, screenInsets.bottom));
            Serializable serializable = lastWindow;
            if (serializable == null || (serializable = serializable.getLocation()) == null) {
                serializable = screenLeftTop;
            }
            lastWindow = serializable;
            Point location = Geometry_desktopKt.plus((Point)serializable, cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            Point rightBottom = Geometry_desktopKt.plus(location, Geometry_desktopKt.getRightBottom(dimension));
            if (rightBottom.x > screenRightBottom.x || var1_1.y > var3_3.y) {
                location = Geometry_desktopKt.plus(screenLeftTop, cascadeOffset);
            }
            return var2_2;
        }
        return cascadeOffset;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

