/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.awt.InteropFocusSwitcher;
import androidx.compose.ui.awt.SwingInteropViewGroup;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropPointerInput_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder_desktopKt;
import androidx.compose.ui.viewinterop.TypedInteropViewHolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\u00020\u0004BA\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001e\u001a\u00020\u00162\n\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ#\u0010 \u001a\u00020\u00162\n\u0010\u001b\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b \u0010\u001fJ\u001b\u0010!\u001a\u00020\u00162\n\u0010\u001b\u001a\u00060\u0019j\u0002`\u001aH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00162\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\n\u0010+\u001a\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0011\u00102\u001a\u0002018\u0006\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00107\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00109\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0014\u0010;\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u0014\u0010=\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00106"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropViewHolder;", "Ljava/awt/Component;", "T", "Landroidx/compose/ui/viewinterop/TypedInteropViewHolder;", "Lorg/jetbrains/skiko/ClipRectangle;", "Lkotlin/Function0;", "factory", "Landroidx/compose/ui/viewinterop/InteropContainer;", "container", "Landroidx/compose/ui/awt/SwingInteropViewGroup;", "group", "Landroidx/compose/ui/awt/InteropFocusSwitcher;", "focusSwitcher", "", "Landroidx/compose/runtime/CompositeKeyHashCode;", "compositeKeyHashCode", "Landroidx/compose/ui/layout/MeasurePolicy;", "measurePolicy", "<init>", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/viewinterop/InteropContainer;Landroidx/compose/ui/awt/SwingInteropViewGroup;Landroidx/compose/ui/awt/InteropFocusSwitcher;JLandroidx/compose/ui/layout/MeasurePolicy;)V", "Landroidx/compose/ui/layout/LayoutCoordinates;", "layoutCoordinates", "", "layoutAccordingTo", "(Landroidx/compose/ui/layout/LayoutCoordinates;)V", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "root", "", "index", "insertInteropView", "(Ljava/awt/Container;I)V", "changeInteropViewIndex", "removeInteropView", "(Ljava/awt/Container;)V", "Landroidx/compose/ui/input/pointer/PointerEvent;", "pointerEvent", "dispatchToView", "(Landroidx/compose/ui/input/pointer/PointerEvent;)V", "Ljava/awt/event/MouseEvent;", "event", "getDeepestComponentForEvent", "(Ljava/awt/event/MouseEvent;)Ljava/awt/Component;", "Landroidx/compose/ui/awt/SwingInteropViewGroup;", "getGroup", "()Landroidx/compose/ui/awt/SwingInteropViewGroup;", "Landroidx/compose/ui/unit/IntRect;", "clipBounds", "Landroidx/compose/ui/unit/IntRect;", "Ljava/awt/event/FocusListener;", "focusListener", "Ljava/awt/event/FocusListener;", "", "getX", "()F", "x", "getY", "y", "getWidth", "width", "getHeight", "height"})
@SourceDebugExtension(value={"SMAP\nSwingInteropViewHolder.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,189:1\n35#2,5:190\n*S KotlinDebug\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n*L\n167#1:190,5\n*E\n"})
public final class SwingInteropViewHolder<T extends Component>
extends TypedInteropViewHolder<T>
implements ClipRectangle {
    private final SwingInteropViewGroup group;
    private IntRect clipBounds;
    public final FocusListener focusListener;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SwingInteropViewHolder(Function0<? extends T> factory, InteropContainer container2, SwingInteropViewGroup group, InteropFocusSwitcher focusSwitcher, long compositeKeyHashCode, MeasurePolicy measurePolicy) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)focusSwitcher, (String)"focusSwitcher");
        Intrinsics.checkNotNullParameter((Object)measurePolicy, (String)"measurePolicy");
        super(var1_1, (InteropContainer)var2_2, group, compositeKeyHashCode, measurePolicy);
        this.group = var3_3;
        this.focusListener = new FocusListener(this, focusSwitcher){
            final /* synthetic */ SwingInteropViewHolder<T> this$0;
            final /* synthetic */ InteropFocusSwitcher $focusSwitcher;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$focusSwitcher = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(e, this.this$0.getGroup())) {
                    void var1_1;
                    FocusEvent.Cause cause = var1_1.getCause();
                    switch (cause == null ? -1 : focusListener.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            this.$focusSwitcher.moveAfterInteropView();
                            return;
                        }
                        case 2: {
                            this.$focusSwitcher.moveBeforeInteropView();
                        }
                    }
                }
            }

            public final void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        this.getGroup().add((Component)((InteropViewHolder)this).interopView());
        this.setPlatformModifier(DrawModifierKt.drawBehind(InteropPointerInput_skikoKt.pointerInteropFilter(Modifier.Companion, this), (Function1<? super DrawScope, Unit>)((Function1)SwingInteropViewHolder::_init_$lambda$0)));
    }

    @Override
    public final SwingInteropViewGroup getGroup() {
        return this.group;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void layoutAccordingTo(LayoutCoordinates layoutCoordinates) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
        LayoutCoordinates rootCoordinates = LayoutCoordinatesKt.findRootCoordinates(layoutCoordinates);
        IntRect clippedBounds = SwingInteropViewHolder_desktopKt.access$round(rootCoordinates.localBoundingBoxOf(layoutCoordinates, true), this.getDensity());
        IntRect bounds = SwingInteropViewHolder_desktopKt.access$round(var2_2.localBoundingBoxOf(layoutCoordinates, false), this.getDensity());
        this.clipBounds = clippedBounds;
        this.getContainer().scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropViewHolder.layoutAccordingTo$lambda$1(this, (IntRect)var3_3, (IntRect)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void insertInteropView(Container root, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.add((Component)this.getGroup(), index);
        super.insertInteropView((Container)var1_1, (int)var2_2);
        this.getContainer().getRoot().addFocusListener(this.focusListener);
        this.getGroup().setOnInvalidate$ui((Function0<Unit>)((Function0)() -> SwingInteropViewHolder.insertInteropView$lambda$2(this)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void changeInteropViewIndex(Container root, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        var1_1.setComponentZOrder(this.getGroup(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeInteropView(Container root) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.remove(this.getGroup());
        super.removeInteropView((Container)var1_1);
        this.getContainer().getRoot().removeFocusListener(this.focusListener);
        this.getGroup().setOnInvalidate$ui(null);
    }

    public final float getX() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getLeft() : this.getGroup().getX();
    }

    public final float getY() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getTop() : this.getGroup().getY();
    }

    public final float getWidth() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getWidth() : this.getGroup().getWidth();
    }

    public final float getHeight() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getHeight() : this.getGroup().getHeight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void dispatchToView(PointerEvent pointerEvent) {
        Intrinsics.checkNotNullParameter((Object)pointerEvent, (String)"pointerEvent");
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull(pointerEvent);
        if (mouseEvent == null) {
            return;
        }
        MouseEvent e = mouseEvent;
        switch (mouseEvent.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom(e.getComponent(), this.getGroup())) {
            return;
        }
        Component component = this.getDeepestComponentForEvent(e);
        if (component != null) {
            void var3_4;
            component.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, (Component)var3_4));
            List<PointerInputChange> $this$fastForEach$iv = pointerEvent.getChanges();
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                PointerInputChange pointerInputChange = $this$fastForEach$iv.get(index$iv);
                PointerInputChange pointerInputChange2 = pointerInputChange;
                pointerInputChange2 = pointerInputChange;
                pointerInputChange.consume();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Component getDeepestComponentForEvent(MouseEvent event) {
        void var1_1;
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)((InteropViewHolder)this).interopView());
        return SwingUtilities.getDeepestComponentAt((Component)((InteropViewHolder)this).interopView(), point.x, var1_1.y);
    }

    private static final Unit _init_$lambda$0(DrawScope $this$drawBehind) {
        DrawScope drawScope;
        Intrinsics.checkNotNullParameter((Object)$this$drawBehind, (String)"$this$drawBehind");
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)Color.Companion.getTransparent-0d7_KjU(), (long)0L, (long)0L, (float)0.0f, null, null, (int)BlendMode.Companion.getClear-0nO6VwU(), (int)62, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit layoutAccordingTo$lambda$1(SwingInteropViewHolder this$0, IntRect $clippedBounds, IntRect $bounds) {
        void var2_2;
        void var1_1;
        SwingInteropViewHolder swingInteropViewHolder;
        this$0.getGroup().setVisible(!$clippedBounds.isEmpty());
        this$0.getGroup().setBounds($clippedBounds.getLeft(), $clippedBounds.getTop(), $clippedBounds.getWidth(), $clippedBounds.getHeight());
        ((Component)((InteropViewHolder)swingInteropViewHolder).interopView()).setBounds($bounds.getLeft() - $clippedBounds.getLeft(), $bounds.getTop() - var1_1.getTop(), $bounds.getWidth(), var2_2.getHeight());
        return Unit.INSTANCE;
    }

    private static final Unit insertInteropView$lambda$2(SwingInteropViewHolder this$0) {
        this$0.getLayoutNode().invalidateMeasurements$ui();
        return Unit.INSTANCE;
    }
}

