/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0011J\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0011J\u001b\u0010\u0018\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u001e\u0010\"\u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\u0002\u00a2\u0006\u0004\b\"\u0010#R\u001e\u0010\u0004\u001a\u00060\u0002j\u0002`\u00038\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010&R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00058\u0006@FX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010(\"\u0004\b)\u0010*R&\u0010,\u001a\u0012\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\u0004\u0012\u00020\f0+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R$\u0010/\u001a\u0004\u0018\u00010.8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00106\u001a\u0002058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropContainer;", "Landroidx/compose/ui/viewinterop/InteropContainer;", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "root", "", "placeInteropAbove", "Lkotlin/Function0;", "", "requestRedraw", "<init>", "(Ljava/awt/Container;ZLkotlin/jvm/functions/Function0;)V", "Landroidx/compose/ui/viewinterop/InteropViewHolder;", "holder", "contains", "(Landroidx/compose/ui/viewinterop/InteropViewHolder;)Z", "updateInteropComponentsOrder", "()V", "place", "(Landroidx/compose/ui/viewinterop/InteropViewHolder;)V", "unplace", "executeScheduledUpdates", "dispose", "body", "postponingExecutingScheduledUpdates", "(Lkotlin/jvm/functions/Function0;)V", "action", "scheduleUpdate", "Ljava/awt/Component;", "component", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipRectForComponent", "(Ljava/awt/Component;)Lorg/jetbrains/skiko/ClipRectangle;", "content", "invoke", "(Lkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;I)V", "Ljava/awt/Container;", "getRoot", "()Ljava/awt/Container;", "value", "Z", "setPlaceInteropAbove", "(Z)V", "", "interopComponents", "Ljava/util/Map;", "Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "rootModifier", "Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "getRootModifier", "()Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "setRootModifier", "(Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;)V", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "getSnapshotObserver", "()Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "Landroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain;", "scheduledUpdatesSwapchain", "Landroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain;"})
@SourceDebugExtension(value={"SMAP\nSwingInteropContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n+ 2 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain\n*L\n1#1,282:1\n60#2,16:283\n*S KotlinDebug\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n*L\n250#1:283,16\n*E\n"})
public final class SwingInteropContainer
implements InteropContainer {
    private final Container root;
    private boolean placeInteropAbove;
    private Map<Container, InteropViewHolder> interopComponents;
    private TrackInteropPlacementModifierNode rootModifier;
    private final SnapshotStateObserver snapshotObserver;
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SwingInteropContainer(Container root, boolean placeInteropAbove, Function0<Unit> requestRedraw) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(requestRedraw, (String)"requestRedraw");
        this.root = var1_1;
        this.placeInteropAbove = var2_2;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver(SwingInteropContainer::snapshotObserver$lambda$0);
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain((Function0<Unit>)var3_3);
    }

    @Override
    public final Container getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPlaceInteropAbove(boolean value) {
        if (this.placeInteropAbove != value) {
            void var1_1;
            this.placeInteropAbove = var1_1;
            this.updateInteropComponentsOrder();
        }
    }

    @Override
    public final TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setRootModifier(TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        void var1_1;
        this.rootModifier = var1_1;
    }

    @Override
    public final SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(InteropViewHolder holder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.interopComponents.containsKey(var1_1.getGroup());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateInteropComponentsOrder() {
        void var1_1;
        List<InteropViewHolder> orderedInteropComponents = InteropContainer_skikoKt.interopComponentsSortedByDrawOrder(this, this.interopComponents.values());
        SwingInteropContainer swingInteropContainer = this;
        swingInteropContainer.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.updateInteropComponentsOrder$lambda$2(swingInteropContainer, (List)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void place(InteropViewHolder holder) {
        void var1_1;
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Container group = holder.getGroup();
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().start();
        }
        boolean isNewInteropView = this.interopComponents.putIfAbsent(group, holder) == null;
        int interopComponentsCount = this.interopComponents.size();
        int interopComponentsBelowCount = InteropContainer_skikoKt.countInteropComponentsBelow(this, holder);
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.place$lambda$3((int)var3_4, this, (boolean)var2_3, interopComponentsBelowCount, (InteropViewHolder)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void unplace(InteropViewHolder holder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.unplace$lambda$4(holder, this)));
        this.interopComponents.remove(var1_1.getGroup());
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Check failed.");
        }
        boolean bl = this.scheduledUpdatesSwapchain.execute();
        if (bl) {
            this.getRoot().validate();
            this.getRoot().repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - void declaration
     */
    public final void postponingExecutingScheduledUpdates(Function0<Unit> body) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ScheduledUpdatesSwapchain this_$iv = this.scheduledUpdatesSwapchain;
        try {
            object2 = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object2) {
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(this_$iv)) {
                    body = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException(body.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, false);
            }
            object.invoke();
        }
        catch (Throwable throwable) {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                void var2_4;
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p((ScheduledUpdatesSwapchain)var2_4, true);
            }
            throw throwable;
        }
        object2 = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
        synchronized (object2) {
            ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, true);
        }
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void scheduleUpdate(Function0<Unit> action) {
        void var1_1;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.scheduledUpdatesSwapchain.scheduleUpdate((Function0<Unit>)var1_1);
    }

    public final ClipRectangle getClipRectForComponent(Component component) {
        String string;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        InteropViewHolder interopViewHolder = this.interopComponents.get(string);
        if (interopViewHolder == null) {
            string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder, (String)"null cannot be cast to non-null type org.jetbrains.skiko.ClipRectangle");
        return (ClipRectangle)interopViewHolder;
    }

    /*
     * WARNING - void declaration
     */
    public final void invoke(Function2<? super Composer, ? super Integer, Unit> content, Composer $composer, int $changed) {
        void var2_2;
        Intrinsics.checkNotNullParameter(content, (String)"content");
        $composer = $composer.startRestartGroup(-1827244710);
        int $dirty = $changed;
        if (($changed & 6) == 0) {
            $dirty |= $composer.changedInstance(content) ? 4 : 2;
        }
        if (($changed & 0x30) == 0) {
            $dirty |= $composer.changedInstance((Object)this) ? 32 : 16;
        }
        if ($composer.shouldExecute(($dirty & 0x13) != 18, $dirty & 1)) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)-1827244710, (int)$dirty, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:271)");
            }
            CompositionLocalKt.CompositionLocalProvider((ProvidedValue)InteropContainer_skikoKt.getLocalInteropContainer().provides((Object)this), (Function2)((Function2)ComposableLambdaKt.rememberComposableLambda((int)-1220154854, (boolean)true, (arg_0, arg_1) -> SwingInteropContainer.invoke$lambda$6(this, content, arg_0, arg_1), (Composer)$composer, (int)54)), (Composer)$composer, (int)(0x30 | ProvidedValue.$stable));
            if (ComposerKt.isTraceInProgress()) {
                // empty if block
            }
        } else {
            $composer.skipToGroupEnd();
        }
        ScopeUpdateScope scopeUpdateScope = var2_2.endRestartGroup();
        if (scopeUpdateScope != null) {
            void var3_3;
            void var1_1;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> SwingInteropContainer.invoke$lambda$7(this, (Function2)var1_1, (int)var3_3, arg_0, arg_1));
            return;
        }
    }

    private static final Unit snapshotObserver$lambda$0(Function0 command) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        function0.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit updateInteropComponentsOrder$lambda$2(SwingInteropContainer this$0, List $orderedInteropComponents) {
        Iterator iterator2;
        int allComponentCount = this$0.getRoot().getComponents().length;
        iterator2 = ((Iterable)CollectionsKt.asReversed((List)((Object)iterator2))).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            InteropViewHolder interopViewHolder = (InteropViewHolder)iterator2.next();
            interopViewHolder.changeInteropViewIndex(this$0.getRoot(), this$0.placeInteropAbove ? allComponentCount - 1 : index);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit place$lambda$3(int $interopComponentsCount, SwingInteropContainer this$0, boolean $isNewInteropView, int $interopComponentsBelowCount, InteropViewHolder $holder) {
        void var2_2;
        void var3_3;
        int lastInteropIndex = $interopComponentsCount - 1;
        if (!this$0.placeInteropAbove) {
            int existingInteropComponentCount = $interopComponentsCount - ($isNewInteropView ? 1 : 0);
            lastInteropIndex += this$0.getRoot().getComponentCount() - existingInteropComponentCount;
        }
        int awtIndex = lastInteropIndex - var3_3;
        if (var2_2 != false) {
            $holder.insertInteropView(this$0.getRoot(), awtIndex);
        } else {
            int n;
            void var1_1;
            $holder.changeInteropViewIndex(var1_1.getRoot(), n);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit unplace$lambda$4(InteropViewHolder $holder, SwingInteropContainer this$0) {
        void var1_1;
        $holder.removeInteropView(var1_1.getRoot());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit invoke$lambda$6(SwingInteropContainer this$0, Function2 $content, Composer $composer, int $changed) {
        if ($composer.shouldExecute(($changed & 3) != 2, $changed & 1)) {
            void var1_1;
            SwingInteropContainer swingInteropContainer;
            if (ComposerKt.isTraceInProgress()) {
                void var3_3;
                ComposerKt.traceEventStart((int)-1220154854, (int)var3_3, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:275)");
            }
            InteropContainer_skikoKt.TrackInteropPlacementContainer(swingInteropContainer, (Function2<? super Composer, ? super Integer, Unit>)var1_1, $composer, 0);
            if (ComposerKt.isTraceInProgress()) {
                // empty if block
            }
        } else {
            void var2_2;
            var2_2.skipToGroupEnd();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit invoke$lambda$7(SwingInteropContainer $tmp0_rcvr, Function2 $content, int $$changed, Composer $composer, int $force) {
        void var2_2;
        void var3_3;
        void var1_1;
        $tmp0_rcvr.invoke((Function2<? super Composer, ? super Integer, Unit>)var1_1, (Composer)var3_3, RecomposeScopeImplKt.updateChangedFlags((int)(var2_2 | 1)));
        return Unit.INSTANCE;
    }
}

