/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.RadioButtonAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\t\u0010\u0013\u001a\u00020\u0014X\u0082\u0004R\u001f\u0010\u0015\u001a\u00060\u0016R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "<init>", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
public final class ComposeAccessible
extends Component
implements Accessible {
    private final AccessibilityController controller;
    private SemanticsNode semanticsNode;
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public ComposeAccessible(SemanticsNode semanticsNode, AccessibilityController controller) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = var2_2;
        this.semanticsNode = var1_1;
        this.composeAccessibleContext$delegate = LazyKt.lazy(() -> ComposeAccessible.composeAccessibleContext_delegate$lambda$1(this));
    }

    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSemanticsNode(SemanticsNode value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.semanticsNode = var1_1;
        this.cachedSemanticsConfig = null;
    }

    /*
     * WARNING - void declaration
     */
    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            void var2_2;
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            this.cachedSemanticsConfig = var2_2;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setRemoved(boolean bl) {
        void var1_1;
        this.removed = var1_1;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    private static final ComposeAccessibleComponent composeAccessibleContext_delegate$lambda$1(ComposeAccessible this$0) {
        ComposeAccessible composeAccessible;
        return new ComposeAccessibleComponent(composeAccessible);
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
        $stable = 8;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0097\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00cd\u0001\u00ce\u0001\u00cf\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000f\u001a\u00020\f*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0014\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0017\u001a\u00020\u0016*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001b\u001a\u00020\u000b*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010 \u001a\u00020\u001d*\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010\"\u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0011\u0010$\u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0004\b$\u0010#J\u0011\u0010%\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b%\u0010&J\u0011\u0010'\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0011\u0010)\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0011\u0010,\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b0\u0010/J\u0019\u00102\u001a\u0004\u0018\u00010\b2\u0006\u00101\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b7\u00108J\u000f\u00109\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b9\u00108J\u000f\u0010:\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b<\u0010=J\u000f\u0010>\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b>\u0010?J\u000f\u0010@\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b@\u0010?J\u000f\u0010A\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bA\u0010?J\u0018\u0010C\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\bC\u0010DJ\u0019\u0010E\u001a\u0004\u0018\u00010\b2\u0006\u0010B\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010FJ\u000f\u0010G\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bG\u0010?J\u000f\u0010I\u001a\u00020HH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u0019\u0010M\u001a\u00020H2\b\u0010L\u001a\u0004\u0018\u00010KH\u0016\u00a2\u0006\u0004\bM\u0010NJ\u0019\u0010O\u001a\u00020H2\b\u0010L\u001a\u0004\u0018\u00010KH\u0016\u00a2\u0006\u0004\bO\u0010NJ\u000f\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u000f\u0010T\u001a\u00020SH\u0016\u00a2\u0006\u0004\bT\u0010UJ\u0013\u0010V\u001a\u00020H*\u00020SH\u0002\u00a2\u0006\u0004\bV\u0010WJ\u0013\u0010X\u001a\u00020H*\u00020SH\u0002\u00a2\u0006\u0004\bX\u0010WJ\u0013\u0010Y\u001a\u00020H*\u00020SH\u0002\u00a2\u0006\u0004\bY\u0010WJ\u0011\u0010[\u001a\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0004\b[\u0010\\J\u0011\u0010^\u001a\u0004\u0018\u00010]H\u0016\u00a2\u0006\u0004\b^\u0010_J\u0019\u0010a\u001a\u00020H2\b\u0010`\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\ba\u0010bJ\u0019\u0010d\u001a\u00020H2\b\u0010c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\bd\u0010eJ\u0019\u0010f\u001a\u00020H2\b\u0010B\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\bf\u0010gJ\u000f\u0010i\u001a\u00020hH\u0016\u00a2\u0006\u0004\bi\u0010jJ\u0019\u0010l\u001a\u00020H2\b\u0010k\u001a\u0004\u0018\u00010hH\u0016\u00a2\u0006\u0004\bl\u0010mJ\u000f\u0010n\u001a\u00020hH\u0016\u00a2\u0006\u0004\bn\u0010jJ\u0019\u0010o\u001a\u00020H2\b\u0010k\u001a\u0004\u0018\u00010hH\u0016\u00a2\u0006\u0004\bo\u0010mJ\u000f\u0010q\u001a\u00020pH\u0016\u00a2\u0006\u0004\bq\u0010rJ\u0019\u0010t\u001a\u00020H2\b\u0010s\u001a\u0004\u0018\u00010pH\u0016\u00a2\u0006\u0004\bt\u0010uJ\u000f\u0010w\u001a\u00020vH\u0016\u00a2\u0006\u0004\bw\u0010xJ\u0019\u0010z\u001a\u00020H2\b\u0010y\u001a\u0004\u0018\u00010vH\u0016\u00a2\u0006\u0004\bz\u0010{J\u0019\u0010}\u001a\u00020|2\b\u0010y\u001a\u0004\u0018\u00010vH\u0016\u00a2\u0006\u0004\b}\u0010~J\u001a\u0010\u0080\u0001\u001a\u00020H2\u0006\u0010\u007f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J\u001a\u0010\u0082\u0001\u001a\u00020H2\u0006\u0010\u007f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0081\u0001J\u0011\u0010\u0083\u0001\u001a\u00020\u0011H\u0016\u00a2\u0006\u0005\b\u0083\u0001\u0010/J\u001a\u0010\u0084\u0001\u001a\u00020!2\u0006\u00101\u001a\u00020\u0011H\u0016\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001J\u001a\u0010\u0086\u0001\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0011H\u0016\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001J\u001e\u0010\u008a\u0001\u001a\u00020!*\n\u0012\u0005\u0012\u00030\u0089\u00010\u0088\u0001H\u0002\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0017\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u008c\u00018F\u00a2\u0006\b\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001R+\u0010\u0095\u0001\u001a\u0019\u0012\u0012\u0012\u0010\u0012\u0005\u0012\u00030\u0092\u0001\u0012\u0004\u0012\u00020\u00060\u0091\u0001\u0018\u00010\u0090\u00018F\u00a2\u0006\b\u001a\u0006\b\u0093\u0001\u0010\u0094\u0001R6\u0010\u0098\u0001\u001a$\u0012\u001d\u0012\u001b\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0096\u0001\u0018\u00010\u0090\u00018F\u00a2\u0006\b\u001a\u0006\b\u0097\u0001\u0010\u0094\u0001R\u0017\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u0089\u00018F\u00a2\u0006\b\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001R\u0017\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u009c\u00018F\u00a2\u0006\b\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001R\u0016\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\b\u001a\u0006\b\u00a0\u0001\u0010\u00a1\u0001R\u0016\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\b\u001a\u0006\b\u00a3\u0001\u0010\u00a1\u0001R\u0018\u0010\u00a8\u0001\u001a\u00030\u00a5\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u00a6\u0001\u0010\u00a7\u0001R\u0017\u0010\u00ac\u0001\u001a\u0005\u0018\u00010\u00a9\u00018F\u00a2\u0006\b\u001a\u0006\b\u00aa\u0001\u0010\u00ab\u0001R\u0017\u0010\u00ae\u0001\u001a\u0005\u0018\u00010\u00a9\u00018F\u00a2\u0006\b\u001a\u0006\b\u00ad\u0001\u0010\u00ab\u0001RV\u0010\u00b6\u0001\u001aD\u0012=\u0012;\u0012\u0017\u0012\u00150\u00b0\u0001\u00a2\u0006\u000f\b\u00b1\u0001\u0012\n\b\u00b2\u0001\u0012\u0005\b\b(\u00b3\u0001\u0012\u0017\u0012\u00150\u00b0\u0001\u00a2\u0006\u000f\b\u00b1\u0001\u0012\n\b\u00b2\u0001\u0012\u0005\b\b(\u00b4\u0001\u0012\u0004\u0012\u00020\u00060\u00af\u0001\u0018\u00010\u0090\u00018F\u00a2\u0006\b\u001a\u0006\b\u00b5\u0001\u0010\u0094\u0001R\u0013\u0010\u00b7\u0001\u001a\u00020\u00068F\u00a2\u0006\u0007\u001a\u0005\b\u00b7\u0001\u0010?R\u0017\u0010\u00bb\u0001\u001a\u0005\u0018\u00010\u00b8\u00018F\u00a2\u0006\b\u001a\u0006\b\u00b9\u0001\u0010\u00ba\u0001R\u001b\u0010\u00be\u0001\u001a\t\u0012\u0004\u0012\u00020\b0\u0088\u00018F\u00a2\u0006\b\u001a\u0006\b\u00bc\u0001\u0010\u00bd\u0001R\u0017\u0010\u00c2\u0001\u001a\u0005\u0018\u00010\u00bf\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c0\u0001\u0010\u00c1\u0001R\u0016\u0010\u00c3\u0001\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\b\u001a\u0006\b\u00c3\u0001\u0010\u00a1\u0001R\u0016\u0010\u00c4\u0001\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\b\u001a\u0006\b\u00c4\u0001\u0010\u00a1\u0001R\u001b\u0010\u00c5\u0001\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00c5\u0001\u0010\u00c6\u0001R+\u0010\u00cc\u0001\u001a\u000e\u0018\u00010\u00c7\u0001R\u00070\u0000R\u00030\u00c8\u00018BX\u0082\u0084\u0002\u00a2\u0006\u000f\n\u0006\b\u00c9\u0001\u0010\u00ca\u0001\u001a\u0005\b[\u0010\u00cb\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "", "vertical", "Ljavax/accessibility/Accessible;", "makeScrollbarChild", "(Z)Ljavax/accessibility/Accessible;", "Ljava/awt/Point;", "Landroidx/compose/ui/geometry/Offset;", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "toComposeOffset", "Landroidx/compose/ui/unit/Dp;", "", "toAwtPx-0680j_4", "(F)I", "toAwtPx", "Landroidx/compose/ui/geometry/Rect;", "Ljava/awt/Rectangle;", "toAwtRectangle", "(Landroidx/compose/ui/geometry/Rect;)Ljava/awt/Rectangle;", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtPoint", "Landroidx/compose/ui/unit/IntSize;", "Ljava/awt/Dimension;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "toAwtDimension", "", "getAccessibleName", "()Ljava/lang/String;", "getAccessibleDescription", "getAccessibleParent", "()Ljavax/accessibility/Accessible;", "getAccessibleComponent", "()Ljavax/accessibility/AccessibleComponent;", "getAccessibleAction", "()Ljavax/accessibility/AccessibleAction;", "Ljavax/accessibility/AccessibleValue;", "getAccessibleValue", "()Ljavax/accessibility/AccessibleValue;", "getAccessibleIndexInParent", "()I", "getAccessibleChildrenCount", "i", "getAccessibleChild", "(I)Ljavax/accessibility/Accessible;", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "getLocationOnScreen", "()Ljava/awt/Point;", "getLocation", "getBounds", "()Ljava/awt/Rectangle;", "getSize", "()Ljava/awt/Dimension;", "isVisible", "()Z", "isEnabled", "isShowing", "p", "contains", "(Ljava/awt/Point;)Z", "getAccessibleAt", "(Ljava/awt/Point;)Ljavax/accessibility/Accessible;", "isFocusTraversable", "", "requestFocus", "()V", "Ljava/awt/event/FocusListener;", "l", "addFocusListener", "(Ljava/awt/event/FocusListener;)V", "removeFocusListener", "Ljavax/accessibility/AccessibleRole;", "getAccessibleRole", "()Ljavax/accessibility/AccessibleRole;", "Ljavax/accessibility/AccessibleStateSet;", "getAccessibleStateSet", "()Ljavax/accessibility/AccessibleStateSet;", "addCheckedStateForCheckboxOrSwitch", "(Ljavax/accessibility/AccessibleStateSet;)V", "addCheckedStateForRadioButton", "addDefaultStateForToggleableState", "Ljavax/accessibility/AccessibleText;", "getAccessibleText", "()Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleEditableText;", "getAccessibleEditableText", "()Ljavax/accessibility/AccessibleEditableText;", "r", "setBounds", "(Ljava/awt/Rectangle;)V", "d", "setSize", "(Ljava/awt/Dimension;)V", "setLocation", "(Ljava/awt/Point;)V", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "c", "setBackground", "(Ljava/awt/Color;)V", "getForeground", "setForeground", "Ljava/awt/Cursor;", "getCursor", "()Ljava/awt/Cursor;", "cursor", "setCursor", "(Ljava/awt/Cursor;)V", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "f", "setFont", "(Ljava/awt/Font;)V", "Ljava/awt/FontMetrics;", "getFontMetrics", "(Ljava/awt/Font;)Ljava/awt/FontMetrics;", "b", "setEnabled", "(Z)V", "setVisible", "getAccessibleActionCount", "getAccessibleActionDescription", "(I)Ljava/lang/String;", "doAccessibleAction", "(I)Z", "", "", "mergeText", "(Ljava/util/List;)Ljava/lang/String;", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "textSelectionRange", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "getSetText", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "setText", "Lkotlin/Function3;", "getSetSelection", "setSelection", "getText", "()Ljava/lang/CharSequence;", "text", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "textLayoutResult", "getFocused", "()Ljava/lang/Boolean;", "focused", "getSelected", "selected", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "horizontalScroll", "getVerticalScroll", "verticalScroll", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "scrollBy", "isPassword", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "toggleableState", "getAuxiliaryChildren", "()Ljava/util/List;", "auxiliaryChildren", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "progressBarRangeInfo", "isContainer", "isTraversalGroup", "accessibleAction", "Ljavax/accessibility/AccessibleAction;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "accessibleText$delegate", "Lkotlin/Lazy;", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText", "ComposeAccessibleText", "ScrollBarAccessible", "ComposeAccessibleEditableText"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 9 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 10 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,936:1\n122#2:937\n30#3:938\n53#4,3:939\n60#4:945\n70#4:948\n85#4:951\n90#4:953\n57#5:942\n62#5:943\n65#6:944\n69#6:947\n22#7:946\n22#7:949\n54#8:950\n59#8:952\n360#9,7:954\n90#10:961\n1#11:962\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n217#1:937\n217#1:938\n217#1:939,3\n234#1:945\n235#1:948\n241#1:951\n242#1:953\n227#1:942\n228#1:943\n234#1:944\n235#1:947\n234#1:946\n235#1:949\n241#1:950\n242#1:952\n323#1:954,7\n359#1:961\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        private AccessibleAction accessibleAction;
        private final Lazy accessibleText$delegate = LazyKt.lazy(() -> ComposeAccessibleComponent.accessibleText_delegate$lambda$14(this));
        final /* synthetic */ ComposeAccessible this$0;

        /*
         * WARNING - void declaration
         */
        public ComposeAccessibleComponent(ComposeAccessible this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        public final CharSequence getText() {
            Object object = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (object == null) {
                List<AnnotatedString> list = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
                object = list != null ? this.mergeText(list) : null;
            }
            return (CharSequence)object;
        }

        /*
         * WARNING - void declaration
         */
        public final TextLayoutResult getTextLayoutResult() {
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            accessibilityAction = accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null ? (Boolean)accessibilityAction.invoke(textLayoutResults) : null;
            if (Intrinsics.areEqual(accessibilityAction, (Object)Boolean.TRUE)) {
                void var1_1;
                return (TextLayoutResult)var1_1.get(0);
            }
            return null;
        }

        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return this.this$0.controller.getDesktopComponent().getDensity();
        }

        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        /*
         * WARNING - void declaration
         */
        public final List<Accessible> getAuxiliaryChildren() {
            List list;
            List $this$_get_auxiliaryChildren__u24lambda_u242 = list = CollectionsKt.createListBuilder();
            if (this.getHorizontalScroll() != null) {
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
            }
            if (this.getVerticalScroll() != null) {
                void var2_2;
                var2_2.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list);
        }

        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        /*
         * WARNING - void declaration
         */
        private final Accessible makeScrollbarChild(boolean vertical) {
            void var1_2;
            void var2_3;
            void var3_4;
            ScrollBarAccessible bar = new ScrollBarAccessible(this, vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, this.this$0);
            bar.getContext().getAccessibleRelationSet().add((AccessibleRelation)var3_4);
            this.getAccessibleRelationSet().add((AccessibleRelation)var2_3);
            return (Accessible)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ2) {
            void var1_3;
            void var2_5;
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u2442 = this.getDensity();
            int n = $this$toComposeOffset_u2dtuRUvjQ2.x;
            float f = $this$toComposeOffset_tuRUvjQ_u24lambda_u2442.toPx-0680j_4(Dp.constructor-impl((float)n));
            int $this$toComposeOffset_u2dtuRUvjQ2 = $this$toComposeOffset_u2dtuRUvjQ2.y;
            float y$iv = $this$toComposeOffset_tuRUvjQ_u24lambda_u2442.toPx-0680j_4(Dp.constructor-impl((float)$this$toComposeOffset_u2dtuRUvjQ2));
            float $this$toComposeOffset_tuRUvjQ_u24lambda_u2442 = f;
            long v1$iv$iv = Float.floatToRawIntBits((float)var2_5);
            long v2$iv$iv = Float.floatToRawIntBits((float)var1_3);
            return Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        }

        /*
         * WARNING - void declaration
         */
        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            void var1_1;
            if (Float.isInfinite($this$toAwtPx_u2d0680j_4)) {
                return Integer.MAX_VALUE;
            }
            return MathKt.roundToInt((float)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            void var3_3;
            void var2_2;
            void var1_1;
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            Rect this_$iv = $this$toAwtRectangle;
            int n = this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getRight() - this_$iv.getLeft()));
            this_$iv = var1_1;
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), n, this.toAwtPx-0680j_4(var2_2.toDp-u2uoSUM(this_$iv.getBottom() - var3_3.getTop())));
        }

        /*
         * WARNING - void declaration
         */
        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            void var3_2;
            void var1_1;
            long l;
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            long l2 = l = $this$toAwtPoint_u2dk_u2d4lQ0M;
            int n = (int)(l >> 32);
            void var4_5 = var1_1;
            l2 = var4_5;
            int n2 = (int)var4_5;
            return new Point(this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(n))), this.toAwtPx-0680j_4(var3_2.toDp-u2uoSUM(Float.intBitsToFloat(n2))));
        }

        /*
         * WARNING - void declaration
         */
        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            void var3_2;
            void var1_1;
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            long l = $this$toAwtDimension_u2dozmzZPI;
            long l2 = l;
            long l3 = l;
            l3 = l2 = var1_1;
            return new Dimension(this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(l >> 32))), this.toAwtPx-0680j_4(var3_2.toDp-u2uoSUM((int)l2)));
        }

        @Override
        public String getAccessibleName() {
            CharSequence charSequence = this.getText();
            if (charSequence != null) {
                return ((Object)charSequence).toString();
            }
            return null;
        }

        @Override
        public String getAccessibleDescription() {
            List<String> list = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
            if (list != null) {
                return this.mergeText(list);
            }
            return null;
        }

        @Override
        public Accessible getAccessibleParent() {
            Object object = this.this$0.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = this.this$0;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(n);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    return (Accessible)object;
                }
            }
            return this.accessibleParent;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleAction getAccessibleAction() {
            void var1_1;
            List actions = new ArrayList();
            if (SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick()) != null) {
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction((List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>>)var1_1, this.this$0){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.$actions = var1_1;
                    this.this$0 = var2_2;
                }

                public final int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String getAccessibleActionDescription(int i) {
                    void var1_1;
                    String string = (String)this.$actions.get((int)var1_1).component1();
                    return string;
                }

                public final boolean doAccessibleAction(int i) {
                    AccessibilityAction accessibilityAction;
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    Object object = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), accessibilityAction);
                    if (object != null) {
                        accessibilityAction = object;
                        Function0 function0 = (Function0)((AccessibilityAction)object).getAction();
                        object = function0 != null ? (Boolean)function0.invoke() : null;
                        if (object != null) {
                            return (Boolean)object;
                        }
                    }
                    return false;
                }
            };
            return this.accessibleAction;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleValue getAccessibleValue() {
            void var1_1;
            Role role = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            if (this.getToggleableState() != null) {
                return new ToggleableAccessibleValue(this);
            }
            int n = Role.Companion.getRadioButton-o7Vup1c();
            void v0 = var1_1;
            if (v0 == null ? false : Role.equals-impl0(v0.unbox-impl(), n)) {
                return new RadioButtonAccessibleValue(this);
            }
            if (this.getProgressBarRangeInfo() != null) {
                return new ProgressBarAccessibleValue(this);
            }
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block3: {
                Object object;
                SemanticsNode semanticsNode = this.this$0.getSemanticsNode().getParent();
                Object object2 = object = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (object2 != null) {
                    object = object2;
                    ComposeAccessible composeAccessible = this.this$0;
                    int index$iv = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object3 = object.next();
                        if (((SemanticsNode)(object3 = (SemanticsNode)object3)).getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block3;
                        }
                        ++index$iv;
                    }
                    return -1;
                }
                n = -1;
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.this$0.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Accessible getAccessibleChild(int i) {
            void var3_3;
            void var1_1;
            List<SemanticsNode> replacedChildren = this.this$0.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            if (i < replacedChildrenSize) {
                void var2_2;
                return this.this$0.controller.accessibleByNodeId(((SemanticsNode)var2_2.get(i)).getId());
            }
            return this.getAuxiliaryChildren().get((int)(var1_1 - var3_3));
        }

        @Override
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        public Point getLocationOnScreen() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(composeAccessibleComponent.this$0.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        public Point getLocation() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(composeAccessibleComponent.this$0.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        public Rectangle getBounds() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtRectangle(composeAccessibleComponent.this$0.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        public Dimension getSize() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtDimension-ozmzZPI(composeAccessibleComponent.this$0.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            return !DelegatableNodeKt.requireCoordinator-64DMado(this.this$0.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent();
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Accessible getAccessibleAt(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                Accessible accessible = this.getAccessibleChild(i);
                Object object = accessible != null ? accessible.getAccessibleContext() : null;
                AccessibleComponent child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt((Point)p)) == null) continue;
                p = object;
                return p;
            }
            if (this.contains((Point)var1_1)) {
                return this.this$0;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.FALSE) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke();
            }
        }

        @Override
        public void addFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public AccessibleRole getAccessibleRole() {
            block15: {
                block14: {
                    AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
                    var1_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getRole());
                    var2_2 = Role.Companion.getButton-o7Vup1c();
                    v0 = var1_1;
                    if (!(v0 == null ? false : Role.equals-impl0(v0.unbox-impl(), var2_2))) break block14;
                    v1 = AccessibleRole.PUSH_BUTTON;
                    break block15;
                }
                var2_2 = Role.Companion.getCheckbox-o7Vup1c();
                v2 = var1_1;
                if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), var2_2)) ** GOTO lbl-1000
                var2_2 = Role.Companion.getSwitch-o7Vup1c();
                v3 = var1_1;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), var2_2)) lbl-1000:
                // 2 sources

                {
                    v1 = AccessibleRole.CHECK_BOX;
                } else {
                    var2_2 = Role.Companion.getRadioButton-o7Vup1c();
                    v4 = var1_1;
                    if (v4 == null ? false : Role.equals-impl0(v4.unbox-impl(), var2_2)) {
                        v1 = AccessibleRole.RADIO_BUTTON;
                    } else {
                        var2_2 = Role.Companion.getTab-o7Vup1c();
                        v5 = var1_1;
                        if (v5 == null ? false : Role.equals-impl0(v5.unbox-impl(), var2_2)) {
                            v1 = AccessibleRole.PAGE_TAB;
                        } else {
                            var2_2 = Role.Companion.getDropdownList-o7Vup1c();
                            v6 = var1_1;
                            v1 = (v6 == null ? false : Role.equals-impl0(v6.unbox-impl(), var2_2)) != false ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            var1_1 = v1;
            v7 = v1;
            if (v1 == null) {
                if (this.isPassword()) {
                    v8 = AccessibleRole.PASSWORD_TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"PASSWORD_TEXT");
                    return v8;
                }
                if (this.getScrollBy() != null) {
                    v9 = AccessibleRole.SCROLL_PANE;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"SCROLL_PANE");
                    return v9;
                }
                if (this.getSetText() != null) {
                    v10 = AccessibleRole.TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"TEXT");
                    return v10;
                }
                if (this.getText() != null) {
                    v11 = AccessibleRole.LABEL;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"LABEL");
                    return v11;
                }
                if (this.getProgressBarRangeInfo() != null) {
                    var1_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsActions.INSTANCE.getSetProgress()) != null ? AccessibleRole.SLIDER : AccessibleRole.PROGRESS_BAR;
                    Intrinsics.checkNotNull((Object)var1_1);
                    return var1_1;
                }
                if (this.isContainer() != null) {
                    v12 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"GROUP_BOX");
                    return v12;
                }
                if (this.isTraversalGroup() != null) {
                    v13 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"GROUP_BOX");
                    return v13;
                }
                v14 = AccessibleRole.UNKNOWN;
                v7 = v14;
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"UNKNOWN");
            }
            return v7;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            var1_1 = new AccessibleStateSet();
            var2_2 = this.this$0;
            $this$getAccessibleStateSet_u24lambda_u2413 = var1_1;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.TRUE)) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.FOCUSED);
            }
            canExpand = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig((ComposeAccessible)var2_2), SemanticsActions.INSTANCE.getExpand()) != null ? 1 : 0;
            v0 = canCollapse = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig((ComposeAccessible)var2_2), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand != 0 || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand != 0) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.EXPANDED);
            }
            var2_2 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig((ComposeAccessible)var2_2), SemanticsProperties.INSTANCE.getRole());
            canExpand = Role.Companion.getCheckbox-o7Vup1c();
            v1 = var2_2;
            if (v1 == null ? false : Role.equals-impl0(v1.unbox-impl(), canExpand)) ** GOTO lbl-1000
            canExpand = Role.Companion.getSwitch-o7Vup1c();
            v2 = var2_2;
            if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), canExpand)) lbl-1000:
            // 2 sources

            {
                this.addCheckedStateForCheckboxOrSwitch($this$getAccessibleStateSet_u24lambda_u2413);
            } else {
                canExpand = Role.Companion.getRadioButton-o7Vup1c();
                v3 = var2_2;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), canExpand)) {
                    this.addCheckedStateForRadioButton($this$getAccessibleStateSet_u24lambda_u2413);
                } else {
                    this.addDefaultStateForToggleableState($this$getAccessibleStateSet_u24lambda_u2413);
                    if (this.getSelected() != null) {
                        $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SELECTABLE);
                    }
                    if (Intrinsics.areEqual((Object)this.getSelected(), (Object)Boolean.TRUE)) {
                        $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SELECTED);
                    }
                }
            }
            it = this.getAccessibleRole();
            if (Intrinsics.areEqual((Object)it, (Object)AccessibleRole.SLIDER) != false || Intrinsics.areEqual((Object)it, (Object)AccessibleRole.PROGRESS_BAR) != false) {
                var3_3.add(AccessibleState.HORIZONTAL);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final void addCheckedStateForCheckboxOrSwitch(AccessibleStateSet $this$addCheckedStateForCheckboxOrSwitch) {
            void var1_1;
            this.addDefaultStateForToggleableState((AccessibleStateSet)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final void addCheckedStateForRadioButton(AccessibleStateSet $this$addCheckedStateForRadioButton) {
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)Boolean.TRUE)) {
                void var1_1;
                var1_1.add(AccessibleState.CHECKED);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void addDefaultStateForToggleableState(AccessibleStateSet $this$addDefaultStateForToggleableState) {
            AccessibleState accessibleState;
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    accessibleState = AccessibleState.CHECKED;
                    break;
                }
                case 2: {
                    accessibleState = AccessibleState.INDETERMINATE;
                    break;
                }
                case -1: 
                case 3: {
                    accessibleState = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AccessibleState state = accessibleState;
            if (accessibleState != null) {
                void var2_2;
                void var1_1;
                var1_1.add((AccessibleState)var2_2);
            }
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText = this.getAccessibleText();
            if (accessibleText instanceof AccessibleEditableText) {
                void var1_1;
                return (AccessibleEditableText)var1_1;
            }
            return null;
        }

        @Override
        public void setBounds(Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setSize(Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setLocation(Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setBackground(Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setForeground(Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setCursor(Cursor cursor) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setFont(Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                return accessibleAction.getAccessibleActionCount();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getAccessibleActionDescription(int i) {
            void var1_1;
            Object object = this.accessibleAction;
            if (object == null || (object = object.getAccessibleActionDescription((int)var1_1)) == null) {
                object = "";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                void var1_1;
                return accessibleAction.doAccessibleAction((int)var1_1);
            }
            return false;
        }

        private final String mergeText(List<? extends CharSequence> $this$mergeText) {
            return CollectionsKt.joinToString$default((Iterable)$this$mergeText, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key);
            if (accessibilityAction != null) {
                void var2_2;
                AccessibilityAction<Function0<Boolean>> accessibilityAction2;
                void var1_1;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                var1_1.add(new Pair((Object)accessibilityAction2.getLabel(), (Object)var2_2));
                return;
            }
        }

        private static final ComposeAccessibleText accessibleText_delegate$lambda$14(ComposeAccessibleComponent this$0) {
            if (this$0.getSetText() != null) {
                return this$0.new ComposeAccessibleEditableText();
            }
            if (this$0.getText() != null) {
                ComposeAccessibleComponent composeAccessibleComponent;
                return new ComposeAccessibleText(composeAccessibleComponent);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ long access$toComposeOffset-tuRUvjQ(ComposeAccessibleComponent $this, Point $receiver) {
            void var1_1;
            return $this.toComposeOffset-tuRUvjQ((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Rectangle access$toAwtRectangle(ComposeAccessibleComponent $this, Rect $receiver) {
            void var1_1;
            return $this.toAwtRectangle((Rect)var1_1);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0015J)\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001f"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "", "s", "", "setTextContents", "(Ljava/lang/String;)V", "", "index", "insertTextAtIndex", "(ILjava/lang/String;)V", "startIndex", "endIndex", "getTextRange", "(II)Ljava/lang/String;", "delete", "(II)V", "cut", "paste", "(I)V", "replaceText", "(IILjava/lang/String;)V", "selectText", "Ljavax/swing/text/AttributeSet;", "as", "setAttributes", "(IILjavax/swing/text/AttributeSet;)V"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,936:1\n1580#2:937\n1580#2:938\n1580#2:939\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n717#1:937\n732#1:938\n750#1:939\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleEditableText() {
                void var1_1;
                super((ComposeAccessibleComponent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setTextContents(String s) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString((String)var1_1, null, 2, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void insertTextAtIndex(int index, String s) {
                void var3_3;
                void var1_1;
                void var2_2;
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index));
                $this$insertTextAtIndex_u24lambda_u240.append((String)var2_2);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence((int)var1_1, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence((int)var1_1, (int)var2_2)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void delete(int startIndex, int endIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$delete_u24lambda_u241.append(text.subSequence(0, (int)var1_1));
                $this$delete_u24lambda_u241.append(text.subSequence((int)var2_2, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public final void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public final void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void replaceText(int startIndex, int endIndex, String s) {
                void var2_2;
                void var3_3;
                void var1_1;
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, (int)var1_1));
                $this$replaceText_u24lambda_u242.append((String)var3_3);
                $this$replaceText_u24lambda_u242.append(text.subSequence((int)var2_2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void selectText(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)((int)var1_1), (Object)((int)var2_2), (Object)Boolean.FALSE);
            }

            @Override
            public final void setAttributes(int startIndex, int endIndex, AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u000fJ\u000f\u0010\u001f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000fJ\u000f\u0010 \u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b \u0010!J\u001f\u0010$\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b$\u0010\u0018J\u001f\u0010&\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b(\u0010'J\u001f\u0010)\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b)\u0010'J\u001f\u0010*\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b*\u0010+"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "Ljava/awt/Point;", "p", "", "getIndexAtPoint", "(Ljava/awt/Point;)I", "i", "Ljava/awt/Rectangle;", "getCharacterBounds", "(I)Ljava/awt/Rectangle;", "getCharCount", "()I", "getCaretPosition", "part", "Lorg/jetbrains/skia/BreakIterator;", "partToBreakIterator", "(I)Lorg/jetbrains/skia/BreakIterator;", "index", "", "getAtIndex", "(II)Ljava/lang/String;", "getAfterIndex", "getBeforeIndex", "Ljavax/swing/text/AttributeSet;", "getCharacterAttribute", "(I)Ljavax/swing/text/AttributeSet;", "getSelectionStart", "getSelectionEnd", "getSelectedText", "()Ljava/lang/String;", "startIndex", "endIndex", "getTextRange", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAt", "(II)Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAfter", "getTextSequenceBefore", "getTextBounds", "(II)Ljava/awt/Rectangle;"})
        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleText(ComposeAccessibleComponent this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getIndexAtPoint(Point p) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.access$toComposeOffset-tuRUvjQ(this.this$0, (Point)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Rectangle getCharacterBounds(int i) {
                void var1_1;
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        CharSequence charSequence = this.this$0.getText();
                        Intrinsics.checkNotNull((Object)charSequence);
                        if (i < charSequence.length()) break block3;
                    }
                    return new Rectangle((int)((float)this.this$0.getLocation().x / this.this$0.getDensity().getDensity()), (int)((float)this.this$0.getLocation().y / this.this$0.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.access$toAwtRectangle(this.this$0, textLayoutResult.getBoundingBox((int)var1_1));
            }

            @Override
            public int getCharCount() {
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return charSequence.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            private final BreakIterator partToBreakIterator(int part) {
                void var1_2;
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                breakIterator.setText(((Object)charSequence).toString());
                return var1_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAtIndex(int part, int index) {
                void var1_1;
                void var2_2;
                int end = this.partToBreakIterator(part).following(index);
                if (end == -1) {
                    return "";
                }
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence((int)var2_2, (int)var1_1)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAfterIndex(int part, int index) {
                void var1_3;
                void var2_4;
                void var3_5;
                BreakIterator iterator2 = this.partToBreakIterator(part);
                while (true) {
                    int start;
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    CharSequence charSequence = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    if (charSequence.charAt(start) == ' ') continue;
                    CharSequence charSequence2 = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)charSequence2);
                    if (charSequence2.charAt(start) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : var3_5;
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence((int)var2_4, (int)var1_3)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getBeforeIndex(int part, int index) {
                void var2_2;
                void var1_1;
                int start = this.partToBreakIterator(part).preceding(index);
                if (start == -1) {
                    return "";
                }
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence((int)var1_1, (int)var2_2)).toString();
            }

            @Override
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getEnd-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        void var3_3;
                        object = this.this$0.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = this.this$0;
                        long selection = textRange.unbox-impl();
                        CharSequence charSequence = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)charSequence);
                        object = ((Object)charSequence.subSequence(TextRange.getStart-impl((long)selection), TextRange.getEnd-impl((long)var3_3))).toString();
                        if (object != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                CharSequence charSequence = this.this$0.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence((int)var1_1, (int)var2_2)).toString();
            }

            @Override
            public AccessibleTextSequence getTextSequenceAt(int part, int index) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\b"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "", "vertical", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "Ljavax/accessibility/AccessibleContext;", "getAccessibleContext", "()Ljavax/accessibility/AccessibleContext;", "Z", "getVertical", "()Z", "context", "Ljavax/accessibility/AccessibleContext;", "getContext"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            private final AccessibleContext context;
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ScrollBarAccessible(ComposeAccessibleComponent this$0, boolean vertical) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.vertical = var2_2;
                ScrollBarAccessible scrollBarAccessible = this;
                this.context = (AccessibleContext)((Object)new AccessibleValue(scrollBarAccessible, scrollBarAccessible.this$0, this.this$0.this$0){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        void var1_1;
                        void var3_3;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = var3_3;
                        if (var1_1.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            void var2_2;
                            ScrollAxisRange scrollAxisRange3 = var2_2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public final AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public final AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        if (scrollBarAccessible.getVertical()) {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL);
                        } else {
                            void var3_3;
                            var3_3.add(AccessibleState.HORIZONTAL);
                        }
                        return accessibleStateSet;
                    }

                    public final Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public final int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public final int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public final Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    public final Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    public final Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean setCurrentAccessibleValue(Number n) {
                        void var1_1;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            return (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        }
                        AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                        Intrinsics.checkNotNull(accessibilityAction);
                        Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                        Intrinsics.checkNotNull(function2);
                        void v6 = var1_1;
                        Intrinsics.checkNotNull((Object)v6);
                        return (Boolean)function2.invoke((Object)Float.valueOf(v6.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                    }

                    public final Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public final Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            public final AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

