/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JM\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0014J!\u0010\u0019\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010%\u001a\u00020\r2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\r2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b'\u0010&J\u0017\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-R\u0018\u0010.\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001c\u00101\u001a\u0002008\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u001c\u00105\u001a\u0002008\u0006@\u0006X\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u00102\"\u0004\b6\u00107"}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService;", "Landroidx/compose/ui/text/input/PlatformTextInputService;", "Landroidx/compose/ui/platform/PlatformComponent;", "component", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;)V", "Landroidx/compose/ui/text/input/TextFieldValue;", "value", "Landroidx/compose/ui/text/input/ImeOptions;", "imeOptions", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onEditCommand", "Landroidx/compose/ui/text/input/ImeAction;", "onImeActionPerformed", "startInput", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/ImeOptions;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "stopInput", "()V", "showSoftwareKeyboard", "hideSoftwareKeyboard", "oldValue", "newValue", "updateState", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/TextFieldValue;)V", "Landroidx/compose/ui/geometry/Rect;", "rect", "notifyFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "Ljava/awt/event/KeyEvent;", "keyEvent", "onKeyEvent", "(Ljava/awt/event/KeyEvent;)V", "Ljava/awt/event/InputMethodEvent;", "event", "inputMethodTextChanged", "(Ljava/awt/event/InputMethodEvent;)V", "replaceInputMethodText", "Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "input", "Landroidx/compose/ui/platform/DesktopTextInputService$methodRequestsForInput$1;", "methodRequestsForInput", "(Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;)Landroidx/compose/ui/platform/DesktopTextInputService$methodRequestsForInput$1;", "Landroidx/compose/ui/platform/PlatformComponent;", "currentInput", "Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "", "charKeyPressed", "Z", "getCharKeyPressed", "()Z", "needToDeletePreviousChar", "setNeedToDeletePreviousChar", "(Z)V", "CurrentInput"})
public final class DesktopTextInputService
implements PlatformTextInputService {
    private final PlatformComponent component;
    private CurrentInput currentInput;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DesktopTextInputService(PlatformComponent component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = var1_1;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNeedToDeletePreviousChar(boolean bl) {
        void var1_1;
        this.needToDeletePreviousChar = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void startInput(TextFieldValue value, ImeOptions imeOptions, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed) {
        void var1_1;
        void var2_2;
        void var3_3;
        CurrentInput input;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
        this.currentInput = input = new CurrentInput(value, (Function1)var3_3, onImeActionPerformed, var2_2.getImeAction-eUduSuo(), null, 16, null);
        this.component.enableInput(this.methodRequestsForInput((CurrentInput)var1_1));
    }

    public final void stopInput() {
        if (this.currentInput == null) {
            return;
        }
        this.component.disableInput();
        this.currentInput = null;
    }

    public final void showSoftwareKeyboard() {
    }

    public final void hideSoftwareKeyboard() {
    }

    /*
     * WARNING - void declaration
     */
    public final void updateState(TextFieldValue oldValue, TextFieldValue newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            void var2_2;
            currentInput.setValue((TextFieldValue)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyFocusedRect(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        CurrentInput currentInput = this.currentInput;
        if (currentInput != null) {
            void var1_1;
            currentInput.setFocusedRect((Rect)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onKeyEvent(KeyEvent keyEvent) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        switch (var1_1.getID()) {
            case 400: {
                this.charKeyPressed = true;
                return;
            }
            case 402: {
                this.charKeyPressed = false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void inputMethodTextChanged(InputMethodEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.currentInput != null && !event.isConsumed()) {
            void var1_1;
            this.replaceInputMethodText(event);
            var1_1.consume();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceInputMethodText(InputMethodEvent event) {
        void var2_2;
        void var3_3;
        CurrentInput currentInput = this.currentInput;
        if (currentInput == null) {
            return;
        }
        CurrentInput input = currentInput;
        String committed = DesktopTextInputService2Kt.getCommittedText(event);
        String composing = DesktopTextInputService2Kt.getComposingText(event);
        List ops = new ArrayList();
        if (this.needToDeletePreviousChar && TextRange.getMin-impl((long)input.getValue().getSelection-d9O1mEE()) > 0 && ((CharSequence)composing).length() == 0) {
            this.needToDeletePreviousChar = false;
            ops.add(new DeleteSurroundingTextInCodePointsCommand(1, 0));
        }
        ops.add(new CommitTextCommand((String)var3_3, 1));
        if (((CharSequence)composing).length() > 0) {
            void var1_1;
            ops.add(new SetComposingTextCommand((String)var1_1, 1));
        }
        var2_2.getOnEditCommand().invoke((Object)ops);
    }

    /*
     * WARNING - void declaration
     */
    private final methodRequestsForInput.1 methodRequestsForInput(CurrentInput input) {
        void var1_1;
        return new InputMethodRequests((CurrentInput)var1_1, this){
            final /* synthetic */ CurrentInput $input;
            final /* synthetic */ DesktopTextInputService this$0;
            {
                void var2_2;
                void var1_1;
                this.$input = var1_1;
                this.this$0 = var2_2;
            }

            public final TextHitInfo getLocationOffset(int x, int y) {
                if (this.$input.getValue().getComposition-MzsxiRA() != null) {
                    return TextHitInfo.leading(0);
                }
                return null;
            }

            public final AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final int getInsertPositionOffset() {
                void var1_1;
                void var2_2;
                void var3_3;
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                int composedStartIndex = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
                TextRange textRange2 = this.$input.getValue().getComposition-MzsxiRA();
                int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
                int caretIndex = TextRange.getStart-impl((long)this.$input.getValue().getSelection-d9O1mEE());
                if (caretIndex < composedStartIndex) {
                    return caretIndex;
                }
                if (caretIndex < composedEndIndex) {
                    return composedStartIndex;
                }
                return (int)(var3_3 - (var2_2 - var1_1));
            }

            public final int getCommittedTextLength() {
                TextRange textRange = this.$input.getValue().getComposition-MzsxiRA();
                return this.$input.getValue().getText().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
                void var1_1;
                if (this.this$0.getCharKeyPressed() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                    this.this$0.setNeedToDeletePreviousChar(true);
                }
                String str = TextRangeKt.substring-FDrldGo((CharSequence)this.$input.getValue().getText(), (long)this.$input.getValue().getSelection-d9O1mEE());
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_1).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }

            /*
             * WARNING - void declaration
             */
            public final Rectangle getTextLocation(TextHitInfo offset) {
                Rect rect = this.$input.getFocusedRect();
                if (rect != null) {
                    void var2_4;
                    void var3_5;
                    void var1_1;
                    offset = rect;
                    DesktopTextInputService desktopTextInputService = this.this$0;
                    TextHitInfo it = offset;
                    int x = (int)(it.getRight() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().x;
                    int y = (int)(it.getTop() / DesktopTextInputService.access$getComponent$p(desktopTextInputService).getDensity().getDensity()) + DesktopTextInputService.access$getComponent$p((DesktopTextInputService)desktopTextInputService).getLocationOnScreen().y;
                    TextHitInfo this_$iv = it;
                    int n = (int)(this_$iv.getRight() - this_$iv.getLeft());
                    this_$iv = var1_1;
                    return new Rectangle((int)var3_5, y, n, (int)(this_$iv.getBottom() - var2_4.getTop()));
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
                void var1_3;
                void var3_5;
                void var2_4;
                TextRange comp = this.$input.getValue().getComposition-MzsxiRA();
                String text = this.$input.getValue().getText();
                long range = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)beginIndex, (int)text.length()), (int)RangesKt.coerceAtMost((int)var2_4, (int)text.length()));
                if (comp == null) {
                    String res = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)range);
                    AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
                    Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                    return attributedCharacterIterator;
                }
                String committed = TextRangeKt.substring-FDrldGo((CharSequence)text, (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)range), TextRange.getMin-impl((long)comp.unbox-impl())), (int)text.length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)range), TextRange.getMax-impl((long)var3_5.unbox-impl())), (int)text.length())));
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)var1_3).getIterator();
                Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
                return attributedCharacterIterator;
            }
        };
    }

    public static final /* synthetic */ PlatformComponent access$getComponent$p(DesktopTextInputService $this) {
        return $this.component;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR)\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\t8\u0006\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\"R$\u0010\r\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'"}, d2={"Landroidx/compose/ui/platform/DesktopTextInputService$CurrentInput;", "", "Landroidx/compose/ui/text/input/TextFieldValue;", "value", "Lkotlin/Function1;", "", "Landroidx/compose/ui/text/input/EditCommand;", "", "onEditCommand", "Landroidx/compose/ui/text/input/ImeAction;", "onImeActionPerformed", "imeAction", "Landroidx/compose/ui/geometry/Rect;", "focusedRect", "<init>", "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ILandroidx/compose/ui/geometry/Rect;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Landroidx/compose/ui/text/input/TextFieldValue;", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "Lkotlin/jvm/functions/Function1;", "getOnEditCommand", "()Lkotlin/jvm/functions/Function1;", "I", "Landroidx/compose/ui/geometry/Rect;", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V"})
    public static final class CurrentInput {
        private TextFieldValue value;
        private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
        public final Function1<ImeAction, Unit> onImeActionPerformed;
        public final int imeAction;
        private Rect focusedRect;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        private CurrentInput(TextFieldValue value, Function1<? super List<? extends EditCommand>, Unit> onEditCommand, Function1<? super ImeAction, Unit> onImeActionPerformed, int imeAction, Rect focusedRect) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            this.value = var1_1;
            this.onEditCommand = var2_2;
            this.onImeActionPerformed = var3_3;
            this.imeAction = imeAction;
            this.focusedRect = focusedRect;
        }

        public /* synthetic */ CurrentInput(TextFieldValue textFieldValue, Function1 function1, Function1 function12, int n, Rect rect, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                rect = null;
            }
            this(textFieldValue, function1, function12, n, rect, null);
        }

        public final TextFieldValue getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void setValue(TextFieldValue textFieldValue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = var1_1;
        }

        public final Function1<List<? extends EditCommand>, Unit> getOnEditCommand() {
            return this.onEditCommand;
        }

        public final Rect getFocusedRect() {
            return this.focusedRect;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFocusedRect(Rect rect) {
            void var1_1;
            this.focusedRect = var1_1;
        }

        public final String toString() {
            return "CurrentInput(value=" + this.value + ", onEditCommand=" + this.onEditCommand + ", onImeActionPerformed=" + this.onImeActionPerformed + ", imeAction=" + ImeAction.toString-impl((int)this.imeAction) + ", focusedRect=" + this.focusedRect + ")";
        }

        public final int hashCode() {
            int n = this.value.hashCode();
            n = n * 31 + this.onEditCommand.hashCode();
            n = n * 31 + this.onImeActionPerformed.hashCode();
            n = n * 31 + ImeAction.hashCode-impl((int)this.imeAction);
            n = n * 31 + (this.focusedRect == null ? 0 : this.focusedRect.hashCode());
            return n;
        }

        public final boolean equals(Object other) {
            CurrentInput currentInput;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CurrentInput)) {
                return false;
            }
            currentInput = currentInput;
            if (!Intrinsics.areEqual((Object)this.value, (Object)currentInput.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onEditCommand, currentInput.onEditCommand)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onImeActionPerformed, currentInput.onImeActionPerformed)) {
                return false;
            }
            if (!ImeAction.equals-impl0((int)this.imeAction, (int)currentInput.imeAction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.focusedRect, (Object)currentInput.focusedRect);
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ CurrentInput(TextFieldValue value, Function1 onEditCommand, Function1 onImeActionPerformed, int imeAction, Rect focusedRect, DefaultConstructorMarker $constructor_marker) {
            this((TextFieldValue)var1_1, (Function1<? super List<? extends EditCommand>, Unit>)var2_2, (Function1<? super ImeAction, Unit>)var3_3, imeAction, focusedRect);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

