/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableScatterMap;
import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.collection.ScatterSetKt;
import androidx.compose.ui.layout.Ruler;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LookaheadCapablePlaceable;
import androidx.compose.ui.node.WeakReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122 \u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u0003R\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)"}, d2={"Landroidx/compose/ui/node/RulerTrackingMap;", "", "<init>", "()V", "Landroidx/compose/ui/layout/Ruler;", "ruler", "", "defaultValue", "getOrDefault", "(Landroidx/compose/ui/layout/Ruler;F)F", "value", "", "set", "(Landroidx/compose/ui/layout/Ruler;F)V", "", "contains", "(Landroidx/compose/ui/layout/Ruler;)Z", "isLookingAhead", "Landroidx/compose/ui/node/LookaheadCapablePlaceable;", "node", "Landroidx/collection/MutableScatterMap;", "Landroidx/collection/MutableScatterSet;", "Landroidx/compose/ui/node/WeakReference;", "Landroidx/compose/ui/node/LayoutNode;", "rulerReaders", "notifyChanged", "(ZLandroidx/compose/ui/node/LookaheadCapablePlaceable;Landroidx/collection/MutableScatterMap;)V", "clear", "", "size", "I", "", "rulers", "[Landroidx/compose/ui/layout/Ruler;", "", "values", "[F", "", "accessFlags", "[B", "layoutNodes", "Landroidx/collection/MutableScatterSet;", "newRulers"})
@SourceDebugExtension(value={"SMAP\nLookaheadDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/RulerTrackingMap\n+ 2 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,686:1\n231#2,3:687\n200#2,7:690\n211#2,3:698\n214#2,9:702\n234#2:711\n231#2,3:712\n200#2,7:715\n211#2,3:723\n214#2,9:727\n234#2:736\n1399#3:697\n1270#3:701\n1399#3:722\n1270#3:726\n*S KotlinDebug\n*F\n+ 1 LookaheadDelegate.kt\nandroidx/compose/ui/node/RulerTrackingMap\n*L\n639#1:687,3\n639#1:690,7\n639#1:698,3\n639#1:702,9\n639#1:711\n646#1:712,3\n646#1:715,7\n646#1:723,3\n646#1:727,9\n646#1:736\n639#1:697\n639#1:701\n646#1:722\n646#1:726\n*E\n"})
final class RulerTrackingMap {
    private int size;
    private Ruler[] rulers = new Ruler[32];
    private float[] values = new float[32];
    private byte[] accessFlags = new byte[32];
    private MutableScatterSet<WeakReference<LayoutNode>> layoutNodes = ScatterSetKt.mutableScatterSetOf();
    private final MutableScatterSet<Ruler> newRulers = ScatterSetKt.mutableScatterSetOf();

    /*
     * WARNING - void declaration
     */
    public final float getOrDefault(Ruler ruler, float defaultValue) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        int index = ArraysKt.indexOf((Object[])this.rulers, (Object)ruler);
        if (index < 0) {
            void var2_3;
            return (float)var2_3;
        }
        return this.values[var1_2];
    }

    /*
     * WARNING - void declaration
     */
    public final void set(Ruler ruler, float value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        int index = ArraysKt.indexOf((Object[])this.rulers, (Object)ruler);
        if (index < 0) {
            void var1_1;
            int newIndex = this.size;
            if (newIndex == this.rulers.length) {
                int newSize = newIndex << 1;
                Ruler[] rulerArray = Arrays.copyOf(this.rulers, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)rulerArray, (String)"copyOf(...)");
                this.rulers = rulerArray;
                float[] fArray = Arrays.copyOf(this.values, newSize);
                Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
                this.values = fArray;
                byte[] byArray = Arrays.copyOf(this.accessFlags, n);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                this.accessFlags = byArray;
            }
            this.rulers[newIndex] = var1_1;
            this.accessFlags[newIndex] = 3;
            this.values[newIndex] = value;
            n = this.size;
            this.size = n + 1;
            return;
        }
        float f = this.values[n];
        if (!(f == value)) {
            void var2_2;
            this.values[n] = var2_2;
            this.accessFlags[n] = 1;
            return;
        }
        if (this.accessFlags[n] == 2) {
            this.accessFlags[n] = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Ruler ruler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)ruler, (String)"ruler");
        return ArraysKt.contains((Object[])this.rulers, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyChanged(boolean isLookingAhead, LookaheadCapablePlaceable node, MutableScatterMap<Ruler, MutableScatterSet<WeakReference<LayoutNode>>> rulerReaders) {
        long l;
        int j$iv$iv;
        int bitCount$iv$iv;
        long $this$maskEmptyOrDeleted$iv$iv$iv;
        long slot$iv$iv;
        int access;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            access = this.accessFlags[i];
            if (access == 3) {
                Ruler ruler = this.rulers[i];
                Intrinsics.checkNotNull((Object)ruler);
                this.newRulers.plusAssign((Object)ruler);
                continue;
            }
            if (access == 0 || rulerReaders == null) continue;
            Ruler ruler = this.rulers[i];
            Intrinsics.checkNotNull((Object)ruler);
            MutableScatterSet readers = (MutableScatterSet)rulerReaders.remove((Object)ruler);
            if (readers == null) continue;
            this.layoutNodes.plusAssign((ScatterSet)readers);
        }
        int removed22 = 0;
        access = this.size;
        for (int sourceIndex = 0; sourceIndex < access; ++sourceIndex) {
            if (this.accessFlags[sourceIndex] == 2) {
                ++removed22;
            } else if (removed22 > 0) {
                int destIndex = sourceIndex - removed22;
                this.rulers[destIndex] = this.rulers[sourceIndex];
            }
            this.accessFlags[sourceIndex] = 2;
        }
        access = this.size;
        for (int i = this.size - removed22; i < access; ++i) {
            this.rulers[i] = null;
        }
        this.size -= removed22;
        LookaheadCapablePlaceable parent = node.getParent();
        ScatterSet this_$iv = (ScatterSet)this.newRulers;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet removed22 = this_$iv;
        Object m$iv$iv = removed22.metadata;
        int lastIndex$iv$iv = removed22.metadata.length - 2;
        int i$iv$iv = 0;
        if (lastIndex$iv$iv >= 0) {
            while (true) {
                if ((slot$iv$iv & (($this$maskEmptyOrDeleted$iv$iv$iv = (slot$iv$iv = m$iv$iv[i$iv$iv])) ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        l = slot$iv$iv & 0xFFL;
                        if (l < 128L) {
                            int n2;
                            int index$iv = n2 = (i$iv$iv << 3) + j$iv$iv;
                            Ruler ruler = (Ruler)elements$iv[index$iv];
                            LookaheadCapablePlaceable lookaheadCapablePlaceable = parent;
                            if (lookaheadCapablePlaceable == null) {
                                lookaheadCapablePlaceable = node;
                            }
                            lookaheadCapablePlaceable.invalidateChildrenOfDefiningRuler$ui(ruler);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.newRulers.clear();
        this_$iv = (ScatterSet)this.layoutNodes;
        elements$iv = this_$iv.elements;
        ScatterSet scatterSet = this_$iv;
        m$iv$iv = scatterSet;
        m$iv$iv = scatterSet.metadata;
        lastIndex$iv$iv = scatterSet.metadata.length - 2;
        i$iv$iv = 0;
        if (lastIndex$iv$iv >= 0) {
            while (true) {
                if ((slot$iv$iv & (($this$maskEmptyOrDeleted$iv$iv$iv = (slot$iv$iv = m$iv$iv[i$iv$iv])) ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        int ruler;
                        int index$iv;
                        WeakReference weakReference;
                        l = slot$iv$iv & 0xFFL;
                        if (l < 128L && (LayoutNode)(weakReference = (WeakReference)elements$iv[index$iv = (ruler = (i$iv$iv << 3) + j$iv$iv)]).get() != null) {
                            if (isLookingAhead) {
                                LayoutNode layoutNode;
                                layoutNode.requestLookaheadRelayout$ui(false);
                            } else {
                                void var2_2;
                                var2_2.requestRelayout$ui(false);
                            }
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.layoutNodes.clear();
    }

    public final void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.rulers[i] = null;
            this.values[i] = Float.NaN;
            this.accessFlags[i] = 0;
        }
        this.size = 0;
    }
}

