/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u000f*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001a"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "Landroidx/compose/ui/node/LayoutNode;", "root", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "relayoutNodes", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "postponedMeasureRequests", "<init>", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;Ljava/util/List;)V", "", "assertConsistent", "()V", "node", "", "isTreeConsistent", "(Landroidx/compose/ui/node/LayoutNode;)Z", "consistentLayoutState", "", "nodeToString", "(Landroidx/compose/ui/node/LayoutNode;)Ljava/lang/String;", "logTree", "()Ljava/lang/String;", "Landroidx/compose/ui/node/LayoutNode;", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "Ljava/util/List;"})
@SourceDebugExtension(value={"SMAP\nLayoutTreeConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,154:1\n35#2,5:155\n118#2:160\n35#2,5:161\n119#2:166\n103#2:167\n35#2,5:168\n104#2:173\n118#2:174\n35#2,5:175\n119#2:180\n35#2,5:181\n*S KotlinDebug\n*F\n+ 1 LayoutTreeConsistencyChecker.kt\nandroidx/compose/ui/node/LayoutTreeConsistencyChecker\n*L\n45#1:155,5\n59#1:160\n59#1:161,5\n59#1:166\n86#1:167\n86#1:168,5\n86#1:173\n93#1:174\n93#1:175,5\n93#1:180\n147#1:181,5\n*E\n"})
public final class LayoutTreeConsistencyChecker {
    private final LayoutNode root;
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public LayoutTreeConsistencyChecker(LayoutNode root, DepthSortedSetsForDifferentPasses relayoutNodes, List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relayoutNodes, (String)"relayoutNodes");
        Intrinsics.checkNotNullParameter(postponedMeasureRequests, (String)"postponedMeasureRequests");
        this.root = var1_1;
        this.relayoutNodes = var2_2;
        this.postponedMeasureRequests = var3_3;
    }

    public final void assertConsistent() {
        LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this;
        boolean bl = !layoutTreeConsistencyChecker.isTreeConsistent(layoutTreeConsistencyChecker.root);
        if (bl) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node) {
        if (!this.consistentLayoutState(node)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            LayoutNode layoutNode = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = layoutNode;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        block31: {
            LayoutNode.LayoutState parentLayoutState;
            LayoutNode parent;
            block32: {
                block34: {
                    block33: {
                        MeasureAndLayoutDelegate.PostponedRequest it;
                        MeasureAndLayoutDelegate.PostponedRequest it$iv;
                        int index$iv$iv;
                        int n;
                        List<MeasureAndLayoutDelegate.PostponedRequest> $this$fastForEach$iv$iv;
                        block25: {
                            block30: {
                                block29: {
                                    boolean bl;
                                    block22: {
                                        block26: {
                                            block28: {
                                                block27: {
                                                    block24: {
                                                        parent = $this$consistentLayoutState.getParent$ui();
                                                        LayoutNode.LayoutState layoutState = parentLayoutState = parent != null ? parent.getLayoutState$ui() : null;
                                                        if ($this$consistentLayoutState.isPlaced()) break block24;
                                                        if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block25;
                                                        LayoutNode layoutNode = parent;
                                                        boolean bl2 = layoutNode != null ? layoutNode.isPlaced() : false;
                                                        if (!bl2) break block25;
                                                    }
                                                    if ($this$consistentLayoutState.getMeasurePending$ui()) {
                                                        MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                                                        block21: {
                                                            List<MeasureAndLayoutDelegate.PostponedRequest> list;
                                                            $this$fastForEach$iv$iv = list = this.postponedMeasureRequests;
                                                            n = ((Collection)$this$fastForEach$iv$iv).size();
                                                            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                                                MeasureAndLayoutDelegate.PostponedRequest postponedRequest2;
                                                                it$iv = postponedRequest2 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                                                it = postponedRequest2;
                                                                if (!(Intrinsics.areEqual((Object)postponedRequest2.getNode(), (Object)$this$consistentLayoutState) && !it.isLookahead())) continue;
                                                                postponedRequest = it$iv;
                                                                break block21;
                                                            }
                                                            postponedRequest = null;
                                                        }
                                                        if (postponedRequest != null) {
                                                            return true;
                                                        }
                                                    }
                                                    if ($this$consistentLayoutState.isDeactivated()) {
                                                        return true;
                                                    }
                                                    if (!$this$consistentLayoutState.getMeasurePending$ui()) break block26;
                                                    if (this.relayoutNodes.contains($this$consistentLayoutState) || $this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) break block27;
                                                    LayoutNode layoutNode = parent;
                                                    if (layoutNode != null ? layoutNode.getMeasurePending$ui() : false) break block27;
                                                    LayoutNode layoutNode2 = parent;
                                                    boolean bl3 = layoutNode2 != null ? layoutNode2.getLookaheadMeasurePending$ui() : false;
                                                    if (!bl3 && parentLayoutState != LayoutNode.LayoutState.Measuring) break block28;
                                                }
                                                return true;
                                            }
                                            return false;
                                        }
                                        if (!$this$consistentLayoutState.getLayoutPending$ui()) break block25;
                                        if (this.relayoutNodes.contains($this$consistentLayoutState) || parent == null || parent.getMeasurePending$ui() || parent.getLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.Measuring || parentLayoutState == LayoutNode.LayoutState.LayingOut) break block29;
                                        $this$fastForEach$iv$iv = this.postponedMeasureRequests;
                                        n = ((Collection)$this$fastForEach$iv$iv).size();
                                        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest = $this$fastForEach$iv$iv.get(index$iv$iv);
                                            it$iv = postponedRequest;
                                            it$iv = postponedRequest;
                                            it = postponedRequest;
                                            if (!Intrinsics.areEqual((Object)postponedRequest.getNode(), (Object)$this$consistentLayoutState)) continue;
                                            bl = true;
                                            break block22;
                                        }
                                        bl = false;
                                    }
                                    if (!bl && $this$consistentLayoutState.getLayoutState$ui() != LayoutNode.LayoutState.Measuring) break block30;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (!Intrinsics.areEqual((Object)$this$consistentLayoutState.isPlacedInLookahead(), (Object)Boolean.TRUE)) break block31;
                        if ($this$consistentLayoutState.getLookaheadMeasurePending$ui()) {
                            MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
                            block23: {
                                $this$fastForEach$iv$iv = this.postponedMeasureRequests;
                                n = ((Collection)$this$fastForEach$iv$iv).size();
                                for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                    MeasureAndLayoutDelegate.PostponedRequest postponedRequest3 = $this$fastForEach$iv$iv.get(index$iv$iv);
                                    it$iv = postponedRequest3;
                                    it$iv = postponedRequest3;
                                    it = postponedRequest3;
                                    if (!(Intrinsics.areEqual((Object)postponedRequest3.getNode(), (Object)$this$consistentLayoutState) && it.isLookahead())) continue;
                                    postponedRequest = it$iv;
                                    break block23;
                                }
                                postponedRequest = null;
                            }
                            if (postponedRequest != null) {
                                return true;
                            }
                        }
                        if (!$this$consistentLayoutState.getLookaheadMeasurePending$ui()) break block32;
                        if (this.relayoutNodes.contains($this$consistentLayoutState, true)) break block33;
                        LayoutNode layoutNode = parent;
                        if ((layoutNode != null ? layoutNode.getLookaheadMeasurePending$ui() : false) || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring) break block33;
                        LayoutNode layoutNode3 = parent;
                        boolean bl = layoutNode3 != null ? layoutNode3.getMeasurePending$ui() : false;
                        if (!bl || !Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)$this$consistentLayoutState)) break block34;
                    }
                    return true;
                }
                return false;
            }
            if ($this$consistentLayoutState.getLookaheadLayoutPending$ui()) {
                void var1_1;
                void var2_2;
                void var3_3;
                return this.relayoutNodes.contains($this$consistentLayoutState, true) || parent == null || parent.getLookaheadMeasurePending$ui() || parent.getLookaheadLayoutPending$ui() || parentLayoutState == LayoutNode.LayoutState.LookaheadMeasuring || var3_3 == LayoutNode.LayoutState.LookaheadLayingOut || var2_2.getLayoutPending$ui() && Intrinsics.areEqual((Object)$this$consistentLayoutState.getLookaheadRoot$ui(), (Object)var1_1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final String nodeToString(LayoutNode node) {
        void var2_2;
        void var1_1;
        StringBuilder $this$nodeToString_u24lambda_u244 = new StringBuilder();
        $this$nodeToString_u24lambda_u244.append(node);
        $this$nodeToString_u24lambda_u244.append("[" + node.getLayoutState$ui() + "]");
        if (!node.isPlaced()) {
            $this$nodeToString_u24lambda_u244.append("[!isPlaced]");
        }
        $this$nodeToString_u24lambda_u244.append("[measuredByParent=" + node.getMeasuredByParent$ui() + "]");
        if (!this.consistentLayoutState((LayoutNode)var1_1)) {
            $this$nodeToString_u24lambda_u244.append("[INCONSISTENT]");
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String logTree() {
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree state:\n");
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node, int depth) {
        int childrenDepth = depth;
        Object nodeRepresentation = this$0.nodeToString(node);
        if (((CharSequence)nodeRepresentation).length() > 0) {
            for (int i = 0; i < depth; ++i) {
                stringBuilder.append("..");
            }
            stringBuilder.append((String)nodeRepresentation).append('\n');
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            nodeRepresentation = $this$fastForEach$iv.get(index$iv);
            LayoutNode it = nodeRepresentation;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

