/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.ObjectIntMap;
import androidx.collection.ObjectIntMapKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSetKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\tJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u001e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"Landroidx/compose/ui/node/DepthSortedSet;", "", "", "extraAssertions", "<init>", "(Z)V", "Landroidx/compose/ui/node/LayoutNode;", "node", "contains", "(Landroidx/compose/ui/node/LayoutNode;)Z", "", "add", "(Landroidx/compose/ui/node/LayoutNode;)V", "remove", "pop", "()Landroidx/compose/ui/node/LayoutNode;", "isEmpty", "()Z", "Landroidx/collection/MutableObjectIntMap;", "safeMapOfOriginalDepth", "()Landroidx/collection/MutableObjectIntMap;", "", "toString", "()Ljava/lang/String;", "Z", "mapOfOriginalDepth", "Landroidx/collection/MutableObjectIntMap;", "Landroidx/compose/ui/node/SortedSet;", "set", "Landroidx/compose/ui/node/SortedSet;"})
@SourceDebugExtension(value={"SMAP\nDepthSortedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 3 ObjectIntMap.kt\nandroidx/collection/ObjectIntMap\n*L\n1#1,265:1\n107#1:287\n57#2,4:266\n57#2,4:270\n57#2,4:274\n57#2,4:278\n57#2,4:283\n438#3:282\n*S KotlinDebug\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n*L\n99#1:287\n55#1:266,4\n63#1:270,4\n70#1:274,4\n77#1:278,4\n84#1:283,4\n81#1:282\n*E\n"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    private MutableObjectIntMap<LayoutNode> mapOfOriginalDepth;
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DepthSortedSet(boolean extraAssertions) {
        void var1_1;
        this.extraAssertions = var1_1;
        this.set = new SortedSet(DepthSortedSetKt.access$getDepthComparator$p());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(LayoutNode node) {
        void var2_3;
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean contains = this.set.contains(node);
        if (this.extraAssertions && !(bl = contains == this.safeMapOfOriginalDepth().containsKey((Object)var1_1))) {
            InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(LayoutNode node) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl = node.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            MutableObjectIntMap<LayoutNode> map = this.safeMapOfOriginalDepth();
            int usedDepth = map.getOrDefault((Object)node, Integer.MAX_VALUE);
            if (usedDepth == Integer.MAX_VALUE) {
                void var2_3;
                LayoutNode layoutNode = node;
                var2_3.set((Object)layoutNode, layoutNode.getDepth$ui());
            } else {
                void var3_5;
                boolean bl2 = var3_5 == node.getDepth$ui();
                if (!bl2) {
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add((LayoutNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl = node.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        boolean contains = this.set.remove(node);
        if (this.extraAssertions) {
            void this_$iv;
            MutableObjectIntMap<LayoutNode> map = this.safeMapOfOriginalDepth();
            ObjectIntMap objectIntMap = (ObjectIntMap)map;
            LayoutNode key$iv = node;
            if (this_$iv.containsKey((Object)key$iv)) {
                void var1_1;
                void var3_3;
                int usedDepth = map.get((Object)node);
                var3_3.remove((Object)node);
                boolean bl2 = usedDepth == (contains ? var1_1.getDepth$ui() : Integer.MAX_VALUE);
                if (!bl2) {
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final LayoutNode pop() {
        void var1_1;
        LayoutNode node = (LayoutNode)this.set.first();
        this.remove(node);
        return var1_1;
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    private final MutableObjectIntMap<LayoutNode> safeMapOfOriginalDepth() {
        if (this.mapOfOriginalDepth == null) {
            this.mapOfOriginalDepth = ObjectIntMapKt.mutableObjectIntMapOf();
        }
        MutableObjectIntMap<LayoutNode> mutableObjectIntMap = this.mapOfOriginalDepth;
        Intrinsics.checkNotNull(mutableObjectIntMap);
        return mutableObjectIntMap;
    }

    public final String toString() {
        return this.set.toString();
    }
}

