/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a!\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\u0012\u001a\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a7\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a/\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001b\u0010\"\u001a\u00020\u0010*\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\"\u0010#\"\u001c\u0010$\u001a\u00020\u001d8\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u001c\u0010(\u001a\u00020\u001d8\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b)\u0010'*\f\b\u0002\u0010*\"\u00020\u00142\u00020\u0014*\u0018\b\u0002\u0010+\"\b\u0012\u0004\u0012\u00020\u00140\n2\b\u0012\u0004\u0012\u00020\u00140\n"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "event", "", "addPointerInputChange", "(Landroidx/compose/ui/input/pointer/util/VelocityTracker;Landroidx/compose/ui/input/pointer/PointerInputChange;)V", "Landroidx/compose/ui/geometry/Offset;", "offset", "addPointerInputChange-0AR0LA0", "(Landroidx/compose/ui/input/pointer/util/VelocityTracker;Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "", "index", "", "time", "", "dataPoint", "set", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "", "x", "y", "sampleCount", "degree", "coefficients", "polyFitLeastSquares", "([F[FII[F)[F", "dataPoints", "", "isDataDifferential", "calculateImpulseVelocity", "([F[FIZ)F", "a", "dot", "([F[F)F", "VelocityTrackerAddPointsFix", "Z", "getVelocityTrackerAddPointsFix", "()Z", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse", "Vector", "Matrix"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,631:1\n593#1:632\n600#1,2:633\n596#1,6:635\n593#1:641\n593#1:642\n588#1:643\n575#1:645\n575#1:646\n69#2:644\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n412#1:632\n414#1:633,2\n416#1:635,6\n423#1:641\n425#1:642\n438#1:643\n560#1:645\n566#1:646\n438#1:644\n*E\n"})
public final class VelocityTrackerKt {
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    /*
     * WARNING - void declaration
     */
    public static final void addPointerInputChange(VelocityTracker $this$addPointerInputChange, PointerInputChange event) {
        void var1_1;
        VelocityTracker velocityTracker;
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VelocityTrackerKt.addPointerInputChange-0AR0LA0(velocityTracker, (PointerInputChange)var1_1, Offset.Companion.getZero-F1C5BW0());
    }

    /*
     * WARNING - void declaration
     */
    public static final void addPointerInputChange-0AR0LA0(VelocityTracker $this$addPointerInputChange_u2d0AR0LA0, PointerInputChange event, long offset) {
        void var2_2;
        void var1_1;
        VelocityTracker velocityTracker;
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange_u2d0AR0LA0, (String)"$this$addPointerInputChange");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        velocityTracker.getPlatformVelocityTracker$ui().addPointerInputChange-Uv8p0NA((PointerInputChange)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void set(DataPointAtTime[] $this$set, int index, long time, float dataPoint) {
        void var2_2;
        DataPointAtTime currentEntry = $this$set[index];
        if (currentEntry == null) {
            var0[var1_1] = new DataPointAtTime(time, dataPoint);
            return;
        }
        currentEntry.setTime((long)var2_2);
        currentEntry.setDataPoint(dataPoint);
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] polyFitLeastSquares(float[] x, float[] y, int sampleCount, int degree, float[] coefficients) {
        void var1_2;
        void rows$iv;
        void rows$iv2;
        int row$iv2;
        int col$iv;
        int i;
        void rows$iv3;
        int m;
        int n;
        void truncatedDegree;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (degree <= 0) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        truncatedDegree = degree >= sampleCount ? sampleCount - 1 : truncatedDegree;
        void var6_6 = n = truncatedDegree + true;
        void cols$iv2 = m;
        int n2 = 0;
        float[][] fArrayArray = new float[rows$iv3][];
        while (n2 < rows$iv3) {
            int n3 = n2++;
            fArrayArray[n3] = new float[cols$iv2];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] cols$iv2 = a;
            int col$iv2 = h;
            $this$set$iv[0][col$iv2] = 1.0f;
            for (i = 1; i < n; ++i) {
                void $this$get$iv;
                void value$iv22;
                float[][] fArrayArray2 = a;
                col$iv2 = i;
                int n4 = h;
                float[][] fArrayArray3 = a;
                int n5 = i - 1;
                col$iv = h;
                $this$set$iv[row$iv][col$iv3] = value$iv22 = $this$get$iv[row$iv2][col$iv] * x[h];
            }
        }
        i = n;
        void cols$iv3 = m;
        int col$iv3 = 0;
        float[][] value$iv22 = new float[rows$iv2][];
        while (col$iv3 < rows$iv2) {
            row$iv2 = col$iv3++;
            value$iv22[row$iv2] = new float[cols$iv3];
        }
        float[][] q = value$iv22;
        cols$iv3 = n;
        void cols$iv4 = n;
        int value$iv22 = 0;
        float[][] row$iv2 = new float[rows$iv][];
        while (value$iv22 < rows$iv) {
            col$iv = value$iv22++;
            row$iv2[col$iv] = new float[cols$iv4];
        }
        float[][] r = row$iv2;
        for (int j = 0; j < n; ++j) {
            float f;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i2 = 0; i2 < j; ++i2) {
                float[] z = q[i2];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n6 = h;
                    w[n6] = w[n6] - dot * z[h];
                }
            }
            float[] $this$norm$iv = w;
            float $this$fastCoerceAtLeast$iv = (float)Math.sqrt(VelocityTrackerKt.dot(w, $this$norm$iv));
            float inverseNorm = 1.0f / (f < 1.0E-6f ? 1.0E-6f : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int dot = h++;
                w[dot] = w[dot] * inverseNorm;
            }
            float[] v = r[j];
            for (int i3 = 0; i3 < n; ++i3) {
                int n7 = i3;
                v[n7] = n7 < j ? 0.0f : VelocityTrackerKt.dot(w, a[i3]);
            }
        }
        void wy = var1_2;
        for (void i4 = n - true; i4 >= 0; --i4) {
            float c = VelocityTrackerKt.dot(q[i4], (float[])wy);
            float[] ri = r[i4];
            void var13_40 = i4 + true;
            void j = n - true;
            if (var13_40 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == var13_40) break;
                    --j;
                }
            }
            coefficients[i4] = c / ri[i4];
        }
        return coefficients;
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start = sampleCount - 1;
        float nextTime = time[start];
        for (int i = start; i > 0; --i) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time[i - 1])) continue;
            float f = isDataDifferential ? -dataPoints[i - 1] : dataPoints[i] - dataPoints[i - 1];
            float vCurr = f / (currentTime - nextTime);
            float kineticEnergy$iv = work;
            float vPrev = Math.signum(kineticEnergy$iv) * (float)Math.sqrt(2.0f * Math.abs(kineticEnergy$iv));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != start) continue;
            work *= 0.5f;
        }
        float kineticEnergy$iv = work;
        return Math.signum(kineticEnergy$iv) * (float)Math.sqrt(2.0f * Math.abs(kineticEnergy$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final float dot(float[] $this$dot, float[] a) {
        void var2_2;
        float result = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result += $this$dot[i] * a[i];
        }
        return (float)var2_2;
    }

    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time, float dataPoint) {
        void var2_2;
        void var1_1;
        VelocityTrackerKt.set($receiver, (int)var1_1, (long)var2_2, dataPoint);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        void var3_3;
        void var2_2;
        void var1_1;
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, (float[])var1_1, (int)var2_2, (boolean)var3_3);
    }
}

