/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.PlatformVelocityTracker;
import androidx.compose.ui.input.pointer.util.VelocityTracker1D;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.unit.Velocity;
import androidx.compose.ui.unit.VelocityKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u001f\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u001f\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0016\u0010#\u001a\u00020\u00068\u0000@\u0000X\u0080\f\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00048\u0000@\u0000X\u0080\f\u00a2\u0006\u0006\n\u0004\b%\u0010$"}, d2={"Landroidx/compose/ui/input/pointer/util/DefaultVelocityTracker;", "Landroidx/compose/ui/input/pointer/util/PlatformVelocityTracker;", "<init>", "()V", "", "timeMillis", "Landroidx/compose/ui/geometry/Offset;", "position", "", "addPosition-Uv8p0NA", "(JJ)V", "addPosition", "Landroidx/compose/ui/unit/Velocity;", "maximumVelocity", "calculateVelocity-AH228Gc", "(J)J", "calculateVelocity", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "event", "offset", "addPointerInputChange-Uv8p0NA", "(Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "addPointerInputChange", "resetTracking", "addPointerInputChangeLegacy-Uv8p0NA", "addPointerInputChangeLegacy", "addPointerInputChangeWithFix-Uv8p0NA", "addPointerInputChangeWithFix", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "xVelocityTracker", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "yVelocityTracker", "currentPointerPositionAccumulator", "J", "lastMoveEventTimeStamp"})
@SourceDebugExtension(value={"SMAP\nPlatformVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformVelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/DefaultVelocityTracker\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 6 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,174:1\n65#2:175\n69#2:178\n60#3:176\n70#3:179\n22#4:177\n22#4:180\n57#5,4:181\n35#6,5:185\n35#6,5:190\n*S KotlinDebug\n*F\n+ 1 PlatformVelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/DefaultVelocityTracker\n*L\n79#1:175\n80#1:178\n79#1:176\n80#1:179\n79#1:177\n80#1:180\n84#1:181,4\n120#1:185,5\n158#1:190,5\n*E\n"})
public final class DefaultVelocityTracker
implements PlatformVelocityTracker {
    private final VelocityTracker1D.Strategy strategy = VelocityTrackerKt.getVelocityTrackerStrategyUseImpulse() ? VelocityTracker1D.Strategy.Impulse : VelocityTracker1D.Strategy.Lsq2;
    private final VelocityTracker1D xVelocityTracker = new VelocityTracker1D(false, this.strategy, 1, null);
    private final VelocityTracker1D yVelocityTracker = new VelocityTracker1D(false, this.strategy, 1, null);
    public long currentPointerPositionAccumulator = Offset.Companion.getZero-F1C5BW0();
    public long lastMoveEventTimeStamp;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addPosition-Uv8p0NA(long timeMillis, long position) {
        void var1_1;
        void var3_2;
        long l;
        long l2 = l = position;
        int n = (int)(l >> 32);
        this.xVelocityTracker.addDataPoint(timeMillis, Float.intBitsToFloat(n));
        void var5_5 = var3_2;
        l2 = var5_5;
        int n2 = (int)var5_5;
        this.yVelocityTracker.addDataPoint((long)var1_1, Float.intBitsToFloat(n2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long calculateVelocity-AH228Gc(long maximumVelocity) {
        void var1_2;
        void var3_4;
        boolean bl = Velocity.getX-impl((long)maximumVelocity) > 0.0f && Velocity.getY-impl((long)maximumVelocity) > 0.0f;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("maximumVelocity should be a positive value. You specified=" + Velocity.toString-impl((long)maximumVelocity));
        }
        float velocityX = this.xVelocityTracker.calculateVelocity(Velocity.getX-impl((long)maximumVelocity));
        float velocityY = this.yVelocityTracker.calculateVelocity(Velocity.getY-impl((long)maximumVelocity));
        return VelocityKt.Velocity((float)var3_4, (float)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addPointerInputChange-Uv8p0NA(PointerInputChange event, long offset) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerKt.getVelocityTrackerAddPointsFix()) {
            this.addPointerInputChangeWithFix-Uv8p0NA(event, offset);
            return;
        }
        this.addPointerInputChangeLegacy-Uv8p0NA((PointerInputChange)var1_1, (long)var2_2);
    }

    @Override
    public final void resetTracking() {
        this.xVelocityTracker.resetTracking();
        this.yVelocityTracker.resetTracking();
        this.lastMoveEventTimeStamp = 0L;
    }

    /*
     * WARNING - void declaration
     */
    private final void addPointerInputChangeLegacy-Uv8p0NA(PointerInputChange event, long offset) {
        void var2_2;
        void var1_1;
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            this.currentPointerPositionAccumulator = event.getPosition-F1C5BW0();
            this.resetTracking();
        }
        long previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange historicalChange;
            HistoricalChange it = historicalChange = $this$fastForEach$iv.get(index$iv);
            long historicalDelta = Offset.minus-MK-Hz9U((long)historicalChange.getPosition-F1C5BW0(), (long)previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            this.currentPointerPositionAccumulator = Offset.plus-MK-Hz9U((long)this.currentPointerPositionAccumulator, (long)historicalDelta);
            this.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U((long)this.currentPointerPositionAccumulator, (long)offset));
        }
        long delta = Offset.minus-MK-Hz9U((long)event.getPosition-F1C5BW0(), (long)previousPointerPosition);
        this.currentPointerPositionAccumulator = Offset.plus-MK-Hz9U((long)this.currentPointerPositionAccumulator, (long)delta);
        this.addPosition-Uv8p0NA(var1_1.getUptimeMillis(), Offset.plus-MK-Hz9U((long)this.currentPointerPositionAccumulator, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void addPointerInputChangeWithFix-Uv8p0NA(PointerInputChange event, long offset) {
        void var1_1;
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            this.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            void var2_2;
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange historicalChange;
                HistoricalChange it = historicalChange = $this$fastForEach$iv.get(index$iv);
                this.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U((long)it.getOriginalEventPosition-F1C5BW0$ui(), (long)offset));
            }
            this.addPosition-Uv8p0NA(event.getUptimeMillis(), Offset.plus-MK-Hz9U((long)event.getOriginalEventPosition-F1C5BW0$ui(), (long)var2_2));
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - this.lastMoveEventTimeStamp > 40L) {
            this.resetTracking();
        }
        this.lastMoveEventTimeStamp = var1_1.getUptimeMillis();
    }
}

