/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Landroidx/compose/ui/focus/FocusableChildrenComparator;", "Ljava/util/Comparator;", "Landroidx/compose/ui/focus/FocusTargetNode;", "Lkotlin/Comparator;", "<init>", "()V", "a", "b", "", "compare", "(Landroidx/compose/ui/focus/FocusTargetNode;Landroidx/compose/ui/focus/FocusTargetNode;)I", "Landroidx/compose/ui/node/LayoutNode;", "layoutNode", "Landroidx/compose/runtime/collection/MutableVector;", "pathFromRoot", "(Landroidx/compose/ui/node/LayoutNode;)Landroidx/compose/runtime/collection/MutableVector;"})
@SourceDebugExtension(value={"SMAP\nOneDimensionalFocusSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,273:1\n44#2:274\n472#2:275\n472#2:276\n1107#3:277\n1085#3,2:278\n*S KotlinDebug\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n*L\n252#1:274\n256#1:275\n257#1:276\n264#1:277\n264#1:278,2\n*E\n"})
final class FocusableChildrenComparator
implements Comparator<FocusTargetNode> {
    public static final FocusableChildrenComparator INSTANCE = new FocusableChildrenComparator();

    private FocusableChildrenComparator() {
    }

    @Override
    public final int compare(FocusTargetNode a, FocusTargetNode b) {
        MutableVector<LayoutNode> mutableVector;
        int n;
        LayoutNode layoutNode2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!FocusTraversalKt.isEligibleForFocusSearch(a) || !FocusTraversalKt.isEligibleForFocusSearch(b)) {
            if (FocusTraversalKt.isEligibleForFocusSearch(a)) {
                return -1;
            }
            if (FocusTraversalKt.isEligibleForFocusSearch(b)) {
                return 1;
            }
            return 0;
        }
        LayoutNode layoutNode1 = DelegatableNodeKt.requireLayoutNode(a);
        if (Intrinsics.areEqual((Object)layoutNode1, (Object)(layoutNode2 = DelegatableNodeKt.requireLayoutNode(b)))) {
            return 0;
        }
        MutableVector<LayoutNode> pathFromRoot1 = this.pathFromRoot(layoutNode1);
        MutableVector<LayoutNode> pathFromRoot2 = this.pathFromRoot(layoutNode2);
        int depth = 0;
        MutableVector<LayoutNode> mutableVector2 = pathFromRoot1;
        int n2 = mutableVector2.getSize() - 1;
        int n3 = Math.min(n2, n = (mutableVector = pathFromRoot2).getSize() - 1);
        if (n3 >= 0) {
            while (true) {
                MutableVector<LayoutNode> mutableVector3 = pathFromRoot1;
                int index$iv = depth;
                MutableVector<LayoutNode> this_$iv = pathFromRoot2;
                if (!Intrinsics.areEqual((Object)this_$iv.content[index$iv], (Object)this_$iv.content[index$iv = depth])) {
                    this_$iv = pathFromRoot1;
                    index$iv = depth;
                    int n4 = ((LayoutNode)this_$iv.content[index$iv]).getPlaceOrder$ui();
                    this_$iv = pathFromRoot2;
                    index$iv = depth;
                    return Intrinsics.compare((int)n4, (int)((LayoutNode)this_$iv.content[index$iv]).getPlaceOrder$ui());
                }
                if (depth == n3) break;
                ++depth;
            }
        }
        throw new IllegalStateException("Could not find a common ancestor between the two FocusModifiers.".toString());
    }

    /*
     * WARNING - void declaration
     */
    private final MutableVector<LayoutNode> pathFromRoot(LayoutNode $i$f$mutableVectorOf) {
        void var2_2;
        LayoutNode current;
        MutableVector path = new MutableVector((Object[])new LayoutNode[16], 0);
        while (current != null) {
            path.add(0, (Object)current);
            current = current.getParent$ui();
        }
        return var2_2;
    }
}

