/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.draw.PainterNode;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutModifierNodeKt;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0018\u001a\u00020\u0014*\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010$R\u0011\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010%R\u0011\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\u0006\n\u0004\b\b\u0010&R\u0011\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\u0006\n\u0004\b\n\u0010'R\u0011\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\u0006\n\u0004\b\f\u0010(R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006\u00a2\u0006\u0006\n\u0004\b\u000e\u0010)"}, d2={"Landroidx/compose/ui/draw/PainterElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/ui/draw/PainterNode;", "Landroidx/compose/ui/graphics/painter/Painter;", "painter", "", "sizeToIntrinsics", "Landroidx/compose/ui/Alignment;", "alignment", "Landroidx/compose/ui/layout/ContentScale;", "contentScale", "", "alpha", "Landroidx/compose/ui/graphics/ColorFilter;", "colorFilter", "<init>", "(Landroidx/compose/ui/graphics/painter/Painter;ZLandroidx/compose/ui/Alignment;Landroidx/compose/ui/layout/ContentScale;FLandroidx/compose/ui/graphics/ColorFilter;)V", "create", "()Landroidx/compose/ui/draw/PainterNode;", "node", "", "update", "(Landroidx/compose/ui/draw/PainterNode;)V", "Landroidx/compose/ui/platform/InspectorInfo;", "inspectableProperties", "(Landroidx/compose/ui/platform/InspectorInfo;)V", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Landroidx/compose/ui/graphics/painter/Painter;", "Z", "Landroidx/compose/ui/Alignment;", "Landroidx/compose/ui/layout/ContentScale;", "F", "Landroidx/compose/ui/graphics/ColorFilter;"})
final class PainterElement
extends ModifierNodeElement<PainterNode> {
    public final Painter painter;
    public final boolean sizeToIntrinsics;
    public final Alignment alignment;
    public final ContentScale contentScale;
    public final float alpha;
    public final ColorFilter colorFilter;

    /*
     * WARNING - void declaration
     */
    public PainterElement(Painter painter, boolean sizeToIntrinsics, Alignment alignment, ContentScale contentScale, float alpha, ColorFilter colorFilter) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        this.painter = var1_1;
        this.sizeToIntrinsics = var2_2;
        this.alignment = var3_3;
        this.contentScale = contentScale;
        this.alpha = alpha;
        this.colorFilter = colorFilter;
    }

    @Override
    public final PainterNode create() {
        return new PainterNode(this.painter, this.sizeToIntrinsics, this.alignment, this.contentScale, this.alpha, this.colorFilter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void update(PainterNode node) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean intrinsicsChanged = node.getSizeToIntrinsics() != this.sizeToIntrinsics || this.sizeToIntrinsics && !Size.equals-impl0((long)node.getPainter().getIntrinsicSize-NH-jbRc(), (long)this.painter.getIntrinsicSize-NH-jbRc());
        node.setPainter(this.painter);
        node.setSizeToIntrinsics(this.sizeToIntrinsics);
        node.setAlignment(this.alignment);
        node.setContentScale(this.contentScale);
        node.setAlpha(this.alpha);
        node.setColorFilter(this.colorFilter);
        if (var2_2 != false) {
            LayoutModifierNodeKt.invalidateMeasurement(node);
        }
        DrawModifierNodeKt.invalidateDraw((DrawModifierNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void inspectableProperties(InspectorInfo $this$inspectableProperties) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
        $this$inspectableProperties.setName("paint");
        $this$inspectableProperties.getProperties().set("painter", this.painter);
        $this$inspectableProperties.getProperties().set("sizeToIntrinsics", this.sizeToIntrinsics);
        $this$inspectableProperties.getProperties().set("alignment", this.alignment);
        $this$inspectableProperties.getProperties().set("contentScale", this.contentScale);
        $this$inspectableProperties.getProperties().set("alpha", Float.valueOf(this.alpha));
        var1_1.getProperties().set("colorFilter", this.colorFilter);
    }

    public final String toString() {
        return "PainterElement(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", contentScale=" + this.contentScale + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ")";
    }

    @Override
    public final int hashCode() {
        int n = this.painter.hashCode();
        n = n * 31 + Boolean.hashCode(this.sizeToIntrinsics);
        n = n * 31 + this.alignment.hashCode();
        n = n * 31 + this.contentScale.hashCode();
        n = n * 31 + Float.hashCode(this.alpha);
        n = n * 31 + (this.colorFilter == null ? 0 : this.colorFilter.hashCode());
        return n;
    }

    @Override
    public final boolean equals(Object other) {
        PainterElement painterElement;
        if (this == other) {
            return true;
        }
        if (!(other instanceof PainterElement)) {
            return false;
        }
        painterElement = painterElement;
        if (!Intrinsics.areEqual((Object)this.painter, (Object)painterElement.painter)) {
            return false;
        }
        if (this.sizeToIntrinsics != painterElement.sizeToIntrinsics) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alignment, (Object)painterElement.alignment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentScale, (Object)painterElement.contentScale)) {
            return false;
        }
        if (Float.compare(this.alpha, painterElement.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorFilter, (Object)painterElement.colorFilter);
    }
}

