/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.utils.IThrowingSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Random RANDOM;
    private static final Logger LOGGER;
    private static final char[] SYMBOLS;

    private Util() {
    }

    /*
     * WARNING - void declaration
     */
    public static Properties readProperties(File _file) {
        if (_file.exists()) {
            try {
                return Util.readProperties(new FileInputStream(_file));
            }
            catch (FileNotFoundException _ex) {
                void var1_1;
                File file;
                LOGGER.info("Could not load properties file: " + String.valueOf(file), (Throwable)var1_1);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties readProperties(InputStream _stream) {
        Properties props = new Properties();
        if (_stream == null) {
            return null;
        }
        try {
            void var1_2;
            props.load(_stream);
            return var1_2;
        }
        catch (IOException | NumberFormatException _ex) {
            void var0_1;
            LOGGER.warn("Could not properties: ", (Throwable)var0_1);
            return null;
        }
    }

    public static boolean isBlank(String _str) {
        String string;
        return _str == null || string.isBlank();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean strEquals(String _str1, String _str2) {
        void var1_1;
        String string;
        if (_str1 == _str2) {
            return true;
        }
        if (_str1 == null || _str2 == null) {
            return false;
        }
        if (_str1.length() != _str2.length()) {
            return false;
        }
        return string.equals(var1_1);
    }

    public static boolean isEmpty(String _str) {
        String string;
        return _str == null || string.isEmpty();
    }

    public static List<String> readFileToList(String _fileName) {
        return Util.getTextfileFromUrl(_fileName, Charset.defaultCharset(), false);
    }

    public static String readFileToString(File _file) {
        File file;
        return String.join((CharSequence)System.lineSeparator(), Util.readFileToList(file.getAbsolutePath()));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getTextfileFromUrl(String _url, Charset _charset, boolean _silent) {
        if (_url == null) {
            return null;
        }
        URL fileUrl = _url;
        if (!((String)((Object)fileUrl)).contains("://")) {
            fileUrl = "file://" + (String)((Object)fileUrl);
        }
        try {
            void var1_2;
            URL dlUrl;
            dlUrl = ((String)((Object)fileUrl)).startsWith("file:/") ? new URL("file", "", ((String)((Object)fileUrl)).replaceFirst("file:\\/{1,2}", "")) : new URL((String)((Object)dlUrl));
            URL urlConn = dlUrl.openConnection();
            ((URLConnection)((Object)urlConn)).setDoInput(true);
            ((URLConnection)((Object)urlConn)).setUseCaches(false);
            return Util.readTextFileFromStream(((URLConnection)((Object)urlConn)).getInputStream(), (Charset)var1_2, _silent);
        }
        catch (IOException _ex) {
            void var2_3;
            if (var2_3 == false) {
                void var0_1;
                LOGGER.warn("Error while reading file:", (Throwable)var0_1);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readTextFileFromStream(InputStream _input, Charset _charset, boolean _silent) {
        if (_input == null) {
            return null;
        }
        try {
            ArrayList fileContent2;
            BufferedReader dis = new BufferedReader(new InputStreamReader(_input, _charset));
            try {
                String s;
                fileContent2 = new ArrayList();
                while ((s = dis.readLine()) != null) {
                    void var3_5;
                    fileContent2.add(var3_5);
                }
            }
            catch (Throwable throwable) {
                try {
                    void var1_3;
                    var1_3.close();
                }
                catch (Throwable fileContent2) {
                    throwable.addSuppressed(fileContent2);
                }
                throw throwable;
            }
            dis.close();
            if (!fileContent2.isEmpty()) {
                return fileContent2;
            }
            return null;
        }
        catch (IOException _ex) {
            void var2_4;
            if (var2_4 == false) {
                void var0_2;
                LOGGER.warn("Error while reading file:", (Throwable)var0_2);
            }
            return null;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean collectionContainsAny(Collection<T> _haystack, Collection<T> _needles) {
        Iterator iterator;
        if (_haystack == null || _needles == null) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object t = iterator.next();
            if (!_haystack.contains(var2_2)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentUser() {
        String[] stringArray = new String[]{"user.name", "USER", "USERNAME"};
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int cfr_ignored_0 = stringArray.length;
        for (int i = 0; i < 3; ++i) {
            String string = stringArray2[i];
            String val = System.getProperty(string);
            if (Util.isEmpty(val)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMacOs() {
        void var0;
        String osName = System.getProperty("os.name");
        return osName != null && var0.toLowerCase(Locale.US).startsWith("mac");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWindows() {
        void var0;
        String osName = System.getProperty("os.name");
        return osName != null && var0.toLowerCase(Locale.US).startsWith("windows");
    }

    /*
     * WARNING - void declaration
     */
    public static void setFilePermissions(Path _path, String _fileOwner, String _fileGroup, Set<PosixFilePermission> _fileUnixPermissions) {
        Objects.requireNonNull(_path, "Path required");
        UserPrincipalLookupService userPrincipalLookupService = _path.getFileSystem().getUserPrincipalLookupService();
        if (userPrincipalLookupService == null) {
            LOGGER.error("Unable to set user/group permissions on {}", (Object)_path);
            return;
        }
        if (!Util.isBlank(_fileOwner)) {
            try {
                UserPrincipal userPrincipal = userPrincipalLookupService.lookupPrincipalByName(_fileOwner);
                if (userPrincipal != null) {
                    Files.getFileAttributeView(_path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setOwner(userPrincipal);
                }
            }
            catch (IOException _ex) {
                void var1_1;
                LOGGER.error("Could not change owner of {} to {}", new Object[]{_path, var1_1, _ex});
            }
        }
        if (!Util.isBlank(_fileGroup)) {
            try {
                GroupPrincipal groupPrincipal = userPrincipalLookupService.lookupPrincipalByGroupName(_fileGroup);
                if (groupPrincipal != null) {
                    Files.getFileAttributeView(_path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(groupPrincipal);
                }
            }
            catch (IOException _ex) {
                void var2_2;
                LOGGER.error("Could not change group of {} to {}", new Object[]{_path, var2_2, _ex});
            }
        }
        if (!Util.isWindows() && _fileUnixPermissions != null) {
            try {
                Files.setPosixFilePermissions(_path, _fileUnixPermissions);
                return;
            }
            catch (Exception _ex) {
                void var3_3;
                Path path;
                LOGGER.error("Could not set file permissions of {} to {}", new Object[]{path, var3_3, _ex});
            }
        }
    }

    public static <T extends Throwable> void waitFor(String _lockName, IThrowingSupplier<Boolean, T> _wait, long _timeoutMs, long _sleepTime) throws T {
        boolean wait22;
        long waited = 0L;
        do {
            Throwable lastEx;
            try {
                lastEx = null;
                wait22 = _wait.get();
            }
            catch (Throwable throwable) {
                Throwable wait22 = throwable;
                lastEx = throwable;
                wait22 = false;
            }
            if (waited >= _timeoutMs) {
                if (lastEx != null) {
                    throw lastEx;
                }
                throw new IllegalStateException(_lockName + " not available in the specified time of " + _timeoutMs + " ms");
            }
            try {
                Thread.sleep(_sleepTime);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.debug("Interrupted while waiting for {}", (Object)_lockName);
                Thread.currentThread().interrupt();
                return;
            }
            LOGGER.debug("Waiting for {} to be available: {} of {} ms waited", new Object[]{_lockName, waited += _sleepTime, _timeoutMs});
        } while (!wait22);
    }

    public static Type unwrapTypeRef(Class<?> _type) {
        return Arrays.stream(_type.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(t -> {
            ParameterizedType parameterizedType;
            return TypeRef.class.equals((Object)parameterizedType.getRawType());
        }).map(t -> t.getActualTypeArguments()[0]).findFirst().orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] toObjectArray(Object _obj) {
        void var2_2;
        if (_obj == null || !_obj.getClass().isArray()) {
            return new Object[0];
        }
        int length = Array.getLength(_obj);
        Object[] ret = new Object[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = Array.get(_obj, i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        char ch;
        RANDOM = new Random();
        LOGGER = LoggerFactory.getLogger(Util.class);
        StringBuilder tmp = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            tmp.append(ch);
        }
        SYMBOLS = var0.toString().toCharArray();
    }
}

