/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.time.Duration;

public class TimeMeasure {
    private volatile long startTm;
    private final ITimeMeasureFormat tmf;

    /*
     * WARNING - void declaration
     */
    public TimeMeasure(ITimeMeasureFormat _formatter) {
        void var1_1;
        this.tmf = var1_1;
        this.reset();
    }

    public TimeMeasure() {
        this(durationInMillis -> {
            long l;
            if (durationInMillis >= 5000L) {
                return (double)durationInMillis / 1000.0 * 10.0 / 10.0 + "s";
            }
            return l + "ms";
        });
    }

    public final TimeMeasure reset() {
        this.startTm = System.nanoTime();
        return this;
    }

    public long getElapsed() {
        return Duration.ofNanos(System.nanoTime() - this.startTm).toMillis();
    }

    public String toString() {
        if (this.tmf == null) {
            return String.valueOf(this.getElapsed());
        }
        return this.tmf.format(this.getElapsed());
    }

    public static interface ITimeMeasureFormat {
        public String format(long var1);
    }
}

