/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

public final class Hexdump {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - void declaration
     */
    public static String toHex(byte[] _buf, boolean _spaces) {
        void var1_1;
        byte[] byArray;
        return Hexdump.toHex(_buf, 0, byArray.length, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toHex(byte[] _buf, int _ofs, int _len, boolean _spaces) {
        void i;
        StringBuilder sb = new StringBuilder();
        int j = _ofs + _len;
        while (i < j) {
            if (i < _buf.length) {
                sb.append(HEX_CHARS[(_buf[i] & 0xF0) >> 4]);
                sb.append(HEX_CHARS[_buf[i] & 0xF]);
                if (_spaces) {
                    sb.append(' ');
                }
            } else if (_spaces) {
                sb.append(' ');
                sb.append(' ');
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toAscii(byte[] _buf) {
        byte[] byArray;
        return Hexdump.toAscii(_buf, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String toAscii(byte[] _buf, int _ofs, int _len) {
        void var3_3;
        void i;
        StringBuilder sb = new StringBuilder();
        int j = _ofs + _len;
        while (i < j) {
            if (i < _buf.length) {
                if (20 <= _buf[i] && 126 >= _buf[i]) {
                    sb.append((char)_buf[i]);
                } else {
                    sb.append('.');
                }
            } else {
                sb.append(' ');
            }
            ++i;
        }
        return var3_3.toString();
    }

    public static String format(byte[] _buf) {
        return Hexdump.format(_buf, 80);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(byte[] _buf, int _width) {
        void var3_3;
        int bs = (_width - 8) / 4;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        do {
            for (int j = 0; j < 6; ++j) {
                sb.append(HEX_CHARS[(i << (j << 2) & 0xF00000) >> 20]);
            }
            sb.append('\t');
            sb.append(Hexdump.toHex(_buf, i, bs, true));
            sb.append(' ');
            sb.append(Hexdump.toAscii(_buf, i, bs));
            sb.append('\n');
        } while ((i += bs) < _buf.length);
        StringBuilder stringBuilder = sb;
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return var3_3.toString();
    }
}

