/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.freedesktop.dbus.exceptions.ClassOutsideOfPackageException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.InvalidBusNameException;
import org.freedesktop.dbus.exceptions.InvalidObjectPathException;
import org.freedesktop.dbus.exceptions.MissingInterfaceImplementationException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.utils.Util;

public final class DBusObjects {
    private static final Pattern OBJECT_REGEX_PATTERN = Pattern.compile("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$");
    private static final Pattern BUSNAME_REGEX = Pattern.compile("^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$");
    private static final Pattern CONNID_REGEX = Pattern.compile("^:[0-9]*\\.[0-9]*$");

    /*
     * WARNING - void declaration
     */
    private static <T, X extends DBusException> T requireBase(T _input, Predicate<T> _validation, Function<String, X> _exSupplier, String _customMessage) throws X {
        T t;
        void var1_1;
        String string;
        if (_input == null) {
            throw (DBusException)_exSupplier.apply(_customMessage != null ? _customMessage : null);
        }
        if (_input instanceof String && (string = (String)_input).isBlank()) {
            throw (DBusException)_exSupplier.apply(_customMessage != null ? _customMessage : "<Empty String>");
        }
        if (!var1_1.test(_input)) {
            void var3_3;
            void var2_2;
            throw (DBusException)var2_2.apply(_customMessage != null ? var3_3 : String.valueOf(_input));
        }
        return t;
    }

    public static Class<?> requirePackage(Class<?> _clz) throws ClassOutsideOfPackageException {
        return DBusObjects.requirePackage(_clz, null);
    }

    public static Class<?> requireDBusInterface(Class<?> _clz) throws MissingInterfaceImplementationException {
        return DBusObjects.requireDBusInterface(_clz, null);
    }

    public static String requireObjectPath(String _objectPath) throws InvalidObjectPathException {
        return DBusObjects.requireObjectPath(_objectPath, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> requirePackage(Class<?> _clz, String _customMsg) throws ClassOutsideOfPackageException {
        void var1_1;
        Class<?> clazz;
        return DBusObjects.requireBase(_clz, DBusObjects::validateClassHasPackage, msg -> {
            void var2_2;
            if (Util.isBlank(_customMsg)) {
                void var1_1;
                return new ClassOutsideOfPackageException((Class<?>)var1_1);
            }
            return new ClassOutsideOfPackageException((String)var2_2);
        }, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> requireDBusInterface(Class<?> _clz, String _customMsg) throws MissingInterfaceImplementationException {
        void var1_1;
        Class<?> clazz;
        return DBusObjects.requireBase(_clz, DBusObjects::validateDBusInterface, msg -> {
            void var2_2;
            if (Util.isBlank(_customMsg)) {
                void var1_1;
                return new MissingInterfaceImplementationException((Class<?>)var1_1);
            }
            return new MissingInterfaceImplementationException((String)var2_2);
        }, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String requireObjectPath(String _objectPath, String _customMsg) throws InvalidObjectPathException {
        void var1_1;
        return DBusObjects.requireBase(_objectPath, DBusObjects::validateObjectPath, InvalidObjectPathException::new, (String)var1_1);
    }

    public static String requireBusName(String _busName) throws InvalidBusNameException {
        return DBusObjects.requireBusName(_busName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String requireBusName(String _busName, String _customMessage) throws InvalidBusNameException {
        void var1_1;
        return DBusObjects.requireBase(_busName, DBusObjects::validateBusName, InvalidBusNameException::new, (String)var1_1);
    }

    public static String requireBusNameOrConnectionId(String _busNameOrConnId) throws InvalidBusNameException {
        String string;
        if (DBusObjects.validateBusName(_busNameOrConnId)) {
            return _busNameOrConnId;
        }
        if (DBusObjects.validateConnectionId(_busNameOrConnId)) {
            return _busNameOrConnId;
        }
        throw new InvalidBusNameException(string);
    }

    public static boolean validateBusName(String _busName) {
        String string;
        return _busName != null && _busName.length() < 255 && BUSNAME_REGEX.matcher(string).matches();
    }

    public static boolean validateObjectPath(String _objectPath) {
        return !DBusObjects.validateNotObjectPath(_objectPath);
    }

    public static boolean validateDBusInterface(Class<?> _clz) {
        Class<?> clazz;
        return DBusInterface.class.isAssignableFrom(clazz);
    }

    public static boolean validateClassHasPackage(Class<?> _clz) {
        Class<?> clazz;
        return !_clz.getName().equals(clazz.getSimpleName());
    }

    public static boolean validateNotObjectPath(String _objectPath) {
        String string;
        return _objectPath == null || _objectPath.length() > 255 || !_objectPath.startsWith("/") || !OBJECT_REGEX_PATTERN.matcher(string).matches();
    }

    public static boolean validateConnectionId(String _connectionId) {
        String string;
        return _connectionId != null && CONNID_REGEX.matcher(string).matches();
    }

    /*
     * WARNING - void declaration
     */
    public static <T, X extends Exception> T requireNotNull(T _input, Supplier<X> _exception) throws X {
        T t;
        if (_input == null) {
            void var1_1;
            throw (Exception)var1_1.get();
        }
        return t;
    }
}

