/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.exceptions.AddressResolvingException;
import org.freedesktop.dbus.utils.Util;

public final class AddressBuilder {
    /*
     * WARNING - void declaration
     */
    public static BusAddress getSessionConnection(String _dbusMachineIdFile) {
        void var1_1;
        Object s = System.getProperty("DBUS_SESSION_BUS_ADDRESS");
        if (s == null) {
            s = Util.isMacOs() ? "unix:path=" + System.getenv("DBUS_LAUNCHD_SESSION_BUS_SOCKET") : System.getenv("DBUS_SESSION_BUS_ADDRESS");
        }
        if (s == null) {
            void var2_2;
            String display = System.getenv("DISPLAY");
            if (display == null) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: DISPLAY variable not set");
            }
            if (display.charAt(0) != ':' && display.contains(":")) {
                String string = display;
                display = string.substring(string.indexOf(58));
            }
            File uuid = AddressBuilder.getDbusMachineId(_dbusMachineIdFile);
            String homedir = System.getProperty("user.home");
            File addressfile = new File((String)var2_2 + "/.dbus/session-bus", (String)((Object)uuid) + "-" + display.replaceAll(":([0-9]*)\\..*", "$1"));
            if (!addressfile.exists()) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: " + String.valueOf(addressfile) + " not found");
            }
            Properties readProperties = Util.readProperties(addressfile);
            if (readProperties == null) {
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: Unable to read " + String.valueOf(addressfile));
            }
            String sessionAddress = readProperties.getProperty("DBUS_SESSION_BUS_ADDRESS");
            if (Util.isEmpty(sessionAddress)) {
                File file;
                throw new AddressResolvingException("Cannot Resolve Session Bus Address: No session information found in " + String.valueOf(file));
            }
            if (sessionAddress.matches("^'[^']+'$")) {
                sessionAddress = sessionAddress.replaceFirst("^'([^']+)'$", "$1");
            }
            return BusAddress.of((String)var1_1);
        }
        return BusAddress.of((String)var1_1);
    }

    public static String getDbusMachineId(String _dbusMachineIdFile) {
        File uuidfile = AddressBuilder.determineMachineIdFile(_dbusMachineIdFile);
        if (uuidfile != null) {
            File uuid = Util.readFileToString(uuidfile);
            if (((String)((Object)uuid)).length() > 0) {
                File file;
                return file;
            }
            throw new AddressResolvingException("Cannot Resolve Session Bus Address: MachineId file is empty.");
        }
        if (Util.isWindows() || Util.isMacOs()) {
            return AddressBuilder.getFakeDbusMachineId();
        }
        throw new AddressResolvingException("Cannot Resolve Session Bus Address: MachineId file can not be found");
    }

    private static File determineMachineIdFile(String _dbusMachineIdFile) {
        List<String> list;
        list = Arrays.asList(System.getenv("DBUS_MACHINE_ID_LOCATION"), list, "/var/lib/dbus/machine-id", "/usr/local/var/lib/dbus/machine-id", "/etc/machine-id");
        return list.stream().filter(Objects::nonNull).map(File::new).filter(f -> {
            File file;
            return f.exists() && file.length() > 0L;
        }).findFirst().orElse(null);
    }

    private static String getFakeDbusMachineId() {
        return String.format("%s@%s", Util.getCurrentUser(), Util.getHostName());
    }
}

