/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.types;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.utils.DBusObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T value;
    private final Type type;
    private final String sig;

    /*
     * WARNING - void declaration
     */
    public Variant(T _value) throws IllegalArgumentException {
        void var1_1;
        DBusObjects.requireNotNull(_value, () -> new IllegalArgumentException("Can't wrap Null in a Variant"));
        this.type = _value.getClass();
        try {
            String[] ss = Marshalling.getDBusType(_value.getClass(), true);
            if (ss.length != 1) {
                throw new IllegalArgumentException("Can't wrap a multi-valued type in a Variant: " + String.valueOf(this.type));
            }
            this.sig = ss[0];
        }
        catch (DBusException _ex) {
            void var2_3;
            this.logger.debug("Cannot create variant", (Throwable)_ex);
            throw new IllegalArgumentException(String.format("Can't wrap %s in an unqualified Variant (%s).", _value.getClass(), var2_3.getMessage()));
        }
        this.value = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Variant(T _value, String _sig) throws IllegalArgumentException {
        void var1_1;
        DBusObjects.requireNotNull(_value, () -> new IllegalArgumentException("Can't wrap Null in a Variant"));
        this.sig = _sig;
        try {
            ArrayList<Type> ts = new ArrayList<Type>();
            Marshalling.getJavaType(_sig, ts, 1);
            if (ts.size() != 1) {
                throw new IllegalArgumentException("Can't wrap multiple or no types in a Variant: " + _sig);
            }
            this.type = (Type)ts.get(0);
        }
        catch (DBusException _ex) {
            void var3_4;
            void var2_2;
            this.logger.debug("Cannot create variant", (Throwable)_ex);
            throw new IllegalArgumentException(String.format("Can''t wrap %s in an unqualified Variant (%s).", var2_2, var3_4.getMessage()));
        }
        this.value = var1_1;
    }

    public T getValue() {
        return this.value;
    }

    public String getSig() {
        return this.sig;
    }

    public String toString() {
        return "[" + String.valueOf(this.value) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object _obj) {
        block3: {
            block2: {
                void var1_1;
                if (this == _obj) break block2;
                if (!(_obj instanceof Variant)) break block3;
                Variant other = (Variant)_obj;
                if (!Objects.equals(this.value, var1_1.value)) break block3;
            }
            return true;
        }
        return false;
    }
}

