/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.types;

import java.math.BigInteger;

public class UInt64
extends Number
implements Comparable<UInt64> {
    public static final BigInteger MAX_BIG_VALUE = new BigInteger("18446744073709551615");
    private final BigInteger value;
    private final long top;
    private final long bottom;

    /*
     * WARNING - void declaration
     */
    public UInt64(long _top, long _bottom) {
        void var3_2;
        void var1_1;
        BigInteger bigInteger = BigInteger.valueOf(_top);
        bigInteger = bigInteger.shiftLeft(32);
        BigInteger a = bigInteger.add(BigInteger.valueOf(_bottom));
        if (0 > a.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(String.format("%s is not between %s and %s.", a, 0L, MAX_BIG_VALUE));
        }
        if (0 < a.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(String.format("%s is not between %s and %s.", a, 0L, MAX_BIG_VALUE));
        }
        this.value = a;
        this.top = var1_1;
        this.bottom = var3_2;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object _o) {
        if (_o instanceof UInt64) {
            void var1_1;
            UInt64 ui = (UInt64)_o;
            if (this.value.equals(var1_1.value)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(UInt64 _other) {
        void var1_1;
        return this.value.compareTo(var1_1.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public long top() {
        return this.top;
    }

    public long bottom() {
        return this.bottom;
    }
}

