/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.propertyref;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusBoundProperty;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.propertyref.PropertyRef;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.Util;

public final class PropRefRemoteHandler {
    private static final Method PROP_GET_METHOD = PropRefRemoteHandler.getPropertiesMethod("Get", String.class, String.class);
    private static final Method PROP_SET_METHOD = PropRefRemoteHandler.getPropertiesMethod("Set", String.class, String.class, Object.class);

    /*
     * WARNING - void declaration
     */
    public static Object handleDBusBoundProperty(AbstractConnection _conn, RemoteObject _remote, Method _method, Object[] _args) throws DBusException {
        Object object;
        void var2_3;
        void var3_4;
        Object result;
        String[] stringArray;
        String name = DBusNamingUtil.getPropertyName(_method);
        DBusProperty.Access access = PropertyRef.accessForMethod(_method);
        Class<?> typeClass = _method.getAnnotation(DBusBoundProperty.class).type();
        Type[] type = null;
        if (TypeRef.class.isAssignableFrom(typeClass)) {
            type = Optional.ofNullable(Util.unwrapTypeRef(typeClass)).map(t -> {
                Type type;
                return new Type[]{type};
            }).orElse(null);
        }
        if (type != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Marshalling.getDBusType(type);
        } else {
            stringArray = null;
        }
        String[] variantType = stringArray;
        Object propertiesRemoteObj = new RemoteObject(_remote.getBusName(), _remote.getObjectPath(), Properties.class, _remote.isAutostart());
        result = access == DBusProperty.Access.READ ? RemoteInvocationHandler.executeRemoteMethod((RemoteObject)propertiesRemoteObj, PROP_GET_METHOD, new Type[]{_method.getGenericReturnType()}, _conn, 0, null, DBusNamingUtil.getInterfaceName(_method.getDeclaringClass()), name) : RemoteInvocationHandler.executeRemoteMethod((RemoteObject)propertiesRemoteObj, PROP_SET_METHOD, variantType, new Type[]{_method.getGenericReturnType()}, (AbstractConnection)result, 0, null, DBusNamingUtil.getInterfaceName(_method.getDeclaringClass()), name, var3_4[0]);
        if (var2_3.getReturnType() != Variant.class && typeClass != Variant.class && result instanceof Variant) {
            propertiesRemoteObj = (Variant)result;
            result = ((Variant)propertiesRemoteObj).getValue();
        }
        if (Struct.class.isAssignableFrom(typeClass)) {
            Constructor<?> cons = typeClass.getConstructors()[0];
            try {
                void var1_2;
                result = var1_2.newInstance((Object[])result);
            }
            catch (Exception _ex) {
                void var0_1;
                throw new DBusException(var0_1.getMessage());
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getPropertiesMethod(String _method, Class<?> ... _signature) {
        try {
            void var1_2;
            return Properties.class.getMethod(_method, (Class<?>)var1_2);
        }
        catch (NoSuchMethodException | SecurityException _ex) {
            void var0_1;
            throw new DBusExecutionException("Unable to get methods of DBus Properties interface", (Throwable)var0_1);
        }
    }
}

