/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.regex.Pattern;
import org.freedesktop.dbus.messages.ExportedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTree {
    public static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TreeNode root = new TreeNode("");

    /*
     * WARNING - void declaration
     */
    private TreeNode recursiveFind(TreeNode _current, String _path) {
        while (!"/".equals(_path)) {
            void var3_3;
            String[] elements = _path.split("/", 2);
            if (_path.startsWith(_current.name)) {
                if (_path.equals(_current.name)) {
                    return _current;
                }
                if (_current.down == null) {
                    return null;
                }
                _path = elements[1];
                _current = _current.down;
                continue;
            }
            if (_current.right == null) {
                return null;
            }
            if (0 > _current.right.name.compareTo((String)var3_3[0])) {
                return null;
            }
            _current = _current.right;
        }
        return _current;
    }

    /*
     * WARNING - void declaration
     */
    private TreeNode recursiveRemove(TreeNode _current, String _path) {
        void var1_1;
        void var2_2;
        void var3_3;
        String[] elements = _path.split("/", 2);
        if (elements[0].equals(_current.name)) {
            if (1 == elements.length || "".equals(elements[1])) {
                _current.object = null;
                _current.data = null;
                if (_current.down != null) {
                    return _current;
                }
                return _current.right;
            }
            if (_current.down != null) {
                _current.down = this.recursiveRemove(_current.down, elements[1]);
                if (_current.down == null && _current.data == null) {
                    return _current.right;
                }
            }
            return _current;
        }
        if (_current.right == null) {
            return _current;
        }
        if (0 > _current.right.name.compareTo((String)var3_3[0])) {
            return _current;
        }
        _current.right = this.recursiveRemove(_current.right, (String)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void remove(String _path) {
        void var1_1;
        this.logger.debug("Removing {} from object tree", (Object)_path);
        ObjectTree objectTree = this;
        objectTree.recursiveRemove(objectTree.root, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String Introspect(String _path) {
        void var3_3;
        void var1_1;
        ObjectTree objectTree = this;
        TreeNode t = objectTree.recursiveFind(objectTree.root, _path);
        if (t == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<node name=\"");
        sb.append((String)var1_1);
        sb.append("\">\n");
        if (t.data != null) {
            sb.append(t.data);
        }
        t = t.down;
        while (t != null) {
            sb.append("<node name=\"");
            sb.append(t.name);
            sb.append("\"/>\n");
            t = t.right;
        }
        sb.append("</node>");
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String recursivePrint(TreeNode _current) {
        void var2_2;
        Object s = "";
        if (_current != null) {
            s = (String)s + _current.name;
            if (_current.object != null) {
                s = (String)s + "*";
            }
            if (_current.down != null) {
                s = (String)s + "/{" + this.recursivePrint(_current.down) + "}";
            }
            if (_current.right != null) {
                void var1_1;
                s = (String)s + ", " + this.recursivePrint(var1_1.right);
            }
        }
        return var2_2;
    }

    public String toString() {
        ObjectTree objectTree = this;
        return objectTree.recursivePrint(objectTree.root);
    }

    static class TreeNode {
        String name;
        ExportedObject object;
        String data;
        TreeNode right;
        TreeNode down;

        /*
         * WARNING - void declaration
         */
        TreeNode(String _name) {
            void var1_1;
            this.name = var1_1;
        }
    }
}

