/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodBase;

public class MethodCall
extends MethodBase {
    private static long replyWaitTimeout = Duration.ofSeconds(20L).toMillis();
    Message reply = null;

    MethodCall() {
    }

    /*
     * WARNING - void declaration
     */
    protected MethodCall(byte _endianess, String _source, String _dest, String _path, String _iface, String _member, byte _flags, String _sig, Object ... _args) throws DBusException {
        super(_endianess, (byte)1, _flags);
        void var1_2;
        if (_member == null || _path == null) {
            throw new MessageFormatException("Must specify destination, path and function name to MethodCalls.");
        }
        Object[] objectArray = this.getHeader();
        Object[] header = objectArray;
        objectArray[1] = _path;
        header[3] = _member;
        ArrayList<Object> hargs = new ArrayList<Object>();
        hargs.add(this.createHeaderArgs((byte)1, "o", _path));
        if (_source != null) {
            void var2_3;
            hargs.add(this.createHeaderArgs((byte)7, "s", var2_3));
        }
        if (_dest != null) {
            void var3_4;
            hargs.add(this.createHeaderArgs((byte)6, "s", var3_4));
        }
        if (_iface != null) {
            hargs.add(this.createHeaderArgs((byte)2, "s", _iface));
        }
        hargs.add(this.createHeaderArgs((byte)3, "s", _member));
        if (_sig != null) {
            this.logger.debug("Appending arguments with signature: {}", (Object)_sig);
            hargs.add(this.createHeaderArgs((byte)8, "g", _sig));
            this.setArgs(_args);
        }
        this.appendFileDescriptors(hargs, _args);
        this.padAndMarshall((List<Object>)var1_2, this.getSerial(), _sig, _args);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Message getReply(long _timeout) {
        this.logger.trace("Blocking on {}", (Object)this);
        if (this.reply != null) {
            return this.reply;
        }
        try {
            void var1_1;
            this.wait((long)var1_1);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.reply;
    }

    public synchronized Message getReply() {
        return this.getReply(replyWaitTimeout);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setReply(Message _reply) {
        void var1_1;
        this.logger.trace("Setting reply to {} to {}", (Object)this, (Object)_reply);
        this.reply = var1_1;
        this.notifyAll();
    }
}

