/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.List;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageTypeException;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;
import org.freedesktop.dbus.utils.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageFactory.class);
    private final byte endianess;

    public final byte getEndianess() {
        return this.endianess;
    }

    /*
     * WARNING - void declaration
     */
    public final MethodCall createMethodCall(String _source, String _dest, String _path, String _iface, String _member, byte _flags, String _sig, Object ... _args) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new MethodCall(this.endianess, (String)var1_1, (String)var2_2, (String)var3_3, _iface, _member, _flags, _sig, _args);
    }

    /*
     * WARNING - void declaration
     */
    public final MethodReturn createMethodReturn(MethodCall _mc, String _sig, Object ... _args) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new MethodReturn((MethodCall)var1_1, (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final Error createError(Message _m, Throwable _ex) throws DBusException {
        void var2_2;
        void var1_1;
        return new Error(this.endianess, (Message)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Message createMessage(byte _type, byte[] _buf, byte[] _header, byte[] _body, List<FileDescriptor> _filedescriptors) throws DBusException, MessageTypeException {
        void var0_1;
        void var3_4;
        void var2_3;
        void var1_2;
        Message m = switch (_type) {
            case 1 -> new MethodCall();
            case 2 -> new MethodReturn();
            case 4 -> new DBusSignal();
            case 3 -> new Error();
            default -> throw new MessageTypeException(String.format("Message type %s unsupported", _type));
        };
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(Hexdump.format(_buf));
            LOGGER.trace(Hexdump.format(_header));
            LOGGER.trace(Hexdump.format(_body));
        }
        m.populate((byte[])var1_2, (byte[])var2_3, (byte[])var3_4, _filedescriptors);
        return var0_1;
    }
}

