/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MarshallingException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.exceptions.UnknownTypeCodeException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.EmptyCollectionHelper;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.dbus.utils.Hexdump;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.freedesktop.dbus.utils.PrimitiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final ExtractOptions DEFAULT_OPTIONS = new ExtractOptions(false, List.of());
    private static byte[][] padding = new byte[][]{null, new byte[1], new byte[2], new byte[3], new byte[4], new byte[5], new byte[6], new byte[7]};
    private static final AtomicLong GLOBAL_SERIAL = new AtomicLong(0L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<FileDescriptor> filedescriptors = new ArrayList<FileDescriptor>();
    private final Object[] headers = new Object[10];
    private byte[][] wiredata = new byte[20][];
    private long bytecounter = 0L;
    private long serial;
    private byte type;
    private byte flags;
    private byte protover;
    private boolean big;
    private Object[] args;
    private byte[] body;
    private long bodylen = 0L;
    private int preallocated = 0;
    private int paofs = 0;
    private byte[] pabuf;
    private int bufferuse = 0;
    private boolean endianWasSet;

    /*
     * WARNING - void declaration
     */
    protected Message(byte _endian, byte _type, byte _flags) throws DBusException {
        this();
        void var3_3;
        void var2_2;
        void var1_1;
        this.big = 66 == _endian;
        this.setSerial(GLOBAL_SERIAL.incrementAndGet());
        this.logger.debug("Creating message with serial {}", (Object)this.getSerial());
        this.type = _type;
        this.flags = _flags;
        this.preallocate(4);
        this.endianWasSet = _endian != 0;
        this.append("yyyy", (byte)var1_1, (byte)var2_2, (byte)var3_3, (byte)1);
    }

    protected Message() {
    }

    /*
     * WARNING - void declaration
     */
    public void updateEndianess(byte _endianess) {
        if (this.endianWasSet) {
            return;
        }
        if (this.wiredata[0] != null) {
            this.wiredata[0][0] = _endianess;
        } else {
            void var1_1;
            this.wiredata[0] = new byte[]{var1_1, 0, 0, 0};
        }
        this.endianWasSet = true;
    }

    /*
     * WARNING - void declaration
     */
    void populate(byte[] _msg, byte[] _headers, byte[] _body, List<FileDescriptor> _descriptors) throws DBusException {
        Object object;
        byte[] msgBuf = new byte[_msg.length];
        System.arraycopy(_msg, 0, msgBuf, 0, _msg.length);
        byte[] headerBuf = new byte[_headers.length];
        System.arraycopy(_headers, 0, headerBuf, 0, _headers.length);
        Object bodyBuf = new byte[_body.length];
        System.arraycopy(_body, 0, bodyBuf, 0, _body.length);
        this.endianWasSet = true;
        this.big = msgBuf[0] == 66;
        this.type = msgBuf[1];
        this.flags = msgBuf[2];
        this.protover = msgBuf[3];
        this.wiredata[0] = msgBuf;
        this.wiredata[1] = headerBuf;
        this.wiredata[2] = bodyBuf;
        this.body = bodyBuf;
        this.bufferuse = 3;
        this.bodylen = ((Number)this.extract("u", msgBuf, 4, DEFAULT_OPTIONS)[0]).longValue();
        long extractedSerial = ((Number)this.extract("u", msgBuf, 8, DEFAULT_OPTIONS)[0]).longValue();
        this.logger.debug("Received message of type {} with serial {}", (Object)this.type, (Object)extractedSerial);
        this.setSerial(extractedSerial);
        this.bytecounter = (long)msgBuf.length + (long)headerBuf.length + (long)((byte[])bodyBuf).length;
        this.filedescriptors.clear();
        if (_descriptors != null) {
            this.filedescriptors.addAll(_descriptors);
        }
        LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> {
            void var1_1;
            this.logger.trace("Message header: {}", (Object)Hexdump.toAscii((byte[])var1_1));
        });
        Object[] hs = this.extractHeader(headerBuf);
        LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> {
            void var1_1;
            this.logger.trace("Extracted objects: {}", (Object)LoggingHelper.arraysVeryDeepString((Object[])var1_1));
        });
        object = (List)object[0];
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Object e = object.next();
            bodyBuf = e;
            Object[] objArr = (Object[])e;
            byte idx = (Byte)objArr[0];
            this.headers[var3_4] = var2_2[1];
        }
    }

    protected Object[] getHeader() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    protected void setHeader(Object[] _header) {
        void var1_1;
        if (_header == null) {
            return;
        }
        if (_header.length > this.headers.length) {
            throw new IllegalArgumentException("Given header is larger (" + _header.length + ") than allowed header size: " + this.headers.length);
        }
        System.arraycopy(_header, 0, this.headers, 0, ((void)var1_1).length);
    }

    protected long getByteCounter() {
        return this.bytecounter;
    }

    /*
     * WARNING - void declaration
     */
    protected void setByteCounter(long _bytecounter) {
        void var1_1;
        this.bytecounter = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void setSerial(long _serial) {
        void var1_1;
        this.serial = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void setWireData(byte[][] _wiredata) {
        void var1_1;
        this.wiredata = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void preallocate(int _num) {
        void var1_1;
        this.preallocated = 0;
        this.pabuf = new byte[_num];
        Message message = this;
        message.appendBytes(message.pabuf);
        this.preallocated = var1_1;
        this.paofs = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureBuffers(int _num) {
        int increase = _num - this.wiredata.length + this.bufferuse;
        if (increase > 0) {
            void var1_2;
            if (increase < 20) {
                increase = 20;
            }
            this.logger.trace("Resizing {}", (Object)this.bufferuse);
            byte[][] temp = new byte[this.wiredata.length + increase][];
            System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
            this.wiredata = var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendBytes(byte[] _buf) {
        void var1_1;
        if (_buf == null) {
            return;
        }
        if (this.preallocated > 0) {
            if (this.paofs + _buf.length > this.pabuf.length) {
                throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Array index out of bounds, paofs={0}, pabuf.length={1}, buf.length={2}.", this.paofs, this.pabuf.length, _buf.length));
            }
            System.arraycopy(_buf, 0, this.pabuf, this.paofs, _buf.length);
            this.paofs += _buf.length;
            this.preallocated -= _buf.length;
            return;
        }
        if (this.bufferuse == this.wiredata.length) {
            void var2_2;
            this.logger.trace("Resizing {}", (Object)this.bufferuse);
            byte[][] temp = new byte[this.wiredata.length + 20][];
            System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
            this.wiredata = var2_2;
        }
        this.wiredata[this.bufferuse++] = _buf;
        this.bytecounter += (long)((void)var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    protected void appendByte(byte _b) {
        void var1_1;
        if (this.preallocated > 0) {
            this.pabuf[this.paofs++] = _b;
            --this.preallocated;
            return;
        }
        if (this.bufferuse == this.wiredata.length) {
            void var2_2;
            this.logger.trace("Resizing {}", (Object)this.bufferuse);
            byte[][] temp = new byte[this.wiredata.length + 20][];
            System.arraycopy(this.wiredata, 0, temp, 0, this.wiredata.length);
            this.wiredata = var2_2;
        }
        this.wiredata[this.bufferuse++] = new byte[]{var1_1};
        ++this.bytecounter;
    }

    /*
     * WARNING - void declaration
     */
    protected long demarshallint(byte[] _buf, int _ofs, int _width) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.big) {
            return Message.demarshallintBig(_buf, _ofs, _width);
        }
        return Message.demarshallintLittle((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendint(long _l, int _width) {
        void var3_2;
        void var1_1;
        byte[] buf = new byte[_width];
        this.marshallint((long)var1_1, buf, 0, (int)var3_2);
        this.appendBytes(buf);
    }

    /*
     * WARNING - void declaration
     */
    protected void marshallint(long _l, byte[] _buf, int _ofs, int _width) {
        void var3_2;
        void var1_1;
        if (this.big) {
            Message.marshallintBig(_l, _buf, _ofs, _width);
        } else {
            Message.marshallintLittle(_l, _buf, _ofs, _width);
        }
        LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> this.lambda$marshallint$2((long)var1_1, (byte[])var3_2, _ofs, _width));
    }

    public byte[][] getWireData() {
        return this.wiredata;
    }

    public List<FileDescriptor> getFiledescriptors() {
        return this.filedescriptors;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(this.flags);
        sb.append(',');
        sb.append(this.getSerial());
        sb.append(')');
        sb.append(' ');
        sb.append('{');
        sb.append(' ');
        if (this.headers.length == 0) {
            sb.append('}');
        } else {
            for (int i = 0; i < this.headers.length; ++i) {
                sb.append(Message.getHeaderFieldName((byte)i));
                sb.append('=');
                sb.append('>');
                sb.append(this.headers[i]);
                sb.append(',');
                sb.append(' ');
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setCharAt(stringBuilder.length() - 2, ' ');
            StringBuilder stringBuilder2 = sb;
            stringBuilder2.setCharAt(stringBuilder2.length() - 1, '}');
        }
        sb.append(' ');
        sb.append('{');
        sb.append(' ');
        Object[] largs = null;
        try {
            largs = this.extractArgs(null);
        }
        catch (DBusException _ex) {
            void var3_5;
            this.logger.debug("", (Throwable)var3_5);
        }
        if (largs == null || 0 == largs.length) {
            sb.append('}');
        } else {
            void var2_3;
            for (void o : var2_3) {
                double[] da;
                long[] la;
                short[] sa;
                int[] ia;
                Object[] ba;
                Object[] oa;
                if (o == null) {
                    sb.append("null");
                } else if (o instanceof Object[]) {
                    oa = (Object[])o;
                    sb.append(Arrays.deepToString(oa));
                } else if (oa instanceof byte[]) {
                    ba = (byte[])oa;
                    sb.append(Arrays.toString(ba));
                } else if (ba instanceof int[]) {
                    ia = ba;
                    sb.append(Arrays.toString(ia));
                } else if (ia instanceof short[]) {
                    sa = (short[])ia;
                    sb.append(Arrays.toString(sa));
                } else if (sa instanceof long[]) {
                    la = sa;
                    sb.append(Arrays.toString(la));
                } else if (la instanceof boolean[]) {
                    ba = (boolean[])la;
                    sb.append(Arrays.toString((boolean[])ba));
                } else if (ba instanceof double[]) {
                    da = ba;
                    sb.append(Arrays.toString(da));
                } else if (da instanceof float[]) {
                    float[] fa = (float[])da;
                    sb.append(Arrays.toString(fa));
                } else {
                    void var5_8;
                    sb.append(var5_8);
                }
                sb.append(',');
                sb.append(' ');
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setCharAt(stringBuilder.length() - 2, ' ');
            StringBuilder stringBuilder3 = sb;
            stringBuilder3.setCharAt(stringBuilder3.length() - 1, '}');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected Object getHeader(byte _type) {
        void var1_1;
        if (this.headers.length == 0 || this.headers.length < _type) {
            return null;
        }
        return this.headers[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    protected void pad(byte _type) {
        void var1_1;
        void var2_2;
        this.logger.trace("padding for {}", (Object)Character.valueOf((char)_type));
        int a = Message.getAlignment(_type);
        this.logger.trace("{} {} {} {}", new Object[]{this.preallocated, this.paofs, this.bytecounter, a});
        int b = (int)((this.bytecounter - (long)this.preallocated) % (long)a);
        if (b == 0) {
            return;
        }
        a -= var2_2;
        if (this.preallocated > 0) {
            this.paofs += a;
            this.preallocated -= a;
        } else {
            this.appendBytes(padding[a]);
        }
        this.logger.trace("{} {} {} {}", new Object[]{this.preallocated, this.paofs, this.bytecounter, (int)var1_1});
    }

    protected void append(String _sig, Object ... _data) throws DBusException {
        LoggingHelper.logIf(this.logger.isDebugEnabled(), () -> {
            void var2_2;
            void var1_1;
            this.logger.debug("Appending sig: {} data: {}", (Object)var1_1, (Object)LoggingHelper.arraysVeryDeepString((Object[])var2_2));
        });
        byte[] sigb = _sig.getBytes();
        int j = 0;
        for (int i = 0; i < sigb.length; ++i) {
            this.logger.trace("Appending item: {} {} {}", new Object[]{i, Character.valueOf((char)sigb[i]), j});
            i = this.appendOne(sigb, i, _data[j++]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int appendOne(byte[] _sigb, int _sigofs, Object _data) throws DBusException {
        try {
            int i = _sigofs;
            this.logger.trace("{}", (Object)this.bytecounter);
            this.logger.trace("Appending type: {} value: {}", (Object)Character.valueOf((char)_sigb[i]), _data);
            this.pad(_sigb[i]);
            switch (_sigb[i]) {
                case 121: {
                    this.appendByte(((Number)_data).byteValue());
                    break;
                }
                case 98: {
                    this.appendint((Boolean)_data != false ? 1L : 0L, 4);
                    break;
                }
                case 100: {
                    long l = Double.doubleToLongBits(((Number)_data).doubleValue());
                    this.appendint(l, 8);
                    break;
                }
                case 102: {
                    int rf = Float.floatToIntBits(((Number)_data).floatValue());
                    this.appendint(rf, 4);
                    break;
                }
                case 117: {
                    this.appendint(((Number)_data).longValue(), 4);
                    break;
                }
                case 120: {
                    this.appendint(((Number)_data).longValue(), 8);
                    break;
                }
                case 116: {
                    if (this.big) {
                        this.appendint(((UInt64)_data).top(), 4);
                        this.appendint(((UInt64)_data).bottom(), 4);
                        break;
                    }
                    this.appendint(((UInt64)_data).bottom(), 4);
                    this.appendint(((UInt64)_data).top(), 4);
                    break;
                }
                case 105: {
                    this.appendint(((Number)_data).intValue(), 4);
                    break;
                }
                case 113: {
                    this.appendint(((Number)_data).intValue(), 2);
                    break;
                }
                case 110: {
                    this.appendint(((Number)_data).shortValue(), 2);
                    break;
                }
                case 104: {
                    this.filedescriptors.add((FileDescriptor)_data);
                    Message message = this;
                    message.appendint((long)message.filedescriptors.size() - 1L, 4);
                    this.logger.debug("Just inserted {} as filedescriptor", (Object)(this.filedescriptors.size() - 1));
                    break;
                }
                case 111: 
                case 115: {
                    String payload;
                    if (_data instanceof DBusInterface) {
                        DBusInterface rf = (DBusInterface)_data;
                        payload = rf.getObjectPath();
                    } else {
                        payload = _data.toString();
                    }
                    byte[] payloadbytes = payload.getBytes(StandardCharsets.UTF_8);
                    this.logger.trace("Appending String of length {}", (Object)payloadbytes.length);
                    this.appendint(payloadbytes.length, 4);
                    this.appendBytes(payloadbytes);
                    this.appendBytes(padding[1]);
                    break;
                }
                case 103: {
                    String payload;
                    if (_data instanceof Type[]) {
                        Type[] payloadbytes = (Type[])_data;
                        payload = Marshalling.getDBusType(payloadbytes);
                    } else {
                        payload = (String)_data;
                    }
                    byte[] pbytes = payload.getBytes();
                    this.preallocate(2 + pbytes.length);
                    this.appendByte((byte)pbytes.length);
                    this.appendBytes(pbytes);
                    this.appendByte((byte)0);
                    break;
                }
                case 97: {
                    if (this.logger.isTraceEnabled() && _data instanceof Object[]) {
                        Object[] oa = (Object[])_data;
                        this.logger.trace("Appending array: {}", (Object)Arrays.deepToString(oa));
                    }
                    byte[] alen = new byte[4];
                    this.appendBytes(alen);
                    this.pad(_sigb[++i]);
                    long c = this.bytecounter;
                    if (_data.getClass().isArray() && _data.getClass().getComponentType().isPrimitive()) {
                        byte[] primbuf;
                        int algn = Message.getAlignment(_sigb[i]);
                        int len = Array.getLength(_data);
                        switch (_sigb[i]) {
                            case 121: {
                                primbuf = (byte[])_data;
                                break;
                            }
                            case 105: 
                            case 110: 
                            case 120: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Array.getLong(_data, j), primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            case 98: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Array.getBoolean(_data, j) ? 1L : 0L, primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            case 100: {
                                primbuf = new byte[len * algn];
                                if (_data instanceof float[]) {
                                    float[] fa = (float[])_data;
                                    int j = 0;
                                    int k = 0;
                                    while (j < len) {
                                        this.marshallint(Double.doubleToRawLongBits(fa[j]), primbuf, k, algn);
                                        ++j;
                                        k += algn;
                                    }
                                } else {
                                    int j = 0;
                                    int k = 0;
                                    while (j < len) {
                                        this.marshallint(Double.doubleToRawLongBits(((double[])_data)[j]), primbuf, k, algn);
                                        ++j;
                                        k += algn;
                                    }
                                }
                                break;
                            }
                            case 102: {
                                primbuf = new byte[len * algn];
                                int j = 0;
                                int k = 0;
                                while (j < len) {
                                    this.marshallint(Float.floatToRawIntBits(((float[])_data)[j]), primbuf, k, algn);
                                    ++j;
                                    k += algn;
                                }
                                break;
                            }
                            default: {
                                throw new MarshallingException("Primitive array being sent as non-primitive array.");
                            }
                        }
                        this.appendBytes(primbuf);
                    } else if (_data instanceof Collection) {
                        Collection primbuf = (Collection)_data;
                        Object[] contents = primbuf.toArray();
                        int diff = i;
                        this.ensureBuffers(contents.length << 2);
                        Object[] len = contents;
                        int j = contents.length;
                        for (int k = 0; k < j; ++k) {
                            Object o = len[k];
                            diff = this.appendOne(_sigb, i, o);
                        }
                        if (contents.length == 0) {
                            diff = EmptyCollectionHelper.determineSignatureOffsetArray(_sigb, diff);
                        }
                        i = diff;
                    } else if (_data instanceof Map) {
                        Map map = (Map)_data;
                        int diff = i;
                        this.ensureBuffers(map.size() * 6);
                        for (Map.Entry o : map.entrySet()) {
                            diff = this.appendOne(_sigb, i, o);
                        }
                        if (map.isEmpty()) {
                            diff = EmptyCollectionHelper.determineSignatureOffsetDict(_sigb, diff);
                        }
                        i = diff;
                    } else {
                        Object[] contents = (Object[])_data;
                        this.ensureBuffers(contents.length << 2);
                        int diff = i;
                        Object[] o = contents;
                        int map = contents.length;
                        for (int j = 0; j < map; ++j) {
                            Object o2 = o[j];
                            diff = this.appendOne(_sigb, i, o2);
                        }
                        if (contents.length == 0) {
                            diff = EmptyCollectionHelper.determineSignatureOffsetArray(_sigb, diff);
                        }
                        i = diff;
                    }
                    this.logger.trace("start: {} end: {} length: {}", new Object[]{c, this.bytecounter, this.bytecounter - c});
                    Message message = this;
                    message.marshallint(message.bytecounter - c, alen, 0, 4);
                    break;
                }
                case 40: {
                    Object[] contents;
                    if (_data instanceof Container) {
                        Container map = (Container)_data;
                        contents = map.getParameters();
                    } else {
                        contents = (Object[])_data;
                    }
                    this.ensureBuffers(contents.length << 2);
                    int j = 0;
                    ++i;
                    while (_sigb[i] != 41) {
                        i = this.appendOne(_sigb, i, contents[j++]);
                        ++i;
                    }
                    break;
                }
                case 123: {
                    if (_data instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)_data;
                        ++i;
                        i = this.appendOne(_sigb, i, entry.getKey());
                        ++i;
                        i = this.appendOne(_sigb, i, entry.getValue());
                        ++i;
                        break;
                    }
                    Object[] contents = (Object[])_data;
                    int j = 0;
                    ++i;
                    while (_sigb[i] != 125) {
                        i = this.appendOne(_sigb, i, contents[j++]);
                        ++i;
                    }
                    break;
                }
                case 118: {
                    if (_data instanceof Variant) {
                        Variant variant = (Variant)_data;
                        this.appendOne(new byte[]{103}, 0, variant.getSig());
                        this.appendOne(variant.getSig().getBytes(), 0, variant.getValue());
                        break;
                    }
                    if (_data instanceof Object[]) {
                        Object[] oa = (Object[])_data;
                        this.appendOne(new byte[]{103}, 0, oa[0]);
                        this.appendOne(((String)oa[0]).getBytes(), 0, oa[1]);
                        break;
                    }
                    String sig = Marshalling.getDBusType(_data.getClass())[0];
                    this.appendOne(new byte[]{103}, 0, sig);
                    this.appendOne(sig.getBytes(), 0, _data);
                }
            }
            return i;
        }
        catch (ClassCastException _ex) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.logger.debug("Trying to marshall to unconvertible type.", (Throwable)_ex);
            throw new MarshallingException(MessageFormat.format("Trying to marshall to unconvertible type (from {0} to {1}).", var3_3.getClass().getName(), Character.valueOf((char)var1_1[var2_2])));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int align(int _current, byte _type) {
        void var2_2;
        void var1_1;
        this.logger.trace("aligning to {}", (Object)Character.valueOf((char)_type));
        int a = Message.getAlignment(_type);
        if (0 == _current % a) {
            return _current;
        }
        return _current + a - var1_1 % var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Object[] extractHeader(byte[] _headers) throws DBusException {
        void var2_2;
        void var1_1;
        int[] offsets = new int[]{0, 0};
        return this.extract("a(yv)", (byte[])var1_1, (int[])var2_2, DEFAULT_OPTIONS, this::readHeaderVariants);
    }

    /*
     * WARNING - void declaration
     */
    private Object readHeaderVariants(byte[] _signatureBuf, byte[] _dataBuf, int[] _offsets, ExtractOptions _options) throws DBusException {
        void var2_2;
        void var3_3;
        void var1_1;
        Object result;
        _offsets[1] = this.align(_offsets[1], _signatureBuf[_offsets[0]]);
        if (_signatureBuf[_offsets[0]] == 97) {
            result = this.extractArray(_signatureBuf, _dataBuf, _offsets, _options, this::readHeaderVariants);
        } else if (_signatureBuf[_offsets[0]] == 121) {
            result = this.extractByte((byte[])result, _offsets);
        } else if (_signatureBuf[_offsets[0]] == 118) {
            result = this.extractVariant((byte[])result, _offsets, DEFAULT_OPTIONS, (sig, obj) -> obj);
        } else if (_signatureBuf[_offsets[0]] == 40) {
            result = this.extractStruct(_signatureBuf, (byte[])result, _offsets, DEFAULT_OPTIONS, this::readHeaderVariants);
        } else {
            throw new MessageFormatException("Unsupported data type in header: " + _signatureBuf[_offsets[0]]);
        }
        this.logger.trace("Extracted header signature type '{}' to: '{}'", (Object)Character.valueOf((char)var1_1[var3_3[0]]), result);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object extractOne(byte[] _signatureBuf, byte[] _dataBuf, int[] _offsets, ExtractOptions _options) throws DBusException {
        Object[] objectArray;
        this.logger.trace("Extracting type: {} from offset {}", (Object)Character.valueOf((char)_signatureBuf[_offsets[0]]), (Object)_offsets[1]);
        _offsets[1] = this.align(_offsets[1], _signatureBuf[_offsets[0]]);
        switch (_signatureBuf[_offsets[0]]) {
            case 121: {
                Object rv = this.extractByte(_dataBuf, _offsets);
                break;
            }
            case 117: {
                Object rv = new UInt32(this.demarshallint(_dataBuf, _offsets[1], 4));
                _offsets[1] = _offsets[1] + 4;
                break;
            }
            case 105: {
                Object rv = (int)this.demarshallint(_dataBuf, _offsets[1], 4);
                _offsets[1] = _offsets[1] + 4;
                break;
            }
            case 110: {
                Object rv = (short)this.demarshallint(_dataBuf, _offsets[1], 2);
                _offsets[1] = _offsets[1] + 2;
                break;
            }
            case 113: {
                Object rv = new UInt16((int)this.demarshallint(_dataBuf, _offsets[1], 2));
                _offsets[1] = _offsets[1] + 2;
                break;
            }
            case 120: {
                Object rv = this.demarshallint(_dataBuf, _offsets[1], 8);
                _offsets[1] = _offsets[1] + 8;
                break;
            }
            case 116: {
                long bottom;
                long top;
                if (this.big) {
                    top = this.demarshallint(_dataBuf, _offsets[1], 4);
                    _offsets[1] = _offsets[1] + 4;
                    bottom = this.demarshallint(_dataBuf, _offsets[1], 4);
                } else {
                    bottom = this.demarshallint(_dataBuf, _offsets[1], 4);
                    _offsets[1] = _offsets[1] + 4;
                    top = this.demarshallint(_dataBuf, _offsets[1], 4);
                }
                Object rv = new UInt64(top, bottom);
                _offsets[1] = _offsets[1] + 4;
                break;
            }
            case 100: {
                long l = this.demarshallint(_dataBuf, _offsets[1], 8);
                _offsets[1] = _offsets[1] + 8;
                Object rv = Double.longBitsToDouble(l);
                break;
            }
            case 102: {
                int rf22 = (int)this.demarshallint(_dataBuf, _offsets[1], 4);
                _offsets[1] = _offsets[1] + 4;
                Float rf22 = Float.valueOf(Float.intBitsToFloat(rf22));
                break;
            }
            case 98: {
                void var1_3;
                int rf = (int)this.demarshallint(_dataBuf, _offsets[1], 4);
                _offsets[1] = _offsets[1] + 4;
                objectArray = true == var1_3 ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 97: {
                objectArray = this.extractArray((byte[])objectArray, _dataBuf, _offsets, _options, this::extractOne);
                break;
            }
            case 40: {
                objectArray = this.extractStruct((byte[])objectArray, _dataBuf, _offsets, _options, this::extractOne);
                break;
            }
            case 123: {
                Object[] decontents = new Object[2];
                LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> this.lambda$extractOne$5((byte[])objectArray, _offsets, _dataBuf));
                _offsets[0] = _offsets[0] + 1;
                decontents[0] = this.extractOne((byte[])objectArray, _dataBuf, _offsets, ExtractOptions.copyWithContainedFlag(_options, true));
                _offsets[0] = _offsets[0] + 1;
                decontents[1] = this.extractOne((byte[])objectArray, _dataBuf, _offsets, ExtractOptions.copyWithContainedFlag(_options, true));
                _offsets[0] = _offsets[0] + 1;
                objectArray = decontents;
                break;
            }
            case 118: {
                objectArray = this.extractVariant(_dataBuf, _offsets, _options, (sig, obj) -> {
                    void var1_1;
                    void var2_2;
                    this.logger.trace("Creating Variant with SIG: {} - Value: {}", sig, obj);
                    return new Variant<void>(var2_2, (String)var1_1);
                });
                break;
            }
            case 104: {
                objectArray = this.filedescriptors.get((int)this.demarshallint(_dataBuf, _offsets[1], 4));
                _offsets[1] = _offsets[1] + 4;
                break;
            }
            case 115: {
                int length = (int)this.demarshallint(_dataBuf, _offsets[1], 4);
                _offsets[1] = _offsets[1] + 4;
                objectArray = new String(_dataBuf, _offsets[1], length, StandardCharsets.UTF_8);
                _offsets[1] = _offsets[1] + (length + 1);
                break;
            }
            case 111: {
                int length = (int)this.demarshallint(_dataBuf, _offsets[1], 4);
                _offsets[1] = _offsets[1] + 4;
                objectArray = new DBusPath(this.getSource(), new String(_dataBuf, _offsets[1], length));
                _offsets[1] = _offsets[1] + (length + 1);
                break;
            }
            case 103: {
                void var2_4;
                int n = _offsets[1];
                _offsets[1] = n + 1;
                int length = _dataBuf[n] & 0xFF;
                objectArray = new String((byte[])var2_4, _offsets[1], length);
                _offsets[1] = _offsets[1] + (length + 1);
                break;
            }
            default: {
                throw new UnknownTypeCodeException((byte)objectArray[_offsets[0]]);
            }
        }
        if (this.logger.isTraceEnabled()) {
            if (objectArray instanceof Object[]) {
                Object[] oa = objectArray;
                this.logger.trace("Extracted: {} (now at {})", (Object)Arrays.deepToString(oa), (Object)_offsets[1]);
            } else {
                void var3_5;
                this.logger.trace("Extracted: {} (now at {})", (Object)objectArray, (Object)((int)var3_5[1]));
            }
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private Object extractByte(byte[] _dataBuf, int[] _offsets) {
        void var2_2;
        void v0 = var2_2;
        void v1 = v0[1];
        v0[1] = v1 + true;
        Byte by = _dataBuf[v1];
        return by;
    }

    private Object extractStruct(byte[] _signatureBuf, byte[] _dataBuf, int[] _offsets, ExtractOptions _options, ExtractMethod _extractMethod) throws DBusException {
        ArrayList<Object> contents = new ArrayList<Object>();
        while (_signatureBuf[_offsets[0] = _offsets[0] + 1] != 41) {
            contents.add(_extractMethod.extractOne(_signatureBuf, _dataBuf, _offsets, ExtractOptions.copyWithContainedFlag(_options, true)));
        }
        Object[] objectArray = contents.toArray();
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private Object extractArray(byte[] _signatureBuf, byte[] _dataBuf, int[] _offsets, ExtractOptions _options, ExtractMethod _extractMethod) throws MarshallingException, DBusException {
        void var1_1;
        void var3_3;
        void var2_2;
        long size = this.demarshallint(_dataBuf, _offsets[1], 4);
        this.logger.trace("Reading array of size: {}", (Object)size);
        _offsets[1] = _offsets[1] + 4;
        _offsets[0] = _offsets[0] + 1;
        byte algn = (byte)Message.getAlignment(_signatureBuf[_offsets[0]]);
        _offsets[1] = this.align(_offsets[1], _signatureBuf[_offsets[0]]);
        int length = (int)(size / (long)algn);
        if (length > 0x4000000) {
            throw new MarshallingException("Arrays must not exceed 67108864");
        }
        List rv = this.optimizePrimitives(_signatureBuf, (byte[])var2_2, (int[])var3_3, size, algn, length, _options, _extractMethod);
        if (_options.contained() && !(rv instanceof List) && !(rv instanceof Map)) {
            rv = ArrayFrob.listify(rv);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Object extractVariant(byte[] _dataBuf, int[] _offsets, ExtractOptions _options, BiFunction<String, Object, Object> _variantFactory) throws DBusException {
        void var1_1;
        void var3_3;
        int[] newofs = new int[]{0, _offsets[1]};
        String sig = (String)this.extract("g", _dataBuf, newofs, _options)[0];
        newofs[0] = 0;
        Object rv = _variantFactory.apply(sig, this.extract(sig, _dataBuf, newofs, (ExtractOptions)var3_3)[0]);
        var2_2[1] = newofs[1];
        return var1_1;
    }

    private Object optimizePrimitives(byte[] _signatureBuf, byte[] _dataBuf, int[] _offsets, long _size, byte _algn, int _length, ExtractOptions _options, ExtractMethod _extractMethod) throws DBusException {
        long end;
        int ofssave;
        Object rv = null;
        int offsetPos = _offsets[0] - 1;
        offsetPos = _options.arrayConvert() != null && _options.arrayConvert().size() > offsetPos && _options.arrayConvert().get(offsetPos) == ConstructorArgType.PRIMITIVE_ARRAY ? 1 : 0;
        if (offsetPos != 0) {
            switch (_signatureBuf[_offsets[0]]) {
                case 121: {
                    rv = new byte[_length];
                    System.arraycopy(_dataBuf, _offsets[1], rv, 0, _length);
                    _offsets[1] = (int)((long)_offsets[1] + _size);
                    break;
                }
                case 110: {
                    int j;
                    rv = new short[_length];
                    for (j = 0; j < _length; ++j) {
                        ((short[])rv)[j] = (short)this.demarshallint(_dataBuf, _offsets[1], _algn);
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
                case 105: {
                    int j;
                    rv = new int[_length];
                    for (j = 0; j < _length; ++j) {
                        ((int[])rv)[j] = (int)this.demarshallint(_dataBuf, _offsets[1], _algn);
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
                case 120: {
                    int j;
                    rv = new long[_length];
                    for (j = 0; j < _length; ++j) {
                        ((long[])rv)[j] = this.demarshallint(_dataBuf, _offsets[1], _algn);
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
                case 98: {
                    int j;
                    rv = new boolean[_length];
                    for (j = 0; j < _length; ++j) {
                        ((boolean[])rv)[j] = 1L == this.demarshallint(_dataBuf, _offsets[1], _algn);
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
                case 102: {
                    int j;
                    rv = new float[_length];
                    for (j = 0; j < _length; ++j) {
                        ((float[])rv)[j] = Float.intBitsToFloat((int)this.demarshallint(_dataBuf, _offsets[1], _algn));
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
                case 100: {
                    int j;
                    rv = new double[_length];
                    for (j = 0; j < _length; ++j) {
                        ((double[])rv)[j] = Double.longBitsToDouble(this.demarshallint(_dataBuf, _offsets[1], _algn));
                        _offsets[1] = _offsets[1] + _algn;
                    }
                    break;
                }
            }
        }
        if (_signatureBuf[_offsets[0]] == 123) {
            ofssave = this.prepareCollection(_signatureBuf, _offsets, _size);
            end = (long)_offsets[1] + _size;
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            while ((long)_offsets[1] < end) {
                _offsets[0] = ofssave;
                Object[] data = (Object[])_extractMethod.extractOne(_signatureBuf, _dataBuf, _offsets, ExtractOptions.copyWithContainedFlag(_options, true));
                map.put(data[0], data[1]);
            }
            rv = map;
        }
        if (rv == null) {
            ofssave = this.prepareCollection(_signatureBuf, _offsets, _size);
            end = (long)_offsets[1] + _size;
            ArrayList<Object> contents = new ArrayList<Object>();
            while ((long)_offsets[1] < end) {
                _offsets[0] = ofssave;
                contents.add(_extractMethod.extractOne(_signatureBuf, _dataBuf, _offsets, ExtractOptions.copyWithContainedFlag(_options, true)));
            }
            rv = contents;
        }
        return rv;
    }

    /*
     * WARNING - void declaration
     */
    private int prepareCollection(byte[] _signatureBuf, int[] _offsets, long _size) throws DBusException {
        void var2_2;
        if (0L == _size) {
            void var3_5;
            void var1_1;
            ArrayList<Type> temp = new ArrayList<Type>();
            byte[] temp2 = new byte[_signatureBuf.length - _offsets[0]];
            System.arraycopy(_signatureBuf, _offsets[0], temp2, 0, temp2.length);
            String temp3 = new String(temp2);
            int temp4 = Marshalling.getJavaType(temp3, temp, 1) - 1;
            _offsets[0] = _offsets[0] + temp4;
            this.logger.trace("Aligned type: {} {} {}", new Object[]{var1_1, (int)var3_5, _offsets[0]});
        }
        return (int)var2_2[0];
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] extract(String _signature, byte[] _dataBuf, int _offsets, ExtractOptions _options) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.extract((String)var1_1, (byte[])var2_2, new int[]{0, var3_3}, _options);
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] extract(String _signature, byte[] _dataBuf, int[] _offsets, ExtractOptions _options) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.extract((String)var1_1, (byte[])var2_2, (int[])var3_3, _options, this::extractOne);
    }

    /*
     * WARNING - void declaration
     */
    Object[] extract(String _signature, byte[] _dataBuf, int[] _offsets, ExtractOptions _options, ExtractMethod _method) throws DBusException {
        void i;
        this.logger.trace("extract({},#{}, {{},{}}", new Object[]{_signature, _dataBuf.length, _offsets[0], _offsets[1]});
        ArrayList<Object> rv = new ArrayList<Object>();
        byte[] sigb = _signature.getBytes();
        while (i[0] < sigb.length) {
            rv.add(_method.extractOne(sigb, _dataBuf, (int[])i, ExtractOptions.copyWithContainedFlag(_options, false)));
            void v0 = i;
            v0[0] = v0[0] + true;
        }
        return rv.toArray();
    }

    public String getSource() {
        return (String)this.getHeader((byte)7);
    }

    public String getDestination() {
        return (String)this.getHeader((byte)6);
    }

    public String getInterface() {
        return (String)this.getHeader((byte)2);
    }

    /*
     * WARNING - void declaration
     */
    public String getPath() {
        void var1_1;
        Object o = this.getHeader((byte)1);
        if (o == null) {
            return null;
        }
        return var1_1.toString();
    }

    public String getName() {
        if (this instanceof Error) {
            return (String)this.getHeader((byte)4);
        }
        return (String)this.getHeader((byte)3);
    }

    public String getSig() {
        return (String)this.getHeader((byte)8);
    }

    public int getFlags() {
        return this.flags;
    }

    public synchronized long getSerial() {
        return this.serial;
    }

    /*
     * WARNING - void declaration
     */
    public long getReplySerial() {
        void var1_1;
        Number l = (Number)this.getHeader((byte)5);
        if (l == null) {
            return 0L;
        }
        return var1_1.longValue();
    }

    public Object[] getParameters() throws DBusException {
        return this.getParameters(null);
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getParameters(List<Type[]> _constructorArgs) throws DBusException {
        if (this.args == null && this.body != null) {
            void var1_1;
            this.args = this.extractArgs((List<Type[]>)var1_1);
        }
        return this.args;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] extractArgs(List<Type[]> _constructorArgs) throws DBusException {
        ExtractOptions extractOptions;
        String sig = this.getSig();
        ExtractOptions options = DEFAULT_OPTIONS;
        if (_constructorArgs != null && !_constructorArgs.isEmpty()) {
            void var1_1;
            ArrayList<Type> dataType = new ArrayList<Type>();
            Marshalling.getJavaType(this.getSig(), dataType, -1);
            extractOptions = new ExtractOptions(DEFAULT_OPTIONS.contained(), Message.usesPrimitives((List<Type[]>)var1_1, (List<Type>)((Object)extractOptions)));
        }
        if (sig != null && this.body != null && this.body.length != 0) {
            void var2_2;
            return this.extract((String)var2_2, this.body, 0, extractOptions);
        }
        return new Object[0];
    }

    /*
     * WARNING - void declaration
     */
    static List<ConstructorArgType> usesPrimitives(List<Type[]> _constructorArgs, List<Type> _dataType) {
        void var2_2;
        Iterator<Type[]> iterator;
        Logger logger = LoggerFactory.getLogger(Message.class);
        iterator = iterator.iterator();
        block0: while (iterator.hasNext()) {
            Type[] ptype = (Type[])iterator.next();
            if (ptype.length != _dataType.size()) continue;
            ArrayList<ConstructorArgType> argTypes = new ArrayList<ConstructorArgType>();
            for (int i = 0; i < ptype.length; ++i) {
                Class sigExpectedClz;
                ParameterizedType pt;
                Class constructorClz;
                logger.trace(">>>>>> Comparing {} with {}", (Object)ptype[i], (Object)_dataType.get(i));
                Type type = ptype[i];
                if (type instanceof Class && (constructorClz = (Class)type).isArray() && (type = _dataType.get(i)) instanceof ParameterizedType && (pt = (ParameterizedType)type).getRawType() == List.class && pt.getActualTypeArguments().length > 0 && (type = pt.getActualTypeArguments()[0]) instanceof Class) {
                    sigExpectedClz = (Class)type;
                    logger.trace("Found List type when array was required, trying to find proper array type");
                    if (PrimitiveUtils.isCompatiblePrimitiveOrWrapper(constructorClz.getComponentType(), sigExpectedClz)) {
                        ConstructorArgType type2 = constructorClz.getComponentType().isPrimitive() ? ConstructorArgType.PRIMITIVE_ARRAY : ConstructorArgType.ARRAY;
                        logger.trace("Selecting {} for parameter {} <=> {}", new Object[]{type2, constructorClz.getComponentType(), sigExpectedClz});
                        argTypes.add(type2);
                        continue;
                    }
                    logger.trace("List uses a different type than required. Found {}, required {}", constructorClz.getComponentType(), (Object)sigExpectedClz);
                    continue block0;
                }
                type = ptype[i];
                if (type instanceof Class) {
                    Class clz = (Class)type;
                    type = _dataType.get(i);
                    if (type instanceof ParameterizedType && clz.isAssignableFrom((Class)(pt = (ParameterizedType)type).getRawType()) && Collection.class.isAssignableFrom(clz)) {
                        logger.trace("Found compatible collection type: {} <=> {}", (Object)clz, (Object)pt.getRawType());
                        argTypes.add(ConstructorArgType.COLLECTION);
                        continue;
                    }
                }
                if ((type = ptype[i]) instanceof Class) {
                    constructorClz = (Class)type;
                    type = _dataType.get(i);
                    if (type instanceof Class && !(sigExpectedClz = (Class)type).isAssignableFrom(constructorClz) && !PrimitiveUtils.isCompatiblePrimitiveOrWrapper(constructorClz, sigExpectedClz)) {
                        logger.trace("Constructor data type mismatch, must be wrong constructor ({} != {})", (Object)constructorClz, (Object)sigExpectedClz);
                        continue block0;
                    }
                }
                logger.trace("Type {} is not an array type, skipping", (Object)ptype[i]);
                argTypes.add(ConstructorArgType.NOT_ARRAY_TYPE);
            }
            return argTypes;
        }
        var2_2.trace("No matching constructor arguments found");
        return List.of();
    }

    /*
     * WARNING - void declaration
     */
    public void setArgs(Object[] _args) {
        void var1_1;
        this.args = var1_1;
    }

    public byte getType() {
        return this.type;
    }

    public byte getEndianess() {
        if (this.endianWasSet) {
            if (this.big) {
                return 66;
            }
            return 108;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] createHeaderArgs(byte _header, String _argType, Object _value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getHeader()[_header] = _value;
        return new Object[]{(byte)var1_1, new Object[]{var2_2, var3_3}};
    }

    /*
     * WARNING - void declaration
     */
    protected void padAndMarshall(List<Object> _hargs, long _serial, String _sig, Object ... _args) throws DBusException {
        void var1_1;
        void var2_2;
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", (long)var2_2, var1_1.toArray());
        this.pad((byte)8);
        long c = this.getByteCounter();
        if (_sig != null) {
            this.append(_sig, _args);
        }
        this.logger.trace("Appended body, type: {} start: {} end: {} size: {}", new Object[]{_sig, c, this.getByteCounter(), this.getByteCounter() - c});
        Message message = this;
        message.marshallint(message.getByteCounter() - c, blen, 0, 4);
        LoggingHelper.logIf(this.logger.isTraceEnabled(), () -> {
            void var1_1;
            void v0 = var1_1;
            this.logger.trace("marshalled size ({}): {}", (Object)v0, (Object)Hexdump.format((byte[])v0));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static long demarshallint(byte[] _buf, int _ofs, byte _endian, int _width) {
        void var3_3;
        void var1_1;
        byte[] byArray;
        if (_endian == 66) {
            return Message.demarshallintBig(_buf, _ofs, _width);
        }
        return Message.demarshallintLittle(byArray, (int)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static long demarshallintBig(byte[] _buf, int _ofs, int _width) {
        void var3_3;
        long l = 0L;
        for (int i = 0; i < _width; ++i) {
            l <<= 8;
            l |= (long)(_buf[_ofs + i] & 0xFF);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long demarshallintLittle(byte[] _buf, int _ofs, int _width) {
        void var3_3;
        long l = 0L;
        for (int i = _width - 1; i >= 0; --i) {
            l <<= 8;
            l |= (long)(_buf[_ofs + i] & 0xFF);
        }
        return (long)var3_3;
    }

    public static void marshallintBig(long _l, byte[] _buf, int _ofs, int _width) {
        long l = _l;
        for (int i = _width - 1; i >= 0; --i) {
            _buf[i + _ofs] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void marshallintLittle(long _l, byte[] _buf, int _ofs, int _width) {
        long l = _l;
        for (int i = 0; i < _width; ++i) {
            _buf[i + _ofs] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static int getAlignment(byte _type) {
        switch (_type) {
            case 2: 
            case 110: 
            case 113: {
                return 2;
            }
            case 4: 
            case 97: 
            case 98: 
            case 102: 
            case 104: 
            case 105: 
            case 111: 
            case 115: 
            case 117: {
                return 4;
            }
            case 8: 
            case 40: 
            case 41: 
            case 100: 
            case 101: 
            case 114: 
            case 116: 
            case 120: 
            case 123: 
            case 125: {
                return 8;
            }
            case 1: 
            case 103: 
            case 118: 
            case 121: {
                return 1;
            }
        }
        return 1;
    }

    public static String getHeaderFieldName(byte _field) {
        switch (_field) {
            case 1: {
                return "Path";
            }
            case 2: {
                return "Interface";
            }
            case 3: {
                return "Member";
            }
            case 4: {
                return "Error Name";
            }
            case 5: {
                return "Reply Serial";
            }
            case 6: {
                return "Destination";
            }
            case 7: {
                return "Sender";
            }
            case 8: {
                return "Signature";
            }
            case 9: {
                return "Unix FD";
            }
        }
        return "Invalid";
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$extractOne$5(byte[] _signatureBuf, int[] _offsets, byte[] _dataBuf) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.logger.trace("Extracting Dict Entry ({}) from: {}", (Object)Hexdump.toAscii(_signatureBuf, _offsets[0], ((void)var1_1).length - _offsets[0]), (Object)Hexdump.toHex(_dataBuf, _offsets[1], ((void)var3_3).length - var2_2[1], true));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$marshallint$2(long _l, byte[] _buf, int _ofs, int _width) {
        void var3_2;
        void var1_1;
        this.logger.trace("Marshalled int {} to {}", (Object)((long)var1_1), (Object)Hexdump.toHex((byte[])var3_2, _ofs, _width, true));
    }

    static final class ExtractOptions
    extends Record {
        private final boolean contained;
        private final List<ConstructorArgType> arrayConvert;

        /*
         * WARNING - void declaration
         */
        ExtractOptions(boolean contained, List<ConstructorArgType> arrayConvert) {
            void var2_2;
            void var1_1;
            this.contained = var1_1;
            this.arrayConvert = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        static ExtractOptions copyWithContainedFlag(ExtractOptions _toCopy, boolean _containedFlag) {
            ExtractOptions extractOptions;
            void var1_1;
            return new ExtractOptions((boolean)var1_1, extractOptions.arrayConvert());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ExtractOptions.class, "contained;arrayConvert", "contained", "arrayConvert"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ExtractOptions.class, "contained;arrayConvert", "contained", "arrayConvert"}, this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object o) {
            void var1_1;
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ExtractOptions.class, "contained;arrayConvert", "contained", "arrayConvert"}, this, var1_1);
        }

        public final boolean contained() {
            return this.contained;
        }

        public final List<ConstructorArgType> arrayConvert() {
            return this.arrayConvert;
        }
    }

    @FunctionalInterface
    static interface ExtractMethod {
        public Object extractOne(byte[] var1, byte[] var2, int[] var3, ExtractOptions var4) throws DBusException;
    }

    static final class ConstructorArgType
    extends Enum<ConstructorArgType> {
        public static final /* enum */ ConstructorArgType PRIMITIVE_ARRAY = new ConstructorArgType();
        public static final /* enum */ ConstructorArgType ARRAY = new ConstructorArgType();
        public static final /* enum */ ConstructorArgType COLLECTION = new ConstructorArgType();
        public static final /* enum */ ConstructorArgType NOT_ARRAY_TYPE = new ConstructorArgType();
        private static final /* synthetic */ ConstructorArgType[] $VALUES;

        private static /* synthetic */ ConstructorArgType[] $values() {
            return new ConstructorArgType[]{PRIMITIVE_ARRAY, ARRAY, COLLECTION, NOT_ARRAY_TYPE};
        }

        static {
            $VALUES = ConstructorArgType.$values();
        }
    }
}

