/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.StrongReference;
import org.freedesktop.dbus.TypeRef;
import org.freedesktop.dbus.annotations.DBusBoundProperty;
import org.freedesktop.dbus.annotations.DBusIgnore;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.DBusProperties;
import org.freedesktop.dbus.annotations.DBusProperty;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.annotations.PropertiesEmitsChangedSignal;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.propertyref.PropertyRef;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.LoggerFactory;

public class ExportedObject {
    private final Map<MethodTuple, Method> methods;
    private final Map<PropertyRef, Method> propertyMethods;
    private final String introspectionData;
    private final Reference<DBusInterface> object;
    private final Set<Class<?>> implementedInterfaces;

    /*
     * WARNING - void declaration
     */
    public ExportedObject(DBusInterface _object, boolean _weakreferences) throws DBusException {
        void var1_1;
        void var2_2;
        this.object = var2_2 != false ? new WeakReference<DBusInterface>(_object) : new StrongReference<DBusInterface>(_object);
        this.methods = new HashMap<MethodTuple, Method>();
        this.propertyMethods = new HashMap<PropertyRef, Method>();
        this.implementedInterfaces = this.getDBusInterfaces(var1_1.getClass());
        this.implementedInterfaces.add(Introspectable.class);
        this.implementedInterfaces.add(Peer.class);
        this.introspectionData = this.generateIntrospectionXml(this.implementedInterfaces);
    }

    /*
     * WARNING - void declaration
     */
    protected String generateAnnotationsXml(AnnotatedElement _c) {
        void var2_2;
        Annotation[] annotationArray;
        StringBuilder ans = new StringBuilder();
        for (Annotation a : annotationArray.getDeclaredAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(DBusInterfaceName.class)) continue;
            Class<? extends Annotation> t = a.annotationType();
            String value = "";
            try {
                Method method = t.getMethod("value", new Class[0]);
                value = method.invoke((Object)a, new Object[0]).toString();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException _ex) {
                LoggerFactory.getLogger(this.getClass()).trace("Could not find value", (Throwable)_ex);
            }
            String name = DBusNamingUtil.getAnnotationName(t);
            ans.append("  <annotation name=\"").append(name).append("\" value=\"").append(value).append("\" />\n");
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String generatePropertyXml(String _propertyName, Class<?> _propertyTypeClass, DBusProperty.Access _access, PropertiesEmitsChangedSignal.EmitChangeSignal _emitChangeSignal) throws DBusException {
        void var2_2;
        void var1_1;
        void var3_3;
        String propertyTypeString;
        if (TypeRef.class.isAssignableFrom(_propertyTypeClass)) {
            Type actualType = Optional.ofNullable(Util.unwrapTypeRef(_propertyTypeClass)).orElseThrow(() -> {
                String string;
                return new DBusException("Could not read TypeRef type for property '" + string + "'");
            });
            propertyTypeString = Marshalling.getDBusType(new Type[]{actualType});
        } else {
            propertyTypeString = List.class.equals((Object)propertyTypeString) ? "av" : (Map.class.equals((Object)propertyTypeString) ? "a{vv}" : Marshalling.getDBusType(new Type[]{propertyTypeString}));
        }
        String access = var3_3.getAccessName();
        if (_emitChangeSignal != null && _emitChangeSignal != PropertiesEmitsChangedSignal.EmitChangeSignal.TRUE) {
            return "<property name=\"" + _propertyName + "\" type=\"" + propertyTypeString + "\" access=\"" + access + "\">\n    <annotation name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\" value=\"" + _emitChangeSignal.name().toLowerCase() + "\"/>\n  </property>\n";
        }
        return "<property name=\"" + (String)var1_1 + "\" type=\"" + (String)var2_2 + "\" access=\"" + access + "\" />";
    }

    /*
     * WARNING - void declaration
     */
    protected String generatePropertiesXml(Class<?> _clz) throws DBusException {
        void var3_3;
        DBusProperty property;
        PropertiesEmitsChangedSignal.EmitChangeSignal globalChangeSignal = Optional.ofNullable(_clz.getAnnotation(PropertiesEmitsChangedSignal.class)).map(e -> e.value()).orElse(PropertiesEmitsChangedSignal.EmitChangeSignal.TRUE);
        StringBuilder xml = new StringBuilder();
        HashMap<String, PropertyRef> map = new HashMap<String, PropertyRef>();
        DBusProperty[] properties = _clz.getAnnotation(DBusProperties.class);
        if (properties != null) {
            for (DBusProperty property2 : properties.value()) {
                if (map.containsKey(property2.name())) {
                    throw new DBusException(MessageFormat.format("Property ''{0}'' defined multiple times.", property2.name()));
                }
                map.put(property2.name(), new PropertyRef(property2));
            }
        }
        if ((property = _clz.getAnnotation(DBusProperty.class)) != null) {
            if (map.containsKey(property.name())) {
                throw new DBusException(MessageFormat.format("Property ''{0}'' defined multiple times.", property.name()));
            }
            map.put(property.name(), new PropertyRef(property));
        }
        for (Method method : _clz.getDeclaredMethods()) {
            DBusBoundProperty propertyAnnot = method.getAnnotation(DBusBoundProperty.class);
            if (propertyAnnot == null) continue;
            String name = DBusNamingUtil.getPropertyName(method);
            DBusProperty.Access access = PropertyRef.accessForMethod(method);
            PropertyRef.checkMethod(method);
            Class<?> type = PropertyRef.typeForMethod(method);
            PropertyRef ref = new PropertyRef(name, type, access);
            this.propertyMethods.put(ref, method);
            if (map.containsKey(name)) {
                void var1_1;
                PropertyRef existing = (PropertyRef)map.get(name);
                if (access.equals((Object)existing.getAccess())) {
                    throw new DBusException(MessageFormat.format("Property ''{0}'' has access mode ''{1}'' defined multiple times.", new Object[]{name, access}));
                }
                PropertiesEmitsChangedSignal.EmitChangeSignal emitSignal = Optional.ofNullable(propertyAnnot.emitChangeSignal()).filter(s -> {
                    PropertiesEmitsChangedSignal.EmitChangeSignal emitChangeSignal;
                    return s == emitChangeSignal;
                }).orElse(globalChangeSignal);
                map.put(name, new PropertyRef(name, type, DBusProperty.Access.READ_WRITE, (PropertiesEmitsChangedSignal.EmitChangeSignal)var1_1));
                continue;
            }
            map.put(name, ref);
        }
        for (PropertyRef ref : map.values()) {
            xml.append("  ").append(this.generatePropertyXml(ref.getName(), ref.getType(), ref.getAccess(), ref.getEmitChangeSignal())).append("\n");
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String generateMethodsXml(Class<?> _clz) throws DBusException {
        void var2_2;
        Method[] methodArray;
        StringBuilder sb = new StringBuilder();
        for (Method meth : methodArray.getDeclaredMethods()) {
            if (ExportedObject.isExcluded(meth)) continue;
            String methodName = DBusNamingUtil.getMethodName(meth);
            if (methodName.length() > 255) {
                throw new DBusException("Introspected method name exceeds 255 characters. Cannot export objects with method " + methodName);
            }
            sb.append("  <method name=\"").append(methodName).append("\" >\n");
            sb.append(this.generateAnnotationsXml(meth));
            for (Class<?> ex : meth.getExceptionTypes()) {
                if (!DBusExecutionException.class.isAssignableFrom(ex)) continue;
                sb.append("   <annotation name=\"org.freedesktop.DBus.Method.Error\" value=\"").append(AbstractConnection.DOLLAR_PATTERN.matcher(ex.getName()).replaceAll(".")).append("\" />\n");
            }
            StringBuilder ms = new StringBuilder();
            for (Type type : meth.getGenericParameterTypes()) {
                for (String s : Marshalling.getDBusType(type)) {
                    sb.append("   <arg type=\"").append(s).append("\" direction=\"in\"/>\n");
                    ms.append(s);
                }
            }
            if (!Void.TYPE.equals(meth.getGenericReturnType())) {
                if (Container.class.isAssignableFrom(meth.getReturnType())) {
                    this.createReturnArguments(meth, sb);
                } else {
                    if (Object[].class.equals((Object)meth.getGenericReturnType())) {
                        throw new DBusException("Return type of Object[] cannot be introspected properly");
                    }
                    for (String string : Marshalling.getDBusType(meth.getGenericReturnType())) {
                        sb.append("   <arg type=\"").append(string).append("\" direction=\"out\"/>\n");
                    }
                }
            }
            sb.append("  </method>\n");
            this.methods.putIfAbsent(new MethodTuple(methodName, ms.toString()), meth);
        }
        return var2_2.toString();
    }

    private void createReturnArguments(Method _meth, StringBuilder _sb) throws DBusException {
        Type type;
        String[] stringArray;
        if (_meth == null || _sb == null || Void.TYPE.equals(_meth.getGenericReturnType())) {
            return;
        }
        List<Type> argTypes = new ArrayList();
        Type object = _meth.getGenericReturnType();
        if (object instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)object;
            argTypes = Arrays.asList(pt.getActualTypeArguments());
            for (Type t22 : stringArray.getActualTypeArguments()) {
                if (t22 == null) continue;
                stringArray = Marshalling.getDBusType(t22);
                int t22 = stringArray.length;
                for (int i = 0; i < t22; ++i) {
                    String s = stringArray[i];
                    _sb.append("   <arg type=\"").append(s).append("\" direction=\"out\"/>\n");
                }
            }
        } else {
            Type type2 = stringArray.getGenericReturnType();
            if (type2 instanceof Class) {
                argTypes = (Class)type2;
                argTypes = Arrays.stream(((Class)((Object)argTypes)).getDeclaredFields()).filter(f -> f.isAnnotationPresent(Position.class)).filter(Objects::nonNull).map(f -> {
                    Field field;
                    return Map.entry(f.getAnnotation(Position.class).value(), field);
                }).sorted(Comparator.comparingInt(k -> (Integer)k.getKey())).map(f -> (Field)f.getValue()).map(Field::getType).map(Type.class::cast).toList();
            }
        }
        stringArray = type.iterator();
        while (stringArray.hasNext()) {
            type = (Type)stringArray.next();
            for (String s : Marshalling.getDBusType(type)) {
                _sb.append("   <arg type=\"").append(s).append("\" direction=\"out\"/>\n");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String generateSignalsXml(Class<?> _clz) throws DBusException {
        void var2_2;
        Class<?>[] classArray;
        StringBuilder sb = new StringBuilder();
        for (Class<?> sig : classArray.getDeclaredClasses()) {
            if (!DBusSignal.class.isAssignableFrom(sig)) continue;
            Object signalName = DBusNamingUtil.getSignalName(sig);
            if (sig.isAnnotationPresent(DBusMemberName.class)) {
                DBusSignal.addSignalMap(sig.getSimpleName(), (String)signalName);
            }
            if (((String)signalName).length() > 255) {
                throw new DBusException("Introspected signal name exceeds 255 characters. Cannot export objects with signals of type " + (String)signalName);
            }
            sb.append("  <signal name=\"").append((String)signalName).append("\">\n");
            signalName = sig.getConstructors()[0];
            Type[] ts = ((Constructor)signalName).getGenericParameterTypes();
            for (int j = 1; j < ts.length; ++j) {
                for (String s : Marshalling.getDBusType(ts[j])) {
                    sb.append("   <arg type=\"").append(s).append("\" direction=\"out\" />\n");
                }
            }
            sb.append(this.generateAnnotationsXml(sig));
            sb.append("  </signal>\n");
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected Set<Class<?>> getDBusInterfaces(Class<?> _inputClazz) {
        void var2_2;
        Objects.requireNonNull(_inputClazz, "inputClazz must not be null");
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        LinkedHashSet<Class> checked = new LinkedHashSet<Class>();
        LinkedList toCheck = new LinkedList();
        toCheck.add(_inputClazz);
        while (!toCheck.isEmpty()) {
            void var1_1;
            List<Class<?>> interfaces;
            Class clazz = (Class)toCheck.poll();
            checked.add(clazz);
            Class superClass = clazz.getSuperclass();
            if (superClass != null && DBusInterface.class.isAssignableFrom(superClass)) {
                toCheck.add(superClass);
            }
            if ((interfaces = Arrays.asList(clazz.getInterfaces())).contains(DBusInterface.class)) {
                result.add(clazz);
            }
            Arrays.stream(var1_1.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(DBusBoundProperty.class)).findAny().ifPresent(x -> toCheck.add(Properties.class));
            interfaces.stream().filter(DBusInterface.class::isAssignableFrom).filter(i -> i != DBusInterface.class).filter(i -> {
                void var1_1;
                return !checked.contains(var1_1);
            }).forEach(toCheck::add);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String generateIntrospectionXml(Set<Class<?>> _interfaces) throws DBusException {
        void var2_2;
        Iterator iterator;
        StringBuilder sb = new StringBuilder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Class iface = (Class)iterator.next();
            String ifaceName = DBusNamingUtil.getInterfaceName(iface);
            if (ifaceName.equals(iface.getSimpleName())) {
                throw new DBusException("DBusInterfaces cannot be declared outside a package");
            }
            if (ifaceName.length() > 255) {
                throw new DBusException("Introspected interface name exceeds 255 characters. Cannot export objects of type " + ifaceName);
            }
            if (iface.isAnnotationPresent(DBusInterfaceName.class)) {
                DBusSignal.addInterfaceMap(iface.getName(), ifaceName);
            }
            sb.append(" <interface name=\"").append(ifaceName).append("\">\n");
            sb.append(this.generateAnnotationsXml(iface));
            sb.append(this.generateMethodsXml(iface));
            sb.append(this.generatePropertiesXml(iface));
            sb.append(this.generateSignalsXml((Class<?>)var3_3));
            sb.append(" </interface>\n");
        }
        return var2_2.toString();
    }

    public Map<MethodTuple, Method> getMethods() {
        return this.methods;
    }

    public Map<PropertyRef, Method> getPropertyMethods() {
        return this.propertyMethods;
    }

    public Reference<DBusInterface> getObject() {
        return this.object;
    }

    public String getIntrospectiondata() {
        return this.introspectionData;
    }

    public Set<Class<?>> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [methodCount=" + this.methods.size() + ", propertyMethodCount=" + this.propertyMethods.size() + ", object=" + (this.object.get() != null ? Objects.toString(this.object) : "<no object referenced>") + "]";
    }

    public static boolean isExcluded(Method _meth) {
        Method method;
        return _meth == null || !Modifier.isPublic(_meth.getModifiers()) || _meth.isSynthetic() || _meth.isDefault() || _meth.isBridge() || _meth.getAnnotation(DBusIgnore.class) != null || _meth.getAnnotation(DBusBoundProperty.class) != null || _meth.getName().equals("getObjectPath") && _meth.getReturnType().equals(String.class) && method.getParameterCount() == 0;
    }
}

