/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.CommonRegexPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBusSignal
extends Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBusSignal.class);
    private static final Map<String, Class<? extends DBusSignal>> CLASS_CACHE = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private static final Map<Class<? extends DBusSignal>, Type[]> TYPE_CACHE = new ConcurrentHashMap<Class<? extends DBusSignal>, Type[]>();
    private static final Map<String, String> SIGNAL_NAMES = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> INT_NAMES = new ConcurrentHashMap<String, String>();
    private static final Map<Class<? extends DBusSignal>, List<CachedConstructor>> CACHED_CONSTRUCTORS = new ConcurrentHashMap<Class<? extends DBusSignal>, List<CachedConstructor>>();
    private Class<? extends DBusSignal> clazz;
    private boolean bodydone = false;
    private byte[] blen;

    DBusSignal() {
    }

    /*
     * WARNING - void declaration
     */
    static void addInterfaceMap(String _java, String _dbus) {
        String string;
        void var1_1;
        INT_NAMES.put((String)var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    static void addSignalMap(String _java, String _dbus) {
        String string;
        void var1_1;
        SIGNAL_NAMES.put((String)var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    private static Class<? extends DBusSignal> createSignalClass(String _intName, String _sigName) throws DBusException {
        void var3_3;
        void var2_2;
        Object name = _intName + "$" + _sigName;
        Class<DBusSignal> c = CLASS_CACHE.get(name);
        if (c == null) {
            c = DBusMatchRule.getCachedSignalType((String)name);
        }
        if (c != null) {
            return c;
        }
        do {
            try {
                c = Class.forName((String)name);
            }
            catch (ClassNotFoundException _exCnf) {
                LOGGER.trace("Class not found for {}", name, (Object)_exCnf);
            }
            name = CommonRegexPattern.EXCEPTION_EXTRACT_PATTERN.matcher((CharSequence)name).replaceAll("\\$$1");
        } while (c == null && CommonRegexPattern.EXCEPTION_PARTIAL_PATTERN.matcher((CharSequence)name).matches());
        if (c == null) {
            void var1_1;
            String string;
            throw new DBusException("Could not create class from signal " + string + "." + (String)var1_1);
        }
        CLASS_CACHE.put((String)var2_2, c);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public DBusSignal createReal(AbstractConnectionBase _conn) throws DBusException {
        String intname = INT_NAMES.get(this.getInterface());
        String signame = SIGNAL_NAMES.get(this.getName());
        if (intname == null) {
            intname = this.getInterface();
        }
        if (signame == null) {
            signame = this.getName();
        }
        if (this.clazz == null) {
            this.clazz = DBusSignal.createSignalClass(intname, signame);
        }
        this.logger.debug("Converting signal to type: {}", this.clazz);
        if (!CACHED_CONSTRUCTORS.containsKey(this.clazz)) {
            DBusSignal dBusSignal = this;
            dBusSignal.cacheConstructors(dBusSignal.clazz);
        }
        Object list = CACHED_CONSTRUCTORS.get(this.clazz);
        Constructor<? extends DBusSignal> con = null;
        Type[] types = null;
        List<Type[]> constructorArgs = list.stream().map(c -> c.types).toList();
        Object[] parameters = this.getParameters(constructorArgs);
        List<Class<?>> wantedArgs = Arrays.stream(parameters).map(Object::getClass).collect(Collectors.toList());
        list = list.iterator();
        while (list.hasNext()) {
            CachedConstructor type = (CachedConstructor)list.next();
            if (!type.matchesParameters(wantedArgs)) continue;
            con = type.constructor;
            types = type.types;
            break;
        }
        if (con == null) {
            this.logger.warn("Could not find suitable constructor for class {} with argument-types: {}", (Object)this.clazz.getName(), wantedArgs);
            return null;
        }
        try {
            void var1_1;
            DBusSignal s;
            Object[] args = Marshalling.deSerializeParameters(parameters, types, _conn);
            if (args == null) {
                s = con.newInstance(this.getPath());
            } else {
                void var3_4;
                Object[] objectArray = new Object[args.length + 1];
                Object[] params = objectArray;
                objectArray[0] = this.getPath();
                System.arraycopy(args, 0, params, 1, args.length);
                s = (DBusSignal)var3_4.newInstance(params);
            }
            s.updateEndianess(var1_1.getMessageFactory().getEndianess());
            s.setHeader(this.getHeader());
            s.setWireData(this.getWireData());
            s.setByteCounter(this.getWireData().length);
            return s;
        }
        catch (Exception _ex) {
            void var2_3;
            throw new DBusException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cacheConstructors(Class<? extends DBusSignal> _clazz) {
        void var2_2;
        void var1_1;
        ArrayList<CachedConstructor> list = new ArrayList<CachedConstructor>();
        Constructor<?>[] constructorArray = _clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            Constructor<?> x = constructor = constructorArray[i];
            list.add(new CachedConstructor(x));
        }
        CACHED_CONSTRUCTORS.put((Class<? extends DBusSignal>)var1_1, (List<CachedConstructor>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendbody(AbstractConnectionBase _conn) throws DBusException {
        if (this.bodydone) {
            return;
        }
        Type[] types = TYPE_CACHE.get(this.getClass());
        Object[] args = Marshalling.convertParameters(this.getParameters(), types, _conn);
        this.setArgs(args);
        String sig = this.getSig();
        long counter = this.getByteCounter();
        if (args != null && 0 < args.length) {
            void var1_1;
            void var2_2;
            this.append((String)var2_2, (Object[])var1_1);
        }
        DBusSignal dBusSignal = this;
        dBusSignal.marshallint(dBusSignal.getByteCounter() - counter, this.blen, 0, 4);
        this.bodydone = true;
    }

    private static class CachedConstructor {
        private final Constructor<? extends DBusSignal> constructor;
        private final List<Class<?>> parameterTypes;
        private final Type[] types;

        /*
         * WARNING - void declaration
         */
        CachedConstructor(Constructor<? extends DBusSignal> _constructor) {
            void var1_1;
            this.constructor = var1_1;
            this.parameterTypes = Arrays.stream(this.constructor.getParameterTypes()).skip(1L).map(c -> {
                Class clazz;
                if (c.isPrimitive()) {
                    return CachedConstructor.wrap(c);
                }
                return clazz;
            }).toList();
            this.types = CachedConstructor.createTypes(this.constructor);
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesParameters(List<Class<?>> _wantedArgs) {
            if (this.parameterTypes == null || _wantedArgs == null) {
                return false;
            }
            if (this.parameterTypes.size() != _wantedArgs.size()) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                void var3_3;
                Class<?> class1 = this.parameterTypes.get(i);
                if (Enum.class.isAssignableFrom(class1) && String.class.equals(_wantedArgs.get(i)) || DBusInterface.class.isAssignableFrom(class1) && ObjectPath.class.equals(_wantedArgs.get(i)) || DBusInterface.class.isAssignableFrom(class1) && DBusPath.class.equals(_wantedArgs.get(i)) || Struct.class.isAssignableFrom(class1) && Object[].class.equals(_wantedArgs.get(i)) || var3_3.isAssignableFrom(_wantedArgs.get(i))) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static Type[] createTypes(Constructor<? extends DBusSignal> _constructor) {
            void var1_1;
            Type[] ts = _constructor.getGenericParameterTypes();
            Type[] types = new Type[ts.length - 1];
            for (int i = 1; i <= types.length; ++i) {
                types[i - 1] = ts[i] instanceof TypeVariable ? ((TypeVariable)ts[i]).getBounds()[0] : ts[i];
            }
            return var1_1;
        }

        private static <T> Class<T> wrap(Class<T> _clz) {
            return MethodType.methodType(_clz).wrap().returnType();
        }
    }
}

