/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.config.TransportConfigBuilder;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.IFileBasedBusAddress;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.InvalidBusAddressException;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.exceptions.TransportRegistrationException;
import org.freedesktop.dbus.spi.transport.ITransportProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportBuilder.class);
    private static final Map<Object, Map<String, ITransportProvider>> PROVIDERS = new ConcurrentHashMap<Object, Map<String, ITransportProvider>>();
    private final TransportConfigBuilder<TransportConfigBuilder<?, TransportBuilder>, TransportBuilder> transportConfigBuilder = new TransportConfigBuilder(() -> this);

    /*
     * WARNING - void declaration
     */
    private TransportBuilder(TransportConfig _config) {
        if (_config != null) {
            void var1_1;
            TransportBuilder.findTransportProvider(_config.getServiceLoaderClassLoader(), _config.getServiceLoaderModuleLayer());
            this.transportConfigBuilder.withConfig((TransportConfig)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void findTransportProvider(ClassLoader _clzLoader, ModuleLayer _layer) {
        Object key;
        Object object = key = _layer != null ? _layer : _clzLoader;
        if (PROVIDERS.containsKey(key)) {
            return;
        }
        try {
            _clzLoader = _layer != null ? ServiceLoader.load(_layer, ITransportProvider.class) : ServiceLoader.load(ITransportProvider.class, (ClassLoader)((Object)_clzLoader));
            _clzLoader = ((ServiceLoader)((Object)_clzLoader)).iterator();
            while (_clzLoader.hasNext()) {
                void var1_2;
                void var3_4;
                ITransportProvider provider = _clzLoader.next();
                String providerBusType = provider.getSupportedBusType();
                if (providerBusType == null) {
                    LOGGER.warn("Transport {} is invalid: No bustype configured", provider.getClass());
                    continue;
                }
                providerBusType = providerBusType.toUpperCase(Locale.US);
                LOGGER.debug("Found provider '{}' named '{}' providing bustype '{}'", new Object[]{provider.getClass().getSimpleName(), provider.getTransportName(), providerBusType});
                if (PROVIDERS.containsKey(key) && PROVIDERS.get(key).containsKey(providerBusType)) {
                    throw new TransportRegistrationException("Found transport " + PROVIDERS.get(key).get(providerBusType).getClass().getName() + " and " + provider.getClass().getName() + " both providing transport for socket type " + providerBusType + ", please only add one of them to classpath.");
                }
                PROVIDERS.computeIfAbsent(key, x -> new HashMap()).put(var3_4, var1_2);
            }
            if (PROVIDERS.isEmpty()) {
                throw new TransportRegistrationException("No dbus-java-transport found in classpath, please add a transport module");
            }
            return;
        }
        catch (ServiceConfigurationError _ex) {
            void var0_1;
            LOGGER.error("Could not initialize service provider.", (Throwable)var0_1);
            return;
        }
    }

    public static TransportBuilder create(TransportConfig _config) throws InvalidBusAddressException {
        TransportConfig transportConfig;
        return new TransportBuilder(transportConfig);
    }

    public final TransportConfigBuilder<TransportConfigBuilder<?, TransportBuilder>, TransportBuilder> configure() {
        return this.transportConfigBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public final AbstractTransport build() throws DBusException, IOException {
        BusAddress myBusAddress = this.getAddress();
        TransportConfig config = this.transportConfigBuilder.build();
        if (myBusAddress == null) {
            throw new DBusException("Transport requires a BusAddress, use withBusAddress() to configure before building");
        }
        int configuredSaslAuthMode = config.getSaslConfig().getAuthMode();
        AbstractTransport transport = null;
        ITransportProvider provider = PROVIDERS.values().stream().map(e -> {
            TransportConfig transportConfig;
            return (ITransportProvider)e.get(transportConfig.getBusAddress().getBusType());
        }).filter(Objects::nonNull).findAny().orElse(null);
        if (provider == null) {
            throw new DBusException("No transport provider found for bustype " + config.getBusAddress().getBusType());
        }
        LOGGER.info("Using transport {} for address {}", (Object)provider.getTransportName(), (Object)config.getBusAddress());
        try {
            transport = provider.createTransport(myBusAddress, config);
            Objects.requireNonNull(transport, "Transport required");
            if (configuredSaslAuthMode > 0 && config.getSaslConfig().getAuthMode() != configuredSaslAuthMode) {
                transport.getSaslConfig().setAuthMode(configuredSaslAuthMode);
            }
        }
        catch (TransportConfigurationException _ex) {
            LOGGER.error("Could not initialize transport", (Throwable)_ex);
        }
        if (transport == null) {
            throw new DBusException("Unknown address type " + myBusAddress.getType() + " or no transport provider found for bus type " + myBusAddress.getBusType());
        }
        if (myBusAddress.isListeningSocket() && myBusAddress instanceof IFileBasedBusAddress) {
            IFileBasedBusAddress _ex = (IFileBasedBusAddress)((Object)myBusAddress);
            _ex.updatePermissions(config.getFileOwner(), config.getFileGroup(), config.getFileUnixPermissions());
        }
        transport.setPreConnectCallback(config.getPreConnectCallback());
        if (config.isAutoConnect() && !config.isListening()) {
            void var1_2;
            void var2_4;
            SocketChannel c = null;
            int max = Math.max(500, config.getTimeout()) / 500;
            int cnt = 0;
            do {
                try {
                    ++cnt;
                    c = transport.connect();
                }
                catch (IOException _ex) {
                    LOGGER.debug("Connection to {} failed, reconnect attempt {} of {}", new Object[]{this.getAddress(), cnt, max});
                    if (cnt >= max) {
                        throw _ex;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.debug("Interrupted while waiting for connection retry for address {}", (Object)this.getAddress());
                        Thread.currentThread().interrupt();
                    }
                }
            } while (c == null);
            LOGGER.debug("Connection to {} established after {} of {} attempts", new Object[]{this.getAddress(), (int)var2_4, (int)var1_2});
        }
        return transport;
    }

    public final BusAddress getAddress() {
        return this.configure().getBusAddress();
    }

    public static List<String> getRegisteredBusTypes() {
        return PROVIDERS.values().stream().flatMap(d -> d.keySet().stream()).toList();
    }

    static {
        TransportBuilder.findTransportProvider(TransportBuilder.class.getClassLoader(), null);
    }
}

