/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.util.concurrent.ConcurrentMap;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.BaseConnectionBuilder;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.AddressResolvingException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.utils.AddressBuilder;

public final class DBusConnectionBuilder
extends BaseConnectionBuilder<DBusConnectionBuilder, DBusConnection> {
    private final String machineId;
    private boolean shared = true;

    /*
     * WARNING - void declaration
     */
    private DBusConnectionBuilder(BusAddress _address, String _machineId) {
        super(DBusConnectionBuilder.class, (BusAddress)var1_1);
        void var2_2;
        void var1_1;
        this.machineId = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static DBusConnectionBuilder forSessionBus(String _machineIdFileLocation) {
        String string;
        void var1_1;
        BusAddress address = DBusConnectionBuilder.validateTransportAddress(AddressBuilder.getSessionConnection(_machineIdFileLocation));
        return new DBusConnectionBuilder((BusAddress)var1_1, AddressBuilder.getDbusMachineId(string));
    }

    public static DBusConnectionBuilder forSessionBus() {
        return DBusConnectionBuilder.forSessionBus(null);
    }

    private static BusAddress validateTransportAddress(BusAddress _address) {
        BusAddress busAddress;
        BusAddress address;
        if (TransportBuilder.getRegisteredBusTypes().isEmpty()) {
            throw new IllegalArgumentException("No transports found to connect to DBus. Please add at least one transport provider to your classpath");
        }
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX") && address != null && address.isBusType("UNIX")) {
            throw new AddressResolvingException("No transports found to handle UNIX socket connections. Please add a unix-socket transport provider to your classpath");
        }
        if (!TransportBuilder.getRegisteredBusTypes().contains("TCP") && address != null && address.isBusType("TCP")) {
            throw new AddressResolvingException("No transports found to handle TCP connections. Please add a TCP transport provider to your classpath");
        }
        return busAddress;
    }

    /*
     * WARNING - void declaration
     */
    public final DBusConnection build() throws DBusException {
        DBusConnection c;
        ReceivingServiceConfig rcvSvcCfg = this.buildThreadConfig();
        TransportConfig transportCfg = this.buildTransportConfig();
        ConnectionConfig connectionConfig = this.getConnectionConfig();
        if (this.shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = DBusConnection.CONNECTIONS;
            synchronized (concurrentMap) {
                String busAddressStr = transportCfg.getBusAddress().toString();
                c = this.getSharedConnection(busAddressStr);
                if (c != null) {
                    c.concurrentConnections.incrementAndGet();
                    return c;
                }
                c = new DBusConnection(this.shared, this.machineId, connectionConfig, transportCfg, rcvSvcCfg);
                DBusConnection.CONNECTIONS.put(busAddressStr, c);
            }
        } else {
            void var1_1;
            void var2_3;
            void var3_4;
            c = new DBusConnection(this.shared, this.machineId, (ConnectionConfig)var3_4, (TransportConfig)var2_3, (ReceivingServiceConfig)var1_1);
        }
        c.connectImpl();
        return c;
    }

    /*
     * WARNING - void declaration
     */
    private DBusConnection getSharedConnection(String _busAddr) {
        ConcurrentMap<String, DBusConnection> concurrentMap = DBusConnection.CONNECTIONS;
        synchronized (concurrentMap) {
            DBusConnection c = (DBusConnection)DBusConnection.CONNECTIONS.get(_busAddr);
            if (c != null) {
                void var3_4;
                if (!c.isConnected()) {
                    void var1_1;
                    DBusConnection.CONNECTIONS.remove(var1_1);
                    return null;
                }
                return var3_4;
            }
            return null;
        }
    }
}

