/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.IDisconnectAction;
import org.freedesktop.dbus.connections.base.AbstractConnectionBase;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.connections.impl.IRemoteObjectGetter;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.utils.CommonRegexPattern;
import org.freedesktop.dbus.utils.DBusObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBusConnection
extends AbstractConnection
implements IRemoteObjectGetter {
    static final ConcurrentMap<String, DBusConnection> CONNECTIONS = new ConcurrentHashMap<String, DBusConnection>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> busnames;
    private final String machineId;
    private DBus dbus;
    private boolean registered;
    final AtomicInteger concurrentConnections = new AtomicInteger(1);
    private final boolean shared;

    /*
     * WARNING - void declaration
     */
    DBusConnection(boolean _shared, String _machineId, ConnectionConfig _conCfg, TransportConfig _tranportCfg, ReceivingServiceConfig _rsCfg) throws DBusException {
        super((ConnectionConfig)var3_3, _tranportCfg, _rsCfg);
        void var1_1;
        void var2_2;
        void var3_3;
        this.busnames = new ArrayList<String>();
        this.machineId = var2_2;
        this.shared = var1_1;
    }

    private AtomicInteger getConcurrentConnections() {
        return this.concurrentConnections;
    }

    /*
     * WARNING - void declaration
     */
    final void connectImpl() throws DBusException {
        void var1_2;
        try {
            this.listen();
        }
        catch (IOException _ex) {
            throw new DBusException(_ex);
        }
        SigHandler h = new SigHandler();
        this.addSigHandlerWithoutMatch((Class<? extends DBusSignal>)DBus.NameAcquired.class, var1_2);
        if (this.getTransportConfig().isRegisterSelf() && this.getTransport().isConnected()) {
            this.register();
            this.getLogger().debug("");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void register() throws DBusException {
        if (this.registered) {
            return;
        }
        this.dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        try {
            DBusConnection dBusConnection = this;
            dBusConnection.doWithBusNames(bn -> {
                bn.add(this.dbus.Hello());
                this.registered = true;
            });
            return;
        }
        catch (DBusExecutionException _ex) {
            void var1_1;
            this.logger.debug("Error while doing 'Hello' handshake", (Throwable)_ex);
            throw new DBusException(_ex.getMessage(), (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T doWithBusNamesAndReturn(Function<List<String>, T> _action) {
        if (_action == null) {
            return null;
        }
        List<String> list = this.busnames;
        synchronized (list) {
            void var1_1;
            return (T)var1_1.apply(this.busnames);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doWithBusNames(Consumer<List<String>> _action) {
        void var1_1;
        this.doWithBusNamesAndReturn(arg_0 -> DBusConnection.lambda$doWithBusNames$1((Consumer)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends DBusInterface> T dynamicProxy(String _source, String _path, Class<T> _type) throws DBusException {
        this.logger.debug("Introspecting {} on {} for dynamic proxy creation", (Object)_path, (Object)_source);
        try {
            void var3_3;
            Introspectable introspectable = this.getRemoteObject(_source, _path, Introspectable.class);
            String[] data = introspectable.Introspect();
            this.logger.trace("Got introspection data: {}", (Object)data);
            data = CommonRegexPattern.PROXY_SPLIT_PATTERN.split((CharSequence)data);
            List<String> ifaces = Arrays.stream(data).filter(t -> t.startsWith("interface")).map(t -> {
                String string;
                return CommonRegexPattern.IFACE_PATTERN.matcher(string).replaceAll("$1");
            }).map(i -> {
                String string;
                if (i.startsWith("org.freedesktop.DBus.")) {
                    return CommonRegexPattern.DBUS_IFACE_PATTERN.matcher((CharSequence)i).replaceAll("$1");
                }
                return string;
            }).toList();
            List<Class<?>> ifcs = this.findMatchingTypes(_type, ifaces);
            if (ifcs.isEmpty()) {
                ifcs.add(DBusInterface.class);
            }
            RemoteObject ro = new RemoteObject(_source, _path, _type, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(ifcs.get(0).getClassLoader(), (Class[])ifcs.toArray(Class[]::new), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.getImportedObjects().put(newi, (RemoteObject)var3_3);
            return (T)newi;
        }
        catch (Exception _ex) {
            void var1_1;
            void var2_2;
            this.logger.debug("Cannot create proxy object", (Throwable)_ex);
            throw new DBusException(String.format("Failed to create proxy object for %s exported by %s. Reason: %s", var2_2, var1_1, _ex.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends DBusInterface> T getExportedObject(String _source, String _path, Class<T> _type) throws DBusException {
        void var3_3;
        void var2_2;
        void var1_1;
        ExportedObject o = this.doWithExportedObjectsAndReturn(DBusException.class, eo -> {
            String string;
            return (ExportedObject)eo.get(string);
        });
        if (o != null && o.getObject().get() == null) {
            this.unExportObject(_path);
            o = null;
        }
        if (o != null) {
            return (T)o.getObject().get();
        }
        if (_source == null) {
            throw new DBusException("Not an object exported by this connection and no remote specified");
        }
        return this.dynamicProxy((String)var1_1, (String)var2_2, (Class<T>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void releaseBusName(String _busname) throws DBusException {
        void var1_1;
        DBusObjects.requireBusName(_busname);
        try {
            this.dbus.ReleaseName(_busname);
        }
        catch (DBusExecutionException _ex) {
            void var1_2;
            this.logger.debug("Failed to release bus name", (Throwable)_ex);
            throw new DBusException(var1_2.getMessage());
        }
        this.doWithBusNames(arg_0 -> DBusConnection.lambda$releaseBusName$7((String)var1_1, arg_0));
    }

    public final String getUniqueName() {
        return this.doWithBusNamesAndReturn(bn -> (String)bn.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <I extends DBusInterface> I getRemoteObject(String _busname, String _objectpath, Class<I> _type, boolean _autostart) throws DBusException {
        void var2_2;
        void var1_1;
        void var3_3;
        DBusObjects.requireBusNameOrConnectionId(_busname);
        DBusObjects.requireObjectPath(_objectpath);
        DBusObjects.requireDBusInterface(_type);
        DBusObjects.requirePackage(_type);
        RemoteObject ro = new RemoteObject(_busname, _objectpath, _type, _autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(_type.getClassLoader(), new Class[]{var3_3}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.getImportedObjects().put(i, (RemoteObject)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = CONNECTIONS;
            synchronized (concurrentMap) {
                DBusConnection connection = (DBusConnection)CONNECTIONS.get(this.getAddress().toString());
                if (connection != null) {
                    if (connection.getConcurrentConnections().get() <= 1) {
                        CONNECTIONS.remove(this.getAddress().toString());
                        super.disconnect();
                    } else {
                        void var2_3;
                        this.logger.debug("Still {} connections left, decreasing connection counter", (Object)(connection.getConcurrentConnections().get() - 1));
                        Optional.ofNullable(this.getDisconnectCallback()).ifPresent(cb -> {
                            DBusConnection dBusConnection;
                            cb.requestedDisconnect(dBusConnection.getConcurrentConnections().get());
                        });
                        var2_3.getConcurrentConnections().decrementAndGet();
                    }
                }
            }
        } else {
            void var1_2;
            IDisconnectAction beforeDisconnectAction = () -> {
                DBusConnection dBusConnection = this;
                dBusConnection.doWithBusNames(bn -> {
                    List<String> list = bn.stream().filter(DBusObjects::validateBusName).toList();
                    list.forEach(busName -> {
                        try {
                            this.releaseBusName((String)busName);
                            return;
                        }
                        catch (DBusException _ex) {
                            void var2_2;
                            void var1_1;
                            this.logger.error("Error while releasing busName '" + (String)var1_1 + "'.", (Throwable)var2_2);
                            return;
                        }
                    });
                });
                this.doWithExportedObjects(null, eos -> {
                    Object object = eos.keySet().stream().filter(Objects::nonNull).toList();
                    object = object.iterator();
                    while (object.hasNext()) {
                        void var2_2;
                        String key = (String)object.next();
                        this.unExportObject((String)var2_2);
                    }
                });
            };
            super.disconnect((IDisconnectAction)var1_2, null);
        }
    }

    @Override
    public final void close() throws IOException {
        ((AbstractConnectionBase)this).disconnect();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeGenericSigHandler(DBusMatchRule _rule, DBusSigHandler<DBusSignal> _handler) throws DBusException {
        Queue<DBusSigHandler<DBusSignal>> genericSignalsList = this.getGenericHandledSignals().get(_rule);
        if (genericSignalsList != null) {
            void var3_5;
            void var2_4;
            genericSignalsList.remove(var2_4);
            if (var3_5.isEmpty()) {
                this.getGenericHandledSignals().remove(_rule);
                try {
                    this.dbus.RemoveMatch(_rule.toString());
                    return;
                }
                catch (NotConnected _ex) {
                    this.logger.debug("No connection.", (Throwable)_ex);
                    return;
                }
                catch (DBusExecutionException _ex) {
                    void var1_3;
                    this.logger.debug("Error removing generic signal", (Throwable)_ex);
                    throw new DBusException((Throwable)var1_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final AutoCloseable addGenericSigHandler(DBusMatchRule _rule, DBusSigHandler<DBusSignal> _handler) throws DBusException {
        void var2_3;
        void var1_1;
        void var3_4;
        AtomicBoolean addMatch = new AtomicBoolean(false);
        Queue queue = this.getGenericHandledSignals().computeIfAbsent(_rule, v -> {
            void var1_1;
            AtomicBoolean atomicBoolean;
            ConcurrentLinkedQueue signalsList = new ConcurrentLinkedQueue();
            atomicBoolean.set(true);
            return var1_1;
        });
        queue.add(_handler);
        if (var3_4.get()) {
            try {
                this.dbus.AddMatch(_rule.toString());
            }
            catch (DBusExecutionException _ex) {
                void var1_2;
                this.logger.debug("Error adding signal handler", (Throwable)_ex);
                throw new DBusException(var1_2.getMessage());
            }
        }
        return () -> this.lambda$addGenericSigHandler$22((DBusMatchRule)var1_1, (DBusSigHandler)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$addGenericSigHandler$22(DBusMatchRule _rule, DBusSigHandler _handler) throws Exception {
        void var2_2;
        void var1_1;
        this.removeGenericSigHandler((DBusMatchRule)var1_1, (DBusSigHandler<DBusSignal>)var2_2);
    }

    private static /* synthetic */ void lambda$releaseBusName$7(String _busname, List bn) {
        String string;
        bn.remove(string);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$doWithBusNames$1(Consumer _action, List bn) {
        void var1_1;
        _action.accept(var1_1);
        return null;
    }

    private final class SigHandler
    implements DBusSigHandler<DBusSignal> {
        private SigHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void handle(DBusSignal _signal) {
            if (_signal instanceof DBus.NameAcquired) {
                void var1_1;
                DBus.NameAcquired na = (DBus.NameAcquired)_signal;
                DBusConnection.this.doWithBusNames(arg_0 -> SigHandler.lambda$handle$0((DBus.NameAcquired)var1_1, arg_0));
            }
        }

        private static /* synthetic */ void lambda$handle$0(DBus.NameAcquired na, List bn) {
            DBus.NameAcquired nameAcquired;
            bn.add(nameAcquired.name);
        }
    }
}

