/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.config;

import java.nio.file.attribute.PosixFilePermission;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.SaslConfig;
import org.freedesktop.dbus.connections.impl.BaseConnectionBuilder;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;

public final class TransportConfig {
    private SaslConfig saslConfig;
    private BusAddress busAddress;
    private Consumer<AbstractTransport> preConnectCallback;
    private int timeout = 10000;
    private boolean autoConnect = true;
    private String fileOwner;
    private String fileGroup;
    private byte endianess = BaseConnectionBuilder.getSystemEndianness();
    private boolean registerSelf = true;
    private ClassLoader serviceLoaderClassLoader = TransportBuilder.class.getClassLoader();
    private ModuleLayer serviceLoaderModuleLayer;
    private Set<PosixFilePermission> fileUnixPermissions;
    private Map<String, Object> additionalConfig = new LinkedHashMap<String, Object>();

    /*
     * WARNING - void declaration
     */
    public TransportConfig(BusAddress _address) {
        void var1_1;
        this.busAddress = var1_1;
    }

    public TransportConfig() {
        this(null);
    }

    public final BusAddress getBusAddress() {
        return this.busAddress;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBusAddress(BusAddress _busAddress) {
        void var1_1;
        this.busAddress = (BusAddress)Objects.requireNonNull(var1_1, "BusAddress required");
    }

    public final boolean isListening() {
        return this.busAddress != null && this.busAddress.isListeningSocket();
    }

    public final Consumer<AbstractTransport> getPreConnectCallback() {
        return this.preConnectCallback;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreConnectCallback(Consumer<AbstractTransport> _preConnectCallback) {
        void var1_1;
        this.preConnectCallback = var1_1;
    }

    public final boolean isAutoConnect() {
        return this.autoConnect;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final String getFileOwner() {
        return this.fileOwner;
    }

    public final String getFileGroup() {
        return this.fileGroup;
    }

    public final Set<PosixFilePermission> getFileUnixPermissions() {
        return this.fileUnixPermissions;
    }

    public final SaslConfig getSaslConfig() {
        if (this.saslConfig == null) {
            this.saslConfig = new SaslConfig();
        }
        return this.saslConfig;
    }

    /*
     * WARNING - void declaration
     */
    final void setSaslConfig(SaslConfig _saslCfg) {
        void var1_1;
        this.saslConfig = var1_1;
    }

    public final boolean isRegisterSelf() {
        return this.registerSelf;
    }

    public final ClassLoader getServiceLoaderClassLoader() {
        return this.serviceLoaderClassLoader;
    }

    public final ModuleLayer getServiceLoaderModuleLayer() {
        return this.serviceLoaderModuleLayer;
    }
}

