/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfigBuilder;
import org.freedesktop.dbus.connections.shared.ExecutorNames;
import org.freedesktop.dbus.connections.shared.IThreadPoolRetryHandler;
import org.freedesktop.dbus.exceptions.IllegalThreadPoolStateException;
import org.freedesktop.dbus.utils.NameableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean closed = false;
    private final Map<ExecutorNames, ExecutorService> executors = new ConcurrentHashMap<ExecutorNames, ExecutorService>();
    private final IThreadPoolRetryHandler retryHandler;

    /*
     * WARNING - void declaration
     */
    ReceivingService(String _namePrefix, ReceivingServiceConfig _rsCfg) {
        void var2_2;
        void var1_1;
        String prefix;
        prefix = _namePrefix == null ? "" : prefix;
        ReceivingServiceConfig rsCfg = Optional.ofNullable(_rsCfg).orElse(ReceivingServiceConfigBuilder.getDefaultConfig());
        this.executors.put(ExecutorNames.SIGNAL, Executors.newFixedThreadPool(rsCfg.getSignalThreadPoolSize(), new NameableThreadFactory(prefix + "DBus-Signal-Receiver-", true, rsCfg.getSignalThreadPriority())));
        this.executors.put(ExecutorNames.ERROR, Executors.newFixedThreadPool(rsCfg.getErrorThreadPoolSize(), new NameableThreadFactory(prefix + "DBus-Error-Receiver-", true, rsCfg.getErrorThreadPriority())));
        this.executors.put(ExecutorNames.METHODCALL, Executors.newFixedThreadPool(rsCfg.getMethodCallThreadPoolSize(), new NameableThreadFactory(prefix + "DBus-MethodCall-Receiver-", true, rsCfg.getMethodCallThreadPriority())));
        this.executors.put(ExecutorNames.METHODRETURN, Executors.newFixedThreadPool(rsCfg.getMethodReturnThreadPoolSize(), new NameableThreadFactory((String)var1_1 + "DBus-MethodReturn-Receiver-", true, rsCfg.getMethodReturnThreadPriority())));
        this.retryHandler = var2_2.getRetryHandler();
    }

    /*
     * WARNING - void declaration
     */
    int execSignalHandler(Runnable _r) {
        void var1_1;
        return this.execOrFail(ExecutorNames.SIGNAL, (Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    int execErrorHandler(Runnable _r) {
        void var1_1;
        return this.execOrFail(ExecutorNames.ERROR, (Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    int execMethodCallHandler(Runnable _r) {
        void var1_1;
        return this.execOrFail(ExecutorNames.METHODCALL, (Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    int execMethodReturnHandler(Runnable _r) {
        void var1_1;
        return this.execOrFail(ExecutorNames.METHODRETURN, (Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    int execOrFail(ExecutorNames _executor, Runnable _r) {
        void var3_3;
        int failCount;
        if (_r == null || _executor == null) {
            return -1;
        }
        for (failCount = 0; failCount < 50; ++failCount) {
            try {
                ExecutorService exec = this.getExecutor(_executor);
                if (exec == null) {
                    throw new IllegalThreadPoolStateException("No executor found for " + String.valueOf((Object)_executor));
                }
                if (this.closed || exec.isShutdown() || exec.isTerminated()) {
                    throw new IllegalThreadPoolStateException("Receiving service already closed");
                }
                exec.execute(_r);
                break;
            }
            catch (IllegalThreadPoolStateException illegalThreadPoolStateException) {
                IllegalThreadPoolStateException exec = illegalThreadPoolStateException;
                throw illegalThreadPoolStateException;
            }
            catch (Exception _ex) {
                if (this.retryHandler != null) continue;
                this.logger.error("Could not handle runnable for executor {}, runnable will be dropped", (Object)_executor, (Object)_ex);
                break;
            }
        }
        if (failCount >= 50) {
            void var1_1;
            this.logger.error("Could not handle runnable for executor {} after {} retries, runnable will be dropped", (Object)var1_1, (Object)failCount);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    ExecutorService getExecutor(ExecutorNames _executor) {
        void var1_1;
        return this.executors.get(var1_1);
    }

    public synchronized void shutdown(int _timeout, TimeUnit _unit) {
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            this.logger.debug("Shutting down executor: {}", (Object)es.getKey());
            es.getValue().shutdown();
        }
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            try {
                es.getValue().awaitTermination(_timeout, _unit);
            }
            catch (InterruptedException interruptedException) {
                this.logger.debug("Interrupted while waiting for termination of executor");
                Thread.currentThread().interrupt();
            }
        }
        this.closed = true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void shutdownNow() {
        for (Map.Entry<ExecutorNames, ExecutorService> es : this.executors.entrySet()) {
            void var2_2;
            if (es.getValue().isTerminated()) continue;
            this.logger.debug("Forcefully stopping {}", (Object)es.getKey());
            ((ExecutorService)var2_2.getValue()).shutdownNow();
        }
        this.closed = true;
    }
}

